/*
 * Copyright : All Rights Reserved. Copyright (C) 2006, Hitachi, Ltd.
 * Title     : ServerConductor WebConsole
 * Version   : 08-00
 * Name      : hostmgmt.js
 * Date      : 2006/04/12
 */

/**
 * This javascript contains methods for operations in the host management main screen.
 * @version 08-00
 * @since 08-00
 */

var errorMsg = new Array();

/**
 * This function is for version information dialog
 * @since 08-00
 */

 // function opVersionInfo(r_stUrl)                                             // 800WA_WEBCONSOLE158 
 function opVersionInfo(r_stUrl,r_stId)                                         // 800WA_WEBCONSOLE158 
 {
  clearMenu();                                                                  // 800WA_WEBCONSOLE445
  if(r_stUrl==null)                                                             // 800WA_WEBCONSOLE029
   {                                                                            // 800WA_WEBCONSOLE029 
       return;                                                                  // 800WA_WEBCONSOLE029
   }                                                                            // 800WA_WEBCONSOLE029
 // showModalDialog(r_stUrl, null, 'dialogHeight:120px;dialogWidth:400px;status=no;scrollbars=yes');    // 800WA_WEBCONSOLE099
 // showModalDialog(r_stUrl, null, 'dialogHeight:120px;dialogWidth:400px;status=no;scrollbars=yes;resizable=yes;help:no');    // 800WA_WEBCONSOLE099 // 800WA_WEBCONSOLE158
    showModalDialog(r_stUrl, r_stId, 'dialogHeight:120px;dialogWidth:400px;status=no;scrollbars=auto;resizable=yes;help:no'); // 800WA_WEBCONSOLE158
 }
/**
 * This function is for logout
 * @since 08-00
 */
 function logout(r_stUrl)
 {
  if(r_stUrl==null)                                                             // 800WA_WEBCONSOLE029
  {                                                                             // 800WA_WEBCONSOLE029
      return;                                                                   // 800WA_WEBCONSOLE029
  }                                                                             // 800WA_WEBCONSOLE029 
  parent.location=r_stUrl;
 }
 /**
 * This function is for update to latest information
 * @since 08-00
 */
  function reload()
{
 // getting the view jsp page from the host list frame and reloading it
  // var listLocation = parent.hostList.location ;                             // 800WA_WEBCONSOLE186   
  // parent.hostList.location = listLocation;                                  // 800WA_WEBCONSOLE186
    // parent.hostList.location.reload();                                       // 800WA_WEBCONSOLE186 // 800WA_WEBCONSOLE449
     
    var l_stReloadURL = "" ;                                                    // 800WA_WEBCONSOLE449
    if (document.forms[0]["selectedView"].value == "site") {                    // 800WA_WEBCONSOLE449
        l_stReloadURL = document.getElementById("siteLink").href;               // 800WA_WEBCONSOLE449
    }                                                                           // 800WA_WEBCONSOLE449
    else if (document.forms[0]["selectedView"].value == "domain") {             // 800WA_WEBCONSOLE449
        l_stReloadURL = document.getElementById("domainLink").href;             // 800WA_WEBCONSOLE449
    }                                                                           // 800WA_WEBCONSOLE449
    else if (document.forms[0]["selectedView"].value == "service") {            // 800WA_WEBCONSOLE449
        l_stReloadURL = document.getElementById("serviceConfLink").href;        // 800WA_WEBCONSOLE449
    }                                                                           // 800WA_WEBCONSOLE449
    else {                                                                      // 800WA_WEBCONSOLE449
        return;                                                                 // 800WA_WEBCONSOLE449
    }                                                                           // 800WA_WEBCONSOLE449
    parent.hostList.location = l_stReloadURL;                                   // 800WA_WEBCONSOLE449
     
 // loading host detail frame with a blank page
  // parent.hostDetail.location = "about:blank";                               // 800WA_WEBCONSOLE125
     parent.hostDetail.location = "jsp/default.html";                          // 800WA_WEBCONSOLE125 
     clearMenu();                                                               // 800WA_WEBCONSOLE445
}

/**
 * This method is used do the validations for host operation and display the 
 * confirmation dialog for the selected nodes.
 * @param r_varKey contains the Key for the delimiter used by string tokenizer.
 * @param r_varOperationCode contains the host operation code.
 * @param r_varTitle contains the title of the confirmation dialog.
 * @param r_varArg0 contains the product name to be added to title.
 * @param r_varImage contains the icon name of the confirmation dialog.
 * @param r_varErrorId contains the confirmation id.
 * @param r_varMessage contains the confirmation message
 * @param r_varOk contains the Ok button value.
 * @param r_varCancel contains the Cancel Button value.
 * @param r_varOkAll contains the Ok All Button value.
 * @since 08-00
 */
//function hostOperation(r_varKey,r_varOperationCode,r_varTitle,r_varArg0,r_varImage,r_varErrorId,r_varMessage,r_varOk,r_varCancel,r_varOkAll)          //800WA_WEBCONSOLE152
function hostOperation(r_stAction,r_varKey,r_varOperationCode,r_varTitle,r_varArg0,r_varImage,r_varErrorId,r_varMessage,r_varOk,r_varCancel,r_varOkAll,r_varAlt) //800WA_WEBCONSOLE152 //800WA_WEBCONSOLE161
{
  clearMenu();                                                                  // 800WA_WEBCONSOLE445
  if(r_varKey==null || r_varOperationCode==null ||
	   r_varTitle==null || r_varArg0==null || r_varImage==null ||
	   r_varErrorId==null || r_varMessage==null || r_varOk==null || 
	          r_varCancel==null || r_varOkAll==null)                            // 800WA_WEBCONSOLE029
  {                                                                             // 800WA_WEBCONSOLE029          
      return;                                                                   // 800WA_WEBCONSOLE029             
  } 
  if(r_varOperationCode==0) 													// 800WA_WEBCONSOLE383  
  {																				// 800WA_WEBCONSOLE383  
  var l_objForm = parent.frames["hostDetail"].location;							// 800WA_WEBCONSOLE383  
	if(parent.frames["hostDetail"].document.forms[0])  							// 800WA_WEBCONSOLE383                           
	{																			// 800WA_WEBCONSOLE383  
		var l_objFormElements = parent.frames["hostDetail"].document.forms[0].	// 800WA_WEBCONSOLE383  
																	elements;	// 800WA_WEBCONSOLE383  
		var l_iCount = 0;														// 800WA_WEBCONSOLE383  
		for(l_iCnt = 0;l_iCnt < l_objFormElements.length; l_iCnt++)				// 800WA_WEBCONSOLE383  
		{  																		// 800WA_WEBCONSOLE383  
			if(l_objFormElements[l_iCnt].type == 'checkbox' && 					// 800WA_WEBCONSOLE383  
			l_objFormElements[l_iCnt].checked)									// 800WA_WEBCONSOLE383  
			{																	// 800WA_WEBCONSOLE383  
				l_iCount = l_iCount + 1;										// 800WA_WEBCONSOLE383  
				if(l_iCount>1)													// 800WA_WEBCONSOLE383 
				break;															// 800WA_WEBCONSOLE383 
			}																	// 800WA_WEBCONSOLE383
		}																		// 800WA_WEBCONSOLE383  
			 if (l_iCount > 1 )													// 800WA_WEBCONSOLE383  
			{																	// 800WA_WEBCONSOLE383  
				alert(MSG_AGENT_ONLY_SELECT_CHECK + "\n" + 						// 800WA_WEBCONSOLE383  
				errorMsg[MSG_AGENT_ONLY_SELECT_CHECK]);							// 800WA_WEBCONSOLE383  
    			return false;													// 800WA_WEBCONSOLE383  
			}																	// 800WA_WEBCONSOLE383  
		} 																		// 800WA_WEBCONSOLE383  
	}     																		// 800WA_WEBCONSOLE383                                         			   
  if(isHostSelected('nodeId',r_varKey))
  {
    parent.frames["hostDetail"].document.getElementById("hostOperationCode").value = r_varOperationCode;
    var r_stTitle = new String(r_varTitle);
    var l_varExpression0 = /\{0\}/gi;
    r_stTitle = r_stTitle.replace(l_varExpression0, r_varArg0);
  
// var l_objCheckBox = parent.frames["hostDetail"].document.forms[0]['nodeId']; // 800WA_WEBCONSOLE260 
    var l_objCheckBox = parent.frames["hostDetail"].document.forms[0];          // 800WA_WEBCONSOLE260 
    var l_varCheckedCount = 0;
    
    for(var i=0;i<l_objCheckBox.length;i++)
    {
	  // if(l_objCheckBox[i].checked)                                           // 800WA_WEBCONSOLE260 
	  if(l_objCheckBox[i].type == 'checkbox' && l_objCheckBox[i].checked)       // 800WA_WEBCONSOLE260 
      {
      	l_varCheckedCount++;
	    var l_varVal = l_objCheckBox[i].value;
	    var l_varTemp = l_varVal.split(";");
        var l_varMessage = new String(r_varMessage);
        l_varMessage = r_varMessage.replace(l_varExpression0, l_varTemp[1]);
    //  var l_varDialogProp = new confirmationProperties(r_stTitle,r_varImage,r_varErrorId,l_varMessage,r_varOk,r_varOkAll,r_varCancel,r_varAlt);   // 800WA_WEBCONSOLE161     // 800WA_WEBCONSOLE260 
		var l_varDialogProp = new confirmationProperties(r_stTitle,r_varImage,r_varErrorId,l_varMessage,r_varOk,r_varOkAll,r_varCancel,r_varAlt,3); // 800WA_WEBCONSOLE260 
        window.showModalDialog('jsp/confirmDialog.html',l_varDialogProp,"dialogHeight:150px;dialogWidth:300px;status:no;help:no");
        if(l_varDialogProp.l_varReturnValue==0) 	// For Ok press.
        {
          continue;
        }
        else if(l_varDialogProp.l_varReturnValue==1) // for Ok all press.
        {
          break;
        }
        else if(l_varDialogProp.l_varReturnValue==2) // For Cancel press.
        {
          if(l_varCheckedCount==1)
          {
            return;
          }
          for(var l_varInnerCount=i; l_varInnerCount<l_objCheckBox.length;l_varInnerCount++)
          {
            if(l_objCheckBox[l_varInnerCount].type == 'checkbox')               // 800WA_WEBCONSOLE260 
            {                                                                   // 800WA_WEBCONSOLE260 
            	l_objCheckBox[l_varInnerCount].checked = false;
            }                                                                   // 800WA_WEBCONSOLE260 
          }
          break;
        }
  	  }
    }
//  parent.frames["hostDetail"].document.forms[0].action = "hostOperation.do";  //800WA_WEBCONSOLE152
    parent.frames["hostDetail"].document.forms[0].action = r_stAction;          //800WA_WEBCONSOLE152
    parent.frames["hostDetail"].document.forms[0].submit();
  }
}


/**
 * This method is used to store the properties of the confirmation dialog.
 * @param r_varTitle contains the title of the confirmation dialog.
 * @param r_varIcon contains the icon name of the confirmation dialog.
 * @param r_varId contains the confirmation id.
 * @param r_varMessage contains the confirmation message
 * @param r_varOk contains the Ok button value.
 * @param r_varOkAll contains the Ok All Button value.
 * @param r_varCancel contains the Cancel Button value.
 * @since 08-00
 */
function confirmationProperties(r_varTitle,r_varIcon,r_varId,r_varMessage,r_varOk,r_varOkAll,r_varCancel,r_varAlt) //800WA_WEBCONSOLE161
{
  
   if(r_varTitle==null || r_varIcon==null || r_varId==null ||                          
	       r_varMessage==null || r_varOk==null || 
	                       r_varOkAll==null || r_varCancel==null || r_varAlt ==null)  // 800WA_WEBCONSOLE029  // 800WA_WEBCONSOLE161
   {                                                                                  // 800WA_WEBCONSOLE029                                                              
      return;                                                                         // 800WA_WEBCONSOLE029                                                              
   }                                                                                  // 800WA_WEBCONSOLE029                                                               
   this.l_varTitle = r_varTitle;
   this.l_varIcon = r_varIcon;
   this.l_varId = r_varId;
   this.l_varMessage = r_varMessage;
   this.l_varOk = r_varOk;
   this.l_varCancel = r_varCancel;
   this.l_varOkAll = r_varOkAll;
   // this.l_varReturnValue = -1;                                               // 800WA_WEBCONSOLE144 
   this.l_varReturnValue = 2;                                                   // 800WA_WEBCONSOLE144
   this.l_varAlt = r_varAlt;                                                    // 800WA_WEBCONSOLE161 
}




/**
 * This method is used to check if atleast one agent is selected. 
 * @param r_varName contains the name of the check box.
 * @param r_varKey contains Key for getting error id.
 */

function isHostSelected(r_varName,r_varKey)
{
   if(r_varName==null || r_varKey==null)                                        // 800WA_WEBCONSOLE029       
  {                                                                             // 800WA_WEBCONSOLE029
    return false;                                                               // 800WA_WEBCONSOLE029 
  }                                                                             // 800WA_WEBCONSOLE029
  var l_varFormExists = true;
  var l_varFormElements ;
  try
  {
    l_varFormElements =  parent.frames["hostDetail"].document.forms[0].elements;
  }
  catch(Exception)
  {
    l_varFormExists = false;
  }
  var flag = false;
  if(l_varFormExists)
  {
    for(var i=0;i<l_varFormElements.length;i++)
    {
	  if(l_varFormElements[i].name==r_varName)
  	  {
        if(l_varFormElements[i].checked)
	    {
	      flag = true;
  	      break;
  	    }
 	  }
    }
  }
  if(!flag)
  {
    alert(r_varKey + "\n" + errorMsg[r_varKey]);
    return false;
  }
  return true;
}

/** 
 * This function is for notification alert display
 * @since 08-00
 */
// function opNotify(r_varUrl)                                                  // 800WA_WEBCONSOLE158
function opNotify(r_varUrl,r_stId)                                              // 800WA_WEBCONSOLE158 
{
 clearMenu();                                                                   // 800WA_WEBCONSOLE445
 if(r_varUrl==null)                                                             // 800WA_WEBCONSOLE029        
  {                                                                             // 800WA_WEBCONSOLE029 
      return;                                                                   // 800WA_WEBCONSOLE029
  }                                                                             // 800WA_WEBCONSOLE029   
   // window.open(r_varUrl,"alert");                                               // 800WA_WEBCONSOLE099
	// window.open(r_varUrl,"alert","menubar = no, toolbar = no, status = yes, "  +  // 800WA_WEBCONSOLE099 // 800WA_WEBCONSOLE158
    // 	"location = no, width = 800px, height = 600px, resizable = yes,scrollbars = yes");  // 800WA_WEBCONSOLE099 // 800WA_WEBCONSOLE158
       window.open(r_varUrl,r_stId,"menubar = no, toolbar = no, status = yes, "  +          // 800WA_WEBCONSOLE158 
    	"location = no, width = 800px, height = 600px, resizable = yes,scrollbars = yes");  // 800WA_WEBCONSOLE158                          
}


/** 
 * This function is for checking the Agent Selection
 * @param r_stUrl contains the url of the screen to be opened.
 * @param r_stNoAgentKey contains the key when no agent is selected.
 * @param r_stNoAgentMsg contains the message when no agent is selected.
 * @param r_stMuliAgentKey contains the key for multi agent selection.
 * @param r_stMuliAgentMsg contains the message for multi agent selection.
 * @param r_stID contain the Id in case of inventory.
 * @since 08-00
 */
function agentSelectionCheck(r_stUrl, r_stNoAgentKey, r_stNoAgentMsg, r_stMuliAgentKey, r_stMuliAgentMsg,r_stID)
{
   clearMenu();                                                                 // 800WA_WEBCONSOLE445
   if(r_stUrl==null || r_stNoAgentKey==null ||
	        r_stNoAgentMsg==null|| r_stMuliAgentKey==null ||
	                  r_stMuliAgentMsg==null || r_stID==null)                   // 800WA_WEBCONSOLE029
	{                                                                           // 800WA_WEBCONSOLE029    
	    return;                                                                 // 800WA_WEBCONSOLE029 
	}                                                                           // 800WA_WEBCONSOLE029
	
	var str=r_stID.substring(r_stID.indexOf("Inventory"));                      // 800WA_WEBCONSOLE173
	//if(r_stID == "inventory") {                                               // 800WA_WEBCONSOLE173
	  if(str == "Inventory") {                                                  // 800WA_WEBCONSOLE173
		//fnClose("dropAlertLog");                                              // 800WA_WEBCONSOLE091 
		  clearSubMenu();                                                       // 800WA_WEBCONSOLE091     
	}
	
	var l_objForm = parent.frames["hostDetail"].location;
	myString = new String(l_objForm);                                           // 800WA_WEBCONSOLE151
    var len = myString.substring((myString.length)-4,myString.length);          // 800WA_WEBCONSOLE151
	// if (l_objForm != "about:blank")                                          // 800WA_WEBCONSOLE151
	// if(len!="html")                                                          // 800WA_WEBCONSOLE151 // 800WA_WEBCONSOLE257
	if(parent.frames["hostDetail"].document.forms[0])                           // 800WA_WEBCONSOLE257
	{
		var l_objFormElements = parent.frames["hostDetail"].document.forms[0].elements;
		var l_iCount = 0;
		var l_iCnt = 0 ;
		var l_iSelAgent = 0;
		for(l_iCnt = 0;l_iCnt < l_objFormElements.length; l_iCnt++)
		{  
			if(l_objFormElements[l_iCnt].type == 'checkbox' && l_objFormElements[l_iCnt].checked)
			{
				l_iSelAgent = l_iCnt;
				l_iCount = l_iCount + 1;
			}
		}
	
			if (l_iCount == 0 )
			{
				alert(r_stNoAgentKey + "\n" + r_stNoAgentMsg);
			}
			else if (l_iCount > 1 )
			{
				alert(r_stMuliAgentKey + "\n" +  r_stMuliAgentMsg);
			}
			else if (l_iCount == 1)
			{
				var val = l_objFormElements[l_iSelAgent].value;
				var v = val.split(";");
				
				//var displayName = parent.frames["hostList"].document.forms[0]["name"].value;// 800WA_WEBCONSOLE447
				var displayName = "" ;                                          // 800WA_WEBCONSOLE447
                if (parent.frames["hostList"].document.forms[0] != null) {      // 800WA_WEBCONSOLE447
                    if (parent.frames["hostList"].document.forms[0]["name"]     // 800WA_WEBCONSOLE447
                                                                      != null) {// 800WA_WEBCONSOLE447
                        displayName = parent.frames["hostList"].document        // 800WA_WEBCONSOLE447 
                                                   .forms[0]["name"].value;     // 800WA_WEBCONSOLE447 
                    }                                                           // 800WA_WEBCONSOLE447
                }				                                                // 800WA_WEBCONSOLE447
				
				// var query = r_stUrl + "?nodeId="+ v[0] + "&agentName=" + v[1] + "&source=ClimbTrail_Flag_Host" + "&nodeID="+ v[0] +"&hostName=" + v[1] +"&displayName=" +displayName; // 800WA_WEBCONSOLE167
				 var query = r_stUrl + "?nodeId="+ v[0] +                                          // 800WA_WEBCONSOLE167   
				 "&agentName=" + v[1] +                                                            // 800WA_WEBCONSOLE167
				  "&source=ClimbTrail_Flag_Host" +                                                 // 800WA_WEBCONSOLE167
				  "&nodeID="+ v[0] +"&hostName=" + v[1] +                                          // 800WA_WEBCONSOLE167
				  "&displayName=" +displayName +                                                   // 800WA_WEBCONSOLE167
				  "&nodeType=" +v[2];                                                              // 800WA_WEBCONSOLE167
				// window.open(query,"inventory");                                                // 800WA_WEBCONSOLE099  
				window.open(query,r_stID,"menubar = no, toolbar = no, status = yes, "  +          // 800WA_WEBCONSOLE099
    			"location = no, width = 800px, height = 600px, resizable = yes, scrollbars = yes"); // 800WA_WEBCONSOLE099
			}
	}
	else
	{
		alert(r_stNoAgentKey + "\n" + r_stNoAgentMsg);
	}
}
/** 
 * This function is for opening web console setting screen
 * @since 08-00
 */
function opWebConSet(r_varUrl,r_stId)
{
clearMenu();                                                                    // 800WA_WEBCONSOLE445
window.open(r_varUrl,r_stId,"menubar = no, toolbar = no, status = yes, "  +          
         "location = no, width = 800px, height = 600px, resizable = yes,scrollbars = auto");
}

/** 
 * This function is for opening manager service setting screen
 * @since 08-00
 */

function opMgrSerSet(r_varUrl,r_stId){
clearMenu();                                                                    // 800WA_WEBCONSOLE445
window.open(r_varUrl,r_stId,"menubar = no, toolbar = no, status = yes, "  +          
         "location = no, width = 800px, height = 600px, resizable = yes,scrollbars = auto");
}


/**
 * This method is used invoke the agent registration screen from host management screen.
 */
function opAgtRegister(r_varUrl,r_stId)
{
  clearMenu();                                                                  // 800WA_WEBCONSOLE445
  window.open(r_varUrl,r_stId,"menubar = no, toolbar = no, status = yes, "  +          
         "location = no, width = 800px, height = 600px, resizable = yes,scrollbars = auto");
}

/**
 * This method is used do the validations for host operation and display the 
 * confirmation dialog for the selected nodes.
 * @param r_varAction Contains the From Action string.
 * @param r_varKey contains the error ID for no agent selection.
 * @param r_varTitle contains the title of the confirmation dialog.
 * @param r_varArg0 contains the product name to be added to title.
 * @param r_varImage contains the icon name of the confirmation dialog.
 * @param r_varErrorId contains the confirmation id.
 * @param r_varMessage contains the confirmation message
 * @param r_varOk contains the Ok button value.
 * @param r_varCancel contains the Cancel Button value.
 * @param r_varOkAll contains the Ok All Button value.
 * @param r_varOkAll contains the Ok All Button value.
 * @param r_varAlt Contains the alt property for the confirm icon.
 * @since 08-00
 */
function opAgtDelete(r_varAction,r_varKey,r_varTitle,r_varArg0,r_varImage,
         r_varErrorId,r_varMessage,r_varOk,r_varCancel,r_varOkAll,r_varAlt) 
{
  clearMenu();                                                                  // 800WA_WEBCONSOLE445
  if(r_varKey==null || r_varTitle==null || r_varArg0==null || r_varImage==null ||
	   r_varErrorId==null || r_varMessage==null || r_varOk==null ||
	          r_varCancel==null || r_varOkAll==null)             
  {                                                                             
      return;                                                                   
  }                                                                             
  
  if(isHostSelected('nodeId',r_varKey))
  {
    var r_stTitle = new String(r_varTitle);
    var l_varExpression0 = /\{0\}/gi;
    r_stTitle = r_stTitle.replace(l_varExpression0, r_varArg0);
 
// var l_objCheckBox = parent.frames["hostDetail"].document.forms[0]['nodeId']; // 800WA_WEBCONSOLE260 
    var l_objCheckBox = parent.frames["hostDetail"].document.forms[0];          // 800WA_WEBCONSOLE260 
    var l_varCheckedCount = 0;
  
    for(var i=0;i<l_objCheckBox.length;i++)
    {
	  // if(l_objCheckBox[i].checked)                                           // 800WA_WEBCONSOLE260 
	  if(l_objCheckBox[i].type == 'checkbox' && l_objCheckBox[i].checked)       // 800WA_WEBCONSOLE260 

      {
      	l_varCheckedCount++;
	    var l_varVal = l_objCheckBox[i].value;
	    var l_varTemp = l_varVal.split(";");
        var l_varMessage = new String(r_varMessage);
        l_varMessage = r_varMessage.replace(l_varExpression0, l_varTemp[1]);
    //  var l_varDialogProp = new confirmationProperties(r_stTitle,r_varImage,r_varErrorId,l_varMessage,r_varOk,r_varOkAll,r_varCancel,r_varAlt);   // 800WA_WEBCONSOLE161     // 800WA_WEBCONSOLE260 
        var l_varDialogProp = new confirmationProperties(r_stTitle,r_varImage,r_varErrorId,l_varMessage,r_varOk,r_varOkAll,r_varCancel,r_varAlt,3); // 800WA_WEBCONSOLE161     // 800WA_WEBCONSOLE260 
        window.showModalDialog('jsp/confirmDialog.html',l_varDialogProp,"dialogHeight:150px;dialogWidth:300px;status:no;help:no");
        if(l_varDialogProp.l_varReturnValue==0) 	// For Ok press.
        {
          continue;
        }
        else if(l_varDialogProp.l_varReturnValue==1) // for Ok all press.
        {
          break;
        }
        else if(l_varDialogProp.l_varReturnValue==2) // For Cancel press.
        {
          if(l_varCheckedCount==1)
          {
            return;
          }
          for(var l_varInnerCount=i; l_varInnerCount<l_objCheckBox.length;l_varInnerCount++)
          {
  	    if(l_objCheckBox[l_varInnerCount].type == 'checkbox')               // 800WA_WEBCONSOLE260 
            {                                                                   // 800WA_WEBCONSOLE260 
            	l_objCheckBox[l_varInnerCount].checked = false;
            }                                                                   // 800WA_WEBCONSOLE260 
          }
          break;
        }
  	  }
    }
    parent.frames["hostDetail"].document.forms[0].action = r_varAction;
    parent.frames["hostDetail"].document.forms[0].submit();
  }
}


/** 
 * This function is for group management window opening.
 * @param r_stUrl contains the url of the screen to be opened.
 * @param r_stId contains the window name.
 * @since 08-00
 */
function opGroupMgmt(r_stUrl,r_stId){
   clearMenu();                                                                 // 800WA_WEBCONSOLE445
   window.open(r_stUrl,r_stId,"menubar = no, toolbar = no, status = yes, "  +          
         "location = no, width = 800px, height = 600px, resizable = yes,scrollbars = auto");
}

