#!/bin/sh
#
#   name    = install.sh
#   func    = install rpm package
#
#                                   Copyright (C) 2006, Hitachi, Ltd.
#

while true
do
  echo -n "Start installation (y/n)?: "
  read -n 1 CH

  echo
  case "$CH" in
    [yY]) break ;;
    [nN]) exit 0 ;;
    *) ;;
  esac
done


#Check CD
CDMOUNTDIR=$1
if [ ! -d "${CDMOUNTDIR}" ]
then
	echo "Error: Invalid rpm path."
	echo ""
	echo "Usage: install.sh <directory>"
	echo " Example: install.sh /mnt/CDROM/ "
	exit 10
else
	CDMOUNTDIR=$1
fi


RPM_FILE=`find ${CDMOUNTDIR} -name ServerConductor_Agent\*.rpm -maxdepth 1 -print`

#Check RPM Package File
if [ ! -e "${RPM_FILE}" ]
then
	echo "Error: RPM package has not been found."
	exit 11
fi


# Check older version
AGENT_VERSION=''
VERSION_DIR=/var/opt/hitachi/serverconductor/agent/log
if [ -f "${VERSION_DIR}/version" ]
then
        AGENT_VERSION=`grep server_agent_version ${VERSION_DIR}/version | sed "s/[a-z ]//g" | sed "s/_//g"`
        STD_BASEPATH=`echo ${CDMOUNTDIR} | sed "s/\// /g"`
        STD_RPMFILE=`echo ${RPM_FILE} | sed "s/\// /g" | sed "s/${STD_BASEPATH}//g"`
        RPM_VERSION=`echo ${STD_RPMFILE} | sed "s/ia64//g" | sed "s/[^0-9]//g"`
        if [ ${RPM_VERSION} -le ${AGENT_VERSION} ]
        then
                echo "Error: A later version of program is already installed."
                exit 12
        fi
fi

## stop daemon.
ps -elf | grep -E 'smhtraced|/opt/hitachi/serverconductor/agent/bin/smhagt' | grep -v grep > /dev/null
if [ $? -eq 0 ]
then
	if [ -L /etc/rc.d/init.d/hsysmgr ]
	then
		/etc/rc.d/init.d/hsysmgr stop > /dev/null
		touch /tmp/.HSYSMGR
	fi
fi

## stop driver.
DRIVER_PROCESS=`lsmod | grep SmDrv*  | head -1`
if [ -n "${DRIVER_PROCESS}" ]
then
	if [ -L /etc/rc.d/init.d/hsysmgr.mod ]
	then
		/etc/rc.d/init.d/hsysmgr.mod stop > /dev/null
		touch /tmp/.HSYSMGRMOD
	elif [ -e /etc/rc.d/init.d/hsysmgr.svp ]
	then
		/etc/rc.d/init.d/hsysmgr.svp stop
	fi
fi

# Install
if [ -z "$AGENT_VERSION" ]
then
        # clean installation
        rpm -i --nodeps ${RPM_FILE}
        INST_STATUS=$?
else
        # update installation
        rpm -U --force --nodeps ${RPM_FILE}
        INST_STATUS=$?
        if [ "${INST_STATUS}" -ne "0" ]
        then
                exit ${INST_STATUS}
        fi

        ## Link gcc module.
        FINDDIR="/opt/hitachi/serverconductor/agent/"
        # for gcc3.4
        if [ -f /usr/lib/libstdc++.so.6 ]
        then
                GCCDIR='gcc3.4'
        elif [ -f /usr/lib/libstdc++.so.5 ]
        then
                GCCDIR='gcc3'
        else
                GCCDIR='gcc2'
        fi
        for SRCDIR in `find $FINDDIR -name "$GCCDIR" -print`
        do
                if [ -d $SRCDIR ]
                then
                        for SRCFILE in `ls $SRCDIR/*`
                        do
                                if [ -f $SRCFILE ]
                                then
                                        DIR=`echo $SRCDIR | sed -e "s/\(.*\/\).*/\1/"`
                                        FILE=`basename $SRCFILE`
                                        rm -f $DIR$FILE
                                        ln -s $SRCFILE $DIR$FILE
                                fi
                        done
                fi
        done
fi

## Prepare for Restarting Daemon
START_DAEMON=''
if [ -f /tmp/.HSYSMGR ]
then
	START_DAEMON=start
	rm -f /tmp/.HSYSMGR
fi

## Prepare for Restarting Driver
START_DRIVER=''
if [ -f /tmp/.HSYSMGRMOD ]
then
	START_DRIVER=start
	rm -f /tmp/.HSYSMGRMOD
fi

## Restart driver
if [ -n "${START_DRIVER}" ]
then
	/etc/rc.d/init.d/hsysmgr.mod ${START_DRIVER} > /dev/null

elif [ -L /etc/rc.d/init.d/hsysmgr.svp ]
then
	/etc/rc.d/init.d/hsysmgr.svp start > /dev/null
fi

## Restart daemon
if [ -n "${START_DAEMON}" ]
then
	/etc/rc.d/init.d/hsysmgr ${START_DAEMON} > /dev/null
fi

if [ "${INST_STATUS}" -eq "0" ]
then
	echo "Installation has completed."
fi
exit ${INST_STATUS}


