#!/bin/sh
# hsysmgr.mod:       Starts the Drivers for System Manager Agent.
#
# Version:
#
# chkconfig:345 94 6
# description: JP1/ServerConductor/Agent (for Linux)
# processname: 
# config:

dirBASE="/opt/hitachi/serverconductor/agent"
LIBDIR="/opt/hitachi/serverconductor/agent/lib"

### Function ###
logFILE="/var/opt/hitachi/serverconductor/agent/log/script.log"
message() {
	_MESSAGE=$1
	_DATE="`date +\"%c\"`> "
	echo "${_MESSAGE}"
	echo -n "${_DATE}" >> ${logFILE}
	echo "${_MESSAGE}" >> ${logFILE}
}

#
# Function for module
#

start_module() {
	module=$1
	device=$2
	DRIVER_DIR=$3

	# Link Driver
	if [ -n "${DRIVER_DIR}" ]
	then
		rm -f ${LIBDIR}/$module.o
		ln -s ${DRIVER_DIR}/$module.o ${LIBDIR}/$module.o
		# echo "Use the driver in ${DRIVER_DIR}"
	else
		message "Error: No Driver for `uname -r` kernel"
		return 1
	fi

	fileMOD="$dirBASE/lib/$module.o"

	if [ -f "$fileMOD" ]
	then
		insmod -f $fileMOD 2> /tmp/smhdriver
		grep -vi Warning /tmp/smhdriver > /tmp/smhdrvErr
		if [ -s /tmp/smhdrvErr ]
		then
			message "Error: Can't load $fileMOD"
			cat /tmp/smhdrvErr
			cat /tmp/smhdrvErr >> ${logFILE}
			rm -rf /tmp/smhdriver
			rm -rf /tmp/smhdrvErr
			return 1
		fi
		rm -rf /tmp/smhdriver
		rm -rf /tmp/smhdrvErr

		major=`cat /proc/devices | awk "\\$2==\"$module\" {print \\$1}"`

		rm -f /dev/$device
		mknod /dev/$device c $major 0
	else
		message "Error: Not exist $fileMOD"
		return 1
	fi
	return 0
}

stop_module() {
	module=`lsmod | cut -d' ' -f1 | grep $1`
	if [ "$module" != "" ]
	then
		rmmod $1
	fi
	return 0
}

get_driver_status() {
	DRIVER_SVP_STATUS=`lsmod | grep SmDrvSvp | head -1`
}

#
# main
#

case "$1" in
	start)
		get_driver_status
		if [ -e /etc/rc.d/init.d/hsysmgr.svp ]
		then
			if [ -z "$DRIVER_SVP_STATUS" ]
			then
				/etc/rc.d/init.d/hsysmgr.svp start
			fi
		fi

		touch /var/lock/subsys/hsysmgr.mod
		;;

	stop)
		if [ -e /etc/rc.d/init.d/hsysmgr.svp ]; then
			/etc/rc.d/init.d/hsysmgr.svp stop
		fi
		rm -f /var/lock/subsys/hsysmgr.mod
		;;

	*)
		exit 1
esac

exit 0
