/* Copyright : All Rights Reserved. Copyright (C) 2006, Hitachi, Ltd.
 * Title     : ServerConductor WebConsole
 * Version   : 08-00
 * Name      : agentRegist.js
 * Date      : 2006/06/01
 * Author    : Sukumaran.R
 */

 /**
 * Contains the error details.
 * @since 08-00
 */
var errorMsg = new Array();
var m_stHostData ;																// 800WA_WEBCONSOLE376
 /**
 * This method is used validate the host information entered in the agent 
 * registration screen.
 * @param r_varHostData Host data entered by the user (IP Address/ Host Name).
 * @since 08-00
 */
function validateHostData(r_varHostData)
{ 
  if(document.forms[0].Register.disabled == true){                              //800WA_WEBCONSOLE451
         return false;                                                          //800WA_WEBCONSOLE451
  }                                                                             //800WA_WEBCONSOLE451
 m_stHostData = r_varHostData;													// 800WA_WEBCONSOLE376
  r_varHostData = trim(r_varHostData);
  if(r_varHostData == null || r_varHostData.length <= 0)
  {
    alertMsgs(MSG_HOST_CHECK);
//    document.forms[0].hostData.focus();										// 800WA_WEBCONSOLE341
	document.forms[0].hostData.value="";										// 800WA_WEBCONSOLE376
	document.forms[0].hostData.select();										// 800WA_WEBCONSOLE341

    return false;
  }
  var l_blFlag = checkIPAddress(r_varHostData);                                 //800WA_WEBCONSOLE451
  if(l_blFlag == true){                                                         //800WA_WEBCONSOLE451
     document.forms[0].Register.disabled = true;                                //800WA_WEBCONSOLE451
     document.forms[0].hostData.readOnly = true;                                //800WA_WEBCONSOLE451
  }
// return checkIPAddress(r_varHostData);                                        //800WA_WEBCONSOLE451
   return l_blFlag;                                                             //800WA_WEBCONSOLE451  
} 

 /**
 * This method is used to check if the input parameter is a valid IP Address.
 * @param r_varHostData The IP Address to be verified for validity.
 * @since 08-00
 */
function checkIPAddress(r_varIPAddress)
{
  r_varIPAddress = trim(r_varIPAddress);
  var l_varSplit = r_varIPAddress.split(".");
  var l_varIPFlag = true;

  if(l_varSplit.length==4)
  {						
    for(l_varCount=0; l_varCount<4; l_varCount++)								// 800WA_WEBCONSOLE485								
    {																			// 800WA_WEBCONSOLE485
        var l_varVal1 = l_varSplit[l_varCount];									// 800WA_WEBCONSOLE485
        l_varVal1 = trim(l_varVal1);											// 800WA_WEBCONSOLE485
        if(l_varVal1 != l_varSplit[l_varCount])									// 800WA_WEBCONSOLE485
        {																		// 800WA_WEBCONSOLE485
           alertMsgs(MSG_RGTAGT_IP_HOST_NAME_ERROR);							// 800WA_WEBCONSOLE485						
           document.forms[0].hostData.select();									// 800WA_WEBCONSOLE485
           return false;														// 800WA_WEBCONSOLE485
        }																		// 800WA_WEBCONSOLE485
    // var l_varToken = parseInt(l_varSplit[l_varCount]);                       // 800WA_WEBCONSOLE439
    // var l_varToken = ""+parseInt(l_varSplit[l_varCount]);                    // 800WA_WEBCONSOLE439
     var l_varToken = ""+parseInt(l_varSplit[l_varCount],10);					// 800WA_WEBCONSOLE482
     // if(l_varToken != l_varSplit[l_varCount])								// 800WA_WEBCONSOLE485
     if(l_varToken == 'NaN')													// 800WA_WEBCONSOLE485
      {
        l_varIPFlag = false;
        break;																	// 800WA_WEBCONSOLE485
      }
    }
    if(l_varIPFlag)																// 800WA_WEBCONSOLE485
    {																			// 800WA_WEBCONSOLE485
        for(l_varCnt=0; l_varCnt<4; l_varCnt++) 								// 800WA_WEBCONSOLE485
        {																		// 800WA_WEBCONSOLE485
            if(l_varSplit[l_varCnt].length > 3)									// 800WA_WEBCONSOLE485
            {																	// 800WA_WEBCONSOLE485
                alertMsgs(MSG_RGTAGT_IP_HOST_NAME_ERROR);						// 800WA_WEBCONSOLE485
                document.forms[0].hostData.select();							// 800WA_WEBCONSOLE485
                return false;													// 800WA_WEBCONSOLE485
            }																	// 800WA_WEBCONSOLE485
        }																		// 800WA_WEBCONSOLE485
    }																			// 800WA_WEBCONSOLE485
   }
   else
   {
     l_varIPFlag = false;
   }

  if(l_varIPFlag == true)
  {
    // The input value is an IP address.
    for(l_varCount=0; l_varCount <  4; l_varCount++)
    {
//      if(l_varToken < 0 || l_varToken > 255)									// 800WA_WEBCONSOLE485
        if(l_varSplit[l_varCount] < 0 || l_varSplit[l_varCount] > 255)			// 800WA_WEBCONSOLE485
      { 
        alertMsgs(MSG_RGTAGT_IP_HOST_NAME_ERROR);
//        document.forms[0].hostData.focus();										// 800WA_WEBCONSOLE341
		document.forms[0].hostData.select();										// 800WA_WEBCONSOLE341
        return false;
      }
    }
    return true;
  }
  else
  {
    // The input value is a host name.
    return (checkValidHostName(r_varIPAddress));
  }
}
  
 /**
 * This method is used to check if the input parameter is a valid Host Name.
 * @param r_varHostData the Host name to be verified for validity.
 * @since 08-00
 */
function checkValidHostName(r_varHostName)
{
	r_varHostName=m_stHostData;													// 800WA_WEBCONSOLE376
  //r_varHostName = trim(r_varHostData);										// 800WA_WEBCONSOLE376
  for(l_varCount = 0;l_varCount<r_varHostName.length; l_varCount++)
  {
    var l_varChar = r_varHostName.charAt(l_varCount);
    if((l_varChar >= 'a' && l_varChar <= 'z') || 
       (l_varChar >= 'A' && l_varChar <= 'Z') || 
       (l_varChar >= '0' && l_varChar <= '9') || 
    // (l_varChar == '@') || (l_varChar == '.'))								// 800WA_WEBCONSOLE376								
   	   (l_varChar == '-') || (l_varChar == '.'))								// 800WA_WEBCONSOLE376
    {
      continue;
    }
    else
    {
      alertMsgs(MSG_RGTAGT_IP_HOST_NAME_ERROR);
//       document.forms[0].hostData.focus();									// 800WA_WEBCONSOLE341
	  document.forms[0].hostData.select();										// 800WA_WEBCONSOLE341
      return false;
    }
  }
  return true;
}
