/*
 * Copyright : All Rights Reserved. Copyright (C) 2006, Hitachi, Ltd.
 * Title     : ServerConductor WebConsole
 * Version   : 08-00
 * Name      : group.js
 * Date      : 2006/04/12
 */
 
 /**
 * This javascript contains methods for operations in the 
 * group management,for user input validations 
 * @version 08-00
 * @since 08-00
 * @author Sundari Sasindran
 */
 
 /**
 * This method is used for setting the groupId on mouse click.
 * @param r_varGroupId Contains the groupId for power control operation
 * It takes the value HsmConst.GROUPTREE_ID_POWERCTRL  
 * @since 08-00
 */
 function groupIdValueSet(r_varGroupId,r_varObj){
   
   document.getElementById('dropGroupMgmtLink').style.backgroundColor = "white";// 800WA_WEBCONSOLE445
   document.getElementById('dropGroupMgmtLink').focus();                        // 800WA_WEBCONSOLE445
   showHide(m_displayGroupsubMenu,'none');                                      // 800WA_WEBCONSOLE445
   //check the input parameter
   if (r_varGroupId == null || r_varObj == null ){
     return;
   }
//  if(window.event.button == CONST_MOUSE_LEFT_CLICK ||                         // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
//      window.event.keyCode == CONST_ENTER){                                   // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
   	document.forms[0]["groupId"].value = r_varGroupId;
   	document.forms[0].submit();
// 	}                                                                           // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
 }
 var CONST_MOUSE_LEFT_CLICK = 1;                                                // 800WA_WEBCONSOLE367
 var CONST_TAB = 9;                                                             // 800WA_WEBCONSOLE353
 var CONST_ENTER = 13;                                                          // 800WA_WEBCONSOLE353
 /**
 * This method is used for setting the groupId on key press.
 * @param r_varGroupId Contains the groupId for power control operation.
 * It takes the value HsmConst.GROUPTREE_ID_POWERCTRL  
 * @since 08-00
 */
 function groupIdValueSetOnKey(r_varGroupId){                                   // 800WA_WEBCONSOLE353
   
   //check the input parameter      
   if (r_varGroupId == null ){                                                  // 800WA_WEBCONSOLE353
     return;                                                                    // 800WA_WEBCONSOLE353
   }                                                                            // 800WA_WEBCONSOLE353
 if(window.event.keyCode == CONST_ENTER){                                       // 800WA_WEBCONSOLE353
   	document.forms[0]["groupId"].value = r_varGroupId;                          // 800WA_WEBCONSOLE353
   	document.forms[0].submit();                                                 // 800WA_WEBCONSOLE353
  } 	                                                                        // 800WA_WEBCONSOLE353
 }                                                                              // 800WA_WEBCONSOLE353
   
 /**
 * This method is used displaying the Tree when the 
 * Display group->Power control is clicked.
 * @param r_varNodeName Contains the name of the node clicked
 * @param r_varPlusImg Contains the image Url for plus icon
 * @param r_varMinusImg Contains the image Url for minus icon
 * @param r_varSelImg Contains the image Url for selected node icon
 * @param r_varNotSelImg Contains the image Url for node icon
 * @since 08-00
 */
 //function listTree(r_varNodeName, r_varPlusImg, r_varMinusImg,                // 800WA_WEBCONSOLE328
 //                              r_varNotSelImg, r_varSelImg) {                 // 800WA_WEBCONSOLE328
 function listTree(r_varNodeName, r_varPlusImg, r_varMinusImg,                  // 800WA_WEBCONSOLE328
                              r_varNotSelImg, r_varSelImg,r_varAltSelect,       // 800WA_WEBCONSOLE328
                              r_varAltNotSelect) {                              // 800WA_WEBCONSOLE328 
   //check the input parameter 
   if (r_varNodeName == null || r_varPlusImg == null || r_varMinusImg == null ){
     return;
   }        
   
   if (r_varNotSelImg == null || r_varSelImg == null ){
     return;
   } 

  var l_varMenu = document.all[r_varNodeName].style;
  var l_varImg = document.all.item(r_varNodeName + "img");
  var l_varImgNodeIcon = document.all.item(r_varNodeName + "imgNodeIcon");

  if(l_varMenu == null || l_varImg == null || l_varImgNodeIcon == null){
  	return;
  }

  if(l_varMenu.display == 'none') {
    
  	l_varMenu.display = "block";
  	l_varImg.src = r_varMinusImg;
    l_varImgNodeIcon.src = r_varSelImg;
    l_varImgNodeIcon.alt = r_varAltNotSelect;                                   // 800WA_WEBCONSOLE328
  } 
  else {
  	l_varMenu.display = "none";
  	l_varImg.src = r_varPlusImg;
	l_varImgNodeIcon.src = r_varNotSelImg;
    l_varImgNodeIcon.alt = r_varAltSelect;                                      // 800WA_WEBCONSOLE328
  }
}

/**
 * This method is used for appending the child node with the parent node.
 * @param r_varDivNode Contains the name of the node clicked
 * @param r_varPlusImg Contains the image Url for plus icon
 * @param r_varMinusImg Contains the image Url for minus icon
 * @param r_varClimbTrail Contains the climb trail of the node 
 * @param r_varURL Contains the name of url of the detail block
 * @param r_varSelIcon Contains the name of url of the selected node icon
 * @param r_varNotSelIcon Contains the name of url of the node icon
 * @param r_varOperationType Contains the operation flag
 * @since 08-00
 */
//function groupParentNode(r_varDivNode, r_varPlusImg, r_varMinusImg,           // 800WA_WEBCONSOLE293
//                   r_varClimbTrail,r_varGroupName,r_varURL,                   // 800WA_WEBCONSOLE293
//	               r_varNotSelIcon, r_varSelIcon,r_varOperationType) {  	    // 800WA_WEBCONSOLE293

/*function groupParentNode(r_varDivNode, r_varPlusImg, r_varMinusImg,           // 800WA_WEBCONSOLE293	// 800WA_WEBCONSOLE328        
                   r_varClimbTrail,r_varURL,r_varNotSelIcon,                    // 800WA_WEBCONSOLE293	// 800WA_WEBCONSOLE328
	                r_varSelIcon,r_varOperationType) { */                       // 800WA_WEBCONSOLE293	// 800WA_WEBCONSOLE328

 function groupParentNode(r_varDivNode, r_varPlusImg, r_varMinusImg,            // 800WA_WEBCONSOLE328        
                   r_varClimbTrail,r_varURL,r_varNotSelIcon,                    // 800WA_WEBCONSOLE328
	                r_varSelIcon,r_varOperationType,r_varAltSelect,             // 800WA_WEBCONSOLE328
	                r_varAltNotSelect) { 	                                    // 800WA_WEBCONSOLE328            
	
	//check the input parameter                
    if (r_varDivNode == null || r_varPlusImg == null || r_varMinusImg == null ){
      return;
    }                
    
  //if (r_varClimbTrail == null || r_varGroupName == null || r_varURL == null){ // 800WA_WEBCONSOLE293
    if (r_varClimbTrail == null || r_varURL == null){                           // 800WA_WEBCONSOLE293  
      return;
    } 
    
    if (r_varNotSelIcon == null || r_varSelIcon == null 
                                                || r_varOperationType == null){
      return;
    }
    //TAB key
    //if(window.event.keyCode != CONST_TAB)                                     // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
//  if(window.event.keyCode == CONST_ENTER ||                                   // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
//     window.event.button == CONST_MOUSE_LEFT_CLICK)                           // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
//	{                                                                           // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
	//groupTargetNode(r_varClimbTrail,r_varGroupName,r_varURL,                  // 800WA_WEBCONSOLE293
	  //           r_varOperationType);                                         // 800WA_WEBCONSOLE293
	groupTargetNode(r_varClimbTrail,r_varURL,r_varOperationType);               // 800WA_WEBCONSOLE293
	
/*	listTree(r_varDivNode, r_varPlusImg, r_varMinusImg,                         // 800WA_WEBCONSOLE328
	             r_varNotSelIcon,r_varSelIcon);*/                               // 800WA_WEBCONSOLE328
	listTree(r_varDivNode, r_varPlusImg, r_varMinusImg,                         // 800WA_WEBCONSOLE328 
	             r_varNotSelIcon,r_varSelIcon,r_varAltSelect,r_varAltNotSelect);// 800WA_WEBCONSOLE328                                          
//	}                                                                           // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
//	else{                                                                       // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
//     document.getElementById(r_varClimbTrail).focus();                        // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
//	}                                                                           // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
	             
}

/**
 * This method is used to set the values in the form and display the 
 * details in the detail block
 * @param r_varClimbTrail Contains the climb trail of the node 
 * @param r_varURL Contains the name of url of the detail block
 * @param r_varOperationType Contains the operation flag 
 * @since 08-00
 */
 
//function groupTargetNode(r_varClimbTrail,r_varGroupName,r_varURL,             // 800WA_WEBCONSOLE293
                          //  r_varOperationType){                              // 800WA_WEBCONSOLE293

  function groupTargetNode(r_varClimbTrail,r_varURL,                            // 800WA_WEBCONSOLE293                                       
                            r_varOperationType){                                // 800WA_WEBCONSOLE293                
   //check the input parameter                         
   //if (r_varClimbTrail == null || r_varGroupName == null ){                   // 800WA_WEBCONSOLE293
   if (r_varClimbTrail == null) {                                               // 800WA_WEBCONSOLE293
     return;
   }
   
   if (r_varURL == null || r_varOperationType == null ){
     return;
   }
    //TAB key
    //if(window.event.keyCode != CONST_TAB)                                     // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
//  if(window.event.keyCode == CONST_ENTER ||                                   // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
//     window.event.button == CONST_MOUSE_LEFT_CLICK)                           // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
//	{                                                                           // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
	//activeLink(r_varClimbTrail,l_varName);                                    // 800WA_WEBCONSOLE367	// 800WA_WEBCONSOLE445
	activeLinkTree(r_varClimbTrail,l_varName);                                  // 800WA_WEBCONSOLE445
    //backgroundColorChange(r_varClimbTrail);                                   // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE367
    var l_varNodeId = r_varClimbTrail + "node";                                 // 800WA_WEBCONSOLE293
    
	//document.forms[0]["groupName"].value = r_varGroupName;                    // 800WA_WEBCONSOLE293
	document.forms[0]["groupName"].value =                                      // 800WA_WEBCONSOLE293
	                                document.getElementById(l_varNodeId).value; // 800WA_WEBCONSOLE293
	document.forms[0]["climbTrail"].value = r_varClimbTrail;	
	document.forms[0]["source"].value = getFrameIndex();
	document.forms[0].action = r_varURL;
	document.forms[0]["operationType"].value = r_varOperationType;
//	parent.frames["1"].document.forms["0"].target = 'groupDetailFrame';         // 800WA_WEBCONSOLE406

    var l_stGroupName = escape(document.getElementById(l_varNodeId).value);     // 800WA_WEBCONSOLE406
	var l_stUrl = r_varURL +                                                    // 800WA_WEBCONSOLE406
	              "?groupName=" + l_stGroupName +                               // 800WA_WEBCONSOLE406
	              "&groupId=" + document.forms[0]["groupId"].value +            // 800WA_WEBCONSOLE406 
	              "&climbTrail=" + r_varClimbTrail +                            // 800WA_WEBCONSOLE406
	              "&source=" + getFrameIndex() +                                // 800WA_WEBCONSOLE406
	              "&operationType=" + r_varOperationType;                       // 800WA_WEBCONSOLE406

	parent.frames[2].location.href = l_stUrl;                                   // 800WA_WEBCONSOLE406
	//document.forms[0].submit();                                               // 800WA_WEBCONSOLE353
//	}                                                                           // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
//	else{                                                                       // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
//     document.getElementById(r_varClimbTrail).focus();                        // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
//	}                                                                           // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
}
 
/**
 * This method is used for editing a group name after selecting a group in the 
 * table and clicking the "Group name edit" menu of Group management screen.
 * @param r_varUrl Contains the URL to the Edit page
 * @param r_varTarget Contains the target name of the Edit page
 * @param r_varOperationType Contains the operation type of the Edit page
 * @since 08-00
 */
function editGroupName(r_varUrl,r_varTarget,r_varOperationType,r_varNodeId){ 
    
    //check the input parameter
    if (r_varUrl == null || r_varTarget == null ){
      return;
    }
    
    if (r_varOperationType == null || r_varNodeId == null ){
      return;
    }
    
//	if(!selectionCheckBox(r_varNodeId)){                                        // 800WA_WEBCONSOLE389
//		formTableSubmit(r_varUrl,r_varTarget,r_varOperationType);               // 800WA_WEBCONSOLE389
//  }                                                                           // 800WA_WEBCONSOLE389

	var l_blTreeUnSelected = false;                                             // 800WA_WEBCONSOLE389
	l_blTreeUnSelected = selectionTreeCheckBox(r_varOperationType);             // 800WA_WEBCONSOLE389
	if(l_blTreeUnSelected == false){                                            // 800WA_WEBCONSOLE389
		formTreeSubmit(r_varUrl,r_varTarget,r_varOperationType);                // 800WA_WEBCONSOLE389
	}                                                                           // 800WA_WEBCONSOLE389
	else if(l_blTreeUnSelected == 'root'){                                      // 800WA_WEBCONSOLE389
        alert(MSG_GROUP_ROOT_ERROR + "\n" +                                     // 800WA_WEBCONSOLE389
		                  errorMessage[MSG_GROUP_ROOT_ERROR]);                  // 800WA_WEBCONSOLE389	
		return;                                                                 // 800WA_WEBCONSOLE389
	}	                                                                        // 800WA_WEBCONSOLE389
	else{                                                                       // 800WA_WEBCONSOLE389
 	    var l_blTableUnSelected = false;                                        // 800WA_WEBCONSOLE389
    	l_blTableUnSelected = selectionCheckBox(r_varNodeId);                   // 800WA_WEBCONSOLE389
	    if(l_blTableUnSelected == false){                                       // 800WA_WEBCONSOLE389
     	    formTableSubmit(r_varUrl,r_varTarget,r_varOperationType);           // 800WA_WEBCONSOLE389
    	}                                                                       // 800WA_WEBCONSOLE389
    	else if(l_blTreeUnSelected == true && l_blTableUnSelected == false){    // 800WA_WEBCONSOLE389
     	    alert(MSG_GROUP_SELECT_CHECK + "\n" +                               // 800WA_WEBCONSOLE389 
	                           errorMessage[MSG_GROUP_SELECT_CHECK]);           // 800WA_WEBCONSOLE389
     	}                                                                       // 800WA_WEBCONSOLE389
    }                                                                           // 800WA_WEBCONSOLE389
} 

/**
 * This method is used for adding a group after selecting a group in the table.
 * and clicking the "Group create" menu of Group management screen.
 * @param r_varUrl Contains the URL to the Create page
 * @param r_varTarget Contains the target name of the Create page
 * @param r_varOperationType Contains the operation type of the Create page
 * @since 08-00
 */
function addGroup(r_varUrl,r_varTarget,r_varOperationType){
	
	//check the input parameter
	if (r_varUrl == null || r_varTarget == null || r_varOperationType == null){
      return;
    }
    
/*if((parent.frames["groupListFrame"].document.all.item("climbTrail")!=null) && // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320 
     parent.frames["groupListFrame"].document.all.item("climbTrail").value !='')// 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
  {                                                                             // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
    var l_varId =                                                               // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
        parent.frames["groupListFrame"].document.forms[0]["climbTrail"].value;  // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
    parent.frames["groupListFrame"].document.all.item(l_varId).focus();         // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
  }*/                                                                           // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
   
//	if(!selectionTreeCheckBox(r_varOperationType)){                             // 800WA_WEBCONSOLE389
//		formTreeSubmit(r_varUrl,r_varTarget,r_varOperationType);                // 800WA_WEBCONSOLE389
//	}                                                                           // 800WA_WEBCONSOLE389
	
	var l_blTreeUnSelected = false;                                             // 800WA_WEBCONSOLE389
	l_blTreeUnSelected = selectionTreeCheckBox(r_varOperationType);             // 800WA_WEBCONSOLE389
	if(l_blTreeUnSelected == false){                                            // 800WA_WEBCONSOLE389
		formTreeSubmit(r_varUrl,r_varTarget,r_varOperationType);                // 800WA_WEBCONSOLE389
	}                                                                           // 800WA_WEBCONSOLE389
	else{                                                                       // 800WA_WEBCONSOLE389
 	    var l_blTableUnSelected = false;                                        // 800WA_WEBCONSOLE389
    	l_blTableUnSelected = selectionCheckBox(CONST_INVALID_NODEID);          // 800WA_WEBCONSOLE389
	    if(l_blTableUnSelected == false){                                       // 800WA_WEBCONSOLE389
     	    formTableSubmit(r_varUrl,r_varTarget,r_varOperationType);           // 800WA_WEBCONSOLE389
    	}                                                                       // 800WA_WEBCONSOLE389
    	else if(l_blTreeUnSelected == true && l_blTableUnSelected == false){    // 800WA_WEBCONSOLE389
     	    alert(MSG_GROUP_SELECT_CHECK + "\n" +                               // 800WA_WEBCONSOLE389 
	                           errorMessage[MSG_GROUP_SELECT_CHECK]);           // 800WA_WEBCONSOLE389
     	}                                                                       // 800WA_WEBCONSOLE389
    }                                                                           // 800WA_WEBCONSOLE389
}

/**
 * This method is used for adding a host under a group after selecting the group 
 * in the table and clicking the "Edit group" menu of Group management screen.
 * @param r_varUrl Contains the URL to the machine add page
 * @param r_varTarget Contains the target name of the mavhine add page
 * @param r_varOperationType Contains the operation type of the machine add page
 * @since 08-00
 */
function machineAdd(r_varUrl,r_varTarget,r_varOperationType){
    
    //check the input parameter 
    if (r_varUrl == null || r_varTarget == null || r_varOperationType == null ){
      return;
    }
    
/*if((parent.frames["groupListFrame"].document.all.item("climbTrail")!=null) && // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
     parent.frames["groupListFrame"].document.all.item("climbTrail").value !='')// 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
  {                                                                             // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
    var l_varId =                                                               // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
        parent.frames["groupListFrame"].document.forms[0]["climbTrail"].value;  // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
    parent.frames["groupListFrame"].document.all.item(l_varId).focus();         // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
  } */                                                                          // 800WA_WEBCONSOLE270	// 800WA_WEBCONSOLE320
  
//	if(!selectionTreeCheckBox(r_varOperationType)){                             // 800WA_WEBCONSOLE389
//		formTreeSubmit(r_varUrl,r_varTarget,r_varOperationType);                // 800WA_WEBCONSOLE389
//  }                                                                           // 800WA_WEBCONSOLE389

	var l_blTreeUnSelected = false;                                             // 800WA_WEBCONSOLE389
	l_blTreeUnSelected = selectionTreeCheckBox(r_varOperationType);             // 800WA_WEBCONSOLE389
	if(l_blTreeUnSelected == false){                                            // 800WA_WEBCONSOLE389
		formTreeSubmit(r_varUrl,r_varTarget,r_varOperationType);                // 800WA_WEBCONSOLE389
	}                                                                           // 800WA_WEBCONSOLE389
	else if(l_blTreeUnSelected == 'root'){                                      // 800WA_WEBCONSOLE389
        alert(MSG_GROUP_ROOT_ERROR + "\n" +                                     // 800WA_WEBCONSOLE389
		                  errorMessage[MSG_GROUP_ROOT_ERROR]);                  // 800WA_WEBCONSOLE389	
        return;	                                                                // 800WA_WEBCONSOLE389
	}	                                                                        // 800WA_WEBCONSOLE389
	else{                                                                       // 800WA_WEBCONSOLE389
 	    var l_blTableUnSelected = false;                                        // 800WA_WEBCONSOLE389
    	l_blTableUnSelected = selectionCheckBox(CONST_INVALID_NODEID);          // 800WA_WEBCONSOLE389
	    if(l_blTableUnSelected == false){                                       // 800WA_WEBCONSOLE389
     	    formTableSubmit(r_varUrl,r_varTarget,r_varOperationType);           // 800WA_WEBCONSOLE389
    	}                                                                       // 800WA_WEBCONSOLE389
    	else if(l_blTreeUnSelected == true && l_blTableUnSelected == false){    // 800WA_WEBCONSOLE389
     	    alert(MSG_GROUP_SELECT_CHECK + "\n" +                               // 800WA_WEBCONSOLE389 
	                           errorMessage[MSG_GROUP_SELECT_CHECK]);           // 800WA_WEBCONSOLE389
     	}                                                                       // 800WA_WEBCONSOLE389
    }                                                                           // 800WA_WEBCONSOLE389
} 

/**
 * This method is used set the values in the tree form 
 * @param r_varUrl Contains the URL to the target page
 * @param r_varTarget Contains the target name target  page
 * @param r_varOperationType Contains the operation type of the target page
 * @since 08-00
 */
function formTreeSubmit(r_varUrl,r_varTarget,r_varOperationType){
    
    //check the input parameter
    if (r_varUrl == null || r_varTarget == null || r_varOperationType == null ){
      return;
    }
    
    window.open("",r_varTarget,"menubar = no, toolbar = no, status = yes, "  +          
  	"location = no, width = 800px, height = 600px, resizable = yes,scrollbars = yes"); 
    parent.frames["1"].document.forms["0"]["operationType"].value = 
                                                            r_varOperationType;
	parent.frames["1"].document.forms["0"].action = r_varUrl;
	parent.frames["1"].document.forms["0"].target = r_varTarget;
	parent.frames["1"].document.forms["0"].submit();
}

/**
 * This method is used set the values in the table form 
 * @param r_varUrl Contains the URL to the target page
 * @param r_varTarget Contains the target name target  page
 * @param r_varOperationType Contains the operation type of the target page
 * @since 08-00
 */
function formTableSubmit(r_varUrl,r_varTarget,r_varOperationType){
    
    //check the input parameter
    if (r_varUrl == null || r_varTarget == null || r_varOperationType == null ){
      return;
    }
    
    window.open("",r_varTarget,"menubar = no, toolbar = no, status = yes, "  +          
  	"location = no, width = 800px, height = 600px, resizable = yes,scrollbars = yes"); 
    parent.frames["2"].document.forms["0"]["operationType"].value =
                                                            r_varOperationType;
	parent.frames["2"].document.forms["0"].action = r_varUrl;
	parent.frames["2"].document.forms["0"].target = r_varTarget;
	parent.frames["2"].document.forms["0"].submit();
	
}

/**
 * This method is used for checking if atleast 1 computer has been
 * checked in the check box 
 * @since 08-00
 */
function selectionCheckBox(r_varNodeId){
    
     
    //check the input parameter 
    if (r_varNodeId == null ){
      return true; 
    }
    
    var l_varElements = null;
    
    //if(parent.frames["1"].document.all.item('climbTrail') != null &&          // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
       //parent.frames["1"].document.all.item('climbTrail').value != '') {      // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
     //parent.frames["1"].document.all.item('climbTrail').value = '';           // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
    //}                                                                         // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
    //check if the check box is checked
    if (parent.frames["2"].document.all.item('climbTrailList') == null){
	  alert(MSG_GROUP_SELECT_CHECK + "\n" + 
	                           errorMessage[MSG_GROUP_SELECT_CHECK]);
	  return true;                                                              // 800WA_WEBCONSOLE242
    }
    else {
	  l_varElements =  parent.frames["2"].document.forms["0"].elements;
	}
	
	
	//check if the elements  are present in the form 
	if(l_varElements == null){
	  return true;
	}
	
	var l_varElementCnt = 0;
	var l_varRet = false;
	
	for(var l_varCnt = 0 ; l_varCnt < l_varElements.length ; l_varCnt++){ 
	        
			if(l_varElements[l_varCnt].name == 'climbTrailList'){
				  if(l_varElements[l_varCnt].checked == true) {
				
					l_varElementCnt++;				      
					 var l_objGroupDetail = 
		              parent.frames["2"].groupDetailBeanCollection[l_varElements[l_varCnt].value];
               		  var l_varNodeId = l_objGroupDetail.nodeId;
               		  parent.frames["2"].document.forms["0"]["climbTrail"].value = l_objGroupDetail.climbTrailList;
               		  parent.frames["2"].document.forms["0"]["groupName"].value = l_objGroupDetail.computerName;
				  }
			}
	}

	if(l_varElementCnt == 0) {
	
	    alert(MSG_GROUP_SELECT_CHECK + "\n" + 
	                           errorMessage[MSG_GROUP_SELECT_CHECK]);
	    l_varRet = true;
	}
	else if (l_varElementCnt == 1 && l_varNodeId != r_varNodeId){
		alert(MSG_GROUP_SELECT_CHECK + "\n" + 
		                           errorMessage[MSG_GROUP_SELECT_CHECK]);
	    l_varRet = true;
	}
	else if(l_varElementCnt > 1 ){
	    alert(MSG_GROUP_ONLY_SELECT_CHECK + "\n" + 
	                      errorMessage[MSG_GROUP_ONLY_SELECT_CHECK]);
	    l_varRet = true;
	}
	else{
	  l_varRet = false;
	}
	return l_varRet;
}

/**
 * This method is used for checking if group is selected
 * before clicking the Create menu
 * @since 08-00
 */
function selectionTreeCheckBox(r_varOperationType){
  
  //check the input parameter
    if (r_varOperationType == null ){
      return true;
    }
    
    var l_varElements = null;
    
    // check if the tree is selected
    if (parent.frames["1"].document.all.item('climbTrail') == null){
//	  alert(MSG_GROUPTREE_SELECT_CHECK + "\n" +                                 // 800WA_WEBCONSOLE389
//				                 errorMessage[MSG_GROUPTREE_SELECT_CHECK]);     // 800WA_WEBCONSOLE389
	  return true;	                                                            // 800WA_WEBCONSOLE242
    }
    else{
	  l_varElements =  parent.frames["1"].document.forms["0"].elements;
    }
    
    
    //check if the element in the form is null
	if(l_varElements == null){
	  return true;
	}
	
	var l_varRet = false;
	var l_varOperationType = trim(GROUP_MACHINE_ADD);
	var l_varOperationTypeEdit = trim(GROUP_NAME_EDIT);                         // 800WA_WEBCONSOLE389
	var l_varOperationTypeDelete = trim(GROUP_DELETE);                          // 800WA_WEBCONSOLE389
	for(var l_varCnt = 0 ; l_varCnt < l_varElements.length ; l_varCnt++)
	{  
		if(l_varElements[l_varCnt].name == 'climbTrail'){
			if(l_varElements[l_varCnt].value == ''){
//				alert(MSG_GROUPTREE_SELECT_CHECK + "\n" +                       // 800WA_WEBCONSOLE389
//				                 errorMessage[MSG_GROUPTREE_SELECT_CHECK]);     // 800WA_WEBCONSOLE389
				l_varRet = true;
		        break;                                                          // 800WA_WEBCONSOLE242  
			}
			
//			else if(r_varOperationType == l_varOperationType &&                 // 800WA_WEBCONSOLE389
			else if((r_varOperationType == l_varOperationType ||                // 800WA_WEBCONSOLE389
			         r_varOperationType == l_varOperationTypeEdit ||            // 800WA_WEBCONSOLE389
			         r_varOperationType == l_varOperationTypeDelete)&&          // 800WA_WEBCONSOLE389
			                          l_varElements[l_varCnt].value == "0"){
//				    alert(MSG_GROUP_ROOT_ERROR + "\n" +                         // 800WA_WEBCONSOLE389
//				                            errorMessage[MSG_GROUP_ROOT_ERROR]);// 800WA_WEBCONSOLE389
	//parent.frames['groupListFrame'].document.forms[0]['climbTrail'].value=''; // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
//				 l_varRet = true;                                               // 800WA_WEBCONSOLE389
				 l_varRet = 'root';                                             // 800WA_WEBCONSOLE389
				 break;                                                         // 800WA_WEBCONSOLE242
			}
			else{
				l_varRet = false;
			}
		}
	}
	return l_varRet;
}

/**
 * This method is used for set the source when the check box
 * is checked
 * @param r_objCheckBox Contains the object of the checkbox 
 * @since 08-00
 */

function setValue(r_objCheckBox)
{
    //check the input parameter
    if (r_objCheckBox == null ){
      return;
    }
	document.forms[0]["source"].value = getFrameIndex();
	
}


/**
 * This method is get the index of the frame
 * @return the frame index
 * @since 08-00
 */  
function getFrameIndex()
{
    //check the input parameter 
	var l_objTopFrame = this.parent;
	var l_varIntValue = -1;

	for(var l_varCnt = 0 ;l_varCnt<l_objTopFrame.length; l_varCnt++){
	
	 if(l_objTopFrame[l_varCnt].name == this.name){
	 
	   	l_varIntValue = l_varCnt;
	   	break;
	   }
	}
	return l_varIntValue;
}

var CONST_INVALID_NODEID = -1;                                                  // 800WA_WEBCONSOLE389
var CONST_TREE = 1;                                                             // 800WA_WEBCONSOLE389
var CONST_TABLE = 2;                                                            // 800WA_WEBCONSOLE389
var CONST_RETURN_OK = 0;                                                        // 800WA_WEBCONSOLE389
var CONST_RETURN_OKALL = 1;                                                     // 800WA_WEBCONSOLE389
var CONST_RETURN_CANCEL = 2;                                                    // 800WA_WEBCONSOLE389

/**
 * This method is  used to check conditions for deleting the selected group
 * @param r_varTitle Contains the title name of the screen
 * @param r_varArg0 Contains the argument 0 for the confirmation message
 * @param r_varImage Contains the image for confirmation dialog box
 * @param r_varErrorId Contains the error id for the error message
 * @param r_varMessage Contains the error message
 * @param r_varOk Contains the data for Ok button
 * @param r_varCancel Contains the data for cancel button
 * @param r_varOkAll Contains the data for OKALL buttton
 * @param r_varURL Contains the URL to the group list page
 * @param r_varTarget Contains the name of the target page
 * @since 08-00
 */ 
function groupDeletionOrPowerOperation(r_varTitle,r_varArg0,r_varImage,
            r_varErrorId,r_varMessage,r_varOk,r_varCancel,r_varOkAll, r_varAlt,  
                                       r_varURL,r_varTarget,r_varOperationType){
     //check the input parameter                                  

    if (r_varTitle == null || r_varArg0 == null || r_varImage == null ){
      return;
    }
    
    if (r_varErrorId == null || r_varMessage == null ){
      return;
    }
    
    if (r_varOk == null || r_varCancel == null || r_varOkAll == null ){
      return;
    }
    
    if (r_varURL == null || r_varTarget == null ){
      return;
    }
    
    if (r_varAlt == null || r_varOperationType == null ){                       // 800WA_WEBCONSOLE244
      return;                                                                   // 800WA_WEBCONSOLE244
    }                                                                           // 800WA_WEBCONSOLE244
    
    var l_varElements = null;
    
    //if(parent.frames["1"].document.all.item('climbTrail') != null &&          // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
       //parent.frames["1"].document.all.item('climbTrail').value != '') {      // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
     //parent.frames["1"].document.all.item('climbTrail').value = '';           // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
    //}                                                                         // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
      
//  if (parent.frames["2"].document.all.item('climbTrailList') == null){        // 800WA_WEBCONSOLE389
//	  alert(MSG_GROUP_COMP_SELECT_CHECK + "\n" +                                // 800WA_WEBCONSOLE389
//                                  errorMessage[MSG_GROUP_COMP_SELECT_CHECK]); // 800WA_WEBCONSOLE389
//    return;                                                                   // 800WA_WEBCONSOLE242 // 800WA_WEBCONSOLE389
//  }                                                                           // 800WA_WEBCONSOLE389
//  else {                                                                      // 800WA_WEBCONSOLE389
// 	  l_varElements =  parent.frames["2"].document.forms["0"].elements;         // 800WA_WEBCONSOLE389

    var l_blTreeUnSelected = false;                                             // 800WA_WEBCONSOLE389
    if(r_varOperationType == trim(GROUP_DELETE)){                               // 800WA_WEBCONSOLE389
       if (parent.frames["2"].document.all.item('climbTrailList') == null &&    // 800WA_WEBCONSOLE389
           parent.frames["1"].document.all.item('climbTrail') == null){         // 800WA_WEBCONSOLE389
            alert(MSG_GROUP_COMP_SELECT_CHECK + "\n" +                          // 800WA_WEBCONSOLE389
                  errorMessage[MSG_GROUP_COMP_SELECT_CHECK]);                   // 800WA_WEBCONSOLE389
            return;                                                             // 800WA_WEBCONSOLE389
       }                                                                        // 800WA_WEBCONSOLE389    	
       //if tree is selected    
       if(parent.frames["1"].document.all.item('climbTrail') != null &&         // 800WA_WEBCONSOLE389 
          parent.frames["1"].document.all.item('climbTrail').value != ''){      // 800WA_WEBCONSOLE389		  	
            l_blTreeUnSelected = selectionTreeCheckBox(r_varOperationType);     // 800WA_WEBCONSOLE389
	        if(l_blTreeUnSelected == true){                                     // 800WA_WEBCONSOLE389
                //if the tree and table are not selected then it is error
                if (parent.frames["2"].document.all.item('climbTrailList') == null // 800WA_WEBCONSOLE389
                 || parent.frames["2"].document.all.item('climbTrailList') == ''){ // 800WA_WEBCONSOLE389
      	              alert(MSG_GROUP_COMP_SELECT_CHECK + "\n" +                // 800WA_WEBCONSOLE389
                               errorMessage[MSG_GROUP_COMP_SELECT_CHECK]);      // 800WA_WEBCONSOLE389
                      return;                                                   // 800WA_WEBCONSOLE389
                }                                                               // 800WA_WEBCONSOLE389
   	        }                                                                   // 800WA_WEBCONSOLE389
    	    else if(l_blTreeUnSelected == 'root'){                              // 800WA_WEBCONSOLE389
                 alert(MSG_GROUP_ROOT_ERROR + "\n" +                            // 800WA_WEBCONSOLE389
		               errorMessage[MSG_GROUP_ROOT_ERROR]);                     // 800WA_WEBCONSOLE389
		         return;                                                        // 800WA_WEBCONSOLE389
            }	                                                                // 800WA_WEBCONSOLE389
       }                                                                        // 800WA_WEBCONSOLE389
       else{                                                                    // 800WA_WEBCONSOLE389       	          
           //if the tree and table are not selected then it is error
           var l_stTableSource = '';                                            // 800WA_WEBCONSOLE389
           if(parent.frames["2"].document.all.item('source') != null){          // 800WA_WEBCONSOLE389
               l_stTableSource =                                                // 800WA_WEBCONSOLE389
                     parent.frames["2"].document.all.item('source').value;      // 800WA_WEBCONSOLE389
           }
           if (l_stTableSource == CONST_TREE ||                                 // 800WA_WEBCONSOLE389
               parent.frames["2"].document.all.item('climbTrailList') == null ||// 800WA_WEBCONSOLE389
                parent.frames["2"].document.all.item('climbTrailList') == ''){  // 800WA_WEBCONSOLE389                
	               alert(MSG_GROUP_COMP_SELECT_CHECK + "\n" +                   // 800WA_WEBCONSOLE389
                                  errorMessage[MSG_GROUP_COMP_SELECT_CHECK]);   // 800WA_WEBCONSOLE389
                   return;                                                      // 800WA_WEBCONSOLE389
           }                                                                    // 800WA_WEBCONSOLE389
       }                                                                        // 800WA_WEBCONSOLE389
    }                                                                           // 800WA_WEBCONSOLE389
	
    var l_stSource = "";                                                        // 800WA_WEBCONSOLE389
    if(r_varOperationType == trim(GROUP_DELETE) &&                              // 800WA_WEBCONSOLE389
       l_blTreeUnSelected == false &&                                           // 800WA_WEBCONSOLE389
       parent.frames["2"].document.all.item('climbTrailList') == '') {          // 800WA_WEBCONSOLE389       
         l_varElements = parent.frames["1"].document.forms["0"].elements;       // 800WA_WEBCONSOLE389
         l_stSource =                                                           // 800WA_WEBCONSOLE389
              trim(parent.frames["1"].document.forms["0"]["source"].value);     // 800WA_WEBCONSOLE389
    }                                                                           // 800WA_WEBCONSOLE389
//  else{                                                                       // 800WA_WEBCONSOLE389	// 800WA_WEBCONSOLE488
    else if(l_blTreeUnSelected == false &&                                      // 800WA_WEBCONSOLE488
       parent.frames["2"].document.forms["0"] != null) {                        // 800WA_WEBCONSOLE488
 	  l_varElements =  parent.frames["2"].document.forms["0"].elements; 	    // 800WA_WEBCONSOLE389
      l_stSource =                                                              // 800WA_WEBCONSOLE389
              trim(parent.frames["2"].document.forms["0"]["source"].value);     // 800WA_WEBCONSOLE389
 	}                                                                           // 800WA_WEBCONSOLE389
 	else{                                                                       // 800WA_WEBCONSOLE488
 		if(l_blTreeUnSelected == true){                                         // 800WA_WEBCONSOLE488
            return;                                                             // 800WA_WEBCONSOLE488
        }                                                                       // 800WA_WEBCONSOLE488
        l_varElements = parent.frames["1"].document.forms["0"].elements;        // 800WA_WEBCONSOLE488
        l_stSource =                                                            // 800WA_WEBCONSOLE488
              trim(parent.frames["1"].document.forms["0"]["source"].value);     // 800WA_WEBCONSOLE488
    }                                                                           // 800WA_WEBCONSOLE488
 	// check if the elemnts are present in the form
 	if(l_varElements == null){
 	  return;
 	}
 	
	var l_varElementCnt=0;
//	var l_varExpression0 = /\{0\}/gi;                                           // 800WA_WEBCONSOLE389
	var l_varFlag = false;
    //for deletion in table and power operations
    if(l_stSource == CONST_TABLE || r_varOperationType != trim(GROUP_DELETE)) { // 800WA_WEBCONSOLE389
	for(var l_varCnt = 0 ; l_varCnt < l_varElements.length ; l_varCnt++){ 
       
		if(l_varElements[l_varCnt].name == 'climbTrailList'){
		    
			if(l_varElements[l_varCnt].checked) {
				
				l_varElementCnt++;					      
				
		        var l_objGroupDetail = 
		               parent.frames["2"].groupDetailBeanCollection[l_varElements[l_varCnt].value];
		        
		        if( l_objGroupDetail == null)
		        {
		          return;
		        }
               	var l_varCompName = l_objGroupDetail.computerName;               	
/*               	
				var l_varMessage = new String(r_varMessage);                    // 800WA_WEBCONSOLE389
				
				
				//replace the value og argument 0 with 
				//the corresponding group or host name
				l_varMessage =                                                  // 800WA_WEBCONSOLE389
				        r_varMessage.replace(l_varExpression0, l_varCompName);  // 800WA_WEBCONSOLE389
				
				var r_varTitle = new String(r_varTitle);                        // 800WA_WEBCONSOLE389
				
				//replace the value og argument0 with the  product name
				r_varFinalTitle =                                               // 800WA_WEBCONSOLE389
				             r_varTitle.replace(l_varExpression0, r_varArg0);   // 800WA_WEBCONSOLE389
				             
				var l_varDialogProp = new                                       // 800WA_WEBCONSOLE389
				                  confirmationProperties(r_varFinalTitle,       // 800WA_WEBCONSOLE389
				                  r_varImage,r_varErrorId,l_varMessage,r_varOk, // 800WA_WEBCONSOLE389
				                  r_varOkAll,r_varCancel,r_varAlt);             // 800WA_WEBCONSOLE389
				
				window.showModalDialog('jsp/confirmDialog.html',l_varDialogProp,// 800WA_WEBCONSOLE389
				"dialogHeight:150px;dialogWidth:300px;status:no;help:no");      // 800WA_WEBCONSOLE389
				if(l_varDialogProp.l_varReturnValue==0) 	// For Ok press.    // 800WA_WEBCONSOLE389
        		{                                                               // 800WA_WEBCONSOLE389
        		  continue;                                                     // 800WA_WEBCONSOLE389
        		}	                                                            // 800WA_WEBCONSOLE389
				if(l_varDialogProp.l_varReturnValue == 1){  //for Ok All press  // 800WA_WEBCONSOLE389
					break;	                                                    // 800WA_WEBCONSOLE389
				}	                                                            // 800WA_WEBCONSOLE389
				else if(l_varDialogProp.l_varReturnValue == 2){ // for Cancel   // 800WA_WEBCONSOLE389
				                                                     //press
				   if( l_varElementCnt == 1){                                   // 800WA_WEBCONSOLE389
				      return;	                                                // 800WA_WEBCONSOLE389
				   }	                                                        // 800WA_WEBCONSOLE389
				   for (var l_varCount = l_varCnt; l_varCount <l_varElements.length;  // 800WA_WEBCONSOLE389
				                                                  l_varCount++){// 800WA_WEBCONSOLE389				      
		              l_varElements[l_varCount].checked = false;                // 800WA_WEBCONSOLE389
				   }	                                                        // 800WA_WEBCONSOLE389
				   l_varFlag = true;               	                            // 800WA_WEBCONSOLE389
				   break;                          	                            // 800WA_WEBCONSOLE389
				}	                               	                            // 800WA_WEBCONSOLE389
*/				       
                var l_iReturnValue = getConfirmDialog(                          // 800WA_WEBCONSOLE389
                      r_varTitle,r_varArg0,r_varImage,r_varErrorId,             // 800WA_WEBCONSOLE389
                      r_varMessage,r_varOk,r_varOkAll,                          // 800WA_WEBCONSOLE389
                      r_varCancel,r_varAlt,l_varCompName);                      // 800WA_WEBCONSOLE389
                           
				if(l_iReturnValue == CONST_RETURN_OK){ 	// For Ok press.        // 800WA_WEBCONSOLE389
        		   continue;                                                    // 800WA_WEBCONSOLE389
        		}	                                                            // 800WA_WEBCONSOLE389
				else if(l_iReturnValue == CONST_RETURN_OKALL){ //for Ok All     // 800WA_WEBCONSOLE389
					break;                                                      // 800WA_WEBCONSOLE389
				}	                                                            // 800WA_WEBCONSOLE389
				else if(l_iReturnValue == CONST_RETURN_CANCEL){ // for Cancel   // 800WA_WEBCONSOLE389
				                                                     //press
				   if( l_varElementCnt == 1){                                   // 800WA_WEBCONSOLE389
				      return;                            	                    // 800WA_WEBCONSOLE389
				   }                              	                            // 800WA_WEBCONSOLE389
				   for (var l_varCount = l_varCnt;                              // 800WA_WEBCONSOLE389
				           l_varCount < l_varElements.length; l_varCount++){	// 800WA_WEBCONSOLE389		      
		              l_varElements[l_varCount].checked = false;                // 800WA_WEBCONSOLE389
				   }                              	                            // 800WA_WEBCONSOLE389
				   l_varFlag = true;               	                            // 800WA_WEBCONSOLE389
				   break;                          	                            // 800WA_WEBCONSOLE389
				}	                                                            // 800WA_WEBCONSOLE389
			}		  
  	    }
    }

    if(l_varElementCnt==0){

       alert(MSG_GROUP_COMP_SELECT_CHECK + "\n" + 
                                   errorMessage[MSG_GROUP_COMP_SELECT_CHECK]);
    } 
    else{
       formTableSubmit(r_varURL,r_varTarget,r_varOperationType)
    }
    }                                                                           // 800WA_WEBCONSOLE389
    else if(l_stSource == CONST_TREE){                                          // 800WA_WEBCONSOLE389
        //for tree
        var l_varCompName = trim(                                               // 800WA_WEBCONSOLE389
                   parent.frames["1"].document.forms["0"]["groupName"].value);  // 800WA_WEBCONSOLE389
        var l_iReturnValue = getConfirmDialog(                                  // 800WA_WEBCONSOLE389
             r_varTitle,r_varArg0,r_varImage,r_varErrorId,                      // 800WA_WEBCONSOLE389
             r_varMessage,r_varOk,r_varOkAll,                                   // 800WA_WEBCONSOLE389
             r_varCancel,r_varAlt,l_varCompName);                               // 800WA_WEBCONSOLE389
    	if(l_iReturnValue == CONST_RETURN_OK){ 	// For Ok press.                // 800WA_WEBCONSOLE389
            formTreeSubmit(r_varURL,r_varTarget,r_varOperationType);            // 800WA_WEBCONSOLE389
        }	                                                                    // 800WA_WEBCONSOLE389
    	else if(l_iReturnValue == CONST_RETURN_OKALL){  //for Ok All press      // 800WA_WEBCONSOLE389
    		formTreeSubmit(r_varURL,r_varTarget,r_varOperationType);            // 800WA_WEBCONSOLE389
    	}	                                                                    // 800WA_WEBCONSOLE389
        else if(l_iReturnValue == CONST_RETURN_CANCEL){ // for Cancel           // 800WA_WEBCONSOLE389
            return;                                                             // 800WA_WEBCONSOLE389
        }	                                                                    // 800WA_WEBCONSOLE389
    }	                                                                        // 800WA_WEBCONSOLE389
}
 
 /**
 * This method is  used to display the confirmation dialog and get the return value
 * @param r_varTitle Contains the title name of the screen
 * @param r_varArg0 Contains the argument 0 for the confirmation message
 * @param r_varImage Contains the image for confirmation dialog box
 * @param r_varErrorId Contains the error id for the error message
 * @param r_varMessage Contains the error message
 * @param r_varOk Contains the data for Ok button
 * @param r_varOkAll Contains the data for OKALL buttton
 * @param r_varCancel Contains the data for cancel button 
 * @param r_varAlt Contains the alt property of the image
 * @param r_varName Contains the name of the group or host
 * @since 08-00
 */ 
 function getConfirmDialog(r_varTitle,r_varArg0,r_varImage,r_varErrorId,        // 800WA_WEBCONSOLE389
                           r_varMessage,r_varOk,r_varOkAll,                     // 800WA_WEBCONSOLE389 
                           r_varCancel,r_varAlt,r_varName){                     // 800WA_WEBCONSOLE389
     var l_varExpression0 = /\{0\}/gi;                                          // 800WA_WEBCONSOLE389
     var l_varMessage = new String(r_varMessage);                               // 800WA_WEBCONSOLE389
     //replace the value of argument 0 with
     //the corresponding group or host name
     l_varMessage = r_varMessage.replace(l_varExpression0, r_varName);          // 800WA_WEBCONSOLE389
     var r_varTitle = new String(r_varTitle);                                   // 800WA_WEBCONSOLE389
     //replace the value of argument0 with the product name
     var l_varFinalTitle = r_varTitle.replace(l_varExpression0, r_varArg0);     // 800WA_WEBCONSOLE389
     var l_varDialogProp = new confirmationProperties(l_varFinalTitle,          // 800WA_WEBCONSOLE389
				                  r_varImage,r_varErrorId,l_varMessage,r_varOk, // 800WA_WEBCONSOLE389
				                  r_varOkAll,r_varCancel,r_varAlt);             // 800WA_WEBCONSOLE389  
     window.showModalDialog('jsp/confirmDialog.html',l_varDialogProp,           // 800WA_WEBCONSOLE389  
     	"dialogHeight:150px;dialogWidth:300px;status:no;help:no");              // 800WA_WEBCONSOLE389  
     return l_varDialogProp.l_varReturnValue;                                   // 800WA_WEBCONSOLE389  
 }                                                                              // 800WA_WEBCONSOLE389  

/**
 * This method is used for validating the text box input value  
 * @since 08-00
 */
function textInputCheck()
{ 
    var l_varTxtValue= document.forms[0]["groupName"].value;
    var l_varFlag=0,l_varCnt=0;
    var l_varRet=false;
    if(document.forms[0].createbut != null){                                    // 800WA_WEBCONSOLE451
        if(document.forms[0].createbut.disabled == true){                       // 800WA_WEBCONSOLE451
		    return false;                                                       // 800WA_WEBCONSOLE451
		}                                                                       // 800WA_WEBCONSOLE451
   	}                                                                           // 800WA_WEBCONSOLE451
   	else if(document.forms[0].Edit != null){                                    // 800WA_WEBCONSOLE451
        if(document.forms[0].Edit.disabled == true){                            // 800WA_WEBCONSOLE451
		    return false;                                                       // 800WA_WEBCONSOLE451
		}                                                                       // 800WA_WEBCONSOLE451
   	}                                                                           // 800WA_WEBCONSOLE451
    
    //when the input is null(or empty )
    if(l_varTxtValue==""){
    	alert(MSG_GROUP_CHECK + "\n" + errorMsg[MSG_GROUP_CHECK]);
    	l_varRet = true;
    }
    else {
        //checks whether the input characters exceed maximum length  
	    if(l_varTxtValue.length >= 1 && 
	                     l_varTxtValue.length <= LENGTH_MAXIMUM_GROUP_NAME){
	                     
	       while(l_varCnt<l_varTxtValue.length && l_varFlag==0){
	            
	         // checks whether the input is valid
	         if(l_varTxtValue.charCodeAt(l_varCnt) >= 
	                      GROUP_TEXT_CHARACTER_ASCII_LOWER_LIMIT && 
	         	l_varTxtValue.charCodeAt(l_varCnt) <= 
	         	          GROUP_TEXT_CHARACTER_ASCII_UPPER_LIMIT){ 
	          	l_varCnt++;
	          }
	          else {
		        alert(MSG_GROUP_CHARACTER_CHECK + "\n" + 
		                                errorMsg[MSG_GROUP_CHARACTER_CHECK])
		        l_varFlag = 1;
		        l_varRet = true;
		        break;                                                          // 800WA_WEBCONSOLE242
	          }
	        }
	    }    
	    else  {
	    
	    alert(MSG_COMMON_RANGE_CHARACTER_CHECK + "\n" +
	                              errorMsg[MSG_COMMON_RANGE_CHARACTER_CHECK]);
	    	l_varRet = true;
	    }
   }
   if(!l_varRet) {
    if(document.forms[0].createbut != null){                                    // 800WA_WEBCONSOLE451
        document.forms[0].groupName.readOnly = true;                            // 800WA_WEBCONSOLE451
    	document.forms[0].createbut.disabled = true;                            // 800WA_WEBCONSOLE451
   	}                                                                           // 800WA_WEBCONSOLE451
   	else if(document.forms[0].Edit != null){                                    // 800WA_WEBCONSOLE451
        document.forms[0].groupName.readOnly = true;                            // 800WA_WEBCONSOLE451
   	    document.forms[0].Edit.disabled = true;                                 // 800WA_WEBCONSOLE451
   	}                                                                           // 800WA_WEBCONSOLE451
    document.forms[0].submit();
   }
   else{                                                                        // 800WA_WEBCONSOLE295
    document.forms[0]["groupName"].focus();                                     // 800WA_WEBCONSOLE295
    document.forms[0]["groupName"].select();                                    // 800WA_WEBCONSOLE368
   }                                                                            // 800WA_WEBCONSOLE295
   return false;                                                                // 800WA_WEBCONSOLE344
}

/**
 * This method is used for checking if atleast 1 computer has been
 * selected before clicking the "Add" button of Machine Addition Screen
 * @param r_stmsg Value to be trimmed
 * @since 08-00
 */
function computerSelectCheck() {
	
	var l_objForm = new Array();
	var l_objListLength = document.forms[0]["nodeIdList"].length;
	
	if(l_objListLength == null){
	  return;
	}
	
	var l_objForm = document.forms[0]["nodeIdList"];
	var l_varFlag = false;
	
	for(var l_varCnt = 0; l_varCnt < l_objListLength; l_varCnt++)
	{
		if(l_objForm.options[l_varCnt].selected)
		{
			l_varFlag = true;
			break;                                                              // 800WA_WEBCONSOLE242
		}
	}
	
	if(l_varFlag == false){
	   alert(MSG_COMPUTER_SELECT_CHECK + "\n" +
	                            errorMsg[MSG_COMPUTER_SELECT_CHECK]);
	   document.forms[0]['nodeIdList'].focus();                                 // 800WA_WEBCONSOLE295                         
	}
	else {
	   document.forms[0].machineAdd.disabled = true;                            // 800WA_WEBCONSOLE451
	   document.forms[0].submit();
	}	
    
}

/**
 * This method is used to make the value of climb trail as null if the focus
 * is removed from the link of the group tree
 * @since 08-00
 */
function focusLost(l_varEvt){                                                   // 800WA_WEBCONSOLE256

   var l_varTarg = l_varEvt.srcElement.tagName;                                 // 800WA_WEBCONSOLE256    
   if(l_varTarg == "A") {                                                       // 800WA_WEBCONSOLE256	// 800WA_WEBCONSOLE270
     return;                                                                    // 800WA_WEBCONSOLE256
   }                                                                            // 800WA_WEBCONSOLE256
   else {                                                                       // 800WA_WEBCONSOLE256
    //if(parent.frames["1"].document.all.item('climbTrail') != null) {          // 800WA_WEBCONSOLE295	// 800WA_WEBCONSOLE327
    if(parent.frames["1"].document.all.item('climbTrail') != null &&            // 800WA_WEBCONSOLE327
       parent.frames["1"].document.all.item('climbTrail').value != '') {        // 800WA_WEBCONSOLE327
     var l_varTemp = parent.frames["1"].document.all.item('climbTrail').value;  // 800WA_WEBCONSOLE320
    // parent.frames["groupListFrame"].document.                                // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE353
    //              getElementById(l_varTemp).style.backgroundColor = '#ffffff';// 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE353
    parent.frames["groupListFrame"].document.                                   // 800WA_WEBCONSOLE367
                  getElementById(l_varTemp).style.backgroundColor = '#ffffff';  // 800WA_WEBCONSOLE367
     parent.frames["1"].document.all.item('climbTrail').value = '';             // 800WA_WEBCONSOLE256 
    }                                                                           // 800WA_WEBCONSOLE295 
   }                                                                            // 800WA_WEBCONSOLE256
}

/**
 * This method is used get the parameter from the bean and 
 * set it in the detail block table
 * @param r_varClimbTrailList contains the list of climb trails 
 * for the seleted groups or hosts
 * @param r_varImageName Contains the url for the group Icon,group selected icon 
 * and host icon
 * @param r_varComputerName Contails the name of the group or host selected
 * @param r_varDomainName Contains the name domain name of the Host selected
 * @param r_varSiteName Contains the site name of the host selected 
 * @since 08-00
 */
function groupDetailBean(r_varClimbTrailList,r_varImageName,r_varComputerName,
                                 r_varDomainName,r_varSiteName,r_varNodeId){
  if(r_varClimbTrailList == null || r_varImageName == null ||                   // 800WA_WEBCONSOLE244
     r_varComputerName == null || r_varDomainName == null ||                    // 800WA_WEBCONSOLE244 
     r_varSiteName == null || r_varNodeId == null){                             // 800WA_WEBCONSOLE244
    return;                                                                     // 800WA_WEBCONSOLE244
  }                                                                             // 800WA_WEBCONSOLE244
  this.climbTrailList = r_varClimbTrailList;
  this.imageName = r_varImageName;
  this.computerName = r_varComputerName;
  this.domainName = r_varDomainName;
  this.siteName = r_varSiteName;
  this.nodeId = r_varNodeId;

}

/**
 * Array that stores the submenu ids 
 */ 
var m_displayGroupsubMenu = ['dropGroupMgmtSub','power'];

/**
 * Array that stores the main menu ids 
 */
var m_menuIds = ['dropGroupMgmtLink','groupCreateLink','groupEditLink',
                 'computerAddLink','deleteLink','helpLink'];
                 
/**
 * This method should be called when the menu is clicked (or mouse over etc)
 * to change the menu.
 * @param r_menuId the id that is clicked
 * @since 08-00
 */
function fnGroupOpen(r_menuId) {

   //check the input parameter
   if(r_menuId == null){
    return;
   }
   if(USER_TYPE_ADMIN != USER_CURRENT){                                         // 800WA_WEBCONSOLE327
		m_menuIds = ['dropGroupMgmtLink','helpLink'];	                        // 800WA_WEBCONSOLE327
   }                                                                            // 800WA_WEBCONSOLE327                   
   activeLink(r_menuId,m_menuIds);
   showHide(m_displayGroupsubMenu,'none');
}

/**
 * Array that stores the detail menu ids 
 */
var m_detailMenuIds = ['powerONLink','powerOFFLink','forcedPowerOFFLink',
                 'rebootOFFLink','helpDetailLink'];
                 
/**
 * This method should be called when the menu in the detail block is clicked 
 * (or mouse over etc) to change the menu.
 * @param r_menuId the id that is clicked
 * @since 08-00
 */
function fnDetailOpen(r_menuId) {

   //check the input parameter
   if(r_menuId == null){
    return;
   }
   if(USER_TYPE_ADMIN != USER_CURRENT){                                         // 800WA_WEBCONSOLE327
		m_detailMenuIds =['helpDetailLink'];                                    // 800WA_WEBCONSOLE327 	     
	}                                                                           // 800WA_WEBCONSOLE327
   activeLink(r_menuId,m_detailMenuIds);
}

/**
 * This method is make the menus inactive when an event  
 * other than the menu clicking occurs.
 * @param evt Contains the window event
 * @since 08-00
 */
function clearAll(evt)
{
    var targ;                                                                       
	if (!evt) var evt = window.event;                                               
	if (evt.target) targ = evt.target;                                              
	else if (evt.srcElement) targ = evt.srcElement;                                 
	var tname;                                                                      
	tname=targ.tagName;                                                             
	if(tname == "A" || tname == "IMG") {                                        
	         return;                                                                
	}  
	
	if(USER_TYPE_ADMIN != USER_CURRENT){                                        // 800WA_WEBCONSOLE327
		m_menuIds = ['dropGroupMgmtLink','helpLink'];                           // 800WA_WEBCONSOLE327
		m_detailMenuIds =['helpDetailLink'];	                                // 800WA_WEBCONSOLE327
	}                                                                           // 800WA_WEBCONSOLE327
	
  if(this.name == "groupHeaderFrame"){                                          // 800WA_WEBCONSOLE320 
	showHide(m_displayGroupsubMenu,'none');
	clearAllActiveLink(m_menuIds);
  }                                                                             // 800WA_WEBCONSOLE320 
  else{                                                                         // 800WA_WEBCONSOLE320 
    clearAllActiveLink(m_detailMenuIds);                                        // 800WA_WEBCONSOLE320 
  }                                                                             // 800WA_WEBCONSOLE320 
}

/**
 * This method is to display or hide the sub menu depending on the user action.
 * @param m_menuArray Contains the array of menu ids
 * @param r_showHideValue Contains the display value(i.e block/none)
 * @since 08-00
 */
function showHide(r_menuArray,r_showHideValue)
{
   //check the input parameter
   if(r_showHideValue == null  || r_menuArray == null){
     return;
   }
   
   for(var l_varCount = 0;l_varCount <r_menuArray.length; l_varCount++)
	{
		document.getElementById(r_menuArray[l_varCount]).style.display = r_showHideValue;
	}
}

/**
 * This method is to display the sub menu when 'display Group ' menu is clicked
 * @param r_menuId Contains the  menu id of the main menu.
 * @param r_subMenuId Contains the menu id of the sub menu
 * @param r_varUserType Contain the user type(admin/sub admin)
 * @since 08-00
 */
function fnGroupOpenSubMenu(r_menuId,r_subMenuId,r_varUserType)                 //800WA_WEBCONSOLE235                 
{
  //check the input parameter
   if(r_menuId == null || r_subMenuId == null){
     return;
   }
   
   if(r_varUserType == USER_TYPE_ADMIN){                                        //800WA_WEBCONSOLE235  
     activeLink(r_menuId,m_menuIds);                                            // 800WA_WEBCONSOLE270
   }                                                                            //800WA_WEBCONSOLE235 
   else{                                                                        //800WA_WEBCONSOLE235 
     //document.getElementById(r_menuId).style.background = 'gray';             //800WA_WEBCONSOLE235	// 800WA_WEBCONSOLE327
     m_menuIds = ['helpLink'];                                                  // 800WA_WEBCONSOLE327
     activeLink(r_menuId,m_menuIds);                                            // 800WA_WEBCONSOLE327
   }                                                                            //800WA_WEBCONSOLE235 
   
   var l_varMenuDisplay =                                                       // 800WA_WEBCONSOLE238 
               document.getElementById(m_displayGroupsubMenu[0]).style.display; // 800WA_WEBCONSOLE238 
   if(l_varMenuDisplay == 'none'){                                              // 800WA_WEBCONSOLE238 
      document.getElementById(r_menuId).style.background = 'gray';              // 800WA_WEBCONSOLE445
      l_varMenuDisplay = 'block';                                               // 800WA_WEBCONSOLE238 
   }                                                                            // 800WA_WEBCONSOLE238 
   else{                                                                        // 800WA_WEBCONSOLE238           
      l_varMenuDisplay = 'none';                                                // 800WA_WEBCONSOLE238 
   }                                                                            // 800WA_WEBCONSOLE238
  showHide(m_displayGroupsubMenu,l_varMenuDisplay);                             // 800WA_WEBCONSOLE238            
}

/**
 * This method is used is used to perform power ON operation
 * @param r_varPowerCode Contains the Control code to be set.
 * @since 08-00
 */
function powerON(r_varPowerCode){
  
  //check the input parameter
   if(r_varPowerCode == null){
     return;
   }
   
  var l_varErrorId = MSG_POWERON_CONFIRM;
  var l_varMessage = errorMessage[MSG_POWERON_CONFIRM]; 	
  groupDeletionOrPowerOperation(DIALOGBOX,COMMON_PRODUCT_NAME,IMAGE_TYPE_CONFIRM
       ,l_varErrorId,l_varMessage,DIALOG_OK,DIALOG_TERMINATE,DIALOG_OKALL,
        ALT_PROPERTY,TARGET_URL,TARGET_FRAME,r_varPowerCode);

}

/**
 * This method is used is used to perform power OFF operation
 * @param r_varPowerCode Contains the Control code to be set.
 * @since 08-00
 */
function powerOFF(r_varPowerCode){

  //check the input parameter
   if(r_varPowerCode == null){
     return;
   }
 
  var l_varErrorId = MSG_POWEROFF_CONFIRM;
  var l_varMessage = errorMessage[MSG_POWEROFF_CONFIRM]; 	
  groupDeletionOrPowerOperation(DIALOGBOX,COMMON_PRODUCT_NAME,IMAGE_TYPE_CONFIRM,
      l_varErrorId,l_varMessage,DIALOG_OK,DIALOG_TERMINATE,DIALOG_OKALL,
      ALT_PROPERTY,TARGET_URL,TARGET_FRAME,r_varPowerCode);

}

/**
 * This method is used is used to perform forced Power OFF operation
 * @param r_varPowerCode Contains the Control code to be set.
 * @since 08-00
 */
function forcedPowerOFF(r_varPowerCode){
  
  //check the input parameter
   if(r_varPowerCode == null){
     return;
   }
      
  var l_varErrorId = MSG_FORCED_CONFIRM;
  var l_varMessage = errorMessage[MSG_FORCED_CONFIRM]; 	
  groupDeletionOrPowerOperation(DIALOGBOX,COMMON_PRODUCT_NAME,IMAGE_TYPE_CONFIRM,
      l_varErrorId,l_varMessage,DIALOG_OK,DIALOG_TERMINATE,DIALOG_OKALL,
      ALT_PROPERTY,TARGET_URL,TARGET_FRAME,r_varPowerCode);

}

/**
 * This method is used is used to perform reboot operation
 * @param r_varPowerCode Contains the Control code to be set.
 * @since 08-00
 */
function reboot(r_varPowerCode){
  
  //check the input parameter
   if(r_varPowerCode == null ){
     return;
   }
   
  var l_varErrorId = MSG_REBOOT_CONFIRM;
  var l_varMessage = errorMessage[MSG_REBOOT_CONFIRM]; 	
  groupDeletionOrPowerOperation(DIALOGBOX,COMMON_PRODUCT_NAME,IMAGE_TYPE_CONFIRM,
      l_varErrorId,l_varMessage,DIALOG_OK,DIALOG_TERMINATE,DIALOG_OKALL,
       ALT_PROPERTY,TARGET_URL,TARGET_FRAME,r_varPowerCode);
}

/**
 * This variable is used to set the previous id for the tree link
 * @since 08-00
 */
 var m_varPreviousid = 'NaN';                                                   // 800WA_WEBCONSOLE320

/**
 * This method is used is used to change the background color of the link in the
 * tree 
 * @param r_varPowerCode Contains the Control code to be set.
 * @since 08-00
 */
/* function backgroundColorChange(r_varObj){                                    // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE367

 //if(m_varPreviousid != 'NaN'){	                                            // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE353
 // document.getElementById(m_varPreviousid).style.backgroundColor = '#ffffff'; // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE353
 //}                                                                            // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE353
   m_varPreviousid = r_varObj ; 			                                    // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE367
//   document.getElementById(r_varObj).style.backgroundColor = 'gray';          // 800WA_WEBCONSOLE320
   document.getElementById(r_varObj).focus();                                   // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367

}*/                                                                             // 800WA_WEBCONSOLE320	// 800WA_WEBCONSOLE367

/**
 * This method is used is used to disable the checkbox when the user rigth is 
 * sun-administrator
 * @since 08-00
 */
function fnSub(){
 if(USER_TYPE_ADMIN != USER_CURRENT){                                           // 800WA_WEBCONSOLE327
  if(parent.frames[2].document.all.item("climbTrailList")!=null){               // 800WA_WEBCONSOLE353
  if(document.forms[0]["climbTrailList"] != null){                              // 800WA_WEBCONSOLE478
   var l_varObjLength = document.forms[0]["climbTrailList"].length;             // 800WA_WEBCONSOLE327
   if(l_varObjLength != null){                                                  // 800WA_WEBCONSOLE478
   for(var l_varCnt = 0;l_varCnt < l_varObjLength;l_varCnt++){                  // 800WA_WEBCONSOLE327
     document.forms[0]["climbTrailList"][l_varCnt].disabled = true;             // 800WA_WEBCONSOLE327
   }                                                                            // 800WA_WEBCONSOLE327
   }                                                                            // 800WA_WEBCONSOLE478
   else{                                                                        // 800WA_WEBCONSOLE478
     //if there is only group under a group
     document.forms[0]["climbTrailList"].disabled = true;                       // 800WA_WEBCONSOLE478
   }                                                                            // 800WA_WEBCONSOLE478
  }                                                                             // 800WA_WEBCONSOLE353
 }                                                                              // 800WA_WEBCONSOLE478
 }                                                                              // 800WA_WEBCONSOLE327
 else{                                                                          // 800WA_WEBCONSOLE327
   return;                                                                      // 800WA_WEBCONSOLE327
 }                                                                              // 800WA_WEBCONSOLE327 
}                                                                               // 800WA_WEBCONSOLE327
                                                                             
/**
 * This method is used to submit the list form when a group is selected in case 
 * of mouse click event
 * @since 08-00
 */
/*
function submitForm(){                                                          // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
if(window.event.keyCode == CONST_ENTER ||                                       // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
   window.event.button == CONST_MOUSE_LEFT_CLICK){                              // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
document.forms[0].submit();                                                     // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
}                                                                               // 800WA_WEBCONSOLE367 // 800WA_WEBCONSOLE406
}                                                                               // 800WA_WEBCONSOLE353 // 800WA_WEBCONSOLE406
*/

/**
 * This method is used to submit the list form when a group is selected in case
 * of pressing enter key
 * @param r_varEvent Contains the window event
 * @since 08-00
 */
function submitThisForm(r_varEvent){                                            // 800WA_WEBCONSOLE353
 if(r_varEvent.keyCode == CONST_ENTER)                                          // 800WA_WEBCONSOLE353
 {                                                                              // 800WA_WEBCONSOLE353
 document.forms[0].submit();                                                    // 800WA_WEBCONSOLE353
 }                                                                              // 800WA_WEBCONSOLE353
}                                                                               // 800WA_WEBCONSOLE353

/**
 * This method is used to set the hidden climbtrail value when the element is 
 * onfocus
 * @since 08-00
 */
/*function focusText(){                                                         // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
 document.forms[0]["climbTrail"].value = window.event.srcElement.id;            // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
}*/                                                                             // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367

/**
 * This method is used to make the hidden climbtrail value null when the element   
 * has lost its focus
 * @since 08-00
 */
/*function focusTextLost(){                                                     // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367

  try{                                                                          // 800WA_WEBCONSOLE364	// 800WA_WEBCONSOLE367
  if(parent.opener.parent.                                                      // 800WA_WEBCONSOLE364	// 800WA_WEBCONSOLE367
             frames['groupListFrame'].document.all.item("climbTrail") != null){ // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
  parent.opener.parent.                                                         // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
            frames['groupListFrame'].document.forms[0]["climbTrail"].value = '';// 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367
  }                                                                             // 800WA_WEBCONSOLE364	// 800WA_WEBCONSOLE367
  }catch(Exception){                                                            // 800WA_WEBCONSOLE364	// 800WA_WEBCONSOLE367
  }                                                                             // 800WA_WEBCONSOLE364	// 800WA_WEBCONSOLE367
}*/                                                                             // 800WA_WEBCONSOLE353	// 800WA_WEBCONSOLE367