/**
 * Copyright : All Rights Reserved. Copyright (C) 2006, Hitachi, Ltd.
 * Title     : ServerConductor WebConsole
 * Version   : 08-00
 * Name      : listTree.js
 * Date      : 2006/05/02
 * Author    : Praveen P
 */

/**
 * This method performs the tree operation for a parent node
 * @param r_stNodeName div tag id
 * @param r_stPlusImg plus image path
 * @param r_stMinusImg minus image path
 * @since 08-00
 */

// function listTree(r_stNodeName, r_stPlusImg, r_stMinusImg) {					// 800WA_WEBCONSOLE317
function listTree(r_stNodeName, r_stPlusImg, r_stMinusImg, r_stTargetWindow) {  // 800WA_WEBCONSOLE317
  if(r_stNodeName == null || r_stPlusImg == null || r_stMinusImg == null) {		// 800WA_WEBCONSOLE017
	  return;																	// 800WA_WEBCONSOLE017
  }																				// 800WA_WEBCONSOLE017
  l_stMenu = document.all[r_stNodeName].style;
  l_stImg = document.all.item(r_stNodeName + "img");
  if(l_stMenu.display == 'none') {
  	l_stMenu.display = "block";
  	l_stImg.src = r_stMinusImg;
  } else {
  	l_stMenu.display = "none";
  	l_stImg.src = r_stPlusImg;
  }

//  parent.detail.document.open();												// 800WA_WEBCONSOLE098
//  parent.detail.document.close();												// 800WA_WEBCONSOLE098
if (r_stTargetWindow == "hostDetail") {											// 800WA_WEBCONSOLE317
parent.hostDetail.location = "jsp/default.html";								// 800WA_WEBCONSOLE317
}																				// 800WA_WEBCONSOLE317
else {																			// 800WA_WEBCONSOLE317
parent.detail.location = "jsp/default.html";									// 800WA_WEBCONSOLE098
}																				// 800WA_WEBCONSOLE317
}


/**
 * This method calls the listTree function and also calls 
 * the targetOpen function
 * @param r_stDivNode div tag id
 * @param r_stPlusImg plus image path
 * @param r_stMinusImg minus image path
 * @param r_stTargetWindow target window name
 * @param r_stTargetUrl target url
 * @param r_stFuncNodeName Hierarchy id
 * @param r_stFlag Flag that indicates if a node has detail block or not
 * @since 08-00
 */

//function parentNode(r_stDivNode, r_stPlusImg, r_stMinusImg,					800WA_WEBCONSOLE293
//				r_stTargetWindow, r_stTargetUrl)								800WA_WEBCONSOLE293
function parentNode(r_stDivNode, r_stPlusImg, r_stMinusImg,r_stTargetWindow, 	
					r_stTargetUrl,r_stFuncNodeName,r_stFlag)					// 800WA_WEBCONSOLE293
			{	
				//listTree(r_stDivNode, r_stPlusImg, r_stMinusImg);             // 800WA_WEBCONSOLE444
				listTree(r_stDivNode, r_stPlusImg, 								// 800WA_WEBCONSOLE444
									r_stMinusImg, r_stTargetWindow);            // 800WA_WEBCONSOLE444
				//window.open(r_stTargetUrl, r_stTargetWindow);					// 800WA_WEBCONSOLE293
				targetOpen(r_stTargetWindow, r_stTargetUrl,r_stFuncNodeName,
						   r_stFlag);											// 800WA_WEBCONSOLE293
			}

/**
 * This method calls the listTree function and
 * also opens the corresponding detail window for the parent node
 * @param r_stTargetWindow target window name
 * @param r_stTargetUrl target url
 * @param r_stFuncNodeName Hierarchy id
 * @param r_stFlag Flag that indicates if a node has detail block or not
 * @since 08-00
 */			
function targetOpen(r_stTargetWindow, r_stTargetUrl,r_stFuncNodeName,r_stFlag)	// 800WA_WEBCONSOLE293
			{																	// 800WA_WEBCONSOLE293
				if(r_stFlag == "true")											// 800WA_WEBCONSOLE293
				{																// 800WA_WEBCONSOLE293
					var l_stTemp = r_stFuncNodeName + "node";					// 800WA_WEBCONSOLE293
					r_stTargetUrl = r_stTargetUrl + "&nodeName=" + 
						document.getElementById(l_stTemp).value;				// 800WA_WEBCONSOLE293
				}																// 800WA_WEBCONSOLE293
				window.open(r_stTargetUrl,r_stTargetWindow);					// 800WA_WEBCONSOLE293					
			}																	// 800WA_WEBCONSOLE293