/*
 * Copyright : All Rights Reserved. Copyright (C) 2006, Hitachi, Ltd.
 * Title     : ServerConductor WebConsole
 * Version   : 08-00
 * Name      : login.js
 * Date      : 2006/04/12
 */
 
 /**
 * This javascript contains methods for operations in the login
 * screen and start screen.
 * @version 08-00
 * @since 08-00
 * @author Kimura
 */

/**
 * This method opens the new login screen.
 * @param r_stLoginURL The URL of login screen
 * @param r_objBtn The button object of start screen
 * @since 08-00
 */ 
function openLoginScreen(r_stLoginURL,r_objBtn){

    if (r_stLoginURL == null || r_stLoginURL.length <= 0 || r_objBtn == null) { // 800WA_WEBCONSOLE037
        return false;                                                           // 800WA_WEBCONSOLE037
    }                                                                           // 800WA_WEBCONSOLE037
    
    r_objBtn.focus();
    
    var l_objDate = new Date();
    var l_stYear = l_objDate.getYear();
    var l_stMonth = l_objDate.getMonth() + 1 ;
    var l_stDate = l_objDate.getDate();
    var l_stHours = l_objDate.getHours();
    var l_stMinutes = l_objDate.getMinutes();
    var l_stSeconds = l_objDate.getSeconds();
    
    if(l_stMonth<10){
         l_stMonth = "0" + l_stMonth;
    }
    if(l_stDate<10){
        l_stDate = "0" + l_stDate;
    }
    if(l_stHours<10){
        l_stHours = "0" + l_stHours;
    }
    if(l_stMinutes<10){
        l_stMinutes = "0" + l_stMinutes;
    }
    if(l_stSeconds<10){
        l_stSeconds = "0" + l_stSeconds;
    }
    
    var l_objWname = l_stYear + l_stMonth + l_stDate + 
                     l_stHours + l_stMinutes + l_stSeconds;

    window.open(r_stLoginURL,l_objWname,
    "menubar = no, toolbar = no, scrollbars = yes,status = yes, "  + 
    "location = no, width = 800px, height = 600px, resizable = yes");
}
/**
 * This method checks if the password box is empty or not.
 * @param r_objPasswordbox The password box object
 * @param r_stErrorCode The error code to display
 * @param r_stErrorMessage The error message to display
 * @return The result of the check
 * @since 08-00
 */ 
function checkEntry(r_objPasswordbox,r_stErrorCode,r_stErrorMessage) {

    if (r_objPasswordbox == null || r_stErrorCode == null ||                    // 800WA_WEBCONSOLE037
        r_stErrorCode.length <= 0 || r_stErrorMessage == null ||                // 800WA_WEBCONSOLE037
        r_stErrorMessage.length <= 0) {                                         // 800WA_WEBCONSOLE037
        return false;                                                           // 800WA_WEBCONSOLE037
    }                                                                           // 800WA_WEBCONSOLE037

    if(r_objPasswordbox.value.length<1) {
        alert(r_stErrorCode  +  "\r\n"  +  r_stErrorMessage );
        r_objPasswordbox.focus();
        return false;     
    }
    return true;
}