/**
 * i2c-adap-ixp400.h
 *
 * @par
 * -- Intel Copyright Notice --
 * 
 * @par
 * Copyright (c) 2004-2007  Intel Corporation. All Rights Reserved. 
 * 
 * @par 
 * This software program is licensed subject to the GNU
 * General Public License (GPL). Version 2, June 1991, available at
 * http://www.fsf.org/copyleft/gpl.html
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * @par
 * -- End Intel Copyright Notice --
 */

#include "IxI2cDrv.h"
 
typedef enum
{
    I2C_DRV_INIT = 0xE100,
    /**< Calls the initialization function of the I2C algo module and passes
        the struct pointer of type IxI2cInitVars.*/

    I2C_DRV_UNINIT,
    /**< Calls the uninitialization function of the I2C algo module and
        passes no parameters.*/

    I2C_DRV_SET_I2C_SLAVE_ADDR,
    /**< Calls the ixI2cDrvSlaveAddrSet function of the I2C algo module and
        passes the slave address to be set. */

    I2C_DRV_BUS_SCAN,
    /**< Calls the ixI2cDrvBusScan function of the I2C algo module and
        passes no parameters. */

    I2C_SLAVE_ADDR_AND_GEN_CALL_CHECK,
    /**< Calls the ixI2cDrvSlaveAddrAndGenCallDetectedCheck function of the
        I2C algo module and passes no parameters. */

    I2C_DRV_SLAVE_OR_GEN_CALL_RECEIVE,
    /**< Calls the ixI2cDrvSlaveOrGenDataReceive function of the I2C algo
        module and passes the struct pointer of type IxI2cSlaveXferInfo. */

    I2C_DRV_SLAVE_TRANSMIT,
    /**< Calls the ixI2cDrvSlaveDataTransmit function of the I2C algo module
        and passes the struct pointer of type IxI2cSlaveXferInfo*/

    I2C_DRV_SLAVE_OR_GEN_CALL_BUF_REPLENISH,
    /**< Calls the ixI2cDrvSlaveOrGenCallBufReplenish function of the I2C algo
        module and passes the struct pointer of type IxI2cSlaveBufInfo. */

    I2C_DRV_REPEATED_START_WRITE_TRANSFER,
    /**< Calls the ixI2cDrvWriteTransfer function of the I2C algo with repeated
        start flow (start w/o stop) and passes the struct pointer of type
        IxI2cMasterXferInfo.*/

    I2C_DRV_REPEATED_START_READ_TRANSFER,
    /**< Calls the ixI2cDrvReadTransfer function of the I2C algo with repeated
        start flow (start w/o stop) and passes the struct pointer of type
        IxI2cMasterXferInfo.*/

    I2C_DRV_STATS_GET,
    /**< Calls the ixI2cDrvStatsGet function of the I2C algo module and
        passes the struct pointer of type IxI2cStatsCounters.*/

    I2C_DRV_STATS_RESET,
    /**< Calls the ixI2cDrvStatsReset function of the I2C algo module
        and passes no parameters.*/

    I2C_DRV_DELAY_SELECT,
    /**< Calls the ixI2cDrvDelayTypeSelect function of the I2C algo module
        and passes the delay type selected of type IxI2cDelayMode. */

    I2C_DRV_SHOW
    /**< Calls the ixI2cDrvShow function of the I2C algo module and passes
        no parameters.*/
} IxI2cAlgoCmds;


/* This struct contains the APIs in the I2C algorithm module that
    can be called by the I2C adapter module. These functions need
    to be mapped to a function of the same type to enable it to be
    called. */
struct i2c_algo_ixp_data
{
    IX_I2C_STATUS (*init) (IxI2cInitVars *initVarsSelected);
    IX_I2C_STATUS (*uninit) (void);
    IX_I2C_STATUS (*slave_addr_set) (UINT8 SlaveAddrSet);
    IX_I2C_STATUS (*master_transmit)
        (UINT8 SlaveAddr,
        char *bufP,
        UINT32 dataSize,
        IxI2cXferMode XferModeSelect);
    IX_I2C_STATUS (*master_receive)
        (UINT8 SlaveAddr,
        char *bufP,
        UINT32 dataSize,
        IxI2cXferMode XferModeSelect);  
    IX_I2C_STATUS (*slave_and_gen_call_check) (void);
    IX_I2C_STATUS (*slave_receive)
            (char *bufP,
            UINT32 bufSize,
            UINT32 *dataSizeRcvd);
    IX_I2C_STATUS (*slave_transmit)
            (char *bufP,
            UINT32 dataSize,
            UINT32 *dataSizeXmtd);
    void  (*slave_buf_replenish) (char *bufP, UINT32 bufSize);
    IX_I2C_STATUS (*stats_get) (IxI2cStatsCounters *I2cStats);
    void (*stats_reset) (void);
    IX_I2C_STATUS (*show) (void);
    IX_I2C_STATUS (*bus_scan) (void);
    void (*delay_select) (IxI2cDelayMode delayTypeSelect);
};

/* struct to contain all the parameters used by the master_transmit and
    master_receive APIs */
typedef struct
{
    char* bufP;
    unsigned int bufSize;
    unsigned short slave_addr;
} IxI2cMasterXferInfo;

/* struct to contain all the parameters used by the slave_receive and
    slave_transmit APIs */
typedef struct
{
    char* bufP;
    unsigned int bufSize;
    unsigned int *dataSizeXfer;
} IxI2cSlaveXferInfo;

/* struct to contain all the parameters used by the slave_buf_replenish
    API */
typedef struct
{
    char* bufP;
    unsigned int bufSize;
} IxI2cSlaveBufInfo;
