/******************************************************************************
*       @file   IxDspCodelet.h
* Contents:  This file contains info for ADS codelet files
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef __IXDSPCODELET_H__
#define __IXDSPCODELET_H__

#include <stdio.h>
#include <assert.h>

/*
 * include the definition of
 * DSP component interface specifications
 */
#include "dspcis.h"

#include "dspcfg.h"

#include "ToneJP.h"
#include "ToneUS.h"
#include "TonePRC.h"
#include "FWTypes.h"
#include "msgdef.h"
#include "IxPlatforms.h"
#include "IxDspSlicHssDriver.h" 

/**************************************************************************/
/* removed CSR src/linux dependency */
#define WAIT_FOREVER (-1)
#ifndef NO_WAIT
#define NO_WAIT (0)
#endif

#ifndef NULL
#define NULL       0L 
#endif
/* removed CSR src/linux dependency */
/*************************************************************/

#define IX_DSP_CODELET_TDM_CHL_T1           IX_DSP_CODELET_MAX_CHL
#define IX_DSP_CODELET_MIXER_PORTS          4

#define IX_DSP_CODELET_MAX_PROMPTS          20

#define IX_DSP_CODELET_COUNTRY_US 1
#define IX_DSP_CODELET_COUNTRY_JP 81
#define IX_DSP_CODELET_COUNTRY_PRC 86


#define IX_DSP_SLIC_ONLY                           0
#define IX_DSP_FRAMER_ONLY                         1
#define IX_DSP_SLIC_AND_FRAMER                     2

#define INVALID_MODE                               3
#define INVALID_BAND                               2 

/*The below #define is set to 1 only to enable a printf message*/
/*to advise EL customers not to pick the framer configs in the*/
/*initial menu*/
#define IX_DSP_SLIC_CONFIG_OPTION           1

#define IX_DSP_CODELET_PHN_IF_INVALID       0
#define IX_DSP_CODELET_PHN_IF_T1            1       /* T1, 4 channels */
#define IX_DSP_CODELET_PHN_IF_NB            2       /* 2 narrowband SLICs */
#define IX_DSP_CODELET_PHN_IF_WB            3       /* 2 wideband SLICs */
#define IX_DSP_CODELET_PHN_IF_MB            4       /* SLIC1 - WB,SLIC2 - NB*/

#define IX_DSP_CODELET_TS_SLIC_1            1        /* time slot of SLIC 1 */
#define IX_DSP_CODELET_TS_SLIC_2            3        /* time slot of SLIC 2 */
#define IX_DSP_CODELET_TS_SLIC_3            5        /* time slot of SLIC 3 */
#define IX_DSP_CODELET_TS_SLIC_4            7        /* time slot of SLIC 4 */
#define IX_DSP_CODELET_TS_SLIC_5            9        /* time slot of SLIC 5 */
#define IX_DSP_CODELET_TS_SLIC_6            11       /* time slot of SLIC 6 */
#define IX_DSP_CODELET_TS_SLIC_7            13       /* time slot of SLIC 7 */
#define IX_DSP_CODELET_TS_SLIC_8            15       /* time slot of SLIC 8 */
#define IX_DSP_CODELET_TS_SLIC_9            17       /* time slot of SLIC 9 */
#define IX_DSP_CODELET_TS_SLIC_10           19       /* time slot of SLIC 10*/
#define IX_DSP_CODELET_TS_SLIC_11           21       /* time slot of SLIC 11*/
#define IX_DSP_CODELET_TS_SLIC_12           23       /* time slot of SLIC 12*/
#define IX_DSP_CODELET_TS_SLIC_13           25       /* time slot of SLIC 13*/
#define IX_DSP_CODELET_TS_SLIC_14           27       /* time slot of SLIC 14*/
#define IX_DSP_CODELET_TS_SLIC_15           29       /* time slot of SLIC 15*/
#define IX_DSP_CODELET_TS_SLIC_16           31       /* time slot of SLIC 16*/
#define IX_DSP_CODELET_TS_SLIC_17           33       /* time slot of SLIC 17*/
#define IX_DSP_CODELET_TS_SLIC_18           35       /* time slot of SLIC 18*/
#define IX_DSP_CODELET_TS_SLIC_19           37       /* time slot of SLIC 19*/
#define IX_DSP_CODELET_TS_SLIC_20           39       /* time slot of SLIC 20*/
#define IX_DSP_CODELET_TS_SLIC_21           41       /* time slot of SLIC 21*/
#define IX_DSP_CODELET_TS_SLIC_22           43       /* time slot of SLIC 22*/
#define IX_DSP_CODELET_TS_SLIC_23           45       /* time slot of SLIC 23*/
#define IX_DSP_CODELET_TS_SLIC_24           47       /* time slot of SLIC 24*/

#define IX_DSP_CODELET_TASK_PRI_BASE    XTASK_PRI_BASE_DEFAULT
#define IX_DSP_CODELET_TASK_PRI_ORDER   XTASK_PRI_ORDER_ASCEND

#define IX_DSP_CODELET_CHANNEL_1        1 
#define IX_DSP_CODELET_CHANNEL_2        2 
#define IX_DSP_CODELET_CHANNEL_3        3 
#define IX_DSP_CODELET_CHANNEL_4        4 
#define IX_DSP_CODELET_CHANNEL_5        5 
#define IX_DSP_CODELET_CHANNEL_6        6 
#define IX_DSP_CODELET_CHANNEL_7        7 
#define IX_DSP_CODELET_CHANNEL_8        8 
#define IX_DSP_CODELET_CHANNEL_9        9 
#define IX_DSP_CODELET_CHANNEL_10       10
#define IX_DSP_CODELET_CHANNEL_11       11
#define IX_DSP_CODELET_CHANNEL_12       12
#define IX_DSP_CODELET_CHANNEL_13       13
#define IX_DSP_CODELET_CHANNEL_14       14
#define IX_DSP_CODELET_CHANNEL_15       15
#define IX_DSP_CODELET_CHANNEL_16       16
#define IX_DSP_CODELET_CHANNEL_17       17
#define IX_DSP_CODELET_CHANNEL_18       18
#define IX_DSP_CODELET_CHANNEL_19       19
#define IX_DSP_CODELET_CHANNEL_20       20
#define IX_DSP_CODELET_CHANNEL_21       21
#define IX_DSP_CODELET_CHANNEL_22       22
#define IX_DSP_CODELET_CHANNEL_23       23
#define IX_DSP_CODELET_CHANNEL_24       24

#define NO_RET

/* Macro to return if NULL pointer */
#define RETURN_IF_NULL_POINTER(pointer,return_value)\
{\
    if(pointer == NULL)\
        return return_value;\
}

typedef struct
{
   struct file          *pFd;
   UINT32               size;
   XCachePromptDesc_t   *pDesc;
   UINT32               offset; /* This is TBD */
   UINT8                *pBuffer;
   unsigned char         handle;
} IxCachePrompt_t;

typedef struct
{
  unsigned char                 handle;
  UINT8                *pBuffer;
  UINT32               size;
} IxDspCodeletPlySyncPrm_t;


/* read parameter object */
typedef struct
{
    UINT8       res;
    UINT16      inst;
    UINT16      parmId;
    UINT16      *pParmVal;
    IX_STATUS   result;
} IxDspCodeletReadParm;

/* write parameter object */
typedef struct
{
    UINT8       res;
    UINT16      inst;
    UINT16      parmId;
    UINT16      parmVal;
    UINT32      trans;
    IX_STATUS   result;
} IxDspCodeletWriteParm;

#define IX_DSP_CODELET_STRLEN          80

/* define demo category */
#define IX_DSP_CODELET_CATEGORY_TEST     0   /* diagnostic utilities */
#define IX_DSP_CODELET_CATEGORY_CID      1   /* caller ID */
#define IX_DSP_CODELET_CATEGORY_GW       2   /* gateway and fax bypass */
#define IX_DSP_CODELET_CATEGORY_3WC      3   /* 3-way call */
#define IX_DSP_CODELET_CATEGORY_PLAY     4   /* Player demo */
#define IX_DSP_CODELET_CATEGORY_CIDCW 	 5   /* CIDCW */
#define IX_DSP_CODELET_CATEGORY_PULSE_DIAL 6   /* Pulse Dial */

#define IX_DSP_CODELET_MAKE_TRANS(category, channel) (((category)<<8) \
                                                           | (channel))

#define IX_DSP_CODELET_TRANS_GET_CHAN(pMsg)   ((pMsg)->transactionId & 0xff)

#define IX_DSP_CODELET_TRANS_GET_CAT(pMsg) (0xff & \
                                              ((pMsg)->transactionId >> 8))

#define IX_DSP_CODELET_SET_TIMER(trans, chan, cnt) \
        xDspParmWrite(XMPR_NET, chan, XPARMID_NET_TIMER, cnt, trans);


extern int ixDspCodeletTestInterface;

/*Global variable used by the codelet to determine 
 * whether to use slic or framer functions*/
extern int slic_framer_choice; 

extern XDSPResConfig_t ixDspCodeletResCfg;
/**************/
/* Prototypes */
/**************/

int demostart(void);
void ixDspCodeletNPEInit(void);
void ixDspCodeletDspInit(int interface, int countryCode);
void ixDspCodeletDspInit2(int countryCode);
void ixDspCodeletRegPrompts(void);
int ixDspCodeletDemoMenu(void);
XStatus_t ixDspCodeletRtpSocketSend(UINT16 channel , unsigned char *buffer);

int ixDspCodeletGetNum(char *str);
void ixDspCodeletAllignCompMode(void);
int ixDspCodeletGetStr(char *str, char *pInStr);
void ixDspCodeletPrtResParms(int res, int inst);

void ixDspCodeletSlicHookCB(IxScHookState state, IxScChipNum potsLine);
int ixDspCodeletCreateCidDataJP(char *pPhoneNo, unsigned char *pData);
void ixDspCodeletClientProcess(void);

int ixDspCodeletPrtMsg(XMsgRef_t pMsg);
int ixDspCodeletGetHookState(int ch);
int ixDspCodeletPolarityInv(int ch);
void ixDspCodeletShortRing(int ch);
void ixDspCodeletNormalRing(int ch);
void ixDspCodeletStopRing(int ch);
void ixDspCodeletSetHookEventCategory(int value);
void ixDspCodeletOnHookTransmission(int ch);

void ixDspCodeletPrtParmsDefinition(int resType);
int ixDspCodeletCallerIdSmJp(XMsgRef_t pMsg);

int ixDspCodeletAddToneTG(void);
int ixDspCodeletAddToneTD(void);
void ixDspCodeletRegPrompts(void);

int ixDspCodeletMsgDecoder(XMsgRef_t pUsrMsg,XMsgRef_t pDspMsg,
                           int sequenceNo);
void ixDspCodeletMsgEncoder(XMsgRef_t pUsrReply, XMsgRef_t pDspReply,
                            int sequenceNo, UINT8 usrMsgType);

void ixDspCodeletDisableEC(void);

#endif /* __IXDSPCODELET_H__ */

