/******************************************************************************
*       @file  IxDspCodeletAddTone.c
*
* Contents: This file contains functions to add tones for TD and TG.
*
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
*
******************************************************************************/

#include "IxDspCodeletAddTone.h"

int ixDspCodeletAddToneTG(void)
{
    XTGToneSeg_t toneSegs[MAX_TONE_SEG];

    UInt32       errorCode;

    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_255_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_255_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_255_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_255_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_255_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_255_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_255_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = XTG_LASTSEG;
    if (XSUCC != xBuildToneTG(TG_TONE_ID_255, (TG_TONE_SEG_0+1), 
                                    toneSegs, &errorCode))
    {
        printf("Failed to build the tone id 255 **** %d\n", errorCode);
    }

    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_254_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = XTG_DUALTONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_254_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_254_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_254_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_254_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_254_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_254_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = XTG_LASTSEG;
    if (XSUCC != xBuildToneTG(TG_TONE_ID_254, (TG_TONE_SEG_0+1), 
                                    toneSegs, &errorCode))
    {
        printf("Failed to build the tone id 254 **** %d\n", errorCode);
    }

    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_253_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = XTG_AMTONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_253_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_253_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_253_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_253_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_253_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_253_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = XTG_LASTSEG;
    if (XSUCC != xBuildToneTG(TG_TONE_ID_253, (TG_TONE_SEG_0+1), 
                                    toneSegs, &errorCode))
    {
        printf("Failed to build the tone id 253 **** %d\n", errorCode);
    }

    /* Two Segment Tone. Continuous. */
    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_252_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_252_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_252_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_252_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_252_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_252_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_252_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = TG_TONE_ID_252_SEG0_NXT_SEG;

    toneSegs[TG_TONE_SEG_1].repCount    = TG_TONE_ID_252_SEG1_REP_CNT;
    toneSegs[TG_TONE_SEG_1].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_1].durationOn  = TG_TONE_ID_252_SEG1_ONTIME;
    toneSegs[TG_TONE_SEG_1].durationOff = TG_TONE_ID_252_SEG1_OFFTIME;
    toneSegs[TG_TONE_SEG_1].freqA       = TG_TONE_ID_252_SEG1_FREQ_A;
    toneSegs[TG_TONE_SEG_1].freqB       = TG_TONE_ID_252_SEG1_FREQ_B;
    toneSegs[TG_TONE_SEG_1].ampA        = TG_TONE_ID_252_SEG1_AMP_A;
    toneSegs[TG_TONE_SEG_1].ampB        = TG_TONE_ID_252_SEG1_AMP_B;
    toneSegs[TG_TONE_SEG_1].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_1].nextSeg     = TG_TONE_ID_252_SEG1_NXT_SEG;
    if (XSUCC != xBuildToneTG(TG_TONE_ID_252, (TG_TONE_SEG_1+1), 
                                    toneSegs, &errorCode))
    {
        printf("Failed to build the tone id 251 **** %d\n", errorCode);
    }

    /* Off-hook warning, Five Segment Tone. Continuous. */
    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_251_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_251_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_251_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_251_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_251_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_251_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_251_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = TG_TONE_ID_251_SEG0_NXT_SEG;

    toneSegs[TG_TONE_SEG_1].repCount    = TG_TONE_ID_251_SEG1_REP_CNT;
    toneSegs[TG_TONE_SEG_1].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_1].durationOn  = TG_TONE_ID_251_SEG1_ONTIME;
    toneSegs[TG_TONE_SEG_1].durationOff = TG_TONE_ID_251_SEG1_OFFTIME;
    toneSegs[TG_TONE_SEG_1].freqA       = TG_TONE_ID_251_SEG1_FREQ_A;
    toneSegs[TG_TONE_SEG_1].freqB       = TG_TONE_ID_251_SEG1_FREQ_B;
    toneSegs[TG_TONE_SEG_1].ampA        = TG_TONE_ID_251_SEG1_AMP_A;
    toneSegs[TG_TONE_SEG_1].ampB        = TG_TONE_ID_251_SEG1_AMP_B;
    toneSegs[TG_TONE_SEG_1].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_1].nextSeg     = TG_TONE_ID_251_SEG1_NXT_SEG;

    toneSegs[TG_TONE_SEG_2].repCount    = TG_TONE_ID_251_SEG2_REP_CNT;
    toneSegs[TG_TONE_SEG_2].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_2].durationOn  = TG_TONE_ID_251_SEG2_ONTIME;
    toneSegs[TG_TONE_SEG_2].durationOff = TG_TONE_ID_251_SEG2_OFFTIME;
    toneSegs[TG_TONE_SEG_2].freqA       = TG_TONE_ID_251_SEG2_FREQ_A;
    toneSegs[TG_TONE_SEG_2].freqB       = TG_TONE_ID_251_SEG2_FREQ_B;
    toneSegs[TG_TONE_SEG_2].ampA        = TG_TONE_ID_251_SEG2_AMP_A;
    toneSegs[TG_TONE_SEG_2].ampB        = TG_TONE_ID_251_SEG2_AMP_B;
    toneSegs[TG_TONE_SEG_2].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_2].nextSeg     = TG_TONE_ID_251_SEG2_NXT_SEG;

    toneSegs[TG_TONE_SEG_3].repCount    = TG_TONE_ID_251_SEG3_REP_CNT;
    toneSegs[TG_TONE_SEG_3].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_3].durationOn  = TG_TONE_ID_251_SEG3_ONTIME;
    toneSegs[TG_TONE_SEG_3].durationOff = TG_TONE_ID_251_SEG3_OFFTIME;
    toneSegs[TG_TONE_SEG_3].freqA       = TG_TONE_ID_251_SEG3_FREQ_A;
    toneSegs[TG_TONE_SEG_3].freqB       = TG_TONE_ID_251_SEG3_FREQ_B;
    toneSegs[TG_TONE_SEG_3].ampA        = TG_TONE_ID_251_SEG3_AMP_A;
    toneSegs[TG_TONE_SEG_3].ampB        = TG_TONE_ID_251_SEG3_AMP_B;
    toneSegs[TG_TONE_SEG_3].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_3].nextSeg     = TG_TONE_ID_251_SEG3_NXT_SEG;

    toneSegs[TG_TONE_SEG_4].repCount    = TG_TONE_ID_251_SEG4_REP_CNT;
    toneSegs[TG_TONE_SEG_4].segType     = XTG_SINGLETONE;
    toneSegs[TG_TONE_SEG_4].durationOn  = TG_TONE_ID_251_SEG4_ONTIME;
    toneSegs[TG_TONE_SEG_4].durationOff = TG_TONE_ID_251_SEG4_OFFTIME;
    toneSegs[TG_TONE_SEG_4].freqA       = TG_TONE_ID_251_SEG4_FREQ_A;
    toneSegs[TG_TONE_SEG_4].freqB       = TG_TONE_ID_251_SEG4_FREQ_B;
    toneSegs[TG_TONE_SEG_4].ampA        = TG_TONE_ID_251_SEG4_AMP_A;
    toneSegs[TG_TONE_SEG_4].ampB        = TG_TONE_ID_251_SEG4_AMP_B;
    toneSegs[TG_TONE_SEG_4].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_4].nextSeg     = TG_TONE_ID_251_SEG4_NXT_SEG;
    if (XSUCC != xBuildToneTG(TG_TONE_ID_251, (TG_TONE_SEG_4+1), 
                                    toneSegs, &errorCode))
    {
        printf("Failed to build the tone id 250 **** %d\n", errorCode);
    }


    /* Information startup tone (CAT), Two SegmentTone. */
    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_250_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = XTG_DUALTONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_250_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_250_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_250_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_250_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_250_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_250_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = TG_TONE_ID_250_SEG0_NXT_SEG;

    toneSegs[TG_TONE_SEG_1].repCount    = TG_TONE_ID_250_SEG1_REP_CNT;
    toneSegs[TG_TONE_SEG_1].segType     = XTG_DUALTONE;
    toneSegs[TG_TONE_SEG_1].durationOn  = TG_TONE_ID_250_SEG1_ONTIME;
    toneSegs[TG_TONE_SEG_1].durationOff = TG_TONE_ID_250_SEG1_OFFTIME;
    toneSegs[TG_TONE_SEG_1].freqA       = TG_TONE_ID_250_SEG1_FREQ_A;
    toneSegs[TG_TONE_SEG_1].freqB       = TG_TONE_ID_250_SEG1_FREQ_B;
    toneSegs[TG_TONE_SEG_1].ampA        = TG_TONE_ID_250_SEG1_AMP_A;
    toneSegs[TG_TONE_SEG_1].ampB        = TG_TONE_ID_250_SEG1_AMP_B;
    toneSegs[TG_TONE_SEG_1].mode        = XTG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_1].nextSeg     = XTG_LASTSEG;

    if (XSUCC != xBuildToneTG(TG_TONE_ID_250, (TG_TONE_SEG_1+1), 
                                    toneSegs, &errorCode))
    {
        printf("Failed to build the tone id 250 **** %d\n", errorCode);
    }

    return (1);
}


int ixDspCodeletAddToneTD(void)
{

    XTDToneInfo_t toneInfo;
    UInt32       errorCode;
    /*
     * 500Hz +- 20 Single Tone.
     */
    toneInfo.type          = XTD_SINGLETONE;
    toneInfo.criteria      = XTD_QUAL_CRITERIA_LOOSE;
    toneInfo.freqLowA      = TD_TONE_ID_255_FREQ_LOW_A;
    toneInfo.freqHighA     = TD_TONE_ID_255_FREQ_HIGH_A;
    toneInfo.freqLowB      = TD_TONE_ID_255_FREQ_LOW_B;
    toneInfo.freqHighB     = TD_TONE_ID_255_FREQ_HIGH_B;
    toneInfo.ampLowA       = TD_TONE_ID_255_AMP_LOW_A;
    toneInfo.ampHighA      = TD_TONE_ID_255_AMP_HIGH_A;
    toneInfo.ampLowB       = TD_TONE_ID_255_AMP_LOW_B;
    toneInfo.ampHighB      = TD_TONE_ID_255_AMP_HIGH_B;
    toneInfo.attributes    = XTD_TONEATTR_EVTBOTH;
    if (XSUCC != xBuildToneTD(TD_TONE_ID_255, &toneInfo, &errorCode))
    {
        printf("Failed to build TD tone id 255 errcd=%d\n", errorCode);
    }

    /*
     * 700Hz +- 10 Single Tone. Amplitude -5 to -30
     */
    toneInfo.type         = XTD_SINGLETONE;
    toneInfo. criteria    = XTD_QUAL_CRITERIA_LOOSE;
    toneInfo.freqLowA     = TD_TONE_ID_249_FREQ_LOW_A;
    toneInfo.freqHighA    = TD_TONE_ID_249_FREQ_HIGH_A;
    toneInfo.freqLowB     = TD_TONE_ID_249_FREQ_LOW_B;
    toneInfo.freqHighB    = TD_TONE_ID_249_FREQ_HIGH_B;
    toneInfo.ampLowA      = TD_TONE_ID_249_AMP_LOW_A;
    toneInfo.ampHighA     = TD_TONE_ID_249_AMP_HIGH_A;
    toneInfo.ampLowB      = TD_TONE_ID_249_AMP_LOW_B;
    toneInfo.ampHighB     = TD_TONE_ID_249_AMP_HIGH_B;
    toneInfo.attributes   = XTD_TONEATTR_EVTBOTH;

    if (XSUCC != xBuildToneTD(TD_TONE_ID_249, &toneInfo, &errorCode))
    {
        printf("Failed to build TD tone id 249 errcd=%d\n", errorCode);
    }


    /*
     * DTMF0 DualTone.
     */
    toneInfo.type         = XTD_DUALTONE;
    toneInfo.criteria     = XTD_QUAL_CRITERIA_LOOSE;
    toneInfo.freqLowA     = TD_TONE_ID_248_FREQ_LOW_A;
    toneInfo.freqHighA    = TD_TONE_ID_248_FREQ_HIGH_A;
    toneInfo.freqLowB     = TD_TONE_ID_248_FREQ_LOW_B;
    toneInfo.freqHighB    = TD_TONE_ID_248_FREQ_HIGH_B;
    toneInfo.ampLowA      = TD_TONE_ID_248_AMP_LOW_A;
    toneInfo.ampHighA     = TD_TONE_ID_248_AMP_HIGH_A;
    toneInfo.ampLowB      = TD_TONE_ID_248_AMP_LOW_B;
    toneInfo.ampHighB     = TD_TONE_ID_248_AMP_HIGH_B;
    toneInfo.attributes   = XTD_TONEATTR_EVTBOTH;
    if (XSUCC != xBuildToneTD(TD_TONE_ID_248, &toneInfo, &errorCode))
    {
        printf("Failed to build TD tone id 248 errcd=%d\n", errorCode);
    }

    return (1);
}

