/******************************************************************************
*       @file  IxDspCodeletAddTone.h
*
* Contents: This file contains defines for various TD and TG tones 
*           and their different components
*
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
*
******************************************************************************/

#include "IxDspCodelet.h"
#include "dspcfg.h"
#include "dsptone.h"

#define MAX_TONE_SEG  5

#define TG_TONE_SEG_0   0
#define TG_TONE_SEG_1   1
#define TG_TONE_SEG_2   2
#define TG_TONE_SEG_3   3
#define TG_TONE_SEG_4   4

#define TG_TONE_ID_250  250
#define TG_TONE_ID_251  251
#define TG_TONE_ID_252  252
#define TG_TONE_ID_253  253
#define TG_TONE_ID_254  254
#define TG_TONE_ID_255  255

#define TG_TONE_ID_255_SEG0_REP_CNT  5
#define TG_TONE_ID_255_SEG0_ONTIME   1000
#define TG_TONE_ID_255_SEG0_OFFTIME  500
#define TG_TONE_ID_255_SEG0_FREQ_A   500
#define TG_TONE_ID_255_SEG0_FREQ_B   0
#define TG_TONE_ID_255_SEG0_AMP_A    (-8)
#define TG_TONE_ID_255_SEG0_AMP_B    0

#define TG_TONE_ID_254_SEG0_REP_CNT  2
#define TG_TONE_ID_254_SEG0_ONTIME   800
#define TG_TONE_ID_254_SEG0_OFFTIME  200
#define TG_TONE_ID_254_SEG0_FREQ_A   2130
#define TG_TONE_ID_254_SEG0_FREQ_B   2750
#define TG_TONE_ID_254_SEG0_AMP_A    (-15)
#define TG_TONE_ID_254_SEG0_AMP_B    (-15)

#define TG_TONE_ID_253_SEG0_REP_CNT  4
#define TG_TONE_ID_253_SEG0_ONTIME   5000
#define TG_TONE_ID_253_SEG0_OFFTIME  1000
#define TG_TONE_ID_253_SEG0_FREQ_A   500
#define TG_TONE_ID_253_SEG0_FREQ_B   10
#define TG_TONE_ID_253_SEG0_AMP_A    (-15)
#define TG_TONE_ID_253_SEG0_AMP_B    50

#define TG_TONE_ID_252_SEG0_REP_CNT  1
#define TG_TONE_ID_252_SEG0_ONTIME   500
#define TG_TONE_ID_252_SEG0_OFFTIME  500
#define TG_TONE_ID_252_SEG0_FREQ_A   400
#define TG_TONE_ID_252_SEG0_FREQ_B   0
#define TG_TONE_ID_252_SEG0_AMP_A    (-8)
#define TG_TONE_ID_252_SEG0_AMP_B    0
#define TG_TONE_ID_252_SEG0_NXT_SEG  1

#define TG_TONE_ID_252_SEG1_REP_CNT  1
#define TG_TONE_ID_252_SEG1_ONTIME   500
#define TG_TONE_ID_252_SEG1_OFFTIME  500
#define TG_TONE_ID_252_SEG1_FREQ_A   800
#define TG_TONE_ID_252_SEG1_FREQ_B   0
#define TG_TONE_ID_252_SEG1_AMP_A    (-8)
#define TG_TONE_ID_252_SEG1_AMP_B    0
#define TG_TONE_ID_252_SEG1_NXT_SEG  (-1)

#define TG_TONE_ID_251_SEG0_REP_CNT  1
#define TG_TONE_ID_251_SEG0_ONTIME   800
#define TG_TONE_ID_251_SEG0_OFFTIME  0
#define TG_TONE_ID_251_SEG0_FREQ_A   600
#define TG_TONE_ID_251_SEG0_FREQ_B   0
#define TG_TONE_ID_251_SEG0_AMP_A    1
#define TG_TONE_ID_251_SEG0_AMP_B    0
#define TG_TONE_ID_251_SEG0_NXT_SEG  1

#define TG_TONE_ID_251_SEG1_REP_CNT  1
#define TG_TONE_ID_251_SEG1_ONTIME   200
#define TG_TONE_ID_251_SEG1_OFFTIME  0
#define TG_TONE_ID_251_SEG1_FREQ_A   1200
#define TG_TONE_ID_251_SEG1_FREQ_B   0
#define TG_TONE_ID_251_SEG1_AMP_A    1
#define TG_TONE_ID_251_SEG1_AMP_B    0
#define TG_TONE_ID_251_SEG1_NXT_SEG  1

#define TG_TONE_ID_251_SEG2_REP_CNT  1
#define TG_TONE_ID_251_SEG2_ONTIME   200
#define TG_TONE_ID_251_SEG2_OFFTIME  0
#define TG_TONE_ID_251_SEG2_FREQ_A   1800
#define TG_TONE_ID_251_SEG2_FREQ_B   0
#define TG_TONE_ID_251_SEG2_AMP_A    1
#define TG_TONE_ID_251_SEG2_AMP_B    0
#define TG_TONE_ID_251_SEG2_NXT_SEG  1

#define TG_TONE_ID_251_SEG3_REP_CNT  1
#define TG_TONE_ID_251_SEG3_ONTIME   200
#define TG_TONE_ID_251_SEG3_OFFTIME  0
#define TG_TONE_ID_251_SEG3_FREQ_A   1200
#define TG_TONE_ID_251_SEG3_FREQ_B   0
#define TG_TONE_ID_251_SEG3_AMP_A    1
#define TG_TONE_ID_251_SEG3_AMP_B    0
#define TG_TONE_ID_251_SEG3_NXT_SEG  1

#define TG_TONE_ID_251_SEG4_REP_CNT  1
#define TG_TONE_ID_251_SEG4_ONTIME   200
#define TG_TONE_ID_251_SEG4_OFFTIME  1000
#define TG_TONE_ID_251_SEG4_FREQ_A   1800
#define TG_TONE_ID_251_SEG4_FREQ_B   0
#define TG_TONE_ID_251_SEG4_AMP_A    1
#define TG_TONE_ID_251_SEG4_AMP_B    0
#define TG_TONE_ID_251_SEG4_NXT_SEG  (-4)

#define TG_TONE_ID_250_SEG0_REP_CNT  1
#define TG_TONE_ID_250_SEG0_ONTIME   60
#define TG_TONE_ID_250_SEG0_OFFTIME  60
#define TG_TONE_ID_250_SEG0_FREQ_A   852
#define TG_TONE_ID_250_SEG0_FREQ_B   1633
#define TG_TONE_ID_250_SEG0_AMP_A    (-8)
#define TG_TONE_ID_250_SEG0_AMP_B    (-7)
#define TG_TONE_ID_250_SEG0_NXT_SEG  1

#define TG_TONE_ID_250_SEG1_REP_CNT  1
#define TG_TONE_ID_250_SEG1_ONTIME   60
#define TG_TONE_ID_250_SEG1_OFFTIME  0
#define TG_TONE_ID_250_SEG1_FREQ_A   941
#define TG_TONE_ID_250_SEG1_FREQ_B   1633
#define TG_TONE_ID_250_SEG1_AMP_A    (-8)
#define TG_TONE_ID_250_SEG1_AMP_B    (-7)

#define TD_TONE_ID_248  248
#define TD_TONE_ID_249  249
#define TD_TONE_ID_255  255

#define TD_TONE_ID_255_FREQ_LOW_A    480
#define TD_TONE_ID_255_FREQ_HIGH_A   520
#define TD_TONE_ID_255_FREQ_LOW_B    0
#define TD_TONE_ID_255_FREQ_HIGH_B   0
#define TD_TONE_ID_255_AMP_LOW_A     0
#define TD_TONE_ID_255_AMP_HIGH_A    0
#define TD_TONE_ID_255_AMP_LOW_B     0
#define TD_TONE_ID_255_AMP_HIGH_B    0

#define TD_TONE_ID_249_FREQ_LOW_A    690
#define TD_TONE_ID_249_FREQ_HIGH_A   710
#define TD_TONE_ID_249_FREQ_LOW_B    0
#define TD_TONE_ID_249_FREQ_HIGH_B   0
#define TD_TONE_ID_249_AMP_LOW_A     (-30)
#define TD_TONE_ID_249_AMP_HIGH_A    (-5)
#define TD_TONE_ID_249_AMP_LOW_B     0
#define TD_TONE_ID_249_AMP_HIGH_B    0

#define TD_TONE_ID_248_FREQ_LOW_A    380
#define TD_TONE_ID_248_FREQ_HIGH_A   420
#define TD_TONE_ID_248_FREQ_LOW_B    780
#define TD_TONE_ID_248_FREQ_HIGH_B   820
#define TD_TONE_ID_248_AMP_LOW_A     (-10)
#define TD_TONE_ID_248_AMP_HIGH_A    (-5)
#define TD_TONE_ID_248_AMP_LOW_B     (-10)
#define TD_TONE_ID_248_AMP_HIGH_B    (-5)

