/******************************************************************************
*       @file	IxDspCodeletAppOssl.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef __IXDSPCODELETAPPOSSL_H__
#define __IXDSPCODELETAPPOSSL_H__

#include <msgdef.h>
#include <poll.h>

#define XTASK_PRI_RT0                   40
#define XTASK_PRI_RT1                   (XTASK_PRI_RT0 + 1)
#define XTASK_PRI_RT2                   (XTASK_PRI_RT0 + 2)
#define XTASK_PRI_RT3                   (XTASK_PRI_RT0 + 3)
#define XTASK_PRI_CTR                   (XTASK_PRI_RT3 + 1)
#define XTASK_CREATE_OPT                0
#define XTASK_STACKSIZE                 10240
#define XMSG_MAX_MSGS                   64
#define XMAX_ALIGNMENT                  1024


#define IX_ACC_DRV_DMA_MALLOC(size)             xMalloc(0, size, 4)
#define IX_ACC_DATA_CACHE_FLUSH(adr, size)
#define IX_ACC_DATA_CACHE_INVALIDATE(adr, size)


/* TASK-16278 ARLC :: VxWorks and Linux Mapping */
typedef int XTaskId_t;
typedef int XSemaphore_t;
typedef int (*XTaskEntry_t)(void *pArg);

XSemaphore_t xSemaCreate(void );
int xWaitTaskTrig(XSemaphore_t semaphore);
int xTrigTask(XSemaphore_t semaphore);
void xInitOssl(void);
void xDestroyOssl();
XStatus_t xMsgSend(void *pMsgBuf);
XStatus_t xMsgReceive(void *pMsgBuf, UINT16 channel, int timeout);
XStatus_t xMsgRead(void *pMsgHdr, int timeout);
XStatus_t xMsgWrite(void *pMsgBuf);
XTaskId_t xTaskCreate(char *name, int priority, XTaskEntry_t func, void *pArg);
int xTaskSleep(int ticks);

#endif
/* __IXDSPCODELETAPPOSSL_H__ */
