/******************************************************************************
*       @file  IxDspCodeletAppOsslLib.c
*
* Contents: This file contains functions for Ossl, threads, task sleep.
*
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#include <pthread.h>
#include <assert.h>

#include "IxDspCodeletAppOssl.h"
#include "IxDspCodelet.h"
#include "IxDspCodeletAppLinuxInc.h"

extern CachePrompts[IX_DSP_CODELET_MAX_PROMPTS];
static int inMsgQue, outMsgQue;

int
ixDspCodeletSyncData (int handle, char *pBuffer, int size)
{
  IxDspCodeletPlySyncPrm_t IxDspCodeletPlySync;

  IxDspCodeletPlySync.handle = handle;
  IxDspCodeletPlySync.size = size;
  IxDspCodeletPlySync.pBuffer = pBuffer;

  return (size);
}

void xDestroyOssl(void)
{
  return;
}

int
XX_Msg_CtrlRet (unsigned int functionid, int arg)
{
  int rc;
  int val = arg;

  if (!inMsgQue)
    {
      return (-1);
    }

  rc = ioctl (inMsgQue, functionid, &val);
  if (rc != 0)
    {
      printf ("ixDspCodelet ioctl rc is failed .. %d \n", rc);
      return (-1);
    }

  return (val);
}

int
XX_Msg_CtrlPtrRet (unsigned int functionid, void *arg)
{
  int rc;

  if (!inMsgQue)
    {
      return -1;
    }

  rc = ioctl (inMsgQue, functionid, arg);
  if (rc != 0)
    {
      printf ("MABB ioctl rc is failed .. %d \n", rc);
      return (-1);
    }

  return (0);
}

int
xTaskSleep_app (int microseconds)
{
  struct timeval delayTime;

  delayTime.tv_sec = (long)0; /* seconds */
  delayTime.tv_usec = microseconds; /* microseconds */

  return (select (0, NULL, NULL, NULL, &delayTime));
}

thread_T
Thread_Create_app (int priority, threadFunc_T startFunc, threadArg_T * arg)
{
  thread_T thread;
  pthread_attr_t thread_attr;
  struct sched_param param;

  pthread_attr_init (&thread_attr);
  pthread_attr_setdetachstate (&thread_attr, PTHREAD_CREATE_DETACHED);

  param.sched_priority = priority;
  pthread_attr_setschedparam (&thread_attr, &param);

  pthread_create (&thread, &thread_attr, (pthread_startroutine_t) startFunc,
      (pthread_addr_t) arg);
  return (thread);
}

int
Thread_Cancel (thread_T thread)
{
  return (pthread_cancel (thread));
}

void
ixOsServTaskSleep (int milliseconds)
{
  struct pollfd foo;

  if (poll (&foo, (unsigned long) 0, milliseconds) == -1)
    {
    }
}
