/******************************************************************************
*       @file   IxDspCodeletInit.c
*
* Contents: This file contains functions for Initialisation.
*
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

/*
 * Put the system defined include files required.
 */

#include <alsa/asoundlib.h>
#include "IxDspCodelet.h"

#define IX_DSP_CODELET_PIU_A_BUILD_1    1
#define IX_DSP_CODELET_PIU_A_BUILD_22   0x16
#define IX_DSP_TS_UNAS IX_HSSACC_TDMMAP_UNASSIGNED
#define IX_DSP_TS_HDLC IX_HSSACC_TDMMAP_HDLC
#define IX_DSP_TS_V64K IX_HSSACC_TDMMAP_VOICE64K
#define IX_DSP_TS_V56K IX_HSSACC_TDMMAP_VOICE56K
#define IX_DSP_CODELET_REALTASK_PRI 15 
 /* realtime task priority  of DSP module*/ 
#define IX_DSP_CODELET_CTRLTASK_PRI 10 
 /* control task priority of DSP module */
#define IX_DSP_CODELET_PCMREAD_TASK_PRI 15 
 /* PCM read task priority of DSP module */                              

#define WB_SLOT_MAP_OFFSET    16
#define WAIT_PLAYER_DEC_INIT  50

static XDSPChanTdmSlots_t INIT_CHAN_TDM_SLOT_MAP_WB;
static XDSPChanTdmSlots_t INIT_CHAN_TDM_SLOT_MAP_NB;

static XDSPSysConfig_t dspConfig = {
    0,                           /* # of chan of TDM terms, determined later */
    0,                           /* # of chan of IP terms,  determined later */
    0,                           /* # of player instances, determined later  */
    1,                           /* number of Audio Mixers */
    IX_DSP_CODELET_MIXER_PORTS,  /* number of ports per mixer */
    0,                               /* country code */
    IX_DSP_CODELET_TASK_PRI_BASE,    /* the base priority of DSP module */
    IX_DSP_CODELET_TASK_PRI_ORDER,   /* the priority ordering of the OS */
    IX_DSP_CODELET_REALTASK_PRI,     /* realtime task priority  of DSP module*/
    IX_DSP_CODELET_CTRLTASK_PRI,     /* control task priority of DSP module */
    IX_DSP_CODELET_PCMREAD_TASK_PRI, /* PCM read task priority of DSP module */
    0,            /* HSS port, must be IX_HSSACC_HSS_PORT_0 */
    &hss_port_config.hssportTx_Rx_config, /* HSS configuration parameters */
    hss_port_config.hssTdmMap,            /* HSS TDM time slot mapping */
    chanTdmSlotMap_NB, 
     /* channel vs. TS mapping initialize wil NB later change 
                                            to WB if required*/
    (XPktRcvFxn_t)ixDspCodeletRtpSocketSend, 
     /* RTP packet send call back function */
    ixDspCodeletMsgDecoder,             /* message decoder function of MA */
    ixDspCodeletMsgEncoder,             /* message encoder function of MA */
    IX_DSP_CODELET_PHN_IF_NB,           /* interface */
    0,                                /* ALSA capture handle */
    0                                 /* ALSA playback handle */
};
static XDSPRegisterCsrOption_t csrOptionalFuncs;
void ixQMgrPeriodicDone(void);
void  ixHssAccChanTslotSwitchEnable(void);
void  ixHssAccChanTslotSwitchDisable(void);
void   ixHssAccChanTslotSwitchGctDownload(void);
typedef IX_STATUS (*HSS_TS_SWITCH_ON)(IxHssAccHssPort,
                                      UINT32, UINT32, UINT32 *);
typedef IX_STATUS (*HSS_TS_SWITCH_OFF)(IxHssAccHssPort, UINT32);
typedef IX_STATUS (*HSS_TS_SWITCH_GCT_LOAD)(IxHssAccHssPort, UINT8 *, UINT32);
extern snd_pcm_t *phandle; /* ALSA playback handle */
extern snd_pcm_t *chandle; /* ALSA capture handle */

static XDSPRegisterCsrOption_t csrOptionalFuncs = {
    (HSS_TS_SWITCH_ON)ixHssAccChanTslotSwitchEnable, 
      /* enable PIU TS switch */
    (HSS_TS_SWITCH_OFF)ixHssAccChanTslotSwitchDisable, 
      /* disable PIU TS switch */
    (HSS_TS_SWITCH_GCT_LOAD)ixHssAccChanTslotSwitchGctDownload, 
      /* download GCT */
    ixQMgrPeriodicDone, 
      /* LLP periodic done */
};


void ixDspCodeletNPEInit(void)
{
 printf("ixDspCodeletHssInit:: Fail to hook the QM QUELOW "
                                "dispatcher to interrupt\n");
}

void ixDspCodeletDspInit(int interface, int countryCode)
{

    /* Add user-defined tone templates to tone generation
     * Note : must be added before xDspSysInit() */
    ixDspCodeletAddToneTD(); 

    /* determine the interface-specific configuration */
    switch(interface)
    {
    case IX_DSP_CODELET_PHN_IF_T1 :
        dspConfig.numChTDM = IX_DSP_CODELET_TDM_CHL_T1;
        dspConfig.pChanTsMap = NULL;
        break;

    case IX_DSP_CODELET_PHN_IF_WB:
       dspConfig.pChanTsMap = chanTdmSlotMap_WB;
        chanTdmSlotMap_WB[1].slotSample2 =
                     chanTdmSlotMap_WB[1].slotSample1 + WB_SLOT_MAP_OFFSET;
       dspConfig.dspInterface = IX_DSP_CODELET_PHN_IF_WB;
        /* no break here */

    case IX_DSP_CODELET_PHN_IF_MB:
        chanTdmSlotMap_WB[0].slotSample2 = 
                     chanTdmSlotMap_WB[0].slotSample1 + WB_SLOT_MAP_OFFSET;
        /* no break here */

    case IX_DSP_CODELET_PHN_IF_NB:
        dspConfig.numChTDM = IX_DSP_CODELET_TDM_CHL_ANALOG;
    default:
    ; /* No default */
    }

    /* set resource configuration */
    dspConfig.numChIP = dspConfig.numChTDM + 1;
    dspConfig.numPlayers = dspConfig.numChTDM + 1;
    dspConfig.countryCode = countryCode;
    dspConfig.port = hss_port_config.hssport_Id;
    dspConfig.alsaCaptureHandle = chandle;
    dspConfig.alsaPlaybackHandle = phandle;

    xDspSysInit(&dspConfig); 

    /* add user-defined tone templates to tone detection
     * Note : must be added after xDspSysInit() */
    ixDspCodeletAddToneTG();

    /* wait let Player Decoder components get initialized */
    ixOsalSleep(WAIT_PLAYER_DEC_INIT);
     
    /* register cache prompts for player */
    ixDspCodeletRegPrompts();

    /* register csr optional functions for LLP and HSS TS switch */
    xDspRegisterCsrOptions(&csrOptionalFuncs); 
}

void ixDspCodeletRegPrompts(void)
{
    extern unsigned char ixDspCodeletVoicePrompt[], ixDspCodeletVoiceDigits[];
    extern int ixDspCodeletVoicePromptSize, ixDspCodeletVoiceDigitsSize;
    XCachePromptDesc_t desc;

    /*
     * register hardcoded voice data.
     * the prompt handle returned by xDspRegCachePrompt()
     * is the sequencial number starting from 0.
     * if this function is called at the beginning, it will
     * get the prompt handle 0 and 1.
     */

    desc.pBuffer = ixDspCodeletVoicePrompt;
    desc.size = ixDspCodeletVoicePromptSize;
    desc.type = XCODER_TYPE_G729A;
    xDspRegCachePrompt(&desc);

    desc.pBuffer = ixDspCodeletVoiceDigits;
    desc.size = ixDspCodeletVoiceDigitsSize;
    desc.type = XCODER_TYPE_G729A;
    xDspRegCachePrompt(&desc);
}

void ixQMgrPeriodicDone(void)
{
}

void  ixHssAccChanTslotSwitchEnable(void)
{           /* enable PIU TS switch */
}

void  ixHssAccChanTslotSwitchDisable(void)
{          /* disable PIU TS switch */
}

void   ixHssAccChanTslotSwitchGctDownload(void)
{      /* download GCT */
}

