/******************************************************************************
*       @file  IxDspCodeletMain.c  
*
* Contents: This file contains the Codelet demostart function.
*
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

/*
 * Put the user defined include files required.
 */
#include "FWTypes.h"
#include "dspcfg.h"
#include "IxDspCodeletAppLinuxInc.h"
#include "IxDspCodelet.h"

#include "IxPlatforms.h"
#define US 1 /* Country code for the Uinited States */

int ixDspCodeletTestInterface;
int companding_mode;

/*****************************
 * test main function entry
 *****************************/
int demostart(void)
{
    static int dspStarted = 0;
    int countryCode = US; 
    int interface= IX_DSP_CODELET_PHN_IF_WB;
    int rc;

    XDSPResConfig_t dspConfig;

    if(dspStarted)
    {
        ixDspCodeletDemoMenu();
        return IX_SUCCESS;
    }

    /* Initialize ALSA drivers for audio */

    rc = ixALSAInit();

    if(rc != IX_SUCCESS)
    {
       printf("ALSA Init Failed \n");
       return IX_FAIL;
    }

    ixDspCodeletTestInterface=interface;

    /*initialize DSP module with built-in HSS interface */
    ixDspCodeletDspInit(interface, countryCode);

    /*get configuration information */
    xDspGetResConfig(&dspConfig);

    printf("-------- DSP Resource Configuration -------\n"
           "\tNumber of TDM terminations = %d\n"
           "\tNumber of IP terminations  = %d\n"
           "\tNumber of Player           = %d\n"
           "\tNumber of Mixers           = %d\n"
           "\tNumber of ports per Mixer  = %d\n"
           "\tCountry code               = %d\n"
           "-------------------------------------------\n",
           dspConfig.numChTDM,
           dspConfig.numChIP,
           dspConfig.numPlayers,
           dspConfig.numMixers,
           dspConfig.numPortsPerMixer,
           dspConfig.countryCode);

   /*create DSP client task that runs the state machine of client application*/
       
   dspStarted = 1;

   return IX_SUCCESS;
}

