/******************************************************************************
*       @file    IxDspCodeletMenu.c
*
* Contents: This file contains functions for the Codelet menu.
*
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

/*
 * Put the user defined include files required.
 */
#include <stdio.h>
#include "IxDspCodelet.h"
#include "IxDspCodeletUsrMsgDef.h"
#include <setjmp.h>
#include "IxDspCodeletAppLinuxInc.h"
#include "IxDspCodeletSocket.h"

/*
 * defines and macros used in this file.
 */
static short channel_up[IX_DSP_CODELET_MAX_CHL];
static short channel_down[IX_DSP_CODELET_MAX_CHL];

#define MAX_STR_LEN_4      4
#define MAX_STR_LEN_100    100
#define MAX_STR_LEN_150    150

#define RFC_2833_PAYLOAD_TYPE_101  101
#define MILLISEC_10                10000

char inpChlStr[MAX_STR_LEN_100];
char tempStr[MAX_STR_LEN_4]; 
char promptGetChlOption[MAX_STR_LEN_150];
char promptGetChlTeardownOption[MAX_STR_LEN_150];

extern int companding_mode;

#define IX_DSP_CODELET_ERROR_SEND_MSG      (-1)
#define IX_DSP_CODELET_ERROR_UNKNOWN_MSG    1

#define MAX_CHANNEL_SETUP_OPTION 24

#define NET_RESOURCE_SERIAL 1
#define NET_RESOURCE_LAW_ID 2
#define NET_RESOURCE_EC_ID  3
#define MAX_GW_DEMO_CHL     4
#define NET_RESOURCE_EC_DISABLED  0
#define NET_RESOURCE_EC_ENABLED   1

#define MIXER_CALL_NUM 1

/* check the number of TDM channels */
#define IX_CODELET_CHECK_CHL_NUM(i, num) {\
        if((i)==0) {\
            (i) = 1;\
            (num) = ixDspCodeletResCfg.numChTDM;\
        }\
        else {\
            (num) = (i);\
        }\
    }

/* check the number of instances of a resource */
#define IX_CODELET_CHECK_INST_NUM(res, i, num) {\
        if((i)==0) {\
            (i) = 1;\
            (num) = (res) == XMPR_NET || res == XMPR_T38 ? \
                              ixDspCodeletResCfg.numChTDM : \
                    (res) == XMPR_PLY ? ixDspCodeletResCfg.numPlayers : \
                    (res) < XMPR_MIX  ? ixDspCodeletResCfg.numChIP : 1;\
        }\
        else { (num) = (i); }\
    }

/* Caller ID Init function pointer */
typedef void (*CidInitFuncType)(int chl, char *numStr);

/* Codelet Menu Function Pointer Type */
typedef void (*IxDspCodeletMenuFunc) (void);

/* menu structure */
typedef struct
{
    char *name;                             /* menu item name */
    IxDspCodeletMenuFunc menuFunc;          /* Service routine */
} IxDspCodeletMenu;

/* Function prototypes. */
/*int ixDspCodeletGwActive(void);*/
/*void ixDspCodeletGwSmInit(void);*/
/*int ixDspCodeletGwSm(XMsgRef_t pMsg);*/
/*void ixDspCodelet3WCallSelect(int callId);*/
/*int ixDspCodelet3WCallSm(XMsgRef_t pMsg);*/
int ixDspCodeletPlayerSm(XMsgRef_t pMsg);
/*int ixDspCodeletPulseDialSm(XMsgRef_t pMsg);*/
/*void ixDspCodeletPulseDial(void);*/

void ixDspCodeletPlayInit(int chl);
void ixDspCodeletCidInitJp(int chl, char *numStr);
void ixDspCodeletCidInitUs(int chl, char *numStr);
void ixDspCodeletCidInitPrc(int chl, char *numStr);
int ixDspCodeletCallerIdSmJp(XMsgRef_t pMsg);
int ixDspCodeletCallerIdSmBc(XMsgRef_t pMsg);
int ixDspCodeletCidCwSmJp(XMsgRef_t pMsg);
/*int ixDspCodeletPulseDialInit(int chl, int numdigits, int intdigtimeout,
                                       int flash_hook_timeout);*/

/* menu functions */
void ixDspCodeletChannelSetup(void);
void ixDspCodeletChannelTeardown(void);
void ixDspCodeletShowChannelParms(void);
void ixDspCodeletShowResourceParms(void);
void ixDspCodeletSetParm(void);
void ixDspCodeletStartCID(void);
/*void ixDspCodeletStartGwDemo(void);*/
void ixDspCodeletStart3WCall(void);
void ixDspCodeletStartPlay(void);
/*void IxDspCodeletStartCIDCW(void);*/
void ixDspCodeletDiag(void);
void ixDspCodletFillBaseStrmInfo(void);
void ixDspCodeletAppProfile(void);

static int hookEventCategory;

extern IxDspCodeletSocketChanConfigInfo ixDspCodeletSocketChanConfigInfo[];

typedef int (*IxDspCodeletCallerIdSm_func)(XMsgRef_t pMsg);
typedef int (*IxDspCodeletCidCwSm_func)(XMsgRef_t pMsg);

IxDspCodeletCallerIdSm_func ixDspCodeletCallerIdSm;
IxDspCodeletCidCwSm_func ixDspCodeletCidCwSm;

void ixDspCodeletAppSockConfig(void);
void ixDspCodeletAppSockStats(void);
void ixDspCodeletSetPlugInParam(void);
void ixDspCodeletGetPlugInParam(void);
XDSPResConfig_t ixDspCodeletResCfg;
static char *promptGetInst = "Enter the instance number (1,2,...;"
                                         " 0 for all instance) - ";
static char *promptGetInst4Ports = "Enter the instance number (1,2,3,4...;"
                                                 " 0 for all instance) - ";
static char *promptGetChl = "Enter the channel number (1,2,...;"
                                       " 0 for all channels) - ";

static char *promptGetChl4Ports = "Enter the channel number (1,2,3,4...;"
                                                " 0 for all channels) - ";

static char *promptGetRes = "Enter the resource number\n"
                            "\tResource : (1:Net, 2:DEC, 3:ENC, 4:TG, 5:TD,"
                                            " 6:PLY, 7:MIX, 8:T38, 9:MA) - ";

static char *promptGetCode = "Coder types :\n"
                             "\t0:PassThru (for debug only)\n"
                             "\t1:G711 u-Law\n"
                             "\t2:G711 A-Law\n"
                             "\t3:G729a/b\n"
                             "\t4:G723.1\n"
                             "\t5:G722 64Kbps\n"
                             "\t6:G722 56Kbps\n"
                             "\t7:G722 48Kbps\n"
                             "\t8:G726 40Kbps\n"
                             "\t9:G726 32Kbps\n"
                             "\t10:G726 24Kbps\n"
                             "\t11:G726 16Kbps\n"
                             "\t12:G729.1 \n"
                             "Enter the coder type - ";
static char *    promptGetEC = "Echo Cancellor types :\n"
                 "\t1 :Acoustic Echo Canceller(AEC)\n"
                             "\t2 :Line Echo Canceller(LEC)\n"

                             "Enter the type - ";

static char*  promptGetResForCustParams = "Enter the resource number\n"
                            "\tResource : (1:Net, 2:DEC, 3:ENC) - ";

static jmp_buf atPrtMenu;

static char *promptGetNumDigits = "Enter Number of Digits to be "
                                      "collected (1 to 20)         : ";
static char *promptGetIntDigTimeout = "Enter InterDigit Timeout Value"
                                           " (5 - 30 secs)         : ";
static char *promptGetFlashTimeout = "Enter Flash Hook window Size"
                                     " (1000 - 2200 milli secs) : ";
/* define the menu table */
IxDspCodeletMenu ixDspCodeletMenu[] =
{
/*      item name                     menuFunc
    -----------------------------------------------------*/
    { "Print Menu",                   NULL},
    { "Channel Setup",                ixDspCodeletChannelSetup},
    { "Channel Teardown",             ixDspCodeletChannelTeardown},
    { "Show Channel Parameters",      ixDspCodeletShowChannelParms},
    { "Show Resource Parameters",     ixDspCodeletShowResourceParms},
    { "Set a Parameter",              ixDspCodeletSetParm},
    { "Caller ID Demo",               ixDspCodeletStartCID},
    { "3-Way Call Demo",              ixDspCodeletStart3WCall},
    { "Player Demo",                  ixDspCodeletStartPlay},
    { "Diagnostic",                   ixDspCodeletDiag},
    { "Socket Configuration",         ixDspCodeletAppSockConfig},
    { "CPU Occupancy",                   ixDspCodeletAppProfile},
    { "Set Plug-in parameter(s)",     ixDspCodeletSetPlugInParam},
    { "Show Plug-in parameter(s)",    ixDspCodeletGetPlugInParam},
    { "Exit",                         NULL},
    { NULL,                           NULL}
};

/* defaut call parameters */
static IxDspCodeletCallParms defCallParms =
{
    0xffff,                     /* decAutoSwitch */
    XCODER_TYPE_G711MU_10MS,    /* Decoder type */
    XCODER_TYPE_G711MU_10MS,    /* Encoder type */
    1,                          /* number frames per packet */
    XPARM_OFF,                  /* vad */
    XPARM_ON,                   /* RFC 2833 */
    RFC_2833_PAYLOAD_TYPE_101,  /* RFC 2833 payload type */
    XPARM_ON,                   /* tone Clamping */
    XPARM_TD_RPT_TONE_ON        /* tone event report */
};


/*******************************************
 * client application thread function.
 * it is pending outbound message queue
 * and executes a simple state machine engine
 ********************************************/
void ixDspCodeletClientProcess(void)
{
    int  msgBuf[XMSG_MAX_WSIZE];
    int  category;
    XMsgRef_t pMsg;

    pMsg = (XMsgRef_t)msgBuf;
    printf("\nClientProcess started\n");

#ifdef IX_DSP_CODELET_POLLING_MODE

    while(1)
    {
        /* polling the message queue in every 10 ms */
        while(xMsgReceive(pMsg, 0, XWAIT_NONE) == XERROR)
        {
          usleep((UINT32)MILLISEC_10);
        }
#else

    /* pending on the message queue */
    while (xMsgReceive(pMsg, 0, XWAIT_FOREVER) == XSUCC)
    {

#endif
        category = IX_DSP_CODELET_TRANS_GET_CAT(pMsg);

        switch(category)
        {
        case IX_DSP_CODELET_CATEGORY_TEST:
            ixDspCodeletPrtMsg(pMsg);
            break;

        case IX_DSP_CODELET_CATEGORY_CID:
            ixDspCodeletCallerIdSm(pMsg);
            break;

/* aduignan - removing for Menlow */
/*        case IX_DSP_CODELET_CATEGORY_GW:*/
/*            ixDspCodeletGwSm(pMsg);*/
/*            break;*/

        case IX_DSP_CODELET_CATEGORY_3WC:
            ixDspCodelet3WCallSm(pMsg);
            break;

        case IX_DSP_CODELET_CATEGORY_PLAY:
            ixDspCodeletPlayerSm(pMsg);
            break;

/* aduignan - removing for Menlow */
/*    case IX_DSP_CODELET_CATEGORY_CIDCW:*/
/*            ixDspCodeletCidCwSmJp(pMsg);*/
/*            break;*/

/* aduignan - removing for Menlow */    
/*        case IX_DSP_CODELET_CATEGORY_PULSE_DIAL:*/
/*            ixDspCodeletPulseDialSm(pMsg);*/
/*            break;*/

        default:
            ixDspCodeletPrtMsg(pMsg);
        }
    }

    printf("ERROR - xMsgReceive() failed, quit from Client Task\n");
}


/*******************************************
 * demo menu main function
 *******************************************/
int ixDspCodeletDemoMenu(void)
{
    int selectedItem=0;
    int lastItem = -1;
    int i;

    xDspGetResConfig(&ixDspCodeletResCfg);

    ixDspCodletFillBaseStrmInfo();

    /* Allign the companding mode to the initial value */
    /* This should be done only for G711 A-Law and U-Law */
    if(0==companding_mode) {
        ixDspCodeletAllignCompMode();
    }

    /* EC disabled by default */
    ixDspCodeletDisableEC();

    selectedItem = setjmp(atPrtMenu);

    do
    {
       /* print the test menu */
        if(!selectedItem)
        {
            printf( "\n----------------------------------------\n"
                      "-      IxDspCodelet Demo Menu          -\n"
                      "----------------------------------------\n");

            for (i = 0; ixDspCodeletMenu[i].name != NULL; i++)
            {
                printf("%3d - %s\n", i, ixDspCodeletMenu[i].name);
            }

            printf("Please select test item - ");
            lastItem = i - 1;
        }

        /* select a menu item */
        selectedItem = ixDspCodeletGetNum(NULL);

        /* skip if not a menu item */
        if (selectedItem >= lastItem || !selectedItem)
        {
          continue;
        }

        ixDspCodeletMenu[selectedItem].menuFunc();

    } while(selectedItem != lastItem);

    return IX_SUCCESS;
}

/**************************
 * get an integer for stdin
 **************************/
int ixDspCodeletGetNum(char *str)
{
    int c;
    int i = 0;
    char input[IX_DSP_CODELET_STRLEN];

    if(str && *str)
    {
      printf("%s", str);
    }
    do
    {
        c = getc(stdin);

        if (c == 0x08)
        {
            if(i)
            {
              i--;
            }
        }
        else
        {
            input[i++] = c;
        }

        /* exception if x entered, jump to main menu */
        if(c == 'x')
        {
          longjmp(atPrtMenu, 1);
        }

    } while(i<IX_DSP_CODELET_STRLEN-1 && c!='\r' && c!='\n');

    input[i] = '\0';
       
    return atoi(input);
}

/**************************
 * get an integer for stdin
 **************************/
int ixDspCodeletGetStr(char *str, char *pInStr)
{
    int c;
    int i=0;

    if(str && *str)
    {
      printf("%s", str);
    }
    do
    {
        c = getc(stdin);
        if (c == 0x08)
        {
            if(i)
            {
              i--;
            }
        }
        else
        {
            pInStr[i++] = c;
        }

    } while(i<IX_DSP_CODELET_STRLEN && c!='\r' && c!='\n');

    pInStr[i-1] = '\0';

    return i-1;
}

/********************************
 * set up channels
 ********************************/
void ixDspCodeletChannelSetup(void)
{
    int option, inpStrLen;
    int msgNumber, i=0, j=0;
    UINT32  trans;
    IxDspCodeletMsgSetupCallwParms msg;
    UINT8   decType;


    snprintf(promptGetChlOption, MAX_STR_LEN_150, 
                                "Enter channel numbers(1-%d) to configure "
                                "delimited by comma\nin the format x,y,z"
                                " OR enter 0 to configure all channels: "
                                            , (int)IX_DSP_CODELET_MAX_CHL);
    inpStrLen = ixDspCodeletGetStr(promptGetChlOption, inpChlStr);
    
 
    do
    {
      tempStr[i++]=inpChlStr[j];
      if( (inpChlStr[j]==',') || (j==inpStrLen) )
      {
        if(j==inpStrLen)
        {
          tempStr[i]='\0';
        }
        else
        {
          tempStr[i-1]='\0';
        }
        option=atoi(tempStr);
        i=0;
        if( (option >=1) && (option <=IX_DSP_CODELET_MAX_CHL) )
        {
          channel_up[option-1]=TRUE;
        }

        if(option == 0)
        {
            for(msgNumber=0; msgNumber<IX_DSP_CODELET_MAX_CHL; msgNumber++)
            {
              channel_up[msgNumber]=TRUE;
            }
            break;
        }
      }
      j++;
    }while(j<=inpStrLen);
    
    decType = (UINT8)ixDspCodeletGetNum(promptGetCode);
    
    for(msgNumber=0; msgNumber<IX_DSP_CODELET_MAX_CHL; msgNumber++)
    {
        
        if(channel_up[msgNumber]==FALSE)
        {
          continue;
        }

        if (ixDspCodeletSocketChanConfigInfo[msgNumber].isActivated  == FALSE)
        {
            printf("%s(): Socket configuration for channel %d not complete;"
                                                   "Going to next channel\n",
                __FUNCTION__, msgNumber+1);
            channel_up[msgNumber]=FALSE;
            continue;
        }           
        msg.parms = defCallParms;
        msg.parms.decType = decType;
        msg.parms.encType = decType;
            
        msg.channelIP = msgNumber+1;
        msg.channelTDM = msgNumber+1;
            
        trans = IX_DSP_CODELET_MAKE_TRANS(IX_DSP_CODELET_CATEGORY_TEST, msgNumber+1);

        IX_DSP_CODELET_MAKE_MSGHDR_SETUP_CALLWPARMS(&msg, trans);
        if(xMsgSend(&msg) != XSUCC)
        {
            printf("ERROR - Channel Setup Message sender fails.\n");
            return;
        }

        channel_up[msgNumber]=FALSE;
    }
}

/********************************
 * tear down a channel
 ********************************/
void ixDspCodeletChannelTeardown(void)
{
    int inpStrLen;
    int msgNumber, i=0, j=0;
    UINT32 trans;
    IxDspCodeletMsgStopIP msg;
    int option;

        snprintf(promptGetChlTeardownOption, MAX_STR_LEN_150, 
                    "Enter channel numbers(1-%d) "
                    "to teardown delimited by comma\nin the format x,y,z"
                    " OR enter 0 to teardown all channels: ",
                                              (int)IX_DSP_CODELET_MAX_CHL);
        inpStrLen = ixDspCodeletGetStr(promptGetChlTeardownOption, inpChlStr);

    do
    {
        tempStr[i++]=inpChlStr[j];
        if( (inpChlStr[j]==',') || (j==inpStrLen) )
        {
            if(j==inpStrLen)
            {
              tempStr[i]='\0';
            }
            else
            {
              tempStr[i-1]='\0';
            }
            option=atoi(tempStr);
            i=0;
            if(option >=1 && option <=IX_DSP_CODELET_MAX_CHL)
            {
              channel_down[option-1]=TRUE;
            }

            if(option == 0)
            {
                for(msgNumber=0; msgNumber<IX_DSP_CODELET_MAX_CHL; msgNumber++)
                {
                  channel_down[msgNumber]=TRUE;
                }
                break;
            }
        }
        j++;
    }while(j<=inpStrLen);


    for(msgNumber=0; msgNumber<IX_DSP_CODELET_MAX_CHL; msgNumber++)
    {
        if(channel_down[msgNumber]==FALSE)
        {
          continue;
        }

        trans = IX_DSP_CODELET_MAKE_TRANS(IX_DSP_CODELET_CATEGORY_TEST, msgNumber+1);
        
        IX_DSP_CODELET_MAKE_MSG_STOP_IP(&msg, trans, msgNumber+1)
        if(xMsgSend(&msg) != XSUCC)
        {
            printf("ERROR - Channel Teardown Message sender fails.\n");
            return;
        }

        channel_down[msgNumber]=FALSE;
    }
}

/********************************
 * get resource parmeters
 ********************************/
void ixDspCodeletShowResourceParms(void)
{
    int inst;
    int numInst;
    int res;

    inst = ixDspCodeletGetNum(promptGetInst4Ports);

    if((inst<0) || (inst >IX_DSP_CODELET_MAX_CHL))
    {
       printf("Invalid Entry\n"); 
       return;
    }
    res = ixDspCodeletGetNum(promptGetRes);

    IX_CODELET_CHECK_INST_NUM(res, inst, numInst)

    if (numInst < 0 || numInst > ixDspCodeletResCfg.numChIP)
    {
       printf("Invalid Instance Number, re-enter\n");
       return;
    }

    for(; inst<=numInst; inst++)
    {
        ixDspCodeletPrtResParms(res, inst);
    }
}


/********************************
 * get channel parmeters
 ********************************/
void ixDspCodeletShowChannelParms(void)
{
    int chl;
    int numChl;
    int res;

    chl = ixDspCodeletGetNum(promptGetChl4Ports);

    IX_CODELET_CHECK_CHL_NUM(chl, numChl)

    if ( numChl < 0 || numChl > ixDspCodeletResCfg.numChTDM)
    {
       printf("Invalid Channel Number, re-enter\n");
       return;
    }

    for(; chl<=numChl; chl++)
    {
        for(res = XMPR_NET; res <= XMPR_TNDET; res++)
        {
            ixDspCodeletPrtResParms(res, chl);
        }
    }
}

/********************************
 * set a resource parmeter
 ********************************/
void ixDspCodeletSetParm(void)
{
    int id;
    int val;
    int inst;
    int numInst;
    int res;
    int temp;
    int category;
    UINT32 trans;

    XMsgSetParm_t msg;

    inst = ixDspCodeletGetNum(promptGetInst4Ports);
   if((inst<0) || (inst >IX_DSP_CODELET_MAX_CHL))
   {
      printf("Invalid Entry\n"); 
      return;
   }
    res = ixDspCodeletGetNum(promptGetRes);

    IX_CODELET_CHECK_INST_NUM(res, inst, numInst)

    if (numInst < 0 || numInst > ixDspCodeletResCfg.numChIP)
    {
       printf("Invalid Instance Number, re-enter\n");
       return;
    }

    for(temp=inst; inst<=numInst; inst++)
    {
        ixDspCodeletPrtResParms(res, inst);
    }

    id    = ixDspCodeletGetNum("Enter the parameter id - ");
    val   = ixDspCodeletGetNum("Enter the parameter value - ");


    for(inst=temp; inst<=numInst; inst++)
    {
        trans = IX_DSP_CODELET_MAKE_TRANS(category, inst);
        XMSG_MAKE_SET_PARM(&msg, trans, res, inst, id, val);

        if(xMsgSend(&msg) != XSUCC)
        {
            printf("ERROR - Message sender fails.\n");
            break;
        }
    }
}

/********************************
 * Start caller ID demo
 ********************************/
void ixDspCodeletStartCID(void)
{
    int chl;
    int numChl;
    int n;
    char numStr[IX_DSP_CODELET_STRLEN];
    CidInitFuncType cidInitFunc;

    if(ixDspCodeletTestInterface == IX_DSP_CODELET_PHN_IF_T1)
    {
       printf("ERROR - Caller ID demo not available on digital interface\n\n");
       return;
    }

    switch(ixDspCodeletResCfg.countryCode)
    {
    case COUNTRY_CODE_US:
        printf("Using US call ID specifications\n");
        ixDspCodeletCallerIdSm = ixDspCodeletCallerIdSmBc;
        cidInitFunc = ixDspCodeletCidInitUs;
        break;

 
    default:
        printf("ERROR - unsupported country code (%d)\n",
                ixDspCodeletResCfg.countryCode);
        return;
    }


    chl = ixDspCodeletGetNum(promptGetChl4Ports);

    if(chl < 0 || chl > IX_DSP_CODELET_TDM_CHL_ANALOG)
    {
        printf("ERROR - invalid channel number %d\n", chl);
        return;  
    }

    n = ixDspCodeletGetStr("Enter the number to be displayed "
                             "(Default: '0123456789') - ", numStr);

    if(!n)
    {
      strncpy(numStr, "0123456789", IX_DSP_CODELET_STRLEN);
    }

    IX_CODELET_CHECK_CHL_NUM(chl, numChl)


    for(; chl<=numChl; chl++)
    {
        cidInitFunc(chl, numStr);
    }
}


/********************************
 * Start 3-Way Call demo
 ********************************/
void ixDspCodeletStart3WCall(void)
{
    ixDspCodelet3WCallSelect(MIXER_CALL_NUM);
}


/********************************
 * Start player demo
 ********************************/
void ixDspCodeletStartPlay(void)
{
    int chl;
    int numChl;


    chl = ixDspCodeletGetNum(promptGetChl4Ports);

    if(chl < 0 || chl > IX_DSP_CODELET_MAX_CHL)
    {
        printf("ERROR - invalid channel number %d\n", chl);
        return ; 
    }

    IX_CODELET_CHECK_CHL_NUM(chl, numChl)

    for(; chl<=numChl; chl++)
    {
        ixDspCodeletPlayInit(chl);
    }
}
/***************************************
SLIC API TEST 
****************************************/

/* This has been moved to Xscale and IA specific folders */
/* These tests not required by IA as this functionality 
    already tested by drivers

*************************************/


/*******************************************************************
 * Function Name : ixDspCodeletAppProfile
 * Input         : 
 * Description   : This routine is used to start the profiling.
 ******************************************************************/
void ixDspCodeletAppProfile(void)
{
    xpr();
}/*ixDspCodeletAppProfile*/

void ixDspCodeletSetPlugInParam(void)
{
    int id;
    int val;
    int inst;
    int numInst;
    int res;
    int   algType;
    XStatus_t xDspStatus;

    inst = ixDspCodeletGetNum(promptGetInst4Ports);
    
    res = ixDspCodeletGetNum(promptGetResForCustParams);

    if((inst<0) || (inst >IX_DSP_CODELET_MAX_CHL))
    {
       printf("Invalid Entry\n"); 
       return;
    }


    IX_CODELET_CHECK_INST_NUM(res, inst, numInst)

    if(res != XMPR_NET  && res != XMPR_DEC && res != XMPR_ENC){
     printf(" \n \t Invalid Resource"); 
     return; 
    }

    if (res == XMPR_ENC  || res == XMPR_DEC)
    {
      algType = ixDspCodeletGetNum(promptGetCode);
    }
    else
    {
      algType = ixDspCodeletGetNum(promptGetEC);
    }
    
    id  = ixDspCodeletGetNum("Enter the plugin parameter id(USCI index) - ");
    val = ixDspCodeletGetNum("Enter the parameter value - ");

    printf("\n **** Writing  plugin type %d parameter ID:%d,"
                                 " Value=%d ****",algType,id,val);
    for(inst; inst<=numInst; inst++)
    {
      xDspStatus = xDspPlugInParmWrite(res,inst-1,algType,id,val);
      if(xDspStatus == XSUCC)
      {
        printf("\n Sucessfully set the channel :%d Param ID %d "
                                          " Value = %d",inst,id,val);
      }
      else
      {
        printf("\n Error setting channel :%d Param ID %d  ",inst,id);
      }
    }
    printf("\n ******** Done ********\n");
}

void ixDspCodeletGetPlugInParam(void)
{
    int val;
    int inst;
    int numInst;
    int res;
    int algType,id;
    XStatus_t xDspStatus;

    inst = ixDspCodeletGetNum(promptGetInst4Ports);
    if((inst<0) || (inst >IX_DSP_CODELET_MAX_CHL))
    {
       printf("Invalid Entry\n"); 
       return;
    }
    res = ixDspCodeletGetNum(promptGetResForCustParams);

    IX_CODELET_CHECK_INST_NUM(res, inst, numInst)

    if(res != XMPR_NET  && res != XMPR_DEC && res != XMPR_ENC){
         printf(" \n \t Invalid Resource"); 
        return; 
    }

    if (res == XMPR_ENC  || res == XMPR_DEC)
    {
      algType = ixDspCodeletGetNum(promptGetCode);
    }
    else
    {
      algType = ixDspCodeletGetNum(promptGetEC);
    }
    
    id = ixDspCodeletGetNum("Enter the plugin parameter id(USCI index) - ");
    
    printf("\n ****Reading plugin type %d parameters****",algType);
    for(inst; inst<=numInst; inst++)
    {
      val = 0;
      xDspStatus = xDspPlugInParmRead(res,inst-1,algType,id,&val);
      if(xDspStatus == XSUCC)
      {
        printf("\n Sucessfully read for  channel :%d Param ID %d "
                                          " Value = %d",inst,id,val);
      }
      else
      {
        printf("\n Error reading channel :%d Param ID %d  ",inst,id);
      }
    }
    printf("\n ******** Done ********\n");
}

void ixDspCodeletDisableEC(void)
{
    UINT32 trans;
    int inst=1;
    XMsgSetParm_t msg;

    for(; inst<=IX_DSP_CODELET_MAX_CHL; inst++)
    {
        trans = IX_DSP_CODELET_MAKE_TRANS(IX_DSP_CODELET_CATEGORY_TEST, inst);
        XMSG_MAKE_SET_PARM(&msg, trans, NET_RESOURCE_SERIAL, inst, 
                                NET_RESOURCE_EC_ID, NET_RESOURCE_EC_DISABLED);
        if(xMsgSend(&msg) != XSUCC)
        {
            printf("ERROR - Message sender fails in ixDspCodeletDisableEC\n");
            break;
        }
    }
    return ;
}

void ixDspCodeletAllignCompMode(void)
{
    UINT32 trans;
    int inst=1;
    XMsgSetParm_t msg;

    for(; inst<=IX_DSP_CODELET_MAX_CHL; inst++)
    {
        trans = IX_DSP_CODELET_MAKE_TRANS(IX_DSP_CODELET_CATEGORY_TEST, inst);
        XMSG_MAKE_SET_PARM(&msg, trans, NET_RESOURCE_SERIAL, inst, 
                                 NET_RESOURCE_LAW_ID, companding_mode);
        if(xMsgSend(&msg) != XSUCC)
        {
            printf("ERROR - Message sender fails"
                   "in ixDspCodeletAllignCompMode\n");
            printf("Companding Mode in NET component"
                   "will be Default U-Law...\n");
            break;
        }
    }
    return ;
}

