/******************************************************************************
*       @file   IxDspCodeletPeripheralsUtil.c

* Contents:  This file has IA specific Slic & Framer Utils API
 
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#include "IxDspCodelet.h"
#include "IxFramerDriverUsrAPIs.h"

/******************************************
        slic callback function.
        call DSP flash hook detector
        to report the hook event
*******************************************/
#define HOOK_EVENT_SHIFT 8
static int hookEventCategory;
void ixDspCodeletSlicHookCB(IxScHookState state, IxScChipNum potsLine)
{   
   potsLine++;
   xFlashHookDetect(potsLine, (XHookState_t) state, 
                    potsLine|(hookEventCategory<<HOOK_EVENT_SHIFT));
   
}

/******************************************
        Framer callback function.
        call DSP flash hook detector
        to report the hook event
*******************************************/

void ixDspCodeletFramerNotifyHookCB(int state, int chanNum)
{

   xFlashHookDetect(chanNum,(XHookState_t) state,
                    chanNum|(hookEventCategory<<HOOK_EVENT_SHIFT));
}

/*******************************************
        Get current SLIC/Framer hook state
********************************************/
int ixDspCodeletGetHookState(int chl)
{
   int hook_state=IX_SC_ON_HOOK;
   
   switch(slic_framer_choice)
   {
     case IX_DSP_SLIC_ONLY:
     {
       hook_state=ixFXSHookStatus(chl);
       if(hook_state==IX_DSP_DRV_FAIL)
       {
         printf("GetHookState Failed for chl %d\n",chl);
         /*Note hook_state is returned from this function*/
       }      
       break;
     }
     case IX_DSP_FRAMER_ONLY:
     {
       hook_state=ixFramerHookStatus(chl); 
       break;
     }
     case IX_DSP_SLIC_AND_FRAMER:
     {
       
       if(chl<=(NUM_SLIC_SLOTS*NUM_FXS_CHIPS))
       {
         hook_state=ixFXSHookStatus(chl);
         if(hook_state==IX_DSP_DRV_FAIL)
         {
           printf("GetHookState Failed for chl %d\n",chl);
         }
         
       }
       else
       {
         hook_state=ixFramerHookStatus(chl); 
       }
       break;
     }
     default:
      printf("Error: ixDspCodeletGetHookState SLIC/Framer choice\n");
   }
   
   return hook_state;
}

/******************************************
        invert the polarity
*******************************************/
int ixDspCodeletPolarityInv(int chl)
{
/* Note this function should only be called on SLIC channels */
/* This should never be called on channels associated with Framer */
   int readData=0;
   int regVal=0;
   int slicLineId=0;
   int rc=0;
   
   if((0<chl)&&(chl<=NUM_SLIC_SLOTS*NUM_FXS_CHIPS)
      && (slic_framer_choice!=IX_DSP_FRAMER_ONLY))
   {
   /* Need to convert ADS channel number to SLIC line ID */
      slicLineId=chl+((chl-1)/NUM_FXS_CHIPS);
   
      rc=ixFXSODirectRegRead(slicLineId,IX_LOOP_CURRENT_SENSE_REG,readData);
      if(rc==IX_DSP_DRV_FAIL){
         printf("Error with ixFXSODirectRegRead in Polarity"
                " Invert function\n");
         return IX_FAIL;   
      }
   
      regVal = readData ^ IX_POL_INVERT_BIT_MASK;
   
      rc=ixFXSODirectRegWrite(slicLineId,IX_LINEFEED_CTRL_REG,regVal);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("Error with ixFXSODirectRegWrite in Polarity"
                " Invert function\n");
         return IX_FAIL;
      }
      return regVal;
   }
   else{
      printf("ixDspCodeletPolarityInv can only be performed"
             " on SLIC channels\n");
      return IX_FAIL;
   }
}

/******************************************
        start short ring
*******************************************/
void ixDspCodeletShortRing(int chl)
{
/* Note this function should only be called on SLIC channels */
/* This should never be called on channels associated with Framer */

   int slicLineId=0;
   int rc=0;
   
   if((0<chl)&&(chl<=NUM_SLIC_SLOTS*NUM_FXS_CHIPS)
      && (slic_framer_choice!=IX_DSP_FRAMER_ONLY))
   {
      /* Need to convert ADS channel number to SLIC line ID */
      slicLineId=chl+((chl-1)/NUM_FXS_CHIPS);
      
      /* Set the ring active timer to 0.5 seconds */     
      rc=ixFXSODirectRegWrite(slicLineId,IX_RINGING_OSCIL_ACTIVE_TIMER_LB_REG,
                              IX_SHORT_RING_ON_TIME_LB);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("Error with ixFXSODirectRegWrite to lower "
                "active timer in ShortRing function\n");
         
      }
      rc=ixFXSODirectRegWrite(slicLineId,IX_RINGING_OSCIL_ACTIVE_TIMER_HB_REG,
                              IX_SHORT_RING_ON_TIME_HB);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("Error with ixFXSODirectRegWrite to higher "
                "active timer in ShortRing function\n");
         
      }
      /* Set the ring inactive timer to 0.5 seconds */
      rc=ixFXSODirectRegWrite(slicLineId,
                              IX_RINGING_OSCIL_INACTIVE_TIMER_LB_REG,
                              IX_SHORT_RING_OFF_TIME_LB);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("Error with ixFXSODirectRegWrite to lower "
                "inactive timer in ShortRing function\n");
         
      }
      rc=ixFXSODirectRegWrite(slicLineId,
                              IX_RINGING_OSCIL_INACTIVE_TIMER_HB_REG,
                              IX_SHORT_RING_OFF_TIME_HB);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("Error with ixFXSODirectRegWrite to higher "
                "inactive timer in ShortRing function\n");
         
      }
      /* Enable the ringing on/off times */
      rc=ixFXSODirectRegWrite(slicLineId,
               IX_RINGING_OSCIL_CTRL_REG,IX_FXS_RINGING_OSCIL_ENABLE);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("Error with ixFXSODirectRegWrite to oscil_ctrl_reg"
                " in ShortRing function\n");
         
      }
      
      /* Set the linefeed control register to ringing */
      rc=ixFXSODirectRegWrite(slicLineId,
                              IX_LINEFEED_CTRL_REG,IX_LINE_FEED_RING);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("Error with ixFXSODirectRegWrite to "
                "linefeed_ctrl_reg in ShortRing function\n");
      }   
      
   }
   else{
       printf("ixDspCodeletShortRing can only be performed"
             " on SLIC channels\n");
      
   }
}


/******************************************
        start normal ring
*******************************************/
void ixDspCodeletNormalRing(int chl)
{
   int rc=0;
   
   switch(slic_framer_choice)
   {
      case IX_DSP_SLIC_ONLY:
      {
         rc=ixFXSStartRinging(chl);
         if(rc==IX_DSP_DRV_FAIL)
         {
            printf("ixFXSStartRinging failed for chl %d",chl);
         }      
         break;
      }

      case IX_DSP_FRAMER_ONLY:
      {
         /* For demo purposes in Framer case - changing the line state
          * instead of 'ringing' */
         rc = ixFramerOffHook(chl);

         if (rc != IX_DSP_DRV_SUCCESS)
         {
            printf("Error: ixFramerOffHook call failed. rc=%d\n",rc);
            return;
         }
         break;
      }

      case IX_DSP_SLIC_AND_FRAMER:
      {
         if(chl<=(NUM_SLIC_SLOTS*NUM_FXS_CHIPS))
         {
            rc=ixFXSStartRinging(chl);
            if(rc==IX_DSP_DRV_FAIL)
            {
               printf("ixFXSStartRinging failed for chl %d",chl);
            }
         }
         else
         {
            rc = ixFramerOffHook(chl);
            if (rc != IX_DSP_DRV_SUCCESS)
            {
               printf("Error: ixFramerOffHook call failed. rc=%d\n",rc);
            }
         }
         break;
      }
 
      default:
      {
         printf("NormalRing error in slic/framer choice\n");
      }
   }
   

}

/******************************************
        stop ring
*******************************************/
void ixDspCodeletStopRing(int chl)
{
   int rc=0;

   switch(slic_framer_choice){
   case IX_DSP_SLIC_ONLY:{
      rc=ixFXSStopRinging(chl);      
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("ixDspCodeletStopRing error on chl %d\n",chl);
      }
      break;
   }
   case IX_DSP_FRAMER_ONLY:{
      /* NOTE: There is no practical purpose for a Framer
      * version of this function at present. */
      printf("ixDspCodeletStopRing called for Framer Only case.\n");
      break;
   }
   case IX_DSP_SLIC_AND_FRAMER:{
      if(chl<=(NUM_SLIC_SLOTS*NUM_FXS_CHIPS)){
         rc=ixFXSStopRinging(chl);
         if(rc==IX_DSP_DRV_FAIL)
         {
            printf("ixDspCodeletStopRing error on chl %d\n",chl);
         }
      }else{
      /* NOTE: There is no practical purpose for a Framer
       * version of this function at present.*/
      
      printf("ixDspCodeletStopRing called for "
              "T1/E1 Framer Channel.\n");
      }
      break;
   }
   default:
      printf("StopRing error in slic/framer choice\n");
   }
}

/******************************************
         set hook event category
*******************************************/
void ixDspCodeletSetHookEventCategory(int value)
{
       hookEventCategory=value;
}

/******************************************
         OnHook Tranmission for Bc
*******************************************/
/*This funciton is required for on hook transmission in 
 * Bellcore's caller id algorithm.*/
/* It sets the linefeed control register to "forward on hook
 * transmission" state where V_{tip}>V_{ring} and audio signal
 * paths are enabled.*/
void ixDspCodeletOnHookTransmission(int chl)
{
/* Note this function should only be called on SLIC channels */
/* This should never be called on channels associated with Framer */

   int slicLineId=0;
   int rc=0;
   
   if((0<chl)&&(chl<=NUM_SLIC_SLOTS*NUM_FXS_CHIPS)
      && (slic_framer_choice!=IX_DSP_FRAMER_ONLY))
   {
   /* Need to convert ADS channel number to SLIC line ID */
      slicLineId=chl+((chl-1)/NUM_FXS_CHIPS);
   
      rc=ixFXSODirectRegWrite(slicLineId,IX_LINEFEED_CTRL_REG,
                                   IX_LINE_FEED_ON_HOOK_TRANS);
      if(rc==IX_DSP_DRV_FAIL)
      {
         printf("OnHookTransmission regwrite error.\n");
      }

   }else{
      printf("OnHookTransmission can only be called on slic channels.\n");
   }
}

