/******************************************************************************
*       @file	IxDspCodeletSocket.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

/*
 * Put the system defined include files required.
 */
#ifndef IXDSPCODELETSOCKET_H
#define IXDSPCODELETSOCKET_H
/*
#include <vxWorks.h>
*/
#include <sys/types.h>

#include "dspcis.h"

#include "FWTypes.h"
#include "IxPlatforms.h"

#ifdef SRTP
#include "srtp.h"
#include "rtp.h"
#endif

#undef IX_DSP_CODELET_SOCKET_DEBUG

#ifdef IX_DSP_CODELET_SOCKET_DEBUG
    #define IX_DSP_CODELET_SOCKET_DEBUG_PRINT(s) printf("%s",s)
#else
    #define IX_DSP_CODELET_SOCKET_DEBUG_PRINT(s)
#endif

#define IX_DSP_CODELET_IP_CHANNELS IX_DSP_CODELET_MAX_CHL
#define IX_DSP_CODELET_SOCKET_NUM_VOICE_CHANNELS IX_DSP_CODELET_MAX_CHL

#define IX_DSP_CODELET_SOCKET_MAX_NUM_SOCKETS IX_DSP_CODELET_SOCKET_NUM_VOICE_CHANNELS

#define IX_DSP_CODELET_SOCKET_MAX_READ_FROM_SOCKET_SIZE  1500

#define IX_DSP_CODELET_SOCKET_INVALID_DESCRIPTER ERROR /* -1 */

/* 
 * This enum defines the various socket configuration 
 * types we have the socket config menu
 */
typedef enum{
  DEFAULT_CONFIG_0 = 7,
  MAX_DEFAULT_CONFIG,
  USER_DEFINED_CONFIG
}IxDspSocketConfigType;

/*
 * The lowest UDP port that is permitted for the DSP codelet socket routines to
 * send and receive data on. This was an arbitrary selection.
 */
#define IX_DSP_CODELET_SOCKET_UDP_PORT_BASE 2000

/*
 *  Define the offset used for signalling channels.
 */
#define IX_DSP_CODELET_SIG_CHANNEL_OFFSET 100


#define IX_DEF_RFC2833_RX_EVENT_PAYLOAD 101
#define IX_DEF_RFC2833_RX_TONE_PAYLOAD 102
#define IX_DEF_RFC2833_RX_RED_PAYLOAD 105
#define IX_DEF_RFC2833_TX_EVENT_PAYLOAD 101
#define IX_DEF_RFC2833_TX_TONE_PAYLOAD 102
#define IX_DEF_RFC2833_TX_RED_PAYLOAD 105


#ifdef SRTP

static UINT8 Key[30] 
        = {0x01,0x02,0x03,0x04,
           0x05,0x06,0x07,0x08,
           0x09,0x0A,0x0B,0x0C,
           0x0D,0x0E,0x0F,0x10,
           0x11,0x12,0x13,0x14,
           0x15,0x16,0x17,0x18,
           0x19,0x1A,0x1B,0x1C,
           0x1D,0x1E};

srtp_policy_t policy;

#endif

/* Structure for Socket Statistics */
typedef struct _ixDspSocketStats
{
    unsigned int numRxPkts;
    unsigned int totalRxBytes;
    unsigned int invalidRxDataLen;
    unsigned int rxFailedCount;
    unsigned int numSuccessTxPkts;
    unsigned int totalTxBytes;
    unsigned int allTxBytesNotTransmittedCount;
    unsigned int txFailedCount;
    unsigned int xPacketCalls;
    unsigned int xPacketReturns;
    unsigned int recvfromCalls;
    unsigned int recvfromReturns;
    unsigned int remoteEventsTx;
    unsigned int remoteEventsRx;
    unsigned int droppedPackets;
} IxDspCodeletSocketStats;

/* Structure for Socket Channel Configuration Information */
typedef struct _ixDspCodeletSocketChanConfigInfo
{
    BOOL isConfigured;
    BOOL isActivated;
    int rxSocketDescripter;
    int txSocketDescripter;
    unsigned int voiceChannel;
    unsigned int localIpAddr;
    char  *remoteIpAddr;
    UINT16 localUdpPort;
    UINT16 remoteUdpPort;
    unsigned long threadID;
    void* rxSockOpts;
    void* txSockOpts;

} IxDspCodeletSocketChanConfigInfo;

#define RTP_MAX_BUF_LEN 16384
#define IX_DSP_CODELET_RTPHDR_LENGTH 12

#define IX_DSP_DEF_RFC2833_RX_EVENT_PAYLOAD 101
#define IX_DSP_DEF_RFC2833_RX_TONE_PAYLOAD 102
#define IX_DSP_DEF_RFC2833_RX_RED_PAYLOAD 105
#define IX_DSP_DEF_RFC2833_TX_EVENT_PAYLOAD 101
#define IX_DSP_DEF_RFC2833_TX_TONE_PAYLOAD 102
#define IX_DSP_DEF_RFC2833_TX_RED_PAYLOAD 105

#define IX_DSP_CODELET_ACTIVE_CHANNEL_RTP 1
#define IX_DSP_CODELET_ACTIVE_CHANNEL_T38 2

/* Structure for RTP Header */
typedef struct
{
    UINT8 rtpVersion;
    UINT8 rtpPayloadType;
    UINT16 rtpSequence;
    UINT32 rtpTimestamp;
    UINT32 rtpSyncSource;
} IxDspCodeletRtpHdr;

/* Structure for Codelet Session */
typedef struct
{
    UINT8 state;
    UINT8 ethPort;
    UINT8 rfc2833RxEvent;
    UINT8 rfc2833RxTone;
    UINT8 rfc2833RxRed;
    UINT8 rfc2833TxEvent;
    UINT8 rfc2833TxTone;
    UINT8 rfc2833TxRed;
    IxDspCodeletRtpHdr rtpHeader;
} IxDspCodeletSession;

/* Structure for RTP message */
typedef struct {
  IxDspCodeletRtpHdr header;
  char body[RTP_MAX_BUF_LEN];
} IxDspCodeletRtpMsg;

/*
 * Function definitions follow...
 */

/*******************************************************************************
 *
 * This routine can configure how the source and destination addresses map to
 * voice channel numbers. This will determine the addressing info that the
 * socket will be interested in listening to and creating.
 *
 ******************************************************************************/
IX_STATUS ixDspCodeletSocketChanConfig(unsigned int voiceChannel,
				       UINT16 localUdpPort);

/*******************************************************************************
 *
 * This routine can be used to disable a channel
 *
 ******************************************************************************/
void ixDspCodeletSocketChanDisable(int channel);

/*******************************************************************************
 *
 * This routine can be used to display the configured channel info
 *
 ******************************************************************************/
void ixDspCodeletSocketChanConfigShow(void);

/*******************************************************************************
 *
 * This routine is used to clear the statistical info that has been captured
 * for the specified channel
 *
 ******************************************************************************/
IX_STATUS ixDspCodeletSocketStatsClear(int channel);


/*******************************************************************************
 *
 * This routine is used to clear all the statistical info that has been captured
 * for all of the configured channels
 *
 ******************************************************************************/
void ixDspCodeletSocketAllStatsClear(void);


/*******************************************************************************
 *
 * Open a socket and bind an address to it
 *
 ******************************************************************************/
IX_STATUS ixDspCodeletSocketCreate(void);

/*******************************************************************************
 *
 * This function needs to read data in from the sockets and write that data
 * to a location accessible by the DSP. This function is running in its own
 * task. The priority of which is slightly higher than the tNetTask.
 *
 ******************************************************************************/
int ixDspCodeletSocketReceive0(void);
int ixDspCodeletSocketReceive1(void);

/*******************************************************************************
 *
 * This routine is used to transmit data from the DSP to the network protocols
 *
 ******************************************************************************/
//XStatus_t ixDspCodeletSocketSend(UINT16 channel , void *buffer);

/*******************************************************************************
 *
 * Initialise the socket processing routines
 *
 ******************************************************************************/
IX_STATUS ixDspCodeletSocketInit(void);

/*******************************************************************************
 *
 * This routine has been coded as a simple and quick means of setting up a 
 * configuration from the windsh for testing purposes. It has little merit in
 * the context of having an operational DSP codelet socket layer.
 *
 ******************************************************************************/
IX_STATUS ixDspCodeletSocketPreDefinedChanConfig(IxDspSocketConfigType configType);

/* Default RTP settings */

void ixDspCodeletRtpDefaultSet(void);

#ifdef SRTP
/*****************************************************************************
 *
 * This routine is used to initialize the SRTP session for send and receive 
 * and has to be called before doind send/receive with srtp library.
 *
 *****************************************************************************/

IX_STATUS ixDspCodeletSRTP_SndRcv_Session_Init(void);

/*****************************************************************************
 *
 * This routine is used to delete the SRTP session for send and receive 
 * and has to be called after all the sockets are destroyed.
 *
 *****************************************************************************/

IX_STATUS ixDspCodeletSRTP_SndRcv_Session_Free(void);

IX_STATUS ixDspCodeletRTPSendInit(rtp_sender_t *sender, int TxSock,
             int channel, UINT32 ssrc, struct sockaddr_in *sendtoaddr,
             srtp_policy_t *rpolicy);

IX_STATUS ixDspCodeletRTPRecvInit(rtp_receiver_t *receiver, int RxSock,
             int channel, UINT32 ssrc, struct sockaddr_in *recvaddr,
             srtp_policy_t *policy);

#endif

#endif /* IXDSPCODELETSOCKET_H */
