/******************************************************************************
*       @file	IxDspCodeletUsrMsgDef.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef __IX_CODELET_USRMSGDEF__
#define __IX_CODELET_USRMSGDEF__

#include <dspcis.h>

/*
 * this file provides the examples of the user-defined
 * higher level message interface based on the termination
 * concept. The messages will be sent to Message Agent
 * for decoding and execution. The source code of the
 * message decoder/encoder functions for the new messages
 * are provided. Users can modify and extend this interface.
 */

#define IX_DSP_CODELET_MAX_ERR_REPLY        16  /* max # of error msg from DSP */
#define IX_DSP_CODELET_MAX_STOP_CMPLT       4  /* max # of stopCmplt msg frm DSP */
#define IX_DSP_CODELET_MAX_PARMS \
    ((XMSG_MAX_SIZE - sizeof(XMsgHdr_t) - 2) / sizeof(IxDspCodeletParm))
#define IX_DSP_CODELET_MSG_TYPE_BEGIN       XMSG_USRMSG_TYPE_BEGIN

#define IX_DSP_CODELET_MSG_MODE_VOICE       0
#define IX_DSP_CODELET_MSG_MODE_T38         1

/* error code returned by message decoder/encoder functions */
#define IX_DSP_CODELET_MSG_ERR_UNDERRUN      (-1)  /* no more message to decode */
#define IX_DSP_CODELET_MSG_ERR_MSG_TYPE      (-2)  /* unknown message type */
#define IX_DSP_CODELET_MSG_ERR_OVERFLOW      (-3)  /* too many DSP replies */
#define IX_DSP_CODELET_MSG_ERR_INVALID_PARM  (-4)  /* invalid parameter */
#define IX_DSP_CODELET_MSG_ERR_TOOMANY_PARMs (-5)  /* too many parameters */

/* types of user-defined messages */
typedef enum{
    /*------ messages send to Message Agent -------*/
    IX_DSP_CODELET_MSG_LINK = IX_DSP_CODELET_MSG_TYPE_BEGIN,
    IX_DSP_CODELET_MSG_LINK_BREAK,
    IX_DSP_CODELET_MSG_LINK_SWITCH,
    IX_DSP_CODELET_MSG_START_IP,
    IX_DSP_CODELET_MSG_STOP_IP,
    IX_DSP_CODELET_MSG_SETUP_CALL,
    IX_DSP_CODELET_MSG_SET_CALL_PARMS,
    IX_DSP_CODELET_MSG_SETUP_CALLWPARMS,
    IX_DSP_CODELET_MSG_SWITCH_CALL,
    IX_DSP_CODELET_MSG_CREATE_3WCALL,
    IX_DSP_CODELET_MSG_EXIT_3WCALL,
    IX_DSP_CODELET_MSG_TEARDOWN_3WCALL,
    IX_DSP_CODELET_MSG_BACKTO_2WCALL,
    IX_DSP_CODELET_MSG_SET_CLEAR_CHAN,
    IX_DSP_CODELET_MSG_T38_SWITCH,
    IX_DSP_CODELET_MSG_SET_PARMS,
    IX_DSP_CODELET_MSG_END_OF_OUTMSG,
    /*------messages received from Message Agent------*/
    IX_DSP_CODELET_MSG_ACK,
    IX_DSP_CODELET_MSG_LINK_ACK,
    IX_DSP_CODELET_MSG_SETUP_ACK,
    IX_DSP_CODELET_MSG_3W_ACK,
    IX_DSP_CODELET_MSG_T38_ACK,
    IX_DSP_CODELET_MSG_STOP_ACK,
    IX_DSP_CODELET_MSG_END_OF_LIST
} IxDspCodeletMsgType;

/* types of terminations, see explanation below */
typedef enum{
    IX_DSP_CODELET_TERM_NULL = 0,   /* null termination, to link to null
                                       means to disconnect the L-Port */
    IX_DSP_CODELET_TERM_TDM,        /* TDM termination contains one DSP
                                       dspResource - Network Endpoint which
                                       has a T-Port and a L-Port */
    IX_DSP_CODELET_TERM_IP,         /* IP termination contains DEC,ENC,
                                       TG and TD resources. It has one
                                       T-Port shared by DEC and TG and
                                       2 L-Ports for ENC and TD. But in
                                       This API, the 2 L-Ports always
                                       listen to the same talker */
    IX_DSP_CODELET_TERM_MIXER_PORT, /* Mixer termination has multiple
                                       T-Ports and L-Ports */
    IX_DSP_CODELET_TERM_EOL         /* End of List */
} IxDspCodeletTermType;

/* termination ID, specified by type and channel */
#ifdef	__ghs__
#pragma pack(1)
#endif
typedef struct{
    UINT8 type;
    UINT8 channel;
#ifdef __GNUC__
} __attribute__ ((packed)) IxDspCodeletTerm;
#endif
#ifdef __ghs__
} IxDspCodeletTerm;
#pragma pack()
#endif

/* usr msg def, make full duplex link between 2 terms */
typedef struct{
    XMsgHdr_t           header;
    IxDspCodeletTerm    term1;
    IxDspCodeletTerm    term2;
} IxDspCodeletMsgLink;

/* macro to make the Link message header */
#define IX_DSP_CODELET_MAKE_MSGHDR_LINK(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_LINK, \
            sizeof(IxDspCodeletMsgLink) \
        )\
    }

/* usr msg def, link the listeners of the terms to null streams */
typedef IxDspCodeletMsgLink IxDspCodeletMsgLinkBreak;

/* macro to make the header of LinkBreak message */
#define IX_DSP_CODELET_MAKE_MSGHDR_LINK_BREAK(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_LINK_BREAK, \
            sizeof(IxDspCodeletMsgLinkBreak) \
        )\
    }

/* usr msg def, break a link and
 * link to another one */
typedef struct{
    XMsgHdr_t           header;
    IxDspCodeletTerm    term;
    IxDspCodeletTerm    switchFrom;
    IxDspCodeletTerm    switchTo;
} IxDspCodeletMsgLinkSwitch;

/* macro to make the header of LinkSwitch mesage */
#define IX_DSP_CODELET_MAKE_MSGHDR_LINK_SWITCH(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_LINK_SWITCH, \
            sizeof(IxDspCodeletMsgLinkSwitch) \
        )\
    }

/* usr msg def, start IP termination (Dec, Enc, TD) */
typedef struct{
    XMsgHdr_t   header;
    UINT8       channel;
} IxDspCodeletMsgStartIP;

/* macro to make StartIP message */
#define IX_DSP_CODELET_MAKE_MSG_START_IP(pMsg, trans, chanIP) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_START_IP, \
            sizeof(IxDspCodeletMsgStartIP) \
        )\
        ((IxDspCodeletMsgStartIP *)(pMsg))->channel = (chanIP);\
    }

/* usr msg def, stop IP termination (Dec, Enc, TD) */
typedef IxDspCodeletMsgStartIP IxDspCodeletMsgStopIP;

/* macro to make StopIP message */
#define IX_DSP_CODELET_MAKE_MSG_STOP_IP(pMsg, trans, chanIP) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_STOP_IP, \
            sizeof(IxDspCodeletMsgStopIP) \
        )\
        ((IxDspCodeletMsgStopIP *)(pMsg))->channel = (chanIP);\
    }

/* usr msg def, link TDM term to IP term and start IP term */
typedef struct{
    XMsgHdr_t   header;
    UINT8       channelIP;
    UINT8       channelTDM;
} IxDspCodeletMsgSetupCall;

/* macro to make SetupCall message */
#define IX_DSP_CODELET_MAKE_MSG_SETUP_CALL(pMsg, trans, chanIP, chanTDM) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_SETUP_CALL, \
            sizeof(IxDspCodeletMsgSetupCall) \
        )\
        ((IxDspCodeletMsgSetupCall *)(pMsg))->channelIP = (chanIP);\
        ((IxDspCodeletMsgSetupCall *)(pMsg))->channelTDM = (chanTDM);\
    }

/* parameters that may be affected by call stack negotiate */
typedef struct{
    UINT16  decAutoSwitch;
    UINT8   decType;
    UINT8   encType;
    UINT8   frmsPerPkt;
    UINT8   vad;
    UINT8   rfc2833;
    UINT8   rfc2833pyldType;
    UINT8   toneClamp;
    UINT8   toneReport;
} IxDspCodeletCallParms;

/* usr msg def, set call parameters */
typedef struct{
    XMsgHdr_t               header;
    IxDspCodeletCallParms   parms;
    UINT8                   channelIP;
}IxDspCodeletSetCallParms;

/* macro to make header of setCallParms message */
#define IX_DSP_CODELET_MAKE_MSGHDR_SET_CALL_PARMS(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_SET_CALL_PARMS, \
            sizeof(IxDspCodeletSetCallParms) \
        )\
    }

/* usr msg def, setup call with parameters */
typedef struct{
    XMsgHdr_t               header;
    IxDspCodeletCallParms   parms;
    UINT8                   channelIP;
    UINT8                   channelTDM;
} IxDspCodeletMsgSetupCallwParms;

/* macro to make the header of setupCallwParms message */
#define IX_DSP_CODELET_MAKE_MSGHDR_SETUP_CALLWPARMS(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_SETUP_CALLWPARMS, \
            sizeof(IxDspCodeletMsgSetupCallwParms) \
        )\
    }

/* usr msg def, put one IP term on-hold and setup new call
 * with another IP term */
typedef struct{
    XMsgHdr_t   header;
    UINT8       channelTDM;
    UINT8       ipChanOnHold;
    UINT8       ipChanNewCall;
} IxDspCodeletMsgSwitchCall;

/* macro to make switchCall message */
#define IX_DSP_CODELET_MAKE_MSG_SWITCH_CALL(pMsg, trans, chTDM, chHld, chNew) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_SWITCH_CALL, \
            sizeof(IxDspCodeletMsgSwitchCall) \
        )\
        ((IxDspCodeletMsgSwitchCall *)(pMsg))->channelTDM = (chTDM);\
        ((IxDspCodeletMsgSwitchCall *)(pMsg))->ipChanOnHold = (chHld);\
        ((IxDspCodeletMsgSwitchCall *)(pMsg))->ipChanNewCall = (chNew);\
    }

/* usr msg def, link 3 terms to mixer */
typedef struct{
    XMsgHdr_t           header;
    IxDspCodeletTerm    parties[3];
} IxDspCodeletMsgCreate3wCall;

/* macro to make the header of create3wCall message */
#define IX_DSP_CODELET_MAKE_MSGHDR_CREATE_3WCALL(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_CREATE_3WCALL, \
            sizeof(IxDspCodeletMsgCreate3wCall) \
        )\
    }

/* usr msg def, unlink 3 terms from mixer */
typedef IxDspCodeletMsgCreate3wCall IxDspCodeletMsgExit3wCall;

/* macro to make the header of create3wCall message */
#define IX_DSP_CODELET_MAKE_MSGHDR_EXIT_3WCALL(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_EXIT_3WCALL, \
            sizeof(IxDspCodeletMsgExit3wCall) \
        )\
    }

/* usr msg def, unlink 3 terms from mixer and stop IP terms */
typedef IxDspCodeletMsgCreate3wCall IxDspCodeletMsgTeardown3wCall;

/* macro to make the header of teardwon3wCall message */
#define IX_DSP_CODELET_MAKE_MSGHDR_TEARDOWN_3WCALL(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_TEARDOWN_3WCALL, \
            sizeof(IxDspCodeletMsgTeardown3wCall) \
        )\
    }

/* usr msg def, link 3 terms to mixer */
typedef struct{
    XMsgHdr_t           header;
    IxDspCodeletTerm    party1;
    IxDspCodeletTerm    party2;
    IxDspCodeletTerm    partyToDrop;

} IxDspCodeletMsgBackto2wCall;

/* macro to make the header of backto2wCall message */
#define IX_DSP_CODELET_MAKE_MSGHDR_BACKTO_2WCALL(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_BACKTO_2WCALL, \
            sizeof(IxDspCodeletMsgBackto2wCall) \
        )\
    }

/* usr msg def, change the channel parameters
 * to make a G711 clear channel for fax bypass */
typedef struct{
    XMsgHdr_t   header;
    UINT8       channelIP;
    UINT8       channelTDM;
    UINT8       codeType;
} IxDspCodeletMsgSetClearChan;

/* macro to make the message setClearChan */
#define IX_DSP_CODELET_MAKE_MSG_SET_CLEAR_CHAN(pMsg, trans, chanIP, ChanTDM, code) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_SET_CLEAR_CHAN, \
            sizeof(IxDspCodeletMsgSetClearChan) \
        )\
        ((IxDspCodeletMsgSetClearChan *)(pMsg))->channelIP = chanIP; \
        ((IxDspCodeletMsgSetClearChan *)(pMsg))->channelTDM = ChanTDM; \
        ((IxDspCodeletMsgSetClearChan *)(pMsg))->codeType = code; \
    }


/* usr msg def, switch between T38 and voice */
typedef struct{
    XMsgHdr_t       header;
    UINT8           channelIP;
    UINT8           channelTDM;
    UINT8           mode;        /* mode to switch, fax or voice */
	UINT8			tone;		 /* Tone type (if any) that triggered switch */
} IxDspCodeletMsgT38Switch;


/* macro to make the header of T38switch message */
#define IX_DSP_CODELET_MAKE_MSG_T38_SWITCH(pMsg, trans, chanIP, ChanTDM, md, toneid) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_T38_SWITCH, \
            sizeof(IxDspCodeletMsgT38Switch) \
        )\
        ((IxDspCodeletMsgT38Switch *)(pMsg))->channelIP = chanIP; \
        ((IxDspCodeletMsgT38Switch *)(pMsg))->channelTDM = ChanTDM; \
        ((IxDspCodeletMsgT38Switch *)pMsg)->mode = md;\
        ((IxDspCodeletMsgT38Switch *)pMsg)->tone = toneid;\
    }

/* DSP parameter */
#ifdef	__ghs__
#pragma pack(1)
#endif
typedef struct{
    UINT16  parmID;
    INT16   value;
    UINT8   dspResource;
    UINT8   dspResInstance;
#ifdef __GNUC__
} __attribute__ ((packed)) IxDspCodeletParm;
#endif
#ifdef __ghs__
} IxDspCodeletParm;
#pragma pack()
#endif

/* usr msg def, set parameters to DSP resources */
typedef struct{
    XMsgHdr_t   header;
    UINT16 numParms;
    IxDspCodeletParm parms[IX_DSP_CODELET_MAX_PARMS];
} IxDspCodeletMsgSetParms;


/* macro to make the header of backto2wCall message */
#define IX_DSP_CODELET_MAKE_MSGHDR_SET_PARMS(pMsg, trans) \
    {\
        XMSG_MA_MAKE_HEADER \
        (   pMsg, \
            trans, \
            IX_DSP_CODELET_MSG_SET_PARMS, \
            sizeof(IxDspCodeletMsgSetParms) \
        )\
    }


/* error information from DSP resources */
typedef struct{
    UINT32  errData;
    UINT16  errCode;
    UINT8   dspResource;
    UINT8   dspResInstance;
} IxDspCodeletError;

/* stop complete information from DSP */
typedef struct{
    UINT32  totalFrames;
    UINT8   dspResource;
    UINT8   dspResInstance;
} IxDspCodeletStopCmplt;

/* general reply message from Message Agent
 * composed by the message encoder */
typedef struct{
    XMsgHdr_t           header;
    INT16               numDspReplies;
    INT16               numErrors;
    IxDspCodeletError   error[IX_DSP_CODELET_MAX_ERR_REPLY];
} IxDspCodeletMsgAck,
  IxDspCodeletMsgLinkAck,
  IxDspCodeletMsgSetupAck,
  IxDspCodeletMsg3WAck,
  IxDspCodeletMsgT38Ack;

/* stop complete reply message from Message Agent
 * composed by the message encoder */
typedef struct{
    XMsgHdr_t             header;
    INT16                 numDspReplies;
    INT16                 numErrors;
    IxDspCodeletError     error[IX_DSP_CODELET_MAX_ERR_REPLY];
    INT16                 numStopAck;
    IxDspCodeletStopCmplt stopAck[IX_DSP_CODELET_MAX_STOP_CMPLT];
} IxDspCodeletMsgStopAck;


#endif
