/******************************************************************************
*       @file  IxDspSlicHssDriver.h
* Contents:  This file contains info for IA specific codelet files
*
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
*
**************************************************************************/
#ifndef __IXDSPSLICHSSDRIVER_H__
#define __IXDSPSLICHSSDRIVER_H__

#include "FWTypes.h"

#define THREAD_DISABLE (0)
#define THREAD_ENABLE  (1)

/* Time for thread to sleep (in seconds) during inactivity */
#define THREAD_SLEEP_TIME   (1)  

#define O_RDWR                              02

#define IX_DSP_CODELET_TDM_CHL_ANALOG       IX_DSP_CODELET_MAX_CHL 

#define IX_DSP_DRV_FAIL -1
#define IX_DSP_DRV_SUCCESS 0

#define BYTE_TO_BIT_CONV 8

#define ALAW_MODE 0
#define MULAW_MODE 1
#define LINEAR_MODE 2

#define USER_CHOICE_NB 0
#define USER_CHOICE_WB 1

/* These defines are used to configure the SLIC using the mode and 
 * band parameters */
/* The band parameter (0 nb, 1 wb) is shifted left by 2 (band_shift_factor) 
 * and added to the mode (0,1,2)*/
/* Note not all band and mode combinations are supported*/
/* In fact currently only the 3 combinations below are supported*/
/* If other configs are required they can be added here  */
#define ALAW_NB 0 
#define MULAW_NB 1
#define LINEAR_WB 6
#define BAND_SHIFT_FACTOR 2

#define NUM_SLIC_SLOTS 2 /* And these are hardcoded to slots 0 and 1 */
#define NUM_FXS_CHIPS 4 /* Number of FXS chips per slot */
#define NUM_SLIC_CHIPS 5 /* Number of FXS+FXO chips per slot */

/* Each SLIC channels 1-4 hardcoded to start on timeslots {1,3,5,7} */
#define SLICBASE_TS 1

#define SLIC_CB_THREAD_PRIORITY 40
#define SLIC_EVT_READ_SIZE 64
#define SLIC_TS_SPACING 2
#define SLIC_WB_TS_OFFSET 16 /*for single E1 config*/

#define NUM_FRAMER_CHAN 24
/*In mixed phone mode the number of framer channels 24-8=16*/
#define NUM_FRAMER_MIXED_CHAN 16

/* analog driver #defines */
#define ANALOGDRV_US_GEO 0
#define ANALOGDRV_EU_GEO 1
#define ANALOGDRV_JP_GEO 2
#define ANALOGDRV_CLK_SPEED_2MHZ 0
#define ANALOGDRV_CLK_SPEED_8MHZ 1 
#define ANALOGDRV_ON_HOOK 0  
#define ANALOGDRV_OFF_HOOK 1 
#define ANALOGDRV_PCM_FORMAT_U_LAW 0    /* note ADS mulaw=1 */
#define ANALOGDRV_PCM_FORMAT_A_LAW 1
#define ANALOGDRV_PCM_FORMAT_LINEAR 2
#define ANALOGDRV_PCM_WIDTH_8_BIT     8         /* PCM width of 8 bits */
#define ANALOGDRV_PCM_WIDTH_16_BIT     16   /* PCM width of 16 bits */
#define ANALOGDRV_PCM_SAMP_FREQ_8_KHZ 8    /* 8 kHZ PCM sample frequency */
#define ANALOGDRV_PCM_SAMP_FREQ_16_KHZ 16   /* 16 kHZ PCM sample frequency */

/* Si3216 registers for direct reads and writes */

#define IX_RINGING_OSCIL_CTRL_REG 34
#define IX_RINGING_OSCIL_ACTIVE_TIMER_LB_REG 48
#define IX_RINGING_OSCIL_ACTIVE_TIMER_HB_REG 49
#define IX_RINGING_OSCIL_INACTIVE_TIMER_LB_REG 50
#define IX_RINGING_OSCIL_INACTIVE_TIMER_HB_REG 51
#define IX_LINEFEED_CTRL_REG 64
#define IX_LOOP_CURRENT_SENSE_REG 79

#define IX_POL_INVERT_BIT_MASK (0x04)
/*LB=0x0A and HB=0xF below conbine to give time of 0.5s*/
#define IX_SHORT_RING_ON_TIME_LB (0xA0)
#define IX_SHORT_RING_ON_TIME_HB (0xF)
#define IX_SHORT_RING_OFF_TIME_LB (0xA0)
#define IX_SHORT_RING_OFF_TIME_HB (0xF)
/* Linefeed set to ringing*/
#define IX_LINE_FEED_RING (0x04)
/*Linefeed set to forward on hook transmission*/
#define IX_LINE_FEED_ON_HOOK_TRANS (0x02)
/*Required to enable ringing on/off times*/
#define IX_FXS_RINGING_OSCIL_ENABLE (0x18)

/* defines for voice driver */
#define IX_HSS_PORT_0 0
#define IX_HSS_PORT_1 1
#define IX_HSS_PORT_2 2
#define IX_HSS_NB_PKT_SIZE 80
#define IX_HSS_WB_PKT_SIZE 320
#define IX_HSS_VOICE_HEADER 4
#define MAX_READ_SIZE IX_DSP_CODELET_MAX_CHL*(IX_HSS_WB_PKT_SIZE+IX_HSS_VOICE_HEADER)


/* Number of unused framer timeslots. Here it is 2 i.e. ts0 and ts16 */
/* these timeslots may be used to transmit signalling info */
#define FRAMER_UNUSED_TS_NUM 2

/* Global variable used by ADS codelet only */
/* This is the voice driver file descriptor opened
 * by the codelet and passed to the lib in
 * IxDspCodeletInit.c*/
extern int voiceDrvfd;

typedef enum{
   IX_SC_ON_HOOK=0,
   IX_SC_OFF_HOOK
}IxScHookState;

typedef int IxScChipNum;

/* SLIC function prototypes */

/* Starts Ringing ADS channel */
int ixFXSStartRinging(int chl);
/* Stops Ringing ADS channel */
int ixFXSStopRinging(int chl);
/* Gets hook state of ADS channel */
int ixFXSHookStatus(int chl);
/* Initialises SLICS on slots 0 and 1 depending on
 * geo info */
int ixFXSOSlicInit(int geo);
/* Configures FXS chips on the SLICs depending on
 * band and mode info */
int ixFXSConfig(int mode, int band);
/* Starts the callback thread for Slic*/
int ixFXSRegCallback(int chip);
/* Initialises Slic callback thread*/
int initCallbackThread(void);
/* Function that handles slic callback */
void * callbackHandler(void *arg);
/*Cancel the callback thread set up to read events from slic*/
void cancelCallbackThread(void);
/* Reads from a SLIC direct register slicLineId identifies the slic chip
 * and reg the required register. Data is returned by the function as an int*/
int ixFXSODirectRegRead(int slicLineId,int reg,int data);
/* Writes to a SLIC direct register slicLineId identifies the slic chip
 * and reg the required register */
int ixFXSODirectRegWrite(int sliclineId,int reg,int data);
/* Closes SLIC file descriptor */
int ixFXSOSlicClose(void);
/* Dummy funcitons not required for ADS1.0*/
/* Can be filled out later if required*/
int ixFXSGetPCMConfig(int chl);
int ixFXSOChipDetails(int lineId);
int ixFXSOSetDeviceLoopback(int slot,int board,int chip);
int ixFXSOResetDeviceLoopback(int slot,int board,int chip);
int ixFXSOGetDeviceLoopback(int slot,int board,int chip);
int ixFXSOVerifyComm(int slot,int board,int chip);
int ixFXSSetPCMConfig(int slot,int board,int chip,int pcmed,int mode,
                      int pcmtfr);
int ixFXOOffhook(int lineId);
int ixFXOOnhook(int lineId);


/* Voice Driver function prototypes */

/* Initialises 3 Hss ports */
int IxHssDriverHssPortInit(Hss_config *port_config);
/* Configures channels associated with ports depending on mode,band 
 * and slic_framer_choice */
int IxHssDriverHssConfig(int mode,int band);
/*Enables 8 channels for slic_framer_choice=IX_DSP_SLIC_ONLY else enables 24*/
int IxHssDriverChanEnable(void);
/* Disables previously enabled channels*/
int IxHssDriverChanDisable(void);
/* Removes channels and brings down all 3 hss ports*/
int IxHssDriverDown(void);
/* Closes the voice drvier file descriptor */
int IxHssDriverClose(void);

#endif
/* __IXDSPSLICHSSDRIVER_H__ */

