/******************************************************************************
*    @file 	IxPlatforms.h
*    @Contents  This file contains info for Platform specific initializations
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/
#ifndef _IA_MENLOW_H_
#define _IA_MENLOW_H_

/* Macros that define the ethernet interfaces. 
 * In our case it is the linux machine on which we run the DSR */
#define DEFAULT_IXP0_IP "127.0.0.1"
#define DEFAULT_IXP1_IP "127.0.0.1"

#define NETWORK_FAMILY AF_INET

/* Define Maximum number of channels */
#define IX_DSP_CODELET_MAX_CHL              3

/* Hss Configuration data intialization */
#define IX_DSP_CODELET_NUM_TIMESLOT     IX_DSP_CODELET_MAX_CHL  /* must >=8 to enable NPE short bypass feature */
#define IX_DSP_TS_UNAS IX_HSSACC_TDMMAP_UNASSIGNED
#define IX_DSP_TS_HDLC IX_HSSACC_TDMMAP_HDLC
#define IX_DSP_TS_V64K IX_HSSACC_TDMMAP_VOICE64K
#define IX_DSP_TS_V56K IX_HSSACC_TDMMAP_VOICE56K

#define IX_NPEDL_NPEIMAGE_NPEA_HSS0 0x00010000
#define IX_NPEDL_NPEIMAGE_NPEB_ETH  0x01000200
#define IX_NPEDL_NPEIMAGE_NPEC_ETH  0x02000200
#define IX_NPEDL_NPEIMAGE_NPEA_HSS_TSLOT_SWITCH 0x00160000

/* Initializing Timeslot Map for both Narrow and Widebands */
#define INIT_CHAN_TDM_SLOT_MAP_NB chanTdmSlotMap_NB[]  = { \
    {1, XCHAN_TDM_SLOT_NULL}, \
    {3, XCHAN_TDM_SLOT_NULL}, \
    {5, XCHAN_TDM_SLOT_NULL}, \
    {7, XCHAN_TDM_SLOT_NULL}, \
    {9, XCHAN_TDM_SLOT_NULL}, \
    {11, XCHAN_TDM_SLOT_NULL}, \
    {13, XCHAN_TDM_SLOT_NULL}, \
    {15, XCHAN_TDM_SLOT_NULL}, \
    {17, XCHAN_TDM_SLOT_NULL}, \
    {19, XCHAN_TDM_SLOT_NULL}, \
    {21, XCHAN_TDM_SLOT_NULL}, \
    {23, XCHAN_TDM_SLOT_NULL}, \
    {25, XCHAN_TDM_SLOT_NULL}, \
    {27, XCHAN_TDM_SLOT_NULL}, \
    {29, XCHAN_TDM_SLOT_NULL}, \
    {31, XCHAN_TDM_SLOT_NULL}, \
    {33, XCHAN_TDM_SLOT_NULL}, \
    {35, XCHAN_TDM_SLOT_NULL}, \
    {37, XCHAN_TDM_SLOT_NULL}, \
    {39, XCHAN_TDM_SLOT_NULL}, \
    {41, XCHAN_TDM_SLOT_NULL}, \
    {43, XCHAN_TDM_SLOT_NULL}, \
    {45, XCHAN_TDM_SLOT_NULL}, \
    {47, XCHAN_TDM_SLOT_NULL} \
};

#define INIT_CHAN_TDM_SLOT_MAP_WB chanTdmSlotMap_WB[]  = { \
    {1, XCHAN_TDM_SLOT_NULL}, \
    {3, XCHAN_TDM_SLOT_NULL}, \
    {5, XCHAN_TDM_SLOT_NULL}, \
    {7, XCHAN_TDM_SLOT_NULL}, \
    {9, XCHAN_TDM_SLOT_NULL}, \
    {11, XCHAN_TDM_SLOT_NULL}, \
    {13, XCHAN_TDM_SLOT_NULL}, \
    {15, XCHAN_TDM_SLOT_NULL}, \
    {17, XCHAN_TDM_SLOT_NULL}, \
    {19, XCHAN_TDM_SLOT_NULL}, \
    {21, XCHAN_TDM_SLOT_NULL}, \
    {23, XCHAN_TDM_SLOT_NULL}, \
    {25, XCHAN_TDM_SLOT_NULL}, \
    {27, XCHAN_TDM_SLOT_NULL}, \
    {29, XCHAN_TDM_SLOT_NULL}, \
    {31, XCHAN_TDM_SLOT_NULL}, \
    {33, XCHAN_TDM_SLOT_NULL}, \
    {35, XCHAN_TDM_SLOT_NULL}, \
    {37, XCHAN_TDM_SLOT_NULL}, \
    {39, XCHAN_TDM_SLOT_NULL}, \
    {41, XCHAN_TDM_SLOT_NULL}, \
    {43, XCHAN_TDM_SLOT_NULL}, \
    {45, XCHAN_TDM_SLOT_NULL}, \
    {47, XCHAN_TDM_SLOT_NULL} \
};

/* HSS Port config declaration and initialization */
typedef struct {
     IxHssAccHssPort      hssport_Id;
     IxHssAccTdmSlotUsage hssTdmMap[IX_HSSACC_TSLOTS_PER_HSS_PORT];
     IxHssAccConfigParams hssportTx_Rx_config;
     UINT32               hssNpeImageid;
}Hss_config;

static Hss_config hss_port_config = {
/* Hss port number */
IX_HSSACC_HSS_PORT_0,

/* TDM Map indicates how each timeslot is used on the 1 T1-trunk */
{/* Trunk 0        */
    IX_DSP_TS_UNAS,     /* TS 00 */
    IX_DSP_TS_V64K,     /* TS 01 */
    IX_DSP_TS_V64K,     /* TS 02 */
    IX_DSP_TS_V64K,     /* TS 03 */
    IX_DSP_TS_V64K,     /* TS 04 */
    IX_DSP_TS_V64K,     /* TS 05 */
    IX_DSP_TS_V64K,     /* TS 06 */
    IX_DSP_TS_V64K,     /* TS 07 */
    IX_DSP_TS_V64K,     /* TS 08 */
    IX_DSP_TS_UNAS,     /* TS 09 */
    IX_DSP_TS_UNAS,     /* TS 10 */
    IX_DSP_TS_UNAS,     /* TS 11 */
    IX_DSP_TS_UNAS,     /* TS 12 */
    IX_DSP_TS_UNAS,     /* TS 13 */
    IX_DSP_TS_UNAS,     /* TS 14 */
    IX_DSP_TS_UNAS,     /* TS 15 */
    IX_DSP_TS_UNAS,     /* TS 16 */
    IX_DSP_TS_UNAS,     /* TS 17 */
    IX_DSP_TS_UNAS,     /* TS 18 */
    IX_DSP_TS_UNAS,     /* TS 19 */
    IX_DSP_TS_UNAS,     /* TS 20 */
    IX_DSP_TS_UNAS,     /* TS 21 */
    IX_DSP_TS_UNAS,     /* TS 22 */
    IX_DSP_TS_UNAS,     /* TS 23 */
    IX_DSP_TS_UNAS,     /* TS 24 */
    IX_DSP_TS_UNAS,     /* TS 25 */
    IX_DSP_TS_UNAS,     /* TS 26 */
    IX_DSP_TS_UNAS,     /* TS 27 */
    IX_DSP_TS_UNAS,     /* TS 28 */
    IX_DSP_TS_UNAS,     /* TS 29 */
    IX_DSP_TS_UNAS,     /* TS 30 */
    IX_DSP_TS_UNAS      /* TS 31 */
 },
/* Rx and Tx port configuration for IA */
{
    /* HSS port TX configuration */
    {

        IX_HSSACC_FRM_SYNC_RISINGEDGE,    /* Frame sync type = rising */
        IX_HSSACC_FRM_SYNC_OUTPUT_RISING, /* Frame sync output enable = rising */
        IX_HSSACC_CLK_EDGE_FALLING,       /* Frame sync clock edge = falling */
        IX_HSSACC_CLK_EDGE_RISING,        /* Data clock edge = rising */
        IX_HSSACC_SYNC_CLK_DIR_OUTPUT,    /* Clock direction = output */
        IX_HSSACC_FRM_PULSE_ENABLED,      /* Frame usage = enabled */
        IX_HSSACC_CLK_RATE,               /* Data rate = clock rate */
        IX_HSSACC_DATA_POLARITY_SAME,     /* Data polarity = same */
        IX_HSSACC_MSB_ENDIAN,             /* Data endianness = msb endian */
        IX_HSSACC_TX_PINS_NORMAL,         /* Drain mode = normal */
        IX_HSSACC_SOF_DATA,               /* FBit usage = data,  E1 */
        IX_HSSACC_DE_DATA,                /* Data enable = data */
        IX_HSSACC_TXSIG_LOW,              /* 56K type = low */
        IX_HSSACC_TXSIG_LOW,              /* Unassigned type = low */
        IX_HSSACC_FB_FIFO,                /* FBit type = fifo */
        IX_HSSACC_56KE_BIT_7_UNUSED,      /* 56K endianness = bit 7 unused */
        IX_HSSACC_56KS_32_8_DATA,         /* 56K selection = 32/8 data */
        0,                                /* Frame offset = 0 */
        256                               /* Frame size = 256
                                            (1 trunk * 32 timeslots * 8 bits), E1  */
    },
    /* HSS port RX configuration */
    {
        IX_HSSACC_FRM_SYNC_RISINGEDGE,     /* Frame sync type = rising edge */
        IX_HSSACC_FRM_SYNC_INPUT,          /* Frame sync sampled as an input */
        IX_HSSACC_CLK_EDGE_FALLING,        /* Frame sync clock edge = falling */
        IX_HSSACC_CLK_EDGE_FALLING,        /* Data clock edge = falling */
        IX_HSSACC_SYNC_CLK_DIR_INPUT,      /* Clock direction = input */
        IX_HSSACC_FRM_PULSE_ENABLED,       /* Frame usage = enabled */
        IX_HSSACC_CLK_RATE,                /* Data rate = clock rate */
        IX_HSSACC_DATA_POLARITY_SAME,      /* Data polarity = same */
        IX_HSSACC_MSB_ENDIAN,              /* Data endianness = msb endian */
        IX_HSSACC_TX_PINS_NORMAL,          /* Drain mode = normal */
        IX_HSSACC_SOF_DATA,                /* FBit usage = data, E1*/
        IX_HSSACC_DE_DATA,                 /* Data enable = data */
        IX_HSSACC_TXSIG_LOW,               /* 56K type = low */
        IX_HSSACC_TXSIG_LOW,               /* Unassigned type = low */
        IX_HSSACC_FB_FIFO,                 /* FBit type = fifo */
        IX_HSSACC_56KE_BIT_7_UNUSED,       /* 56K endianness = bit 7 unused */
        IX_HSSACC_56KS_32_8_DATA,          /* 56K selection = 32/8 data */
        0,                                 /* Frame offset = 0 */
        256                                /* Frame size = 256
                                            (1 trunk * 32 timeslots * 8 bits), E1 */
    },
    IX_DSP_CODELET_NUM_TIMESLOT,    /* Number of channelised timeslots */
    0,                  /* Number of packetised clients */
    0x7F,               /* Channelised idle pattern */
    FALSE,              /* HSS loopback state */
    0x7F7F7F7F,         /* Channelised idle pattern */
    IX_HSSACC_CLK_SPEED_2048KHZ /* HSS clock speed, E1  */
},
IX_NPEDL_NPEIMAGE_NPEA_HSS_TSLOT_SWITCH
};
#endif
