/******************************************************************************
*       @file	FWTypes.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef _FWTypes_h_
#define _FWTypes_h_


#include <stdlib.h>
#include <string.h>

#ifdef ADS_OSAL_INCLUDED
#include "IxOsal.h"
#endif /*ADS_OSAL_INCLUDED*/

#ifdef OS_VXWORK
#include <vxWorks.h>
#endif

typedef int                 Int, Int32, Int24;
typedef unsigned int        Uint, Uint32, UInt32, Uint24;
typedef short               Short, Int16;
typedef unsigned short      Ushort, Uint16, UInt16;
typedef signed char         Int8;
typedef unsigned char       Uchar, UChar, Uint8, UInt8;
typedef void                Void;

#define MPY16BY16(x, y)     (Int16)(((x)*(y) + 0x4000) >> 15)
#define SIZEOF(x)           sizeof(x)
#define SAT16(y)            (y > 32767 ? 32767 : (y < -32767 ? -32767 : y))

/* definition of the return value of state functions */
typedef enum{

    XSUCC = 0,          /* successful */
    XMSG_EXECPTION,     /* recieved an unexpected msg */
    XRESET,             /* reset the state machine */
    XFATAL,             /* fatal errors that cause SM to be stopped */
    XERROR = -1         /* general errors */

} XStatus_t;


/* these are defined in IxTypes.h */
#ifdef ADS_OSAL_INCLUDED
typedef int (*FUNCPTR)(void);

#else
#ifndef OS_VXWORK
typedef unsigned char  UINT8;
typedef char  INT8;
typedef short INT16;
typedef int   INT32;
typedef unsigned int   UINT32;
typedef unsigned short UINT16;
typedef int BOOL;
typedef int (*FUNCPTR)(void);
#endif /*OS_VXWORK*/

typedef volatile UINT32 VUINT32;
typedef UINT32 IX_STATUS;

#endif /*ADS_OSAL_INCLUDED*/

/**
 * Definition of TRUE
 *  */
#ifndef TRUE
#define TRUE (1)
#endif

#if TRUE != 1
#error TRUE is not defined to 1
#endif

 /**
  *  * Definition of FALSE 
  *   */
#ifndef FALSE
#define FALSE (0)
#endif

#if FALSE != 0 
#error FALSE is not defined to 0
#endif

 /**
  *  * definition of NULL
  *   */
#ifndef NULL
#define NULL 0L
#endif /* NULL */

#define OK              0
#define ERROR           (-1)
#define NO_WAIT         0
#define WAIT_FOREVER    (-1)

#ifndef PUBLIC
#define PUBLIC
#endif /* PUBLIC */

#ifndef IX_SUCCESS 
#define IX_SUCCESS 0
#endif

#ifndef IX_FAIL 
#define IX_FAIL 1
#endif

#define VOID void
#endif
