/******************************************************************************
*       @file	IxSlicCodec.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef __IXSLICCODEC_H__
#define __IXSLICCODEC_H__

#include "FWTypes.h"

/*
 * #defines for function return types, etc.
 */

/**
 * @enum IxScChipNum
 * @brief The Si3210 valid chip numbers. There can be a maximum of 8
 * daisy chained Si3210 devices
 *
 */
typedef enum
{
    IX_SC_CHIP_0 = 0,   /**< Chip number 0 */
    IX_SC_CHIP_1 = 1,   /**< Chip number 1 */
    IX_SC_CHIP_2 = 2,   /**< Chip number 2 */
    IX_SC_CHIP_3 = 3,   /**< Chip number 3 */
    IX_SC_CHIP_4 = 4,   /**< Chip number 4 */
    IX_SC_CHIP_5 = 5,   /**< Chip number 5 */
    IX_SC_CHIP_6 = 6,   /**< Chip number 6 */
    IX_SC_CHIP_7 = 7,   /**< Chip number 7 */
    IX_SC_CHIP_MAX      /**< Delimiter for error checks */
} IxScChipNum;

/**
 * @def IX_SI3210_DEVICES_MAX
 *
 * @brief The maximum number of Si3210 devices on the board. The maximum number
 * of Si3210 devices chained is 8 i.e. from 0 to 7
 */
#if defined(IXDPG425)
#define IX_SI3210_DEVICES_MAX IX_SC_CHIP_4
#else
#define IX_SI3210_DEVICES_MAX IX_SC_CHIP_2
#endif

/*
 * Si3210 direct registers' addresses.
 */
/* Setup Registers */
#define IX_SPI_MODE_SELECT_REG                         0
#define IX_PCM_MODE_SELECT_REG                         1
#define IX_PCM_TX_START_COUNT_LB_REG                   2
#define IX_PCM_TX_START_COUNT_HB_REG                   3
#define IX_PCM_RX_START_COUNT_LB_REG                   4
#define IX_PCM_RX_START_COUNT_HB_REG                   5
#define IX_DIGITAL_IO_CTRL_REG                         6
/* Audio Registers */
#define IX_AUDIO_PATH_LOOPBACK_CTRL_REG                8
#define IX_AUDIO_GAIN_CTRL_REG                         9
#define IX_TWO_WIRE_IMPEDANCE_SYNTH_CTRL_REG           10
#define IX_HYBRID_CTRL_REG                             11
/* Powerdown Registers */
#define IX_POWER_DOWN_CTRL_1_REG                       14
#define IX_POWER_DOWN_CTRL_2_REG                       15
/* Interrupt Registers */
#define IX_INTERRUPT_STATUS_1_REG                      18
#define IX_INTERRUPT_STATUS_2_REG                      19
#define IX_INTERRUPT_STATUS_3_REG                      20
#define IX_INTERRUPT_ENABLE_1_REG                      21
#define IX_INTERRUPT_ENABLE_2_REG                      22
#define IX_INTERRUPT_ENABLE_3_REG                      23
#define IX_DECODE_STATUS_REG                           24
/* Indirect Register Access Registers */
#define IX_INDIRECT_DATA_ACCESS_LB_REG                 28
#define IX_INDIRECT_DATA_ACCESS_HB_REG                 29
#define IX_INDIRECT_ADDRESS_REG                        30
#define IX_INDIRECT_ADDRESS_STATUS_REG                 31
/* Oscillators Registers */
#define IX_OSCIL_1_CTRL_REG                            32
#define IX_OSCIL_2_CTRL_REG                            33
#define IX_RINGING_OSCIL_CTRL_REG                      34
#define IX_PULSE_METERING_OSCIL_CTRL_REG               35
#define IX_OSCIL_1_ACTIVE_TIMER_LB_REG                 36
#define IX_OSCIL_1_ACTIVE_TIMER_HB_REG                 37
#define IX_OSCIL_1_INACTIVE_TIMER_LB_REG               38
#define IX_OSCIL_1_INACTIVE_TIMER_HB_REG               39
#define IX_OSCIL_2_ACTIVE_TIMER_LB_REG                 40
#define IX_OSCIL_2_ACTIVE_TIMER_HB_REG                 41
#define IX_OSCIL_2_INACTIVE_TIMER_LB_REG               42
#define IX_OSCIL_2_INACTIVE_TIMER_HB_REG               43
#define IX_PULSE_METERING_OSCIL_ACTIVE_TIMER_LB_REG    44
#define IX_PULSE_METERING_OSCIL_ACTIVE_TIMER_HB_REG    45
#define IX_PULSE_METERING_OSCIL_INACTIVE_TIMER_LB_REG  46
#define IX_PULSE_METERING_OSCIL_INACTIVE_TIMER_HB_REG  47
#define IX_RINGING_OSCIL_ACTIVE_TIMER_LB_REG           48
#define IX_RINGING_OSCIL_ACTIVE_TIMER_HB_REG           49
#define IX_RINGING_OSCIL_INACTIVE_TIMER_LB_REG         50
#define IX_RINGING_OSCIL_INACTIVE_TIMER_HB_REG         51
#define IX_FSK_DATA_REG                                52
/* SLIC Registers */
#define IX_LOOP_CLOSR_DEB_INTRVL__4_AUTO_RING_REG      63
#define IX_LINEFEED_CTRL_REG                           64
#define IX_EXTERNAL_BIPOLAR_TRANSISTOR_CTRL_REG        65
#define IX_BATTERY_FEED_CTRL_REG                       66
#define IX_AUTO_MANUAL_CONTROL_REG                     67
#define IX_LOOP_CLOSR_RING_TRIP_DETECT_STATUS_REG      68
#define IX_LOOP_CLOSURE_DEBOUNCE_INTERVAL_REG          69
#define IX_RING_TRIP_DETECT_DEBOUNCE_INTERVAL_REG      70
#define IX_LOOP_CURRENT_LIMIT_REG                      71
#define IX_ONHOOK_LINE_VOLTAGE_REG                     72
#define IX_COMMON_MODE_VOLTAGE_REG                     73
#define IX_HIGH_BATTERY_VOLTAGE_REG                    74
#define IX_LOW_BATTERY_VOLTAGE_REG                     75
#define IX_POWER_MONITOR_POINTER_REG                   76
#define IX_LINE_POWER_OUTPUT_MONITOR_REG               77
#define IX_LOOP_VOLTAGE_SENSE_REG                      78
#define IX_LOOP_CURRENT_SENSE_REG                      79
#define IX_TIP_VOLTAGE_SENSE_REG                       80
#define IX_RING_VOLTAGE_SENSE_REG                      81
#define IX_BATTERY_VOLTAGE_SENSE_1_REG                 82
#define IX_BATTERY_VOLTAGE_SENSE_2_REG                 83
#define IX_TRANSISTOR_1_CURRENT_SENSE_REG              84
#define IX_TRANSISTOR_2_CURRENT_SENSE_REG              85
#define IX_TRANSISTOR_3_CURRENT_SENSE_REG              86
#define IX_TRANSISTOR_4_CURRENT_SENSE_REG              87
#define IX_TRANSISTOR_5_CURRENT_SENSE_REG              88
#define IX_TRANSISTOR_6_CURRENT_SENSE_REG              89
#define IX_DC_DC_CONVERTER_PWM_PERIOD_REG              92
#define IX_DC_DC_CONVERTER_SWITCHING_DELAY_REG         93
#define IX_PWM_PULSE_WIDTH_REG                         94
#define IX_CALIB_CONTROL_STATUS_REG_1_REG              96
#define IX_CALIB_CONTROL_STATUS_REG_2_REG              97
#define IX_RING_GAIN_MISMATCH_CALIB_RESULT_REG         98
#define IX_TIP_GAIN_MISMATCH_CALIB_RESULT_REG          99
#define IX_DIFF_LOOP_CURRENT_GAIN_CALIB_RESULT_REG     100
#define IX_COMMON_MODE_LOOP_CURRENT_GAIN_CALIB_RES_REG 101
#define IX_CURRENT_LIMIT_CALIB_RESULT_REG              102
#define IX_MONITOR_ADC_OFFSET_CALIB_RESULT_REG         103
#define IX_ANALOG_DAC_ADC_OFFSET_REG                   104
#define IX_DAC_OFFSET_CALIB_RESULT                     105
#define IX_COMMON_MODE_BALANCE_CALIB_RESULT_REG        106
#define IX_DC_PEAK_VOLTAGE_CALIB_RESULT_REG            107
#define IX_ENHANCEMENT_ENABLE_REG                      108

/* Scratch pad register addresses in the device */
#define IX_SCRATCH_PAD_0                               97
#define IX_SCRATCH_PAD_1                               193
#define IX_SCRATCH_PAD_2                               194
#define IX_SCRATCH_PAD_3                               195
#define IX_SCRATCH_PAD_4                               196
#define IX_SCRATCH_PAD_5                               197
#define IX_SCRATCH_PAD_6                               198
#define IX_SCRATCH_PAD_7                               199
#define IX_SCRATCH_PAD_8                               200
#define IX_SCRATCH_PAD_9                               201
#define IX_SCRATCH_PAD_10                              202
#define IX_SCRATCH_PAD_11                              203
#define IX_SCRATCH_PAD_12                              204
#define IX_SCRATCH_PAD_13                              205
#define IX_SCRATCH_PAD_14                              206
#define IX_SCRATCH_PAD_15                              207
#define IX_SCRATCH_PAD_16                              208
#define IX_SCRATCH_PAD_17                              209
#define IX_SCRATCH_PAD_18                              210
#define IX_SCRATCH_PAD_19                              211

/**
 * @enum IxScHookState
 * @brief The IxScHookState defines the valid hook states
 *
 */
typedef enum
{
    IX_SC_ON_HOOK = 0,
    IX_SC_OFF_HOOK
} IxScHookState;

/**
 * @enum IxScDtmfDigit
 * @brief The IxScDtmfDigit defines the valid DTMF digits that can be detected
 *
 */
typedef enum
{
    IX_SC_DTMF_0 = 10,
    IX_SC_DTMF_1 = 1,
    IX_SC_DTMF_2 = 2,
    IX_SC_DTMF_3 = 3,
    IX_SC_DTMF_4 = 4,
    IX_SC_DTMF_5 = 5,
    IX_SC_DTMF_6 = 6,
    IX_SC_DTMF_7 = 7,
    IX_SC_DTMF_8 = 8,
    IX_SC_DTMF_9 = 9,
    IX_SC_DTMF_HASH = 12,
    IX_SC_DTMF_STAR = 11,
    IX_SC_DTMF_A = 13,
    IX_SC_DTMF_B = 14,
    IX_SC_DTMF_C = 15,
    IX_SC_DTMF_D = 0
} IxScDtmfDigit;

/**
 * @enum IxScCompanding
 * @brief IxScCompanding defines the type of companding modes that are supported
 * by SI3210 devices
 *
 */

typedef enum
{
    IX_SC_ALAW = 0,
    IX_SC_ULAW = 1,
    IX_SC_LINEAR = 2,
    IX_SC_MODES_MAX   /* Delimiter for error checks */
} IxScCompanding;

typedef enum
{
    IX_SC_NB = 0,
    IX_SC_WB = 1
} IxScBand;

/**
 * @struct IxScChipTimeslotPair
 * @brief Structure containing the Si3210 chip number and its equivalent PCM
 * timeslot
 *
 */
typedef struct
{
    IxScChipNum chip;     /**< Daisy chained Si3210 chip ID */
    UINT32 rxTimeslot;    /**< PCM timeslot to receive speech on */
    UINT32 txTimeslot;    /**< PCM timeslot to transmit speech on */
	IxScCompanding mode;  /**< PCM stream companding mode */
	IxScBand band;        /**< PCM wideband/narrowband selection */
} IxScChipTimeslotPair;

#endif 
/* __IXSLICCODEC_H__ */






