/******************************************************************************
*       @file	PlugInDefs.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/
/*DONOT EDIT OR MODIFY THIS FILE*/
#ifndef __PLUGINDEFS_H__
#define __PLUGINDEFS_H__
#include <dspcis.h>

/*EC types*/
typedef enum{
	XEC_TYPE_NONE=0,
	XEC_TYPE_AEC=1,
	XEC_TYPE_LINE_EC=2,
}XEcType_t;


/*Various PlugIn interface types*/
typedef enum tagPlugInIType{
	ITYPE_UNKNOWN,
	ITYPE_USCI_CODEC,	/*USCI interface based codec plugin*/
	ITYPE_USCI_EC,		/*USCI interface based EC plugin*/
	ITYPE_DSR_G711_CODEC,
	/*ANY OTHER NEW interface types define here*/

}PlugInIType;

/*Plug in representation*/
typedef struct tagDsrPlugIn{
	PlugInIType		IType;				/*Interface type*/
	void*			pPlugInInterface;	/*Interface ptr*/
	unsigned int	Type;				/*Plugin type like XCODER_TYPE_G711A_10MS,XEC_TYPE_AEC*/
	char**			ppParamDescripTbl;		/*parameter description table*/
}DsrPlugIn;



#define USCI_PLUG_IN_ARRAY g_pPlugInArray

#define DECLARE_PLUG_IN_LIST \
	extern DsrPlugIn USCI_PLUG_IN_ARRAY[];

#define PLUG_IN_LIST_BEGIN \
	DsrPlugIn USCI_PLUG_IN_ARRAY[] = {

#define PLUG_IN_LIST_END \
	{ITYPE_UNKNOWN,(void*)0,0,0}};

/*Macro for USCI codecs*/
#define USCI_CODEC_PLUG_IN(IUsci,CodecType,pParamdesc) \
	{ITYPE_USCI_CODEC,(void*)(&IUsci),(CodecType),(pParamdesc)},

/*Macro for USCI EC's*/
#define USCI_EC_PLUG_IN(IUsci,CodecType,pParamdesc) \
	{ITYPE_USCI_EC,(void*)(&IUsci),(CodecType),(pParamdesc)},

#endif /*__PLUGINDEFS_H__*/
