/******************************************************************************
*       @file	ToneJP.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef _TONE_JP_H_
#define _TONE_JP_H_

/*
 * Japan call pregress tones are generated according to
 * NTT Technical Reference -
 * Telephone Service Interfaces, Edition 5, .
 *
 * Tone IDs (NTT_TID_XXX) are mapped to RFC 2833 definitions.
 */

#define COUNTRY_CODE_JP	81

#define NTT_TID_DT		RFC_TID_DIAL		/* dial tone */
#define NTT_TID_RBT		RFC_TID_RING		/* ring back tone */
#define NTT_TID_BT		RFC_TID_BUSY		/* busy tone */
#define NTT_TID_PDT		RFC_TID_PBX_DIAL	/* private dial tone */
#define NTT_TID_SDT		RFC_TID_2ND_DIAL	/* 2nd dial tone */
#define NTT_TID_CPT		RFC_TID_POS_IND		/* acceptance tone tone */
#define NTT_TID_HST		RFC_TID_HOLD		/* hold service tone */
#define NTT_TID_IIT		RFC_TID_CALL_WT		/* incoming identification tone */
#define NTT_TID_SIIT	110					/* special incoming identification tone */
#define NTT_TID_HOW		RFC_TID_OFFHK_WARN	/* howler tone */

#endif

