/******************************************************************************
*       @file	dspcfg.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef __dspcfg_h_
#define __dspcfg_h_

#include <FWTypes.h>
#include <dspcis.h>
#include <alsa/asoundlib.h>
#include "IxHssAcc.h"

#define XTASK_PRI_ORDER_ASCEND      1
#define XTASK_PRI_ORDER_DESCEND     (-1)
/* #define XTASK_PRI_BASE_DEFAULT      40 */
#define XTASK_PRI_BASE_DEFAULT      10

#define XCHAN_TDM_SLOT_NULL         (-1)

/* the time slot assignment to a Network Endpoint instance */
typedef struct{
    int slotSample1;            /* time slot of the 1st sample  */
    int slotSample2;            /* time slot of the 2nd sample,
                                   set to XCHAN_TDM_SLOT_NULL if narrowband */
} XDSPChanTdmSlots_t;


/* data structure of system configuraton with built-in HSS interface */
typedef struct{
    int                  numChTDM;         /* number of channels of TDM termination */
    int                  numChIP;          /* number of channels of IP termination */
    int                  numPlayers;       /* number of player instances */
    int                  numMixers;        /* number of Audio Mixers */
    int                  numPortsPerMixer; /* number of ports per mixer */
    int                  countryCode;      /* country code */
    int                  taskPriBase;      /* the base priority of DSP module */
    int                  taskPriOrder;     /* the priority ordering of the OS */
    int                  taskPriReal;      /* realtime task priority  of DSP module*/
    int 	         taskPriCtrl;      /* control task priority of DSP module */
    int 	        taskPriPCMRead;    /* PCM read task priority of DSP module */
    IxHssAccHssPort      port;             /* HSS port */
    IxHssAccConfigParams *pHssCfgParms;    /* HSS configuration parameters */
    IxHssAccTdmSlotUsage *pHssTDMSlots;    /* HSS TDM time slot mapping */
    XDSPChanTdmSlots_t   *pChanTsMap;      /* channel vs. slot mapping for WB mode */
    XPktRcvFxn_t         pktRcvFxn;        /* packet receiver function */
    XMsgAgentDec_t       msgDecoder;       /* message decoder function of MA */
    XMsgAgentEnc_t       msgEncoder;       /* message encoder function of MA */
    int                  dspInterface;     /* interface */
    snd_pcm_t            *alsaCaptureHandle; /* ALSA Capture buffer descriptor */
    snd_pcm_t            *alsaPlaybackHandle; /* ALSA Playback buffer descriptor */
} XDSPSysConfig_t;

/* system configuration function with built-in HSS interface */
void xDspSysInit(XDSPSysConfig_t *pSysConfig);
/* system shutdown routine */
XStatus_t xDspSysClose( void );

/* register CSR optional functions */
typedef struct{
    IX_STATUS (*hssTsSwitchOn)(IxHssAccHssPort, UINT32, UINT32, UINT32 *);
    IX_STATUS (*hssTsSwitchOff)(IxHssAccHssPort, UINT32);
    IX_STATUS (*hssTsSwitchGctLoad)(IxHssAccHssPort, UINT8 *, UINT32);
    void (*qMgrPeriodDone)(void);
} XDSPRegisterCsrOption_t;

void xDspRegisterCsrOptions(XDSPRegisterCsrOption_t *pCSRFuncs);


/* data structure to obtain configuraton information */
typedef struct{
    int numChTDM;           /* number of channels of TDM termination */
    int numChIP;            /* number of channels of IP termination */
    int numPlayers;         /* number of player instances */
    int numMixers;          /* number of Audio Mixers */
    int numPortsPerMixer;   /* number of ports per mixer */
    int numStreams;         /* number of total streams in the router */
    int streamBaseTDM;      /* strm id of the 1st chnl of TMD termination */
    int streamBaseIP;       /* strm id of the 1st chnl of IP termination */
    int streamBasePly;      /* strm id of the 1st port of the 1st mixer */
    int streamBaseMix;      /* strm id of the 1st port of the 1st mixer */
    int countryCode;        /* country code */
} XDSPResConfig_t;

void xDspGetResConfig(XDSPResConfig_t *pCfgInfo);

/* contstants, definitions and api's for defining/generating tone's. */
#include "dsptone.h"

#endif
