/******************************************************************************
*       @file	dspcis.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef _DSPCIS_H_
#define _DSPCIS_H_  1

#include <msgdef.h>

#define XMAX_PARMS_SET              ((XMSG_MAX_SIZE - sizeof(XMsgHdr_t)) / 4 - 1)
#define XMAX_PARMS_GET              XMAX_PARMS_SET
#define XMAX_TONEBUFSIZE            32
#define XMAX_DIGITBUFSIZE           32
#define XMAX_FSKDATASIZE            128
#define XTOTAL_TONE                 32
#define XMAX_TONE_SIZE              52

#define XMSG_MAX_USRMSG_SIZE        (XMSG_MAX_SIZE - sizeof(XMsgHdr_t))

#define XMAX_PLY_SEG \
    ((XMSG_MAX_SIZE - sizeof(XMsgHdr_t)) / sizeof(XPlyMediaDesc_t) - 1)

/* common resource state parameter */
#define XPARMID_RES_STATE           0

/* define parameter value */
#define XPARM_ON                    1
#define XPARM_OFF                   0
#define XPARM_NET_ALAW              0
#define XPARM_NET_MULAW             1
#define XPARM_NET_PASSTHRU          2
#define XPARM_EC_NLP_ON             1
#define XPARM_EC_NLP_SUP_ON         2
#define XPARM_TD_RPT_TONE_ON        1
#define XPARM_TD_RPT_TONE_OFF       2
#define XPARM_TD_RPT_TONE_ON_OFF    3
#define XPARM_TD_TC_FRAMES_MAX      3
#define XPARM_G726_PACK_LSB         0
#define XPARM_G726_PACK_MSB         1

#define XPARM_TNGEN_FSK_V23         0
#define XPARM_TNGEN_FSK_B202        1
#define XPARM_TNGEN_FSK_R1200       8
#define XPARM_TNGEN_FSK_R600        16
#define XPARM_TNGEN_FSK_R300        32
#define XPARM_TNGEN_FSK_R150        64
#define XPARM_TNGEN_FSK_R75         128

/* Country specific TG FSK params */
#define XPARM_TNGEN_FSK_CS_US       300
#define XPARM_TNGEN_FSK_MARK_US     180
#define XPARM_TNGEN_FSK_CS_JP       0
#define XPARM_TNGEN_FSK_MARK_JP     100
#define XPARM_TNGEN_FSK_CS_PRC      300
#define XPARM_TNGEN_FSK_MARK_PRC    180

/* Country specific TD FSK params */
#define XPARM_TD_FSK_CS_US          200
#define XPARM_TD_FSK_MARK_US        100
#define XPARM_TD_FSK_CS_JP          0
#define XPARM_TD_FSK_MARK_JP        60
#define XPARM_TD_FSK_CS_PRC         200
#define XPARM_TD_FSK_MARK_PRC       100

/* auto-switch control bit for each decoder type */
#define XPARM_DEC_AUTOSW_OFF        0x0000
#define XPARM_DEC_AUTOSW_G711MU     0x0001
#define XPARM_DEC_AUTOSW_G711A      0x0002
#define XPARM_DEC_AUTOSW_G729A      0x0004
#define XPARM_DEC_AUTOSW_G723       0x0008
#define XPARM_DEC_AUTOSW_G722_64    0x0010
#define XPARM_DEC_AUTOSW_G726_40    0x0020
#define XPARM_DEC_AUTOSW_G726_32    0x0040
#define XPARM_DEC_AUTOSW_G726_24    0x0080
#define XPARM_DEC_AUTOSW_G726_16    0x0100
#define XPARM_DEC_AUTOSW_G729_1     0x0200
#define XPARM_DEC_AUTOSW_G722_56    0x0400 
#define XPARM_DEC_AUTOSW_G722_48    0x0800
#define XPARM_DEC_AUTOSW_ALL        0xffff

/* terminat digit mask bit */
#define XTD_TIMEOUT_FOREVER         0xffff
#define XTD_TERM_DIGIT_NONE         0x0000
#define XTD_TERM_DIGIT_0            0x0001
#define XTD_TERM_DIGIT_1            0x0002
#define XTD_TERM_DIGIT_2            0x0004
#define XTD_TERM_DIGIT_3            0x0008
#define XTD_TERM_DIGIT_4            0x0010
#define XTD_TERM_DIGIT_5            0x0020
#define XTD_TERM_DIGIT_6            0x0040
#define XTD_TERM_DIGIT_7            0x0080
#define XTD_TERM_DIGIT_8            0x0100
#define XTD_TERM_DIGIT_9            0x0200
#define XTD_TERM_DIGIT_STAR         0x0400
#define XTD_TERM_DIGIT_POUND        0x0800
#define XTD_TERM_DIGIT_A            0x1000
#define XTD_TERM_DIGIT_B            0x2000
#define XTD_TERM_DIGIT_C            0x4000
#define XTD_TERM_DIGIT_D            0x8000

/* End-of-play flag in media segment */
#define XPLY_MEDIA_SEG_EOP          0x7f

/* stop reasons, must not be 0 */
#define XMSG_STOP_REASON_USER       1       /* stopped by XMSG_STOP */
#define XMSG_STOP_REASON_EOD        2       /* end of data */
#define XMSG_STOP_REASON_TERM       3       /* stopped by a termination condition */
#define XMSG_STOP_REASON_TIMEOUT    4       /* time out */
#define XMSG_STOP_REASON_ERROR      5       /* general error */

typedef INT16 XMediaHandle_t;
#define XMEDIA_HANDLE_NULL          -1

/* Hook state for flash hook detector */
typedef enum{
    XHOOK_STATE_ON = 0,
    XHOOK_STATE_OFF,
    XHOOK_STATE_FLASH
}XHookState_t;

/* codec types */
typedef enum{
    XCODER_TYPE_PASSTHRU 	=0,
    XCODER_TYPE_G711MU_10MS	=1,
    XCODER_TYPE_G711A_10MS 	=2,
	XCODER_TYPE_G729A		=3,
	XCODER_TYPE_G723		=4,/*G723.1*/
	XCODER_TYPE_G722_64		=5,/* G722 64kbps*/
    XCODER_TYPE_G722_56     =6,/* G722 56kbps*/
    XCODER_TYPE_G722_48     =7,/* G722 48kbps*/
	XCODER_TYPE_G726_40		=8,
    XCODER_TYPE_G726_32		=9,
    XCODER_TYPE_G726_24		=10,
    XCODER_TYPE_G726_16		=11,
	XCODER_TYPE_G729_1		=12,
	XCODER_TYPE_G722_1		=13,/*G722.1*/
	XCODER_TYPE_G728		=14,
	XCODER_TYPE_G729I		=15,/*Integrated modes*/
	XCODER_TYPE_GSM_AMR		=16,
	XCODER_TYPE_AMRWB		=17,/*ITU G722.2, 3GPP AMRWB*/	
	XCODER_TYPE_AMRWB_PLUS	=18,/*3GPP AMRWB Enhanced codec => AMRWB+ */  
	XCODER_TYPE_GSM_FR		=19,
	XCODER_TYPE_GSM_HR		=20,/*GSM Half Rate*/
	XCODER_TYPE_GSM_EFR		=21,/*GSM Enhanced Full rate codec*/
	XCODER_TYPE_QCELP8		=22,/*Qualcomm codec*/
	XCODER_TYPE_QCELP13		=23,/*Qualcomm codec*/
	XCODER_TYPE_SMV			=24,/*Selectable Mode Vocoder*/
	XCODER_TYPE_ILBC		=25,/*Internet Low Bit rate codec.*/
	XCODER_TYPE_EVRC		=26,/*Enhanced variable rate codec*/
	XCODER_TYPE_SIREN14		=27,/* ITU G722.1C */

    /* add new coder here */
    XCODER_TYPE_UNDEF = -1
} XCoderType_t;
/* Resource Type definitions */
typedef enum{
    XMPR_ANY = 0,       /* All resources, for message broadcasting */
    XMPR_NET,           /* Network Endpoint resource */
    XMPR_DEC,           /* Decoder resource */
    XMPR_ENC ,          /* Encoder resource */
    XMPR_TNGEN,         /* Tone generator resource */
    XMPR_TNDET,         /* Tone detector resource */
    XMPR_PLY,           /* Audio player resource */
    XMPR_MIX,           /* Audio mixer resource */
    XMPR_T38,           /* T38 IP fax resource */
    XMPR_MA,            /* Message Agent resource */
    XMPR_EOL            /* end of list */
} XMPResource_t;

/* NET parameters ids */
typedef enum{
    XPARMID_NET_LP_STREAM       /* L-Port stream */
        = XPARMID_RES_STATE + 1,
    XPARMID_NET_LAW,            /* PCM data format, A-law or mu-law */
    XPARMID_NET_ECENABLE,       /* EC flag, 1 - enable, 0 - disable */
    XPARMID_NET_ECTAIL,         /* EC tail length */
    XPARMID_NET_ECNLP,          /* EC NLP flag, 0 - disable; 1 - NLP on & Suppr Off;
                                   2 - NLP on & Suppr on */
    XPARMID_NET_ECFREEZE,       /* EC freeze flag, 1 - freeze, 0 - not freeze */
    XPARMID_NET_DELAYCOMP,      /* EC delay componesation 0 ~ 40 */
    XPARMID_NET_FLASH_HK,       /* flash hook window in 10-ms unit */
    XPARMID_NET_TIMER,          /* timer counter in 10-ms unit */
    XPARMID_NET_GAIN_RX,        /* Rx gain in dB (+15 ~ -40) */
    XPARMID_NET_GAIN_TX,        /* Tx gain in dB (+15 ~ -40) */
    XPARMID_NET_HSS_BYPASS,      /* HSS Bypass flag, 1 - enable, 0 - disable */
    XPARMID_NET_AECENABLE,       /* AEC flag, 1 - enable, 0 - disable */
    XPARMID_NET_AECALG,       	/* AEC ALG flag, 0- Full band, 1- Sub-band, 2-Sub band fast */
    XPARMID_NET_AECTAIL,      	/* AEC Tail Length 1 to 128 ms */
    XPARMID_NET_AECNLP,       	/* AEC NLP, 1 - enable, 0 - disable */
    XPARMID_NET_AECFREEZE,    	/* AEC freeze flag, 1 - enable, 0 - disable */
    XPARMID_NET_AECHOWL,      	/* 0 - disable anti-howling,  1-spectra-based HD, 2- energy-based HD */
    XPARMID_NET_AECTD,			/* AEC TD flg, 1 - enable, 0 - disable */
	XPARMID_NET_LSTXDLY,        /* Transmit side LSD delay control*/
    XPARMID_NET_LSRXDLY,        	/* Receive side LSD delay control*/
} XParmIdNet_t;

/* DEC parameter IDs */
typedef enum{
    XPARMID_DEC_VOL             /* Decoder volume adjustment level */
        = XPARMID_RES_STATE + 1,
    XPARMID_DEC_ALC,            /* ALC flag, 1 - enable, 0 - disable */
    XPARMID_DEC_CNG,            /* CNG flag, 1 - enable, 0 - disable */
    XPARMID_DEC_CTYPE,          /* codec type */
    XPARMID_DEC_EVT_PKT,        /* packet-loss report, 1 - enable, 0 - disable */
    XPARMID_DEC_EVT_PKTCHNG,    /* report payload type change, 1 - enable, 0 - disable */
    XPARMID_DEC_AUTOSW,         /* Auto coder switch mask, Or'd bits */
    XPARMID_DEC_JB_MAXDLY,      /* jitter buffer maximum delay (0 ~ 300 ms) */
    XPARMID_DEC_JB_PLR,         /* jitter buffer packet loss rate */
    XPARMID_DEC_JB_MODE,        /* jitter buffer mode 0: Static, 1: Histogram 2: RFC1889 */
    XPARMID_DEC_G726_40_RTP_PLD,/* RTP payload type for G.726-40 */
    XPARMID_DEC_G726_32_RTP_PLD,/* RTP payload type for G.726-32 */
    XPARMID_DEC_G726_24_RTP_PLD,/* RTP payload type for G.726-24 */
    XPARMID_DEC_G726_16_RTP_PLD,/* RTP payload type for G.726-16 */
    XPARMID_DEC_G726_PACK,      /* G.726 packing format */
	XPARMID_DEC_G729_1_RTP_PLD, /* RTP payload type for G.729.1 */
    XPARMID_DEC_G722_64_RTP_PLD,/* RTP payload type for G.722-64 */
    XPARMID_DEC_G722_56_RTP_PLD,/* RTP payload type for G.722-56 */
    XPARMID_DEC_G722_48_RTP_PLD,/* RTP payload type for G.722-48 */
} XParmIdDec_t;

/* ENC parameter IDs */
typedef enum{
    XPARMID_ENC_LP_STREAM       /* L-Port stream */
        = XPARMID_RES_STATE + 1,
    XPARMID_ENC_AGC,            /* AGC flag, 1 - enable, 0 - disable */
    XPARMID_ENC_VAD,            /* VAD flag, 1 - enable, 0 - disable */
    XPARMID_ENC_CTYPE,          /* codec type */
    XPARMID_ENC_MFPP,           /* number of frames per packet */
    XPARMID_ENC_EVT_PKT,        /* packet-loss report, 1 - enable, 0 - disable */
    XPARMID_ENC_G723_RATE,      /* G723 encoding rate either 5.3k or 6.3k */
    XPARMID_ENC_G726_40_RTP_PLD,/* RTP payload type for G.726-40 */
    XPARMID_ENC_G726_32_RTP_PLD,/* RTP payload type for G.726-32 */
    XPARMID_ENC_G726_24_RTP_PLD,/* RTP payload type for G.726-24 */
    XPARMID_ENC_G726_16_RTP_PLD,/* RTP payload type for G.726-16 */
    XPARMID_ENC_G726_PACK,      /* G.726 packing format */
    XPARMID_ENC_VOL,            /* volume adjustment */
	XPARMID_ENC_G729_1_RTP_PLD, /* RTP payload type for G.729.1 */
	XPARMID_ENC_G729_1_RATE,      /* G729.1 encoding rate */
    XPARMID_ENC_G722_64_RTP_PLD,/* RTP payload type for G.722-64 */
    XPARMID_ENC_G722_56_RTP_PLD,/* RTP payload type for G.722-56 */
    XPARMID_ENC_G722_48_RTP_PLD,/* RTP payload type for G.722-48 */
 } XParmIdEnc_t;

/* TG parameter IDs */
typedef enum{
    XPARMID_TNGEN_VOL           /* volume adjustment */
        = XPARMID_RES_STATE + 1,
    XPARMID_TNGEN_FSK_MOD,      /* V.23 or Bellcore 202 */
    XPARMID_TNGEN_FSK_CS,       /* CS bit length */
    XPARMID_TNGEN_FSK_MARK,     /* MARK bit length */
    XPARMID_TNGEN_FSK_RATE,     /* Baud rate */
    XPARMID_TNGEN_RFC2833,      /* RFC2833 flag, 1 - enable, 0 - disable */
    XPARMID_TNGEN_FSK_POSTMK    /* post mark bit length */
} XParmIdTG_t;

/* TD parameter IDs */
typedef enum{
    XPARMID_TD_LP_STREAM            /* L-Port stream */
        = XPARMID_RES_STATE + 1,
    XPARMID_TD_TC,                  /* Tone clamping flag, 1 - enable, 0 - disable */
    XPARMID_TD_TC_FRAMES,           /* Number of frames to buffer in TC buffer */
    XPARMID_TD_RPT_EVENTS,          /* report event, 0-disable, 1-tone_on, 2-tone_off,
                                       3-both on & off */
    XPARMID_TD_RFC2833E_ENABLE,     /* RFC2833E flag, 1 - enable, 0 - disable */
    XPARMID_TD_RFC2833E_UPDATERATE, /* Update rate of RFC2833 pkts. (in 10-ms units) */
    XPARMID_TD_RFC2833E_NUMEOE,     /* End of Event Redundancy. */
    XPARMID_TD_RFC2833E_NUMBOE,     /* Begin of Event Redundancy. */
    XPARMID_TD_RFC2833E_AUDIOSUPRESS,/* Suppress encoder when sending RFC2833 RTP packets
                                        0-disabled, 1-enabled */
    XPARMID_TD_RFC2833E_PAYLOADTYPE, /* RFC2833 payload type */
    XPARMID_TD_FSK_CS,               /* minimum CS-bit length required by FSK receiver */
    XPARMID_TD_FSK_MARK,             /* minimum mark-bit length required by FSK receiver */
    XPARMID_TD_FSK_STOP,             /* extra stop-bit length allowed between the data */
    XPARMID_TD_FSK_RATE,             /* FSK receiver Baud rate,  */
    XPARMID_TD_FSK_ADAPT_THRESHOLD,  /* FSK detector with adaptive or non-adaptive threshold */
    XPARMID_TD_FSK_RX_MIN_BYTES      /* Minimum number of bytes to be received by the FSK detector */
} XParmIdTD_t;

/* Mixer parameters IDs */
typedef enum{
    XPARMID_MIX_LP_STREAM           /* L-Port stream */
        = XPARMID_RES_STATE + 1,
} XParmIdMix_t;

/* Player parameters IDs */
typedef enum{
    XPARMID_PLY_VOL                 /* Volume control in dB */
        = XPARMID_RES_STATE + 1,
} XParmIdPlay_t;

/* T38 parameter IDs */
typedef enum{
    XPARMID_T38_ELLIPSIS         /* Ellipsis flag, 0-disable, 1-enable */
        = XPARMID_RES_STATE + 1,
    XPARMID_T38_FEC,            /* FEC flag, 0-disable, 0-enable */
    XPARMID_T38_REDUNDANCY,     /* redundancy level 0~7 */
    XPARMID_T38_RATE_NEG,       /* modem rate negotiation, 0:local, 1:end-to-end */
    XPARMID_T38_TCF_THRSHLD,    /* TCF error threshold in percentage */
    XPARMID_T38_TRANSPORT,      /* packet transport, 0-UDP, 1:TCP */
    XPARMID_T38_MODE,           /* mode, 0:ITU-T.38, 1:China-T.38 */
    XPARMID_T38_DISCONNECT,	/* Enable/disable generation of China T.38 disconnect messages */	
    XPARMID_T38_FEC_NMESSAGES,	/* Number of FEC messages per packet. */
    XPARMID_T38_FEC_NPACKETS    /* No.of packets per FEC message */
} XParmIdT38_t;

/* Message Agent parameters IDs */
typedef enum{
    XPARMID_MA_DEBUG            /* enable debug prints */
        = XPARMID_RES_STATE + 1,
} XParmIdMa_t;


/* Message type definitions */
typedef enum{
    XMSG_BEGIN = 0,         /* Begin list */
    XMSG_RESET,             /* reset a SP resource */
    XMSG_START,             /* start action,processing,algorithm on a SP resource */
    XMSG_STOP,              /* stop a current action on a SP resource */
    XMSG_PING,              /* ping a SP resource */
    XMSG_SET_PARM,          /* set a parameter on a SP resource */
    XMSG_SET_MPARMS,        /* set multiple parameters on a SP resource */
    XMSG_GET_PARM,          /* get a parameter from a SP resource */
    XMSG_GET_PARM_ACK,      /* acknowledgement to get parameter message */
    XMSG_GET_ALLPARMS,      /* get all parameters from a SP resource */
    XMSG_GET_ALLPARMS_ACK,  /* acknowledgement to get all parameter message */
    XMSG_ACK,               /* general acknowledgement message */
    XMSG_ERROR,             /* error message from SP resource */
    XMSG_EVENT,             /* event message from SP resource */
    XMSG_CODER_START,       /* start a codec resource */
    XMSG_CODER_STOP_ACK,    /* acknowledgement to stop message */
    XMSG_TG_PLAY,           /* play a digit string on a instance */
    XMSG_TG_PLAY_FSK,       /* play FSK modulated data */
    XMSG_TG_PLAY_CMPLT,     /* play-completed message from a instance */
    XMSG_TD_RCV,            /* receive a digit string on a instance */
    XMSG_TD_RCV_CMPLT,      /* receive-completed message from a instance */
    XMSG_TD_RCV_FSK,        /* receive a FSK signal on a instance */
    XMSG_TD_RCV_FSK_CMPLT,  /* receive-completed message from a instance */
    XMSG_PLY_START,         /* start playing audio */
    XMSG_PLY_CMPLT,         /* play complete */
    XMSG_GET_JBSTAT,        /* get jitter buffer statistics from decoder instance */
    XMSG_GET_JBSTAT_CMPLT,  /* response to the get-statistics message */
    XMSG_T38_START,         /* start T.38 resource */
    XMSG_T38_CMPLT,         /* T.38 session complete message */
    /*--------------Definition for internal messages -------------*/
    XMSG_STATE_FWD,         /* state forward message */
    XMSG_END_OF_LIST        /* end of list */
} XMsgType_t;


/**** XMSG_RESET *****/
typedef struct{
    XMsgHdr_t   head;   /* message header */
} XMsgReset_t;


#define XMSG_MAKE_RESET(pMsg, trans, res, inst) \
    {\
      XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgReset_t), XMSG_RESET, 0)\
    }

/**** XMSG_START *****/
typedef struct{
    XMsgHdr_t   head;    /* message header */
} XMsgStart_t;

#define XMSG_MAKE_START(pMsg, trans, res, inst)\
   {\
      XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgStart_t), XMSG_START, 0)\
   }


/**** XMSG_STOP *****/
typedef struct{
    XMsgHdr_t   head;   /* message header */
} XMsgStop_t;


#define XMSG_MAKE_STOP(pMsg, trans, res, inst)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgStop_t), XMSG_STOP, 0)\
    }


/**** XMSG_PING *****/
typedef struct{
    XMsgHdr_t   head;   /* message header */
} XMsgPing_t;


#define XMSG_MAKE_PING(pMsg, trans, res, inst) \
    {\
        XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgPing_t), XMSG_PING, 0)\
    }


/**** XMSG_SET_PARM *****/
typedef struct{
    XMsgHdr_t   head;       /* message header */
    UINT16      parmId;     /* parameter id */
    UINT16      value;      /* parameter value */
} XMsgSetParm_t;


#define XMSG_MAKE_SET_PARM(pMsg, trans, res, inst, id, val) \
    {\
        XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgSetParm_t), XMSG_SET_PARM, 0)\
        ((XMsgSetParm_t *)(pMsg))->parmId   = id;\
        ((XMsgSetParm_t *)(pMsg))->value    = val;\
    }


/**** XMSG_SET_MPARMS *****/
typedef struct{
    XMsgHdr_t   head;                       /* message header */
    UINT16      numParms;                   /* number of parameters */
    UINT16      parmIDs[XMAX_PARMS_SET];        /* parameter id */
    UINT16      values[XMAX_PARMS_SET];         /* parameter value */
} XMsgSetmParms_t;


#define XMSG_MAKE_SET_MPARMS(pMsg, trans, res, inst, num) \
    {\
        XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgSetmParms_t), XMSG_SET_MPARMS, 0)\
        ((XMsgSetmParms_t *)(pMsg))->numParms = num; \
    }

#define XMSG_FIELD_SET_MPARMS(pMsg, pIDs, pVals) \
    {\
        pIDs    = ((XMsgSetmParms_t *)(pMsg))->parmIDs;\
        pVals   = ((XMsgSetmParms_t *)(pMsg))->values;\
    }


/**** XMSG_GET_PARM *****/
typedef struct{
    XMsgHdr_t   head;       /* message header */
    UINT16      parmId;     /* parameter id */
} XMsgGetParm_t;


#define XMSG_MAKE_GET_PARM(pMsg, trans, res, inst, id) \
    {\
      XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgGetParm_t), XMSG_GET_PARM, 0)\
        ((XMsgGetParm_t *)(pMsg))->parmId= id;\
    }


/**** XMSG_GET_PARM_ACK *****/
typedef struct{
    XMsgHdr_t   head;           /* message header */
    UINT16      parmId;         /* parameter id */
    UINT16      value;          /* parameter value */
} XMsgGetParmAck_t;


#define XMSG_FIELD_GET_PARM_ACK(pMsg, id, val)\
    {\
        id  = ((XMsgGetParmAck_t *)(pMsg))->parmId;\
        val = ((XMsgGetParmAck_t *)(pMsg))->value;\
    }


/**** XMSG_GET_ALLPARMS *****/
typedef struct{
    XMsgHdr_t   head;       /* message header */
} XMsgGetAllParms_t;


#define XMSG_MAKE_GET_ALLPARMS(pMsg, trans, res, inst) \
    {\
      XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgGetAllParms_t), XMSG_GET_ALLPARMS, 0)\
    }

/**** XMSG_GET_ALLPARMS_ACK *****/
typedef struct{
    XMsgHdr_t   head;                       /* message header */
    UINT16      numParms;                   /* number of parameters */
    UINT16      parmIDs[XMAX_PARMS_GET];    /* array of parameter IDs */
    UINT16      values[XMAX_PARMS_GET];     /* array of parameter values */
} XMsgGetAllParmsAck_t;


#define XMSG_FIELD_GET_ALLPARMS_ACK(pMsg, num, pIDs, pVals)\
    {\
        num = ((XMsgGetAllParmsAck_t *)(pMsg))->numParms;\
        pIDs = ((XMsgGetAllParmsAck_t *)(pMsg))->parmIDs;\
        pVals = ((XMsgGetAllParmsAck_t *)(pMsg))->values;\
    }

/**** XMSG_ACK *****/
typedef struct{
    XMsgHdr_t   head;       /* message header */
} XMsgAck_t;


/**** XMSG_ERROR *****/
typedef struct{
    XMsgHdr_t   head;   /* message header */
    UINT32      code;   /* error code */
    UINT32      data1;  /* error data1 */
    UINT32      data2;  /* error data2 */
} XMsgError_t;


#define XMSG_FIELD_ERROR(pMsg, c, d1, d2)\
    {\
        c = ((XMsgError_t *)(pMsg))->code;\
        d1 = ((XMsgError_t *)(pMsg))->data1;\
        d2 = ((XMsgError_t *)(pMsg))->data2;\
    }


/**** XMSG_EVENT *****/
typedef struct{
    XMsgHdr_t   head;       /* message header */
    UINT32      code;       /* event code (type). */
    UINT32      data1;      /* event data1. Meaning defined by the component. */
    UINT32      data2;      /* event data2. Meaning defined by the component. */
} XMsgEvent_t;


#define XMSG_MAKE_EVENT(pMsg, trans, res, inst, c, d1, d2)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgEvent_t), XMSG_EVENT, 0)\
        ((XMsgEvent_t *)(pMsg))->code = c;\
        ((XMsgEvent_t *)(pMsg))->data1 = d1;\
        ((XMsgEvent_t *)(pMsg))->data2 = d2;\
    }


#define XMSG_FIELD_EVENT(pMsg, c, d1, d2)\
    {\
        c = ((XMsgEvent_t *)(pMsg))->code;\
        d1 = ((XMsgEvent_t *)(pMsg))->data1;\
        d2 = ((XMsgEvent_t *)(pMsg))->data2;\
    }


/**** XMSG_CODER_START *****/
typedef struct{
    XMsgHdr_t   head;               /* message header */
    UINT16      codecType;          /* codec type */
    UINT16      frmsPerPkt;         /* number of frames per packet */
} XMsgCoderStart_t;

#define XMSG_MAKE_CODER_START(pMsg, trans, res,  inst, cType, fpp)\
    {\
      XMSG_MAKE_HEAD(pMsg, trans, res, inst, sizeof(XMsgCoderStart_t), XMSG_CODER_START, 0)\
      ((XMsgCoderStart_t *)(pMsg))->codecType = cType;\
      ((XMsgCoderStart_t *)(pMsg))->frmsPerPkt = fpp;\
    }

/**** XMSG_CODER_STOPACK *****/
typedef struct{
    XMsgHdr_t   head;               /* message header */
    UINT32      numFrames;          /* total number of frames processed */
    UINT32      numBadFrames;       /* number of bad frames */
} XMsgCoderStopAck_t;


#define XMSG_FIELD_CODEC_STOP_ACK(pMsg, num, numBad)\
    {\
        num = ((XMsgCoderStopAck_t *)(pMsg))->numFrames;\
        numBad = ((XMsgCoderStopAck_t *)(pMsg))->numBadFrames;\
    }


/**** XMSG_TG_PLAY *****/
typedef struct{
    XMsgHdr_t   head;                       /* message header */
    UINT8       numTones;                   /* number of tones to play */
    UINT8       toneId[XMAX_TONEBUFSIZE];   /* tone ID string */
} XMsgTGPlay_t;


#define XMSG_MAKE_TG_PLAY(pMsg, trans, inst, num)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, XMPR_TNGEN, inst, sizeof(XMsgTGPlay_t), XMSG_TG_PLAY, 0)\
        ((XMsgTGPlay_t *)(pMsg))->numTones = num;\
    }

#define XMSG_FIELD_TG_PLAY(pMsg, pToneID) \
    {\
        pToneID = ((XMsgTGPlay_t *)(pMsg))->toneId;\
    }

/**** XMSG_TG_PLAY_FSK *****/
typedef struct{
    XMsgHdr_t   head;                       /* message header */
    UINT8       numBytes;                   /* number of bytes to play */
    UINT8       data[XMAX_FSKDATASIZE];     /* data string */
} XMsgTGPlayFSK_t;


#define XMSG_MAKE_TG_PLAY_FSK(pMsg, trans, inst, num)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, XMPR_TNGEN, inst, sizeof(XMsgTGPlayFSK_t), XMSG_TG_PLAY_FSK, 0)\
        ((XMsgTGPlayFSK_t *)(pMsg))->numBytes = num;\
    }

#define XMSG_FIELD_TG_PLAY_FSK(pMsg, pData) \
    {\
        pData   = ((XMsgTGPlayFSK_t *)(pMsg))->data;\
    }

/**** XMSG_TG_PLAY_CMPLT *****/
typedef struct{
    XMsgHdr_t   head;           /* message header */
    UINT16      reason;         /* the reason of completion */
    UINT8       numTones;       /* number of tones played */
} XMsgTGPlayCmplt_t;


#define XMSG_FIELD_TG_PLAY_CMPLT(pMsg, rsn, num)\
    {\
        rsn  = ((XMsgTGPlayCmplt_t *)(pMsg))->reason;\
        num = ((XMsgTGPlayCmplt_t *)(pMsg))->numTones;\
    }

/**** XMSG_TD_RCV *****/
typedef struct{
    XMsgHdr_t   head;                   /* message header */
    UINT16      totalTimeout;           /* total time out (in 10 ms unit) */
    UINT16      firstDigitTimeout;      /* first digit time out (10 ms uint)*/
    UINT16      interDigitTimeout;      /* inter digit time out (10 ms unit)*/
    UINT16      termDigit;              /* OR'd terminate digit bits */
    UINT8       numDigits;              /* number of digits to receive */
} XMsgTDRcv_t;


#define XMSG_MAKE_TD_RCV(pMsg, trans, inst, num, term, tm, fstTm, intTm)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, XMPR_TNDET, inst, sizeof(XMsgTDRcv_t), XMSG_TD_RCV, 0)\
        ((XMsgTDRcv_t *)(pMsg))->numDigits = num;\
        ((XMsgTDRcv_t *)(pMsg))->termDigit = term;\
        ((XMsgTDRcv_t *)(pMsg))->totalTimeout = tm;\
        ((XMsgTDRcv_t *)(pMsg))->firstDigitTimeout = fstTm;\
        ((XMsgTDRcv_t *)(pMsg))->interDigitTimeout = intTm;\
    }

/**** XMSG_TD_RCV_CMPLT *****/
typedef struct{
    XMsgHdr_t   head;           /* message header */
    UINT16      reason;         /* the reason of completion */
    UINT8       numDigits;      /* number of tones received */
    UINT8       digits[XMAX_DIGITBUFSIZE];  /* received tone IDs */
} XMsgTDRcvCmplt_t;


#define XMSG_FIELD_TD_RCV_CMPLT(pMsg, rsn, num, pBuf)\
    {\
        rsn = ((XMsgTDRcvCmplt_t *)(pMsg))->reason;\
        num = ((XMsgTDRcvCmplt_t *)(pMsg))->numDigits;\
        pBuf= ((XMsgTDRcvCmplt_t *)(pMsg))->digits;\
    }

/**** XMSG_TD_RCV_FSK *****/
typedef struct{
    XMsgHdr_t   head;                   /* message header */
    UINT16      timeout;                /* total time out (in 10 ms unit) */
} XMsgTDRcvFSK_t;


#define XMSG_MAKE_TD_RCV_FSK(pMsg, trans, inst, tmout)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, XMPR_TNDET, inst, sizeof(XMsgTDRcvFSK_t), XMSG_TD_RCV_FSK, 0)\
        ((XMsgTDRcvFSK_t *)(pMsg))->timeout = tmout;\
    }

/**** XMSG_TD_RCV_FSK_CMPLT *****/
typedef struct{
    XMsgHdr_t   head;           /* message header */
    UINT16      reason;         /* the reason of completion */
    UINT8       numBytes;       /* number of bytes received */
    UINT8       data[XMAX_FSKDATASIZE];  /* received data */
} XMsgTDRcvFskCmplt_t;


#define XMSG_FIELD_TD_RCV_FSK_CMPLT(pMsg, rsn, num, pBuf)\
    {\
        rsn = ((XMsgTDRcvFskCmplt_t *)(pMsg))->reason;\
        num = ((XMsgTDRcvFskCmplt_t *)(pMsg))->numBytes;\
        pBuf= ((XMsgTDRcvFskCmplt_t *)(pMsg))->data;\
    }

/**** Media Descriptor *****/
typedef struct{
    INT32           offset;      /* offset in byte where player starts */
    INT32           length;      /* length to play (in 10ms unit), 0 : till EOD */
    XMediaHandle_t  handle;      /* media storage handle */
    INT16           next;        /* next segment,  XPLY_MEDIA_SEG_EOP : end of play */
} XPlyMediaDesc_t;


/**** XMSG_PLY_START *****/
typedef struct{
    XMsgHdr_t           head;                      /* message header */
    XPlyMediaDesc_t     mediaSeg[XMAX_PLY_SEG];    /* media segments */
    UINT8               numSeg;
} XMsgPlyStart_t;


#define XMSG_MAKE_PLY_START(pMsg, trans, inst, num)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, XMPR_PLY, inst, sizeof(XMsgPlyStart_t), XMSG_PLY_START, 0)\
        ((XMsgPlyStart_t *)(pMsg))->numSeg = num;\
    }

#define XMSG_FIELD_PLY_START(pMsg, pMedia) \
    {\
        pMedia   = ((XMsgPlyStart_t *)(pMsg))->mediaSeg;\
    }

/**** XMSG_PLY_CMPLT *****/
typedef struct{
    XMsgHdr_t   head;           /* message header */
    UINT16      reason;         /* the reason of completion */
} XMsgPlyCmplt_t;

#define XMSG_FIELD_PLY_CMPLT(pMsg, rsn)\
    {\
        rsn = ((XMsgPlyCmplt_t *)(pMsg))->reason;\
    }

/****** XMSG_GET_JBSTAT **********/
typedef struct{
    XMsgHdr_t   head;       /* message header */
    UINT16      reset;      /* reset flag */
} XMsgGetJBStat_t;

#define XMSG_MAKE_GET_JBSTAT(pMsg, trans, inst, clr)\
    {\
        XMSG_MAKE_HEAD(pMsg, trans, XMPR_DEC, inst, sizeof(XMsgGetJBStat_t), XMSG_GET_JBSTAT, 0)\
        ((XMsgGetJBStat_t *)(pMsg))->reset = clr;\
    }

/****** XMSG_GET_JBSTAT_CMPLT **********/
typedef struct{
    UINT32      rcvdPackets;        /* total packets received */
    UINT32      lostPackets;        /* lost packets */
    UINT32      badFrames;          /* decoder bad frames */
    UINT32      rcvdTonePackets;    /* RFC2833 packets */
} XJBStatistics_t;

typedef struct{
    XMsgHdr_t           head;   /* message header */
    XJBStatistics_t     stat;   /* jiter buffer statistics */
} XMsgGetJBStatCmplt_t;

#define XMSG_FIELD_GET_JBSTAT_CMPLT(pMsg, pStat)\
    {\
        pStat = &(((XMsgGetJBStatCmplt_t *)(pMsg))->stat);\
    }

/**** XMSG_T38_START *****/
typedef struct{
    XMsgHdr_t   head;    /* message header */
    UINT16      toneId;  /* fax tone id */
} XMsgT38Start_t;

#define XMSG_MAKE_T38_START(pMsg, trans, inst, tnid)\
   {\
      XMSG_MAKE_HEAD(pMsg, trans, XMPR_T38, inst, sizeof(XMsgT38Start_t), XMSG_T38_START, 0)\
      ((XMsgT38Start_t *)(pMsg))->toneId = tnid;\
   }


/**** XMSG_T38_CMPLT *****/
typedef struct{
    XMsgHdr_t   head;           /* message header */
    UINT16      reason;         /* the reason of completion */
} XMsgT38Cmplt_t;

#define XMSG_FIELD_T38_CMPLT(pMsg, rsn)\
    {\
        rsn = ((XMsgT38Cmplt_t *)(pMsg))->reason;\
    }


/* Define micros for Messsage Agent and user message interface */
#define XMSG_USRMSG_TYPE_BEGIN      XMSG_END_OF_LIST
#define XMSG_USRMSG_TYPE_END        0x70
#define XMSG_USRMSG_MAX_BODY        (XMSG_MAX_SIZE - sizeof(XMsgHdr_t))

#define XMSG_MA_ENCODING_INIT       0
#define XMSG_MA_ENCODING_CMPLT      -1

#define XMSG_MA_MAKE_HEADER(pMsg, trans, typ, siz) \
    XMSG_MAKE_HEAD(pMsg, trans, XMPR_MA, 1, siz, typ, 0)


/* ERROR CODES */
#define XERR_INVALID_CODE_TYPE      0x401       /* invalid codec type */
#define XERR_INVALID_FPP            0x402       /* invalid number of frames per packet */
#define XERR_TG_INVALID_TONE_ID     0x403       /* invalid tone ID */
#define XERR_TG_INVALID_TID_NUM     0x404       /* too many tone IDs */
#define XERR_TG_INVALID_DATA_NUM    0x405       /* too many FSK data */
#define XERR_TD_INVALID_DIGIT_NUM   0x406       /* too many digits */
#define XERR_RESOURCE_BUSY          0x407       /* resource is busy */
#define XERR_RESOURCE_IDLE          0x408       /* resource is busy */
#define XERR_MA_DEEP_RECURSIVE      0x409       /* too deep recursive */
#define XERR_MA_MSG_DECORDER        0x40a       /* message decoding fail */
#define XERR_PLY_INVALID_SEG_NUM    0x40b       /* too many media segment */
#define XERR_PLY_BAD_MEDIA_SEG      0x40c       /* bad media segment */

/* EVENT CODES */
#define XEVT_CODE_TD_TONEON         0x101       /* tone-on event */
#define XEVT_CODE_TD_TONEOFF        0x102       /* tone-off event */
#define XEVT_LOST_PACKET            0x103       /* lost packet */
#define XEVT_DEC_PACKET_CHNG        0x104       /* payload type of packek changed  */
#define XEVT_NET_HOOK_STATE         0x105       /* hook state changes detected by NET */
#define XEVT_NET_TIMER              0x106       /* timer expired */

/**********************************************************************************************/
/*** TD EVENT DATA (i.e. data1 field) for TONEON and TONEOFF                                  */
/*** The data2 field in not applicable.                                                       */
/**********************************************************************************************/
/* tone id definitions. Consistent to RFC 2833 stardard */

#define RFC_TID_DTMF_0      0
#define RFC_TID_DTMF_1      1
#define RFC_TID_DTMF_2      2
#define RFC_TID_DTMF_3      3
#define RFC_TID_DTMF_4      4
#define RFC_TID_DTMF_5      5
#define RFC_TID_DTMF_6      6
#define RFC_TID_DTMF_7      7
#define RFC_TID_DTMF_8      8
#define RFC_TID_DTMF_9      9
#define RFC_TID_DTMF_STAR   10
#define RFC_TID_DTMF_POUND  11
#define RFC_TID_DTMF_A      12
#define RFC_TID_DTMF_B      13
#define RFC_TID_DTMF_C      14
#define RFC_TID_DTMF_D      15

/* Fax tone id for fax bypass */
#define RFC_TID_FAX_CED     32
#define RFC_TID_FAX_CNG     36
#define RFC_TID_FAX_V21     40

#define RFC_CPT_START        64

#define RFC_TID_DIAL         66      /* dial tone */
#define RFC_TID_PBX_DIAL     67      /* PBX dial tone */
#define RFC_TID_SP_DIAL      68      /* special dial tone */
#define RFC_TID_2ND_DIAL     69      /* 2nd dial tone */
#define RFC_TID_RING         70      /* ring tone */
#define RFC_TID_SP_RING      71      /* special ring tone */
#define RFC_TID_BUSY         72      /* busy tone */
#define RFC_TID_CONGESTION   73      /* congestion tone */
#define RFC_TID_SP_INFO      74      /* special information tone */
#define RFC_TID_COMFORT      75      /* comfort tone */
#define RFC_TID_HOLD         76      /* hold tone */
#define RFC_TID_REC          77      /* record tone */
#define RFC_TID_CALLER_WT    78      /* caller waiting tone */
#define RFC_TID_CALL_WT      79      /* call waiting tone */
#define RFC_TID_PAY          80      /* pay tone */
#define RFC_TID_POS_IND      81      /* positive indication tone */
#define RFC_TID_NEG_IND      82      /* negtive indication tone */
#define RFC_TID_WARNING      83      /* warning tone */
#define RFC_TID_INSTRUSION   84      /* instrusion tone */
#define RFC_TID_CAL_CARD     85      /* calling card service tone */
#define RFC_TID_PAYPHONE     86      /* payphone recognition tone */
#define RFC_TID_CAS          87      /* CPE alerting signal */
#define RFC_TID_OFFHK_WARN   88      /* Off-hook warning tone */
#define RFC_TID_CONFIRMATION 97      /* confirmation tone */
#define RFC_TID_THR_PARTY    99      /* three party remind tone */
#define RFC_TID_UNAVAILABLE  102     /* number-unavailable tone */
#define RFC_TID_QUEUE        106     /* quene tone */


/*-------------- data structures and functions of packet interface --------- */

#define XMAX_PAYLOAD_SIZE           1024
#define XMAX_ENCODED_FRAME_SIZE     80
#define XMAX_FRAMES_PER_PACKET      24

/* RTP media type */
#define RTP_MD_TYPE_AUDIO                       0x1
#define RTP_MD_TYPE_RFC2833_EVENT               0x2
#define RTP_MD_TYPE_RFC2833_TONE                0x4
#define RTP_MD_TYPE_T38                         0x8

/* RTP payload type */
#define RTP_PLD_TYPE_PCMU           0
#define RTP_PLD_TYPE_G726_32        2
#define RTP_PLD_TYPE_GSM            3
#define RTP_PLD_TYPE_G723           4
#define RTP_PLD_TYPE_DVI4           5
#define RTP_PLD_TYPE_LPC            7
#define RTP_PLD_TYPE_PCMA           8
#define RTP_PLD_TYPE_G722           9
#define RTP_PLD_TYPE_QCELP          12
#define RTP_PLD_TYPE_SID            13
#define RTP_PLD_TYPE_G728           15
#define RTP_PLD_TYPE_G729           18
#define RTP_PLD_TYPE_DYNAMIC96      96
#define RTP_PLD_TYPE_DYNAMIC97      97
#define RTP_PLD_TYPE_DYNAMIC98      98
#define RTP_PLD_TYPE_DYNAMIC99      99
#define RTP_PLD_TYPE_DYNAMIC100     100

/* those two are our definition */
#define RTP_PLD_TYPE_PASSTHRU       0x7f
#define RTP_PLD_TYPE_NULL           0xff
#define RTP_PLD_TYPE_DYNAMIC        RTP_PLD_TYPE_NULL

#define RTP_PLD_END_OF_SIL_BIT      0x80

/* define the packet header */
#ifdef  __ghs__
#pragma pack(1)
#endif
typedef struct{
    UINT8           channelID;          /* channel ID */
    UINT8           payloadType;        /* bit[0-6] payload type, bit[7] SID mark bit */
    unsigned int    mediaType:4;        /* media type */
    unsigned int    payloadLen:12;      /* payload length */
    UINT32          timeStamp;          /* local or remote time stamp */
#ifdef __GNUC__
} __attribute__ ((packed)) XPacketHeader_t;
#endif
#ifdef __ghs__
} XPacketHeader_t;
#pragma pack()
#endif

#ifdef  __ghs__
#pragma pack(1)
#endif
typedef struct{
    UINT8           channelID;          /* channel ID */
    UINT8           payloadType;        /* bit[0-6] payload type, bit[7] SID mark bit */
    unsigned int    mediaType:4;        /* media type */
    unsigned int    payloadLen:12;      /* payload length */
    UINT32          timeStamp;          /* local or remote time stamp */
    UINT8           payload[XMAX_PAYLOAD_SIZE];     /* payload */
#ifdef __GNUC__
} __attribute__ ((packed)) XPacket_t;
#endif
#ifdef __ghs__
} XPacket_t;
#pragma pack()
#endif

#ifdef __ghs__
#pragma pack(1)
#endif
typedef struct{
    UINT8           channelID;          /* channel ID */
    UINT8           payloadType;        /* bit[0-6] payload type, bit[7] SID mark bit */
    unsigned int    mediaType:4;        /* media type */
    unsigned int    payloadLen:12;      /* payload length */
    UINT32          timeStamp;          /* local or remote time stamp */
    UINT8           payload[XMAX_TONE_SIZE];        /* payload */
#ifdef __GNUC__
} __attribute__ ((packed)) IX_2833PKT;
#endif
#ifdef __ghs__
} IX_2833PKT;
#pragma pack()
#endif

/* cache prompt description */
typedef struct{
    UINT8        *pBuffer;
    INT32        size;
    XCoderType_t type;
} XCachePromptDesc_t;

typedef XStatus_t (*XPktRcvFxn_t)(UINT16 channel, XPacket_t *pPacket);
XStatus_t xPacketReceive(UINT16 channel, XPacket_t *buffer);

typedef int (*XMsgAgentDec_t)(XMsgRef_t pUsrMsg, XMsgRef_t pNativeMsg, int sequenceNo);
typedef void (*XMsgAgentEnc_t)(XMsgRef_t pUsrReply, XMsgRef_t pNativeReply, int sequenceNo, UINT8 usrMsgType);

XStatus_t xFlashHookDetect(UINT16 channel, XHookState_t hookState, UINT32 transId);
XStatus_t xDspParmRead(UINT8 res, UINT16 inst, UINT16 parmId, UINT16 *pParmVal);
XStatus_t xDspParmWrite(UINT8 res, UINT16 inst, UINT16 parmId, UINT16 parmVal, UINT32 trans);
XStatus_t xGetJBStat(UINT16 channel, XJBStatistics_t *pStat, int reset);
XStatus_t xDspPlugInParmRead(UINT8 res, UINT16 inst,UINT16 algType, UINT16 parmId, UINT32 *pParmVal);
XStatus_t xDspPlugInParmWrite(UINT8 res, UINT16 inst,UINT16 algType, UINT16 parmId, UINT32 ParmVal);
XMediaHandle_t xDspRegCachePrompt(XCachePromptDesc_t *pDesc);
char *xDspGetVersion(void );

#endif
