/******************************************************************************
*       @file	dsptone.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef __dsptone_h
#define __dsptone_h

/* ================================================== */
/* Dynamic Tone Generation Template Configuration API */
/* ================================================== */

#define XTG_LASTSEG  0x7F       /* the last segment */

#define XTG_MODE_OVERWRITE  1   /* replaces/overwrites decoder output. */
#define XTG_MODE_MIX        2   /* sums/mixes with decoder output. */

#define XTG_SINGLETONE      1   /* Single tone generation segment type. */
#define XTG_DUALTONE        2   /* Dual tone generation segement type. */
#define XTG_AMTONE          3   /* Amp Modulation tone generation segment type. */

/* Error code defintions. */
#define XTG_ERR_INVALID_TONEID      0x1
#define XTG_ERR_SEGS_EXHAUSTED      0x2
#define XTG_ERR_INVALID_SEG         0x3

/* Tone catergory */
#define XTONE_CATEGORY_DTMF        0
#define XTONE_CATEGORY_FAX         1

/* segment data for tone generation template. */
typedef struct {
    UINT16  repCount;     /* Number of repeating the segment.
                            0 means to repeate forever */
    UINT16  segType;      /* signal type (single, dual or AM tone ) */
    UINT32  durationOn;   /* tone on duration in milli seconds. */
    UINT32  durationOff;  /* tone off duration in milli seconds. */
    INT16   freqA;        /* the frequence in Hz */
    INT16   freqB;        /* the 2nd frequence in Hz if dual or AM tone,
                             ignored if single tone */
    INT16   ampA;         /* amplitude of A signal in dBm */
    INT16   ampB;         /* amplitude of B signal in dBm if dual tone,
                             modulation rate in percentage if AM tone,
                             ignored if single tone */
    UINT16  mode;         /* mode, overwrite or mix over the decoder outupt */
    INT16   nextSeg;      /* the index of next segment relative to the
                             current segement. e.g., 1 means to go the following
                             segment, 0 means repeat the current segment,
                             -2 means go back to previous 2 segments.
                             XTG_LASTSEG means the last segment */
} XTGToneSeg_t;


/* API to build tone for generating purpose. */
/* Return XSUCC in pass case and XERROR in fail case. */
XStatus_t xBuildToneTG(UINT16       toneId,     /* tone id as input */
                       UINT16       numSegs,    /* number of segments */
                       XTGToneSeg_t *pToneSegs, /* array of segment data. */
                       UINT32       *pErrCode); /* error code if failure. */

/* API to change the DTMF tone parameters for tone generator */
XStatus_t xSetTGParmDTMF(int toneOn,    /* tone on duration in ms */
                         int toneOff,   /* tone off duration in ms */
                         int ampdBm);   /* tone level in dBm */


/* ================================================== */
/* Dynamic Tone Detection Template Configuration API  */
/* ================================================== */

/* Qualification Criteria. */
#define XTD_QUAL_CRITERIA_LOOSE     1
#define XTD_QUAL_CRITERIA_MEDIUM    2
#define XTD_QUAL_CRITERIA_TIGHT     3

/* Tone Attibutes */
/* Qualification Criteria. */
#define XTD_TONEATTR_EVTON       1
#define XTD_TONEATTR_EVTOFF      2
#define XTD_TONEATTR_EVTBOTH     (XTD_TONEATTR_EVTON|XTD_TONEATTR_EVTOFF)

/* Error code defintions. */
#define XTD_ERR_DUPLICATE_TONEID    0x1
#define XTD_ERR_TONES_EXHAUSTED     0x2
#define XTD_ERR_INVALID_TONEINFO    0x3

/* the type of tones detected. */
#define  XTD_SINGLETONE  1  /* Single tone detection. */
#define  XTD_DUALTONE    2  /* Dual tone detection. */

/* segment data for tone generation template. */
typedef struct {
    UINT16          type;           /* single or dual frequency tone */
    UINT16          criteria;       /* loose, medium or tight */
    UINT16          freqLowA;       /* low bound of the 1st frequency in Hz */
    UINT16          freqHighA;      /* high bound of the 1st frequency in Hz */
    UINT16          freqLowB;       /* low bound of the 2nd frequency in Hz */
    UINT16          freqHighB;      /* high bound of the 2nd frequency in Hz */
    INT16           ampLowA;        /* low level of the 1st frequency in dBm */
    INT16           ampHighA;       /* high level of the 1st frequency in dBm */
    INT16           ampLowB;        /* low level of the 2nd frequency in dBm */
    INT16           ampHighB;       /* high level of the 2nd frequency in dBm */
    UINT8           attributes;     /* attribute (how to report the tone) */
} XTDToneInfo_t;


/* API to build tone for detection purpose. */
/* Return XSUCC in pass case and XERROR in fail case. */
XStatus_t xBuildToneTD(UINT8           toneId,
                       XTDToneInfo_t  *pToneInfo, /* Input tone info */
                       UINT32         *pErrCode); /* error code if failure. */

/* set TD amplitude range check, +3 ~ -60 dBm */
XStatus_t xSetAmplitudeRangeTD(int category, int ampMinF0, int ampMaxF0, int ampMinF1, int ampMaxF1);

#endif
