/******************************************************************************
*       @file	msgdef.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef _MSG_DEF_H_
#define _MSG_DEF_H_

#include <FWTypes.h>

#ifdef _FW_h_
#include <ossl.h>
#else

XStatus_t xMsgSend(void *pMsgBuf);
XStatus_t xMsgReceive(void *pMsgBuf, UINT16 channel, int timeout);
XStatus_t xMsgWrite(void *pMsgBuf);

/* xMsgRead() is only used internally and should never be
 * called by user's applications */
XStatus_t xMsgRead(void *pMsgBuf, int timeout);

#define XWAIT_NONE              NO_WAIT
#define XWAIT_FOREVER           WAIT_FOREVER
#define XOS_SUCC                OK
#define XOS_ERROR               ERROR

#endif

#define XMSG_MAX_SIZE           192
#define XMSG_MAX_WSIZE          XMSG_MAX_SIZE/4

#define XMSG_CLASS_INTERNAL     0x80
#define XINVALID_INST           ((UINT16)0xffff)


typedef struct{
    UINT32  transactionId;  /* used by apps to track the message */
    UINT16  instance;       /* instance ID (1-0xffff), 0:reserved */
    UINT8   resource;       /* MPR resource type */
    UINT8   reserved;       /* reserved for future */
    UINT16  size;           /* total size in bytes */
    UINT8   type;           /* message type */
    UINT8   attribute;      /* attribute, reserved for future */
} XMsgHdr_t, *XMsgRef_t;



#define XMSG_MAKE_HEAD(pMsg, trans, res, inst, sz, typ, attr) \
      ((XMsgRef_t)(pMsg))->transactionId = (trans);\
      ((XMsgRef_t)(pMsg))->instance      = (inst);\
      ((XMsgRef_t)(pMsg))->resource      = (res);\
      ((XMsgRef_t)(pMsg))->reserved      = 0;\
      ((XMsgRef_t)(pMsg))->size          = (sz);\
      ((XMsgRef_t)(pMsg))->type          = (typ);\
      ((XMsgRef_t)(pMsg))->attribute     = (attr);



#endif
