/******************************************************************************
*       @file	usc_ec.h
* -- Intel Copyright Notice --
* 
* Copyright (c) 2002-2008 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents
* related to the source code ("Material") are owned by Intel Corporation
* or its suppliers or licensors.  Title to the Material remains with
* Intel Corporation or its suppliers and licensors. The software is licensed under 
* IXA SDK license.
* 
* The Material is protected by worldwide copyright and trade secret laws
* and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted,
* distributed, or disclosed in any way except in accordance with the
* applicable license agreement .
* 
* No license under any patent, copyright, trade secret or other
* intellectual property right is granted to or conferred upon you by
* disclosure or delivery of the Materials, either expressly, by
* implication, inducement, estoppel, except in accordance with the
* applicable license agreement.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or
* alter this notice or any other notice embedded in Materials by Intel
* or Intel's suppliers or licensors in any way.
* 
* For further details, please see the file README.TXT distributed with
* this software.
* 
* -- End Intel Copyright Notice --
* 
******************************************************************************/

#ifndef __USC_EC_H__
#define __USC_EC_H__
#include "usc_base.h"

typedef enum {
   EC_SUBBAND     = 0,
   EC_FULLBAND    = 1,
   EC_FASTSUBBAND = 2
} USC_EC_Algs;

typedef enum {
    AD_OFF = 0,       /*            - no adaptation*/
    AD_FULLADAPT = 1, /*   -  full adaptation */
    AD_LITEADAPT = 2  /*     - lite adaptation*/
} USC_AdaptType;
typedef enum op_code {
    EC_COEFFS_ZERO = 0,
    EC_ADAPTATION_ENABLE,
    EC_ADAPTATION_ENABLE_LITE,
    EC_ADAPTATION_DISABLE,
    EC_ADAPTATION_DISABLE_LITE,
    EC_NLP_ENABLE,
    EC_NLP_DISABLE,
    EC_TD_ENABLE,
    EC_TD_DISABLE,
    EC_AH_ENABLE1, /* Enable AH, Howling Detector mode 1 - spectra based*/
    EC_AH_ENABLE2, /* Enable AH, HD mode 2 - energy based*/
    EC_AH_DISABLE,
    EC_ALG1
} ECOpcode;

typedef enum ah_op_code_enum {
    AH_ENABLE= 0,
    AH_DISABLE,
    AH_ENABLE1,
    AH_ENABLE2,
} AHOpcode;

/* USC echo canceller modes */
typedef struct {
   USC_AdaptType adapt;      /* 0 - disable adaptation, 1 - enable full adaptation, 2 - enable lite adaptation  */
   int           zeroCoeff;  /* 0 - no zero coeffs of filters, 1 - zero coeffs of filters  */
   int           nlp;        /* 0 - disable NLP, 1 - enable NLP */
   int           nr;         /* 0 - 100 dB noise to be reduced */
   int           il;         /* 0 - 100 insertion loss to be done */
   int           td;         /* 0 - disable ToneDisabler, 1 - enable ToneDisabler */
   int           ah;         /* 0 - disable anti-howling,  1-spectra-based HD, 2- energy-based HD */
   int           hd_period;  /* The period of obligatory howling suppression when detected*/
   int           freq_shift; /* The value frequency to be shift by */
}USC_EC_Modes;

/* USC echo canceller option */
typedef struct {
   USC_EC_Algs  algType;    /* EC algorithm type */
   USC_PCMType  pcmType;    /* PCM type to support */
   int          echotail;   /* echo tail length value, ms: in range [1, 200] for subband algorithm, [1, 16] for fullband algorithm */
   int          framesize;  /* EC frame size in bytes */
   int          nModes;     /* Number of modes ( actually, supposed to be equal to sizeof(USC_EC_Modes)/sizeof(int) ) */
   USC_EC_Modes modes;      /* EC modes*/
}USC_EC_Option;

/* USC echo canceller information */
typedef struct {
   const char     *name;     /* codec name */
   int             nPcmTypes;
   USC_PCMType    *pPcmTypesTbl; /* supported PCMs lookup table */
   USC_EC_Option   params;    /*options supported by the EC type or the current options of an instance*/
}USC_EC_Info;

typedef struct {
    USC_baseFxns std;
   /*   CancelEcho()
        pSin - pointer to send-in PCM data [input]
        pSin - pointer to receive-in PCM data [input]
        pSin - pointer to send-out PCM data [output]
    */
    USC_Status (*CancelEcho)(USC_Handle handle, short *pSin, short *pRin, short *pSout);
} USC_EC_Fxns;

#endif /* __USC_EC_H__ */
