' Obtains Serial Number from USBC and then uses it to set static IP address on USBC Network Adapter
'
' INTEL CONFIDENTIAL
' Copyright 2008 Intel Corporation All Rights Reserved.

' The source code contained or described herein and all documents related to the source code ("Material")
' are owned by Intel Corporation or its suppliers or licensors. Title to the Material remains with Intel 
' Corporation or its suppliers and licensors. The Material contains trade secrets and proprietary and 
' confidential information of Intel or its suppliers and licensors. The Material is protected by worldwide 
' copyright and trade secret laws and treaty provisions. No part of the Material may be used, copied, 
' reproduced, modified, published, uploaded, posted, transmitted, distributed, or disclosed in any way 
' without Intels prior express written permission.

' No license under any patent, copyright, trade secret or other intellectual property right is granted
' to or conferred upon you by disclosure or delivery of the Materials, either expressly, by implication, 
' inducement, estoppel or otherwise. Any license under such intellectual property rights must be express
' and approved by Intel in writing.
'

' Configuration
strComputer = "."
strSerialNumber = "192.168.0.0"
strSubnetMask = "255.255.255.0"
strNetworkAddress = "001517710000"
Const HKEY_LOCAL_MACHINE = &H80000002

' create Shell
Set WshShell = WScript.CreateObject("WScript.Shell")

' create the USBC SerialNumber
Set TypeLib = CreateObject("Scriptlet.TypeLib")
strSerialNumber = TypeLib.Guid
strSerialNumber = Replace(strSerialNumber,"{","")
strSerialNumber = Replace(strSerialNumber,"-","")
strSerialNumber = Replace(strSerialNumber,"}","")
' Truncate the string to 14 characters as some Vista systems change the PnPDeviceId for string longer that 14 characters
strSerialNumber = left(strSerialNumber, 14)


' create NetworkAddress
upperBound = 34810
lowerBound = 1
randomBase = 27392
Randomize
intNetworkAddress = randomBase + Int((upperBound - lowerBound + 1) * Rnd() + lowerBound)
strTempNetAddr = CStr(intNetworkAddress)
' needs to be 12 chars
strNetworkAddress = Mid(strNetworkAddress, 1, len(strNetworkAddress)-len(strTempNetAddr)) & strTempNetAddr


' obtain the registry key to USBC Network adapter
strNetAdapterClassKey = "SYSTEM\CurrentControlSet\Control\Class\{4D36E972-E325-11CE-BFC1-08002BE10318}"
Set objReg = GetObject("winmgmts:{impersonationLevel=impersonate}!\\" & strComputer & "\root\default:StdRegProv")
objReg.EnumKey HKEY_LOCAL_MACHINE, strNetAdapterClassKey, arrSubKeys

For Each Subkey in arrSubKeys
 strDriverDesc = WshShell.RegRead("HKLM\" & strNetAdapterClassKey & "\" & Subkey & "\DriverDesc")
 If strDriverDesc = "Intel(R) USB Client Ethernet Device" Then
   strNetAdapterClassUSBCKey = subKey
   Exit For
 End If
Next


' USBC Registry settings
WshShell.RegWrite "HKLM\" & strNetAdapterClassKey & "\" & strNetAdapterClassUSBCKey & "\SerialNumber", strSerialNumber, "REG_SZ"
WshShell.RegWrite "HKLM\" & strNetAdapterClassKey & "\" & strNetAdapterClassUSBCKey & "\NetworkAddress", strNetworkAddress, "REG_SZ"
WshShell.RegWrite "HKLM\Software\Intel\USBCClientPermStore\SerialNumber", strSerialNumber, "REG_SZ"
WshShell.RegWrite "HKLM\Software\Intel\USBCClientPermStore\NetworkAddress", strNetworkAddress, "REG_SZ"

' restart driver to load the new randomized parameters 
WshShell.Run "embdevhelp.exe restart ""PCI\VEN_8086&DEV_8118""", 0, 1


'  calculate IP fields 3 & 4 and IP Address 
IPField3 = CInt("&H" & Left(strSerialNumber,2))
IPField4 = CInt("&H" & Mid(strSerialNumber,3,2))
strIPAddress = "192.168." & IPField3 & "." & IPField4
strIPPeerAddress = "192.168." & IPField3 & "." & IPField4 + 1

' Network Adapter configuration
arrIPAddress = Array(strIPAddress)
arrSubnetMask = Array(strSubnetMask)

' Enable Static IP on Network Adapter
Set objWmi = GetObject("winmgmts:\\" & strComputer & "\root\cimv2")
Set colNetAdaptersConfig = objWMI.ExecQuery ("Select * from Win32_NetworkAdapterConfiguration where IPEnabled=TRUE and Servicename='USBCCOMP' ")
For Each objNetAdapterConfig in colNetAdaptersConfig
     errEnableStatic = objNetAdapterConfig.EnableStatic(arrIPAddress, arrSubnetMask) 	 
Next


' USBC Registry settings
WshShell.RegWrite "HKLM\SOFTWARE\Intel\USBCClientPermStore\IPAddress", strIPAddress, "REG_SZ"
WshShell.RegWrite "HKLM\SOFTWARE\Intel\USBCClient\InstanceConfig\StaticIP", strIPAddress, "REG_SZ"
WshShell.RegWrite "HKLM\SOFTWARE\Intel\USBCClient\InstanceConfig\PeerIP", strIPPeerAddress, "REG_SZ"
WshShell.RegWrite "HKLM\SOFTWARE\Intel\USBCClient\InstanceConfig\SubnetMask", strSubnetMask, "REG_SZ"

' Delete the Run registry key, RunOnceEx not used because iernonce.dll is needed
WshShell.RegDelete "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run\USBC"
