
/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
*/

/*****************************************************************************
 * Module name:
 *    1588
 *
 * Abstract:
 *    This header file is to be included by the 1588.c file only. 
 *
 * Revision:
 *    TBD
 *
 *****************************************************************************/

#ifndef TS1588_H
#define TS1588_H

#include <ntddk.h>
#include <wdf.h>
#include <initguid.h>
#include <errno.h>
#include <stdio.h>
#include <wdmguid.h>

#include "ixtimesyncacc.h"
#include "win_ioctls.h"

#define DRIVERNAME "1588"

// enumeration of events used
typedef enum _NotifyEvent
{
    TARG_TIME_EVENT_NUM,
    AUX_TIME_EVENT_NUM,
    AUX_TARG_TIME_EVENT_NUM,
    PPS_EVENT_NUM,
    NUM_EVENTS
} NotifyEvent;

// 1588 register states
typedef struct reg_states
{
	unsigned int AmmsInterrupt;
	unsigned int AsmsInterrupt;
	unsigned int TtmInterrupt;
	unsigned int AtmInterrupt;
	unsigned int PpsmInterrupt;
	IxTimeSyncAccTimeValue SystemTime;
	IxTimeSyncAccTimeValue TargetTime;
	IxTimeSyncAccTimeValue AuxTargetTime;
	unsigned int PulsePerSecond;
	unsigned int Addend;
	unsigned int MasterMode[ICP_TIMESYNCACC_1588PORT_INVALID];
	unsigned int MsgTimestamp[ICP_TIMESYNCACC_1588PORT_INVALID];
} reg_states_t;

// private driver data
typedef struct timesync_data
{
    WDFINTERRUPT Interrupt;
    char *pRegs;
    ULONG RegSize;
    WDFDEVICE WdfDevice;
	reg_states_t state;
} timesync_data_t;

WDF_DECLARE_CONTEXT_TYPE(timesync_data_t)

// ioctl call data structures for notify events
IxTimeSyncAccTimeValue gTargTimeIoctl;
IxTimeSyncAccTimeValue gAuxTargTimeIoctl;
IxTimeSyncAccAuxTimeIoctl gAuxTimeIoctl;
UINT32 gPulsePerSecondIoctl;

KEVENT gNotifyEvent[NUM_EVENTS];

// interrupt event flags
UINT32 ixTimeSyncAccEventAmmsFlagGet(void);
UINT32 ixTimeSyncAccEventAsmsFlagGet(void);
UINT32 ixTimeSyncAccEventAtmFlagGet(void);
UINT32 ixTimeSyncAccEventPpsmFlagGet(void);
UINT32 ixTimeSyncAccEventTtmFlagGet(void);

// HAL callback function pointers
IxTimeSyncAccTargetTimeCallback TargetTimeCallbackPtr;
IxTimeSyncAccAuxTimeCallback AuxTimeCallbackPtr;
IxTimeSyncAccAuxTargetTimeCallback AuxTargetTimeCallbackPtr;
IxTimeSyncAccPulsePerSecondCallback PulsePerSecondCallbackPtr;

// HAL callback function prototypes
void TargTimeCallback(IxTimeSyncAccTimeValue targetTime);
void AuxTimeCallback(IxTimeSyncAccAuxMode auxMode, IxTimeSyncAccTimeValue auxTime);
void AuxTargetTimeCallback(IxTimeSyncAccTimeValue auxTargetTime);
void PulsePerSecondCallback(UINT32 pulsePerSecond);

//
// private driver functions
//

void SaveRegState(WDFDEVICE Device);
void RestoreRegState(WDFDEVICE Device);
void DisableInterrupts();
void RestoreInterrupts(WDFDEVICE Device);

//
// Windows Driver Functions
//

NTSTATUS
DriverEntry(IN PDRIVER_OBJECT DriverObject,
	IN PUNICODE_STRING RegistryPath
	);

NTSTATUS
TSEvtDeviceAdd(
	IN WDFDRIVER Driver,
	IN PWDFDEVICE_INIT DeviceInit
	);


VOID
TSEvtIoDeviceControl(
	IN WDFQUEUE Queue,
	IN WDFREQUEST Request,
	IN size_t OutputBufferLength,
	IN size_t InputBufferLength,
	IN ULONG IoControlCode
	);


NTSTATUS
TSEvtDevicePrepareHardware(
	IN WDFDEVICE  Device,
	IN WDFCMRESLIST  ResourcesRaw,
	IN WDFCMRESLIST  ResourcesTranslated
	);

NTSTATUS
TSEvtDeviceReleaseHardware(
	IN WDFDEVICE  Device,
	IN WDFCMRESLIST  ResourcesTranslated
	);

BOOLEAN
TimeSyncIsr(
	IN WDFINTERRUPT  Interrupt,
	IN ULONG  MessageID
	);

NTSTATUS
  TSEvtInterruptEnable(
    IN WDFINTERRUPT  Interrupt,
    IN WDFDEVICE  AssociatedDevice
    );

NTSTATUS
  TSEvtInterruptDisable(
    IN WDFINTERRUPT  Interrupt,
    IN WDFDEVICE  AssociatedDevice
    );

NTSTATUS
  TSEvtDeviceD0Entry(
    IN WDFDEVICE  Device,
    IN WDF_POWER_DEVICE_STATE  PreviousState
    );

NTSTATUS
TSEvtDeviceD0Exit(
    IN  WDFDEVICE Device,
    IN  WDF_POWER_DEVICE_STATE TargetState
    );

NTSTATUS
PCIConfigReadWrite(
    IN PDEVICE_OBJECT DeviceObject,
    IN ULONG          ReadWriteMode, 
    IN PVOID          Buffer,
    IN ULONG          Offset,
    IN ULONG          Length
    );

#endif

