
/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 */

/*****************************************************************************
 * Module name:
 *    1588
 *
 * Abstract:
 *    This header file is to be included by the files which need the 1588
 *    module ioctl commands (1588.c). 
 *
 * Revision:
 *    TBD
 *
 *****************************************************************************/
    
#ifndef WIN_IOCTLS_H
#define WIN_IOCTLS_H

// Device type in user defined range
#define TS_SIOCTL_TYPE 0x8000

//
// 1588 module ioctl command codes
//

#define IOCTL_PORT_CONFIG_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PORT_CONFIG_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_RX_POLL \
    CTL_CODE( TS_SIOCTL_TYPE, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TX_POLL \
    CTL_CODE( TS_SIOCTL_TYPE, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_CAN_POLL \
    CTL_CODE( TS_SIOCTL_TYPE, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SYS_TIME_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SYS_TIME_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TICK_RATE_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TICK_RATE_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TARG_TIME_INTRPT_ENABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TARG_TIME_INTRPT_DISABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x80A, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TARG_TIME_POLL \
    CTL_CODE( TS_SIOCTL_TYPE, 0x80B, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TARG_TIME_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x80C, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TARG_TIME_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x80D, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TIME_INTRPT_ENABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x80E, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TIME_INTRPT_DISABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x80F, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TIME_POLL \
    CTL_CODE( TS_SIOCTL_TYPE, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_RESET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x811, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_CHNL_RESET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x812, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_STATS_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x813, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_STATS_RESET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x814, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SHOW_ALL \
    CTL_CODE( TS_SIOCTL_TYPE, 0x815, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TARG_TIME_INTRPT_ENABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x816, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TARG_TIME_INTRPT_DISABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x817, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TARG_TIME_POLL \
    CTL_CODE( TS_SIOCTL_TYPE, 0x818, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TARG_TIME_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x819, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TARG_TIME_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x81A, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PULSE_PER_SEC_INTRPT_ENABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x81B, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PULSE_PER_SEC_INTRPT_DISABLE \
    CTL_CODE( TS_SIOCTL_TYPE, 0x81C, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TARG_TIME_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x81D, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TIME_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x81E, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TARG_TIME_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x81F, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PULSE_PER_SEC_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x820, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_TARG_TIME_CLR_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x821, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TIME_CLR_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x822, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_AUX_TARG_TIME_CLR_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x823, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PULSE_PER_SEC_CLR_NOTIFY \
    CTL_CODE( TS_SIOCTL_TYPE, 0x824, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PULSE_PER_SEC_TIME_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x825, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PULSE_PER_SEC_TIME_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x826, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PORT_VERSION_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x827, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PORT_VERSION_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x828, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PORT_OPERATION_MODE_SET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x829, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_PORT_OPERATION_MODE_GET \
    CTL_CODE( TS_SIOCTL_TYPE, 0x82a, METHOD_BUFFERED, FILE_ANY_ACCESS )


//
// GUID to open interface to driver
//
// {50772641-F508-4e4b-8DD1-C1B7D2DD91DB}
DEFINE_GUID(GUID_DEVINTERFACE_1588, 
0x50772641, 0xf508, 0x4e4b, 0x8d, 0xd1, 0xc1, 0xb7, 0xd2, 0xdd, 0x91, 0xdb);


#endif
