/*******************************************************************************
 * %LICENSE_PROPRIETARY%
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 *******************************************************************************/

/*****************************************************************************
 * can_port.h
 *
 * Common Driver OS Portability Enabling Module
 *
 * Description
 *   This is an internal API that intended as a lightweight common 
 *   portability layer that allows driver versions to reduce their 
 *   OS dependent code. 
 *
 *****************************************************************************/

#ifndef __CAN_PORT_H__
#define __CAN_PORT_H__

#include <ntddk.h>

#define CAN_REG_WRITE(addr, val)	WRITE_REGISTER_ULONG((addr), (val));
#define CAN_REG_READ(addr)		READ_REGISTER_ULONG((addr));

#define CAN_POOL_TAG           ' NAC'

#define CAN_PRINT_DEBUG			DbgPrint

#ifdef ICP_CAN_DEBUG
#define DEBUG_OUT(S)                    DbgPrint("CAN_DEBUG: %s\n", S)
#else
#define DEBUG_OUT(S)
#endif


#define CAN_MEM_ALLOC(size)		ExAllocatePoolWithTag(NonPagedPool, (size), CAN_POOL_TAG);
#define CAN_MEM_FREE(ptr)		ExFreePool((ptr));


#endif /* __CAN_PORT_H__ */
