
/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 */

/*****************************************************************************
 * Module name:
 *    gpio
 *
 * Abstract:
 *    This header file is to be included by the gpio.c file only. 
 *    It is OS independent.
 *
 * Revision:
 *    
 *
 *****************************************************************************/

#ifndef COMMON_H
#define COMMON_H

#define SEL 2 
#define LVL 2 

//offset into low pin count(LPC) config space of the GPIO base address 
#define GPIO_BAR_OFFSET 0x48

//vendor and device IDs of LPC device
#define LPC_VENDOR_ID 0x8086
#define LPC_DEVICE_ID 0x5031

//Location of the LPC device on the PCI bus
#define LPC_BUS_NUM 0
#define LPC_DEVICE_NUM 31
#define LPC_FUNCTION_NUM 0

#define MAX_GPIO_SIGNALS 64

//GPIO register memory size in bytes
#define GPIO_MEM_SIZE 64

//msb bit number of a GPIO register
#define GPIO_REG_MSB 31

//number of bits in a GPIO register
#define GPIO_REG_BITS 32

// offsets for gpio registers
#define GPIO_USE_SEL   0x00
#define	GP_IO_SEL      0x04
#define	GP_LVL 		   0x0c
#define	GPO_BLINK	   0x18
#define	GPI_INV        0x2c
#define	GPIO_USE_SEL2  0x30
#define	GP_IO_SEL2	   0x34
#define	GP_LVL2		   0x38


/******************************************************************************
  Description:
     This structure contains an IO address to each of the gpio registers 
     contained in the hardware device memory. Each register can then be 
     accessed using the IO address.
 *****************************************************************************/
typedef struct gpio_regs_s
{
	unsigned int gpio_use_sel;    // alternative or gpio function (signals 0-31)
	unsigned int gp_io_sel;		  // input or output (signals 0-31)
	unsigned int gp_lvl;		  // low or high level (signals 0-31)
	unsigned int gpo_blink;		  // blink function (signals 0-31)
	unsigned int gpi_inv;		  // invert function (signals 0-31)
	unsigned int gpio_use_sel2;	  // alternative or gpio function (signals 32-63)
	unsigned int gp_io_sel2;	  // input or output (signals 32-63)
	unsigned int gp_lvl2;		  // low or high level (signals 32-63)
} gpio_regs_t;

#endif
