
/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 */

/*****************************************************************************
 * Module name:
 *    gpio
 *
 * Abstract:
 *    This header file is to be included by the gpio.c file only. 
 *
 * Revision:
 *    TBD
 *
 *****************************************************************************/

#ifndef GPIO_H
#define GPIO_H

#include <ntddk.h>
#include <wdf.h>
#include <initguid.h>
#include <errno.h>
#include <stdio.h>

#include "win_ioctls.h"
#include "common.h"

#define DRIVERNAME "GPIO"

#define LPC_BUS_OFFSET 16
#define LPC_DEVICE_OFFSET 11 
#define LPC_FUNCTION_OFFSET 8
#define FIRST_HALF 2


typedef struct _DEVICE_EXTENSION
{
	int x;
} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

WDF_DECLARE_CONTEXT_TYPE(DEVICE_EXTENSION)

//
// private driver functions
//

NTSTATUS GetHardwareInfo();
VOID SetBit(IN ULONG bit, IN PULONG pData);
VOID ClearBit(IN ULONG bit,IN PULONG pData);
ULONG TestBit(IN ULONG bit, IN ULONG Data);
LONG GetPinInfo(ULONG signal, UCHAR *pBuff);
VOID ReadPCIConfig(ULONG pci_offset, ULONG *read_data);
VOID set_reg_addrs(IN ULONG addr);


//
// Windows Driver Functions
//

NTSTATUS
DriverEntry(IN PDRIVER_OBJECT DriverObject,
	IN PUNICODE_STRING RegistryPath
	);

NTSTATUS
GPIOEvtDeviceAdd(
	IN WDFDRIVER Driver,
	IN PWDFDEVICE_INIT DeviceInit
	);


VOID
GPIOEvtIoDeviceControl(
	IN WDFQUEUE Queue,
	IN WDFREQUEST Request,
	IN size_t OutputBufferLength,
	IN size_t InputBufferLength,
	IN ULONG IoControlCode
	);


NTSTATUS
GPIOEvtDevicePrepareHardware(
	IN WDFDEVICE  Device,
	IN WDFCMRESLIST  ResourcesRaw,
	IN WDFCMRESLIST  ResourcesTranslated
	);

NTSTATUS
GPIOEvtDeviceReleaseHardware(
	IN WDFDEVICE  Device,
	IN WDFCMRESLIST  ResourcesTranslated
	);


#endif
