
/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 */

/*****************************************************************************
 * Module name:
 *    gpio
 *
 * Abstract:
 *    This header file is to be included by the files which need the gpio
 *    module ioctl commands (gpio.c, app.c). 
 *
 * Contents:
 *    No exported items in this file
 *
 * Revision:
 *    TBD
 *
 *****************************************************************************/
    
#ifndef IOCTLS_H
#define IOCTLS_H

// Device type in user defined range
#define GPIO_SIOCTL_TYPE 0x8000

//
// gpio module ioctl command codes
//
// The IOCTL function codes from 0x800 to 0xFFF are for customer use.
//
#define IOCTL_GET_PIN_INFO \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SET_TO_ALTERNATIVE \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SET_TO_GPIO \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SET_AS_INPUT \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SET_AS_OUTPUT \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SET_HIGH \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_SET_LOW \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_START_BLINK \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_STOP_BLINK \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_INVERTED_INPUT \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_NONINVERTED_INPUT \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x80A, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_LEVEL \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x80B, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GPIO_USE_SEL_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x80C, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GP_IO_SEL_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x80D, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GP_LVL_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x80E, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GPO_BLINK_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x80F, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GPI_INV_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GPIO_USE_SEL2_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x811, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GP_IO_SEL2_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x812, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_READ_GP_LVL2_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x813, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GPIO_USE_SEL_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x814, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GP_IO_SEL_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x815, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GP_LVL_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x816, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GPO_BLINK_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x817, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GPI_INV_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x818, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GPIO_USE_SEL2_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x819, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GP_IO_SEL2_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x81A, METHOD_BUFFERED, FILE_ANY_ACCESS )

#define IOCTL_WRITE_GP_LVL2_DWORD \
    CTL_CODE( GPIO_SIOCTL_TYPE, 0x81B, METHOD_BUFFERED, FILE_ANY_ACCESS )

//
// GUID to open interface to driver
//
// {8a205a31-d03e-4b2e-8b22-5419ee3d710b}
DEFINE_GUID(GUID_DEVINTERFACE_GPIO, 
	0x8a205a31, 0xd03e,	0x4b2e,	0x8b, 0x22,	0x54, 0x19, 0xee, 0x3d, 0x71, 0x0b);

/*
 *****************************************************************************
 *
 * Description:
 *    This structure is passed in to the driver and back out from 
 *    the driver for all gpio ioctl commands.  
 *
 *****************************************************************************/
typedef struct gpio_ioctl_s
{
    unsigned int signal;  // gpio signal number
    unsigned int data;	  // numerical value data
    char buff[512];		  // string value data
} gpio_ioctl_t;

#endif
