/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 */
#ifndef _OEM_M88E1118_H_
#define _OEM_M88E1118_H_

typedef enum {
    M88E1118_cable_length_10  = 10,
    M88E1118_cable_length_20  = 20,
    M88E1118_cable_length_30  = 30,
    M88E1118_cable_length_40  = 40,
    M88E1118_cable_length_50  = 50,
    M88E1118_cable_length_60  = 60,
    M88E1118_cable_length_70  = 70,
    M88E1118_cable_length_80  = 80,
    M88E1118_cable_length_90  = 90,
    M88E1118_cable_length_100 = 100,
    M88E1118_cable_length_110 = 110,
    M88E1118_cable_length_120 = 120,
    M88E1118_cable_length_130 = 130,
    M88E1118_cable_length_140 = 140,
    M88E1118_cable_length_150 = 150,
    M88E1118_cable_length_160 = 160,
    M88E1118_cable_length_170 = 170,
    M88E1118_cable_length_180 = 180
} M88E1118_cable_length;


/* Marvel 88E1118 PHY ID, spec pg 71 */
#define PHY_ID_M88E1118                         0x01410E10

/* M88E1118 specific registers */

/* PHY specific control  and status register */
#define M88E1118_PHY_SPEC_CTRL                          16
#define M88E1118_PHY_SPEC_STATUS                        17
/* Page address: selects regs 0 - 28 */
#define M88E1118_PAGE_ADDRESS                           22
/* Receive Error Counter */
#define M88E1118_RX_ERR_CNTR                            0x15  

/* spec pg: 97 Advanced VCT(TM) regs on page #5*/
#define M88E1118_ADV_VCT_TX_TO_MDI0_RX_COUPLING_PG5     16 
#define M88E1118_ADV_VCT_TX_TO_MDI1_RX_COUPLING_PG5     17
#define M88E1118_ADV_VCT_TX_TO_MDI2_RX_COUPLING_PG5     18
#define M88E1118_ADV_VCT_TX_TO_MDI3_RX_COUPLING_PG5     19

#define M88E1118_ADV_VCT_CONTROL_PG5                    23

/* reg. bit masks */

/* reg: M88E1118_PHY_SPEC_CTRL: Pg 82 */
/* polarity reversal disable; 1 => disable */
#define M88E1118_PHY_SPEC_CTRL_POL_REV_DISABLE          0x0002
/* MDI crossover mode */
#define M88E1118_PHY_SPEC_CTRL_MDI_X_MODE_MASK          0x0060
    #define M88E1118_PHY_SPEC_CTRL_MDI_X_MAN_MDI_CONFIG     0x0000
    #define M88E1118_PHY_SPEC_CTRL_MDI_X_MAN_MDIX_CONFIG    0x0020
    #define M88E1118_PHY_SPEC_CTRL_MDI_X_AUTO_CONFIG        0x0060
/* enable extended distance */
#define M88E1118_PHY_SPEC_CTRL_ENABLE_EX_DISTANCE       0x0080
/* enable downshift of speed */
#define M88E1118_PHY_SPEC_CTRL_ENABLE_DOWNSHIFT         0x0800
/* downshift counter */
#define M88E1118_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_MASK   0x7000
    #define M88E1118_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_1x   0x0000 
    #define M88E1118_PHY_SPEC_CTRL_DOWNSHIFT_COUNTER_2x   0x1000 

/* M88E1000 PHY Specific Status Register */
/* 1=Link up, 0=Link down */
#define M88E1118_PSSR_LINK                              0x0400
#define M88E1118_PSSR_JABBER             0x0001 /* 1=Jabber */
#define M88E1118_PSSR_REV_POLARITY       0x0002 /* 1=Polarity reversed */
#define M88E1118_PSSR_DOWNSHIFT          0x0020 /* 1=Downshifted */
#define M88E1118_PSSR_MDIX               0x0040 /* 1=MDIX; 0=MDI */
#define M88E1118_PSSR_CABLE_LENGTH       0x0380 /* 0=<50M;1=50-80M;2=80-110M;
                                            * 3=110-140M;4=>140M */
#define M88E1118_PSSR_LINK               0x0400 /* 1=Link up, 0=Link down */
#define M88E1118_PSSR_SPD_DPLX_RESOLVED  0x0800 /* 1=Speed & Duplex resolved */
#define M88E1118_PSSR_PAGE_RCVD          0x1000 /* 1=Page received */
#define M88E1118_PSSR_DPLX               0x2000 /* 1=Duplex 0=Half Duplex */
#define M88E1118_PSSR_SPEED              0xC000 /* Speed, bits 14:15 */
#define M88E1118_PSSR_10MBS              0x0000 /* 00=10Mbs */
#define M88E1118_PSSR_100MBS             0x4000 /* 01=100Mbs */
#define M88E1118_PSSR_1000MBS            0x8000 /* 10=1000Mbs */

#define M88E1118_PSSR_REV_POLARITY_SHIFT 1
#define M88E1118_PSSR_DOWNSHIFT_SHIFT    5
#define M88E1118_PSSR_MDIX_SHIFT         6
#define M88E1118_PSSR_CABLE_LENGTH_SHIFT 7

/* reg: M88E1118_ADV_VCT_TX_TO_MDI0_RX_COUPLING_PG5 */
/* cable length; ref: pg. 34 */
#define M88E1118_ADV_VCT_TX_TO_MDI0_RX_COUPLING_PG5_DISTANCE    0x00FF

/* reg: M88E1118_ADV_VCT_CONTROL_PG5 */
#define M88E1118_ADV_VCT_CONTROL_PG5_ENABLE_TEST        0x8000
#define M88E1118_ADV_VCT_CONTROL_PG5_TEST_STATUS        0x4000

#endif /* ! _OEM_M88E1118_H_ */
