/*****************************************************************************

INTEL CONFIDENTIAL
Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.

The source code contained or described herein and all documents related to the
source code ("Material") are owned by Intel Corporation or its suppliers or
licensors. Title to the Material remains with Intel Corporation or its
suppliers and licensors. The Material may contain trade secrets and proprietary
and confidential information of Intel Corporation and its suppliers and
licensors, and is protected by worldwide copyright and trade secret laws and
treaty provisions. No part of the Material may be used, copied, reproduced,
modified, published, uploaded, posted, transmitted, distributed, or disclosed
in any way without Intels prior express written permission.
No license under any patent, copyright, trade secret or other intellectual
property right is granted to or conferred upon you by disclosure or delivery
of the Materials, either expressly, by implication, inducement, estoppel or
otherwise. Any license under such intellectual property rights must be
express and approved by Intel in writing.

Include any supplier copyright notices as supplier requires Intel to use.
Include supplier trademarks or logos as supplier requires Intel to use,
preceded by an asterisk.
An asterisked footnote can be added as follows: 
  *Third Party trademarks are the property of their respective owners.

Unless otherwise agreed by Intel in writing, you may not remove or alter this
notice or any other notice embedded in Materials by Intel or Intels suppliers
or licensors in any way.

 version: Embedded.X.1.0.3-127

  Contact Information:

  Intel Corporation, 5000 W Chandler Blvd, Chandler, AZ 85226 

*****************************************************************************/

/*****************************************************************************
 * @ingroup OEM_PHY_GENERAL
 *
 * @file phyoem.h
 *
 * @description
 *   This file contains oem PHY specific function declarations 
 *****************************************************************************/

#ifndef _PHYOEM_H_
#define _PHYOEM_H_

#define DELAY_ONE_MICROSECOND   (-10)
#define DELAY_ONE_MILLISECOND   (DELAY_ONE_MICROSECOND*1000)

void 
OemRegisterCallback( PPHYDEV_INTERFACE_V1 devInterface );

void 
OemDbgPrint(__in PCCH format,...);

NTSTATUS 
OemPhyIsMediaCopper(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite,
                OUT BOOLEAN*       copper
                );

NTSTATUS 
OemPhyLinkSetup(IN PVOID     callerCtx, 
            IN ULONG            phyId,
            IN PIEGB_PHY_RD     iegbPhyRead,
            IN PIEGB_PHY_WR     iegbPhyWrite,
            IN MDI_MODE         mdiMode,
            IN ULONG            polarityReversalDisable
            );

NTSTATUS 
OemPhyHwReset(IN PVOID     callerCtx, 
            IN ULONG            phyId,
            IN PIEGB_PHY_RD     iegbPhyRead,
            IN PIEGB_PHY_WR     iegbPhyWrite
            );

BOOLEAN 
OemPhyNeedsResetWithMac(IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

NTSTATUS 
OemPhyGetCableLength(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite,
                OUT PUSHORT        minLen,
                OUT PUSHORT        maxLen
                );

NTSTATUS 
OemPhyIsLinkUp(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite,
                OUT BOOLEAN*        linkup
                );

NTSTATUS 
OemPhyCheckPolarity(
                    IN PVOID           callerCtx,
                    IN ULONG           phyId,
                    IN PIEGB_PHY_RD    iegbPhyRead,
                    IN PIEGB_PHY_WR    iegbPhyWrite,
                    OUT BOOLEAN*       polarity
                    );

BOOLEAN 
OemPhyIsAutoNegEnabled(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite
                );

NTSTATUS 
OemPhyForceSpeedDuplex(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite
                );

BOOLEAN 
OemPhyIsSpeedDuplex(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite
                );

BOOLEAN 
OemPhyIsSpeed1000(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite
                );

BOOLEAN 
OemPhyIsSpeed100(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite
                );

NTSTATUS 
OemPhyGetRxErrorCnt(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite,
                IN PUSHORT         pRxErrCnt
                );

BOOLEAN 
OemPhyCheckDownshift(
                IN PVOID           callerCtx,
                IN ULONG           phyId,
                IN PIEGB_PHY_RD    iegbPhyRead,
                IN PIEGB_PHY_WR    iegbPhyWrite
                );

#endif _PHYOEM_H_
