/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 */

#ifndef _PHYDEV_PUBLIC_H_
#define _PHYDEV_PUBLIC_H_

#include <initguid.h>

/*
 * define device interface GUID
 */
DEFINE_GUID(GUID_PHYDEV_IF, 0xd337b69e, 0xf358, 0x4547,\
            0x93, 0x27, 0x1b, 0x59, 0x9a, 0x2b, 0x50, 0x50);

/*
 * define query interface GUID
 */
DEFINE_GUID(GUID_PHYDEV_QUERY_IF, 0xd337b69e, 0xf358, 0x4547,\
            0x93, 0x27, 0x1b, 0x59, 0x9a, 0x2b, 0x50, 0x50);

typedef ULONG (*PIEGB_PHY_RD) (IN PVOID callerCtx, 
                                  IN USHORT regOffset, 
                                  OUT USHORT* regVal);

typedef ULONG (*PIEGB_PHY_WR) (IN PVOID callerCtx, 
                                  IN USHORT regOffset, 
                                  IN USHORT regVal);

#define OPTIONAL_FUNCTION   /* this is an optional function */

typedef enum MDI_MODE {
    MDI_MODE_AUTO_CONFIG=0,
    MDI_MODE_MANUAL_MDI_CONFIG=1,
    MDI_MODE_MANUAL_MDIX_CONFIG=2,
    MDI_MODE_AUTO_FOR_1000BASE_T_ONLY=3,
} MDI_MODE;

typedef VOID (*PPHYDEV_IF_OEM_DBGPRINT)(IN PCCH format,...);

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHYLINK_SETUP)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite,
                     IN MDI_MODE        mdiMode,
                     IN ULONG           polarityReversalDisable
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_HW_RESET)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef ULONG (*PPHYDEV_IF_OEM_POST_PHYLINK_CHANGE_CONFIG)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef BOOLEAN (*PPHYDEV_IF_OEM_PHY_NEEDS_RESET_WITH_MAC)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_GET_CABLE_LENGTH)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite,
                     OUT PUSHORT        minLen,
                     OUT PUSHORT        maxLen
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_IS_LINK_UP)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite,
                     IN BOOLEAN*        linkup
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_IS_COPPER)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite,
                     IN BOOLEAN*        linkup
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_CHECK_POLARITY)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite,
                     OUT BOOLEAN*       polarity
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_CHECK_DOWNSHIFT)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite,
                     OUT BOOLEAN*       speedDownshifted
                    );

typedef BOOLEAN (*PPHYDEV_IF_OEM_PHY_IS_AUTO_NEG_ENABLED)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_GET_RX_ERROR_COUNT)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite,
                     IN PUSHORT         pRxErrCnt
                    );

typedef NTSTATUS (*PPHYDEV_IF_OEM_PHY_FORCE_SPEED_DUPLEX)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef BOOLEAN (*PPHYDEV_IF_OEM_PHY_CHECK_DOWN_SHIFT)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef BOOLEAN (*PPHYDEV_IF_OEM_PHY_IS_SPEED_DUPLEX)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef BOOLEAN (*PPHYDEV_IF_OEM_PHY_IS_SPEED_1000)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef BOOLEAN (*PPHYDEV_IF_OEM_PHY_IS_SPEED_100)
                    (IN PVOID           callerCtx,
                     IN ULONG           phyId,
                     IN PIEGB_PHY_RD    iegbPhyRead,
                     IN PIEGB_PHY_WR    iegbPhyWrite
                    );

typedef struct _PHYDEV_INTERFACE_V1
{
    INTERFACE                                   hdr;
    PPHYDEV_IF_OEM_DBGPRINT                     OPTIONAL_FUNCTION 
                                                    OemDbgPrint;
    PPHYDEV_IF_OEM_PHY_IS_COPPER                OemPhyIsMediaCopper;
    PPHYDEV_IF_OEM_PHY_CHECK_POLARITY           OemPhyCheckPolarity;
    PPHYDEV_IF_OEM_PHY_IS_AUTO_NEG_ENABLED      OemPhyIsAutoNegEnabled;
    PPHYDEV_IF_OEM_PHY_IS_SPEED_DUPLEX          OemPhyIsSpeedDuplex;
    PPHYDEV_IF_OEM_PHY_IS_SPEED_1000            OemPhyIsSpeed1000;
    PPHYDEV_IF_OEM_PHY_IS_SPEED_100             OemPhyIsSpeed100;
    PPHYDEV_IF_OEM_PHY_FORCE_SPEED_DUPLEX       OemPhyForceSpeedDuplex;
    PPHYDEV_IF_OEM_PHY_GET_RX_ERROR_COUNT       OemPhyGetRxErrorCnt;
    PPHYDEV_IF_OEM_PHYLINK_SETUP                OemPhyLinkSetup;
    PPHYDEV_IF_OEM_PHY_NEEDS_RESET_WITH_MAC     OPTIONAL_FUNCTION
                                                    OemPhyNeedsResetWithMac;
    PPHYDEV_IF_OEM_PHY_HW_RESET                 OemPhyHwReset;
    PPHYDEV_IF_OEM_PHY_IS_LINK_UP               OemPhyIsLinkUp;
    PPHYDEV_IF_OEM_PHY_CHECK_DOWN_SHIFT         OPTIONAL_FUNCTION
                                                    OemPhyCheckDownshift;
    PPHYDEV_IF_OEM_PHY_GET_CABLE_LENGTH         OPTIONAL_FUNCTION
                                                    OemPhyGetCableLength;
} PHYDEV_INTERFACE_V1, *PPHYDEV_INTERFACE_V1;

#endif //_PHYDEV_PUBLIC_H_
