/*++   
(do not edit the above line)
********************************************************************************
**   Platform Components Group (PCG) - Systems Software Engineering           **
**   Copyright Intel Corporation 1999 - 2000                                  **
********************************************************************************
**                                                                            **
**    INTEL CONFIDENTIAL                                                      **
**    This file, software, or program is supplied under the terms of a        **
**    license agreement and/or nondisclosure agreement with Intel Corporation **
**    and may not be copied or disclosed except in accordance with the        **
**    terms of that agreement.  This file, software, or program contains      **
**    copyrighted material and/or trade secret information of Intel           **
**    Corporation, and must be treated as such.  Intel reserves all rights    **
**    in this material, except as the license agreement or nondisclosure      **
**    agreement specifically indicate.                                        **
**                                                                            **
**    All rights reserved.  No part of this program or publication            **
**    may be reproduced, transmitted, transcribed, stored in a                **
**    retrieval system, or translated into any language or computer           **
**    language, in any form or by any means, electronic, mechanical,          **
**    magnetic, optical, chemical, manual, or otherwise, without              **
**    the prior written permission of Intel Corporation.                      **
**                                                                            **
**    Intel makes no warranty of any kind regarding this code.  This code     **
**    is provided on an "As Is" basis and Intel will not provide any support, **
**    assistance, installation, training or other services.  Intel does not   **
**    provide any updates, enhancements or extensions.  Intel specifically    **
**    disclaims any warranty of merchantability, noninfringement, fitness     **
**    for any particular purpose, or any other warranty.                      **
**                                                                            **
**    Intel disclaims all liability, including liability for infringement     **
**    of any proprietary rights, relating to use of the code.  No license,    **
**    express or implied, by estoppel or otherwise, to any intellectual       **
**    property rights is granted herein.                                      **
**                                                                            **
********************************************************************************
**
**    Module Name:  SMBusIoctl.h
**
**    Abstract:
**      Definitions of IOCTL codes and data structures exported by SMBus Driver.
**
**    Product Name:  
**      SMBus Driver
**
**    Version:
**      $Revision: 6 $   
**
**    Authors:
**      Christopher Spiegel
**
********************************************************************************
**    Revision History:
**      $Log: /SMB2/Export/smb_ioctl.h $ 
**     
**     6     6/16/03 12:40p Cjspiege
**     
**     5     1/07/03 11:47a Cjspiege
**     Fixed a bug with the padding being incorrect
**     
**     4     2/28/02 9:44a Cjspiege
**     Added reload registry
**     
**     3     10/19/01 10:17a Cjspiege
**     
**     2     5/02/01 5:26p Cjspiege
**     
**     4     8/07/00 11:46a Cjspiege
**     Cleaned up some compiler warnings
**     
**     3     8/04/00 11:06a Cjspiege
**     Added comments, changed IOCTL to match SMBus spec, 
**     added IOCTLs for ARPing functions, and added ARP structures
**     
**     2     7/31/00 5:18p Cjspiege
**     Fixed a problem with GUID
**     
**     1     3/02/00 8:34a Cjspiege
**     Initial Install
**     
**     3     2/04/00 11:14a Cspiegel
**     Cleaned up the code
**
** $NoKeywords: $
********************************************************************************
 (do not edit the bottom line)
--*/   

// Sentry Header
#ifndef SMBUSIOCTL_INCLUDED
#define SMBUSIOCTL_INCLUDED

#include <guiddef.h>
// {05599D11-9710-11d3-91D4-00A0C91403F1}
DEFINE_GUID(SMB_CONTROLLER_GUID, 
0x5599d11, 0x9710, 0x11d3, 0x91, 0xd4, 0x0, 0xa0, 0xc9, 0x14, 0x3, 0xf1);

/*++
********************************************************************************
**                                                         
** DECLARATIONS:
**   IOCTL Control Codes
**
** DESCRIPTION:
**   The following defines all the IOCTL control codes for the SMBus Driver
**   that are supported.  All these IOCTL calls transfer data to and from
**   the driver in the SystemBuffer, that is formated as described in the 
**   SMB_INFO structure.  
**
********************************************************************************
--*/
// Performs the ReceiveByte Protocol on SMBus
#define IOCTL_SMB_RECEIVE_BYTE            \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x801,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the SendByte Protocol on SMBus
#define IOCTL_SMB_SEND_BYTE               \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x802,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the ReadByte Protocol on SMBus
#define IOCTL_SMB_READ_BYTE               \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x803,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the WriteByte Protocol on SMBus
#define IOCTL_SMB_WRITE_BYTE              \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x804,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the ReadWord Protocol on SMBus
#define IOCTL_SMB_READ_WORD               \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x805,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the WriteWord Protocol on SMBus
#define IOCTL_SMB_WRITE_WORD              \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x806,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the BlockRead Protocol on SMBus
#define IOCTL_SMB_READ_BLOCK              \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x807,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the BlockWrite Protocol on SMBus
#define IOCTL_SMB_WRITE_BLOCK             \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x808,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the QuickCommand Write Protocol on SMBus
#define IOCTL_SMB_WRITE_QUICK             \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x809,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Performs the QuickCommand Read Protocol on SMBus
#define IOCTL_SMB_READ_QUICK              \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x80a,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )


// Allows testing of the bus clearing algorithm
#define IOCTL_SMB_HANG_BUS        \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x80d,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Allows testing of the INUSE logic
#define IOCTL_SMB_RELOAD_REG_SETTINGS \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x80e,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

/*
 * The following IOCTLS are not supported yet and are new to the driver
 */


// Performs the ProcessCall Protocol on SMBus
#define IOCTL_SMB_PROCESS_CALL            \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x80b,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

// Allows the caller to determine the devices found on the SMBus
#define IOCTL_SMB_DISCOVER_DEVICES        \
   CTL_CODE( FILE_DEVICE_UNKNOWN, 0x80c,  \
      METHOD_BUFFERED, FILE_ANY_ACCESS )

/*++
********************************************************************************
**                                                         
** DECLARATIONS:
**   SMB_INFO, *PSMB_INFO
**
** DESCRIPTION:
**   This structure declares the the format of the IRP's SystemBuffer 
**   that is used to transfer data in and out of the driver
**
**   SlaveAddress - Address of the Slave device (should be a 7-bit value)
**                  On PEC enabled systems, bit 7 indicates when to use PEC in
**                  the transfer
**   CommandCode  - Command Code to be transferred on SMBus 
**                  (Not used in Quick Command)
**   DataByteLow  - Lower Data Byte transferred on SMBus
**   DataByteHigh - Upper Data Byte transferred on SMBus (WORD R/W)
**                  Only used when performing Word transfers
**   Count        - Number of Bytes to transfer in a block transfer
**                  (Only used in block transfers)
**   BlockBuf[32] - Buffer for block transfer data
**                  (Only used in block transfers)
**   Status;      - I/O request status (values match up to WinNT results)
**
********************************************************************************
--*/
typedef struct _SMB_INFO
{
   BYTE  SlaveAddress;  
   BYTE  CommandCode;   
   BYTE  DataByteLow;   
   BYTE  DataByteHigh;  
   BYTE  Count;         
   BYTE  BlockBuf[32];  
   BYTE  Pad[3];
   DWORD Status;        
} SMB_INFO, *PSMB_INFO;

C_ASSERT(sizeof(SMB_INFO) == 44);

#define SMB_HANG_SIG 0xDEADBEEF
#define SMB_RELOAD_REG_SIG 0xDEADBEE2
typedef struct 
{                  
  ULONG Signature;
  BYTE  Reserved[37];
} SMB_TEST_BUF, *PSMB_TEST_BUF;

C_ASSERT(sizeof(SMB_TEST_BUF) == sizeof(SMB_INFO));

#endif // SMBUSIOCTL_INCLUDED

