/* -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: wdt.c
 * $Revision: 1.7 $
 * <Summary Description>
 *---------------------------------------------------------------------------- */

/*
 * INTEL CONFIDENTIAL
 * Copyright 2007,2008,2009 Intel Corporation All Rights Reserved.
 * 
 * The source code contained or described herein and all documents related to the
 * source code ("Material") are owned by Intel Corporation or its suppliers or
 * licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material may contain trade secrets and proprietary
 * and confidential information of Intel Corporation and its suppliers and
 * licensors, and is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or disclosed
 * in any way without Intels prior express written permission.
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or delivery
 * of the Materials, either expressly, by implication, inducement, estoppel or
 * otherwise. Any license under such intellectual property rights must be
 * express and approved by Intel in writing.
 * 
 * Include any supplier copyright notices as supplier requires Intel to use.
 * Include supplier trademarks or logos as supplier requires Intel to use,
 * preceded by an asterisk.
 * An asterisked footnote can be added as follows: 
 *   *Third Party trademarks are the property of their respective owners.
 * 
 * Unless otherwise agreed by Intel in writing, you may not remove or alter this
 * notice or any other notice embedded in Materials by Intel or Intels suppliers
 * or licensors in any way.
 * 
 *  version: Embedded.X.1.0.3-127
 */

/*----------------------------------------------------------------------------
 * Module Name:
 *    driver.h
 *
 * Abstract:
 *    This module contains the watchdog timer driver code.
 *
 * Author:
 *    Sinclair Yeh (syeh2) 01-Aug-2005
 *
 * Environment:
 *    Kernel mode only.
 *
 * Revision History:
 *    01-08-2005     syeh2:  Modified for Whitmore Lake
 *    04-06-2006     mroohola:  Added global variables for spinlock
 */

#ifndef WDT_DRIVER_H
#define WDT_DRIVER_H

/*-----------------------------------------------------------------------------
 * Device extension
 *-----------------------------------------------------------------------------
 */

typedef struct _DEVICE_EXTENSION {

      PDRIVER_OBJECT DriverObject;    /* pointer to driver object */

      PKINTERRUPT    InterruptObject; /* pointer to interrupt object */

      USHORT         PortBase;        /* store the I/O port address */
      UCHAR          IRQ;

      PKEVENT        UserEvent;       /* UserMode event handle */

      WDFDPC         IsrDpc;          /* Handle to the framework DPC object */

      ULONG          Enabled;         /* store WDT Timer Enable bit */
      BOOLEAN        Locked;          /* store WDT Timer Lock bit */
      ULONG          Mode;            /* store WDT Timout Config bit */
      ULONG          Scale;           /* store WDT Prescaler Select bit */
      ULONG          ExtOutState;     /* store WDT Timeout Output Enable bit */
      ULONG          IntType;         /* store WDT Interrupt Type*/
      ULONG          Timeout1;        /* store Preload1 reg */
      ULONG          Timeout2;        /* store Preload2 reg */


} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

WDF_DECLARE_CONTEXT_TYPE_WITH_NAME(DEVICE_EXTENSION, WdtGetData)

/*-----------------------------------------------------------------------------
 * Status Definitions
 *-----------------------------------------------------------------------------
 */
#define WDT_SUCCESS         1                           /* Function Passed */
#define WDT_FAILURE         0                           /* Function Failed */


/*-----------------------------------------------------------------------------
 * Non-register related Hardware Definitions:  Used to access/find hardware
 *-----------------------------------------------------------------------------
 */

#define CONFIG_INDEX        0x04E              /* LPC Config INDEX Port */
#define CONFIG_DATA         0x04F              /* LPC Config DATA Port  */
#define CONFIG_UNLOCK_KEY1  0x80               /* register unlocking key 1 */
#define CONFIG_UNLOCK_KEY2  0x86               /* register unlocking key 2 */
#define CONFIG_LOCK_KEY1    0x68               /* register locking key 1 */
#define CONFIG_LOCK_KEY2    0x08               /* register locking key 2 */
#define LPC_DEVICE_NUM      31
#define LPC_FUNCTION_NUM    0
#define LPC_BUS_NUM         0
#define LPC_DEVICE_ID       0x5031
#define WDT_LOGICAL_DEV_NUM 0x6

#define ENABLE              0x02

#define ENABLE_TEST         0x02
#define MODE_MASK           0xFB
#define MODE_TEST           0x04
#define TIMEOUT_TEST        0x02
#define EXTOUT_MASK         0xDF
#define EXTOUT_TEST         0x20
#define IRQ_TEST            0x07
#define INTTYPE_MASK        0xFC
#define INTTYPE_TEST        0x03
#define SERIRQ_TEST         0x01
#define LOCK_TEST           0x01


/*-----------------------------------------------------------------------------
 * Config registers offsets
 *-----------------------------------------------------------------------------
 */

#define CONFIG_GLB_LOGIC_DEV_SELECT_REG   0x07
#define CONFIG_WDT_ENABLE_REG             0x30
#define CONFIG_WDT_BASE_ADDR_MSB_REG      0x60
#define CONFIG_WDT_BASE_ADDR_LSB_REG      0x61
#define CONFIG_WDT_INT_SELECT_REG         0x70

#define WDT_PRELOAD_VAL1_REG0_OFFSET      0x00 /* [7:0] of preload val 1 */
#define WDT_PRELOAD_VAL1_REG1_OFFSET      0x01 /* [15:8] of preload val 1 */
#define WDT_PRELOAD_VAL1_REG2_OFFSET      0x02 /* [19:16] of preload val 1 */
#define WDT_PRELOAD_VAL2_REG0_OFFSET      0x04 /* [7:0] of preload val 2 */
#define WDT_PRELOAD_VAL2_REG1_OFFSET      0x05 /* [15:8] of preload val 2 */
#define WDT_PRELOAD_VAL2_REG2_OFFSET      0x06 /* [19:16] of preload val 2 */
#define WDT_INT_STATUS_REG_OFFSET         0x08 /* interrupt status register */
#define WDT_RELOAD_REG0_OFFSET            0x0C /* reload register */
#define WDT_RELOAD_REG1_OFFSET            0x0D /* reload register */
#define WDT_CONFIG_REG_OFFSET             0x10 /* WDT configuration register */
#define WDT_DOWN_CNT_REG0_OFFSET          0x14 /* [7:0] of down counter */
#define WDT_DOWN_CNT_REG1_OFFSET          0x15 /* [15:8] of down counter */
#define WDT_DOWN_CNT_REG2_OFFSET          0x16 /* [23:16] of down counter */
#define WDT_LOCK_REGISTER_OFFSET          0x18 /* WDT lock register */


/*-----------------------------------------------------------------------------
 * Formal declaration for IOCTL handling functions
 *-----------------------------------------------------------------------------
 */

void     ioctl_enable_wdt( PDEVICE_EXTENSION, BOOLEAN );
ULONG    ioctl_get_wdt_enable( PDEVICE_EXTENSION );
BOOLEAN  ioctl_lock_wdt( PDEVICE_EXTENSION );
BOOLEAN  ioctl_set_timeout_1( PDEVICE_EXTENSION, ULONG );
BOOLEAN  ioctl_set_timeout_2( PDEVICE_EXTENSION, ULONG );
ULONG    ioctl_get_timeout_1( PDEVICE_EXTENSION );
ULONG    ioctl_get_timeout_2( PDEVICE_EXTENSION );
BOOLEAN  ioctl_ping_wdt( PDEVICE_EXTENSION );
ULONG    ioctl_get_down_counter( PDEVICE_EXTENSION );
BOOLEAN  ioctl_set_mode( PDEVICE_EXTENSION, ULONG);
ULONG    ioctl_get_mode( PDEVICE_EXTENSION );
ULONG    ioctl_get_timeout( PDEVICE_EXTENSION );
ULONG    ioctl_clr_timeout( PDEVICE_EXTENSION );
BOOLEAN  ioctl_set_prescaler( PDEVICE_EXTENSION, ULONG );
ULONG    ioctl_get_prescaler( PDEVICE_EXTENSION );
BOOLEAN  ioctl_set_external_out( PDEVICE_EXTENSION, ULONG );
ULONG    ioctl_get_external_out( PDEVICE_EXTENSION );
BOOLEAN  ioctl_set_intr_type( PDEVICE_EXTENSION, ULONG );
ULONG    ioctl_get_intr_type( PDEVICE_EXTENSION );




/*-----------------------------------------------------------------------------
 * Capability Defines
 *-----------------------------------------------------------------------------
 */
#define VERSION 0x1;
#define MIN_TIMER_INTERVAL 0x1
#define MAX_TIMER_INTERVAL 0xFFFFF
#define NO_DISABLABLE 0x0
#define N0_SHUTDOWNABLE 0x0



/*-----------------------------------------------------------------------------
 * Misc Defines
 *-----------------------------------------------------------------------------
 */
#define INT_8 8
#define INT_16 16

/*-----------------------------------------------------------------------------
 * Specifies the pool tag for the allocated memory
 *-----------------------------------------------------------------------------
 */
#define TAG_WDT 'TDW'

#endif