echo -off
# + ============================================================== +
#  Copyright (c) 2009, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  startup.nsh

#  Abstract:  Script file for invoking iflash.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

@echo -off
mode 80 25
;foundimage section is simply to locate the correct drive
cls
if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE
echo ==========================================================================
echo "This utility will allow you to update the BIOS and firmware."
echo "If you want to do all these functions, press Enter. If not, hit 'q'."
echo "if you want to update single components like BMC/BIOS seperately,"
echo "please go to the EFIscripts folder and execute the specified scripts"
echo "seperately."  
echo "Do NOT reboot during this process until you see Updates completed."
echo "Pre release updates may take significant time with a 20 minute HSC update."

echo ==========================================================================
pause
echo ""

echo Integrated BMC and Intel Remote Management Module 3 firmware update to rev 00.34
echo ""
Fwpiaupd -u -bin -o -pia -ni BMC_0034.ima 

echo ME Firmware Update rev: Production Release
echo ""
fwpiaupd -u -o -b -address=2c -bin -ni sps_110_dib.bin

echo "Update FRUSDR using FRUSDR utility"
frusdr -cfg MASTER.CFG

echo Flashing BIOS...
IFlash32.efi R0033.cap /u /ni

echo "Updates completed. Please reboot using the front panel button."
:END

