/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "StdAfx.h"
#include "TokenSvcProxy.h"

#include "PlatformTokenApp_i.c"

//define SP status string
#define STR_STATUS_ENABLED			L"ENABLED"
#define STR_STATUS_NOT_CONFIGURED	L"NOT_CONFIGURED"
#define STR_STATUS_DISABLED			L"DISABLED"

CTokenSvcProxy::CTokenSvcProxy(void)
{
}

CTokenSvcProxy::~CTokenSvcProxy(void)
{
}


HRESULT CTokenSvcProxy::Initialize(BSTR bstrSpPluginVersion)
{
	HRESULT hr;
	hr = CoInitialize( NULL );
	if( FAILED(hr) ) 
	{
		char buff[256];
		sprintf_s( buff, 256, "CoInitialize() failed: %x\n", hr );
		NPLOG( buff ); 
	}


	m_bstrSpPluginVersion = bstrSpPluginVersion; 
	hr = m_spTokenSvc.CoCreateInstance(CLSID_TokenSvc);
	if( FAILED(hr) ) 
	{
		char buff[256];
		sprintf_s( buff, 256, "m_spTokenSvc.CoCreateInstance() failed: %x\n", hr );
		NPLOG( buff ); 
	}

   return(hr);
}

// Release resources allocated.
HRESULT CTokenSvcProxy::UnInitialize(void)
{
	if( m_spTokenSvc )
	{
		m_spTokenSvc.Release();
	}
	CoUninitialize();
	return(S_OK);
}

// Get current status of Sentry Peak and Sentry Peak Version.
HRESULT CTokenSvcProxy::GetSpStatusVersion(BSTR* bstrSpStatus, BSTR* bstrSpVersion)
{
	NPLOG( "Entering CTokenSvcProxy::GetSpStatusVersion()\n");

	if( !bstrSpStatus || !bstrSpVersion )
	{
		return E_INVALIDARG;
	}

	HRESULT hr= S_OK;
	SP_FW_STATUS_TYPE enSpStatus= SP_STATUS_ERROR;

	if(NULL == m_spTokenSvc)
	{
		NPLOG( "CTokenSvcProxy::GetSpStatusVersion: NULL TokenSvc pointer\n" );
		hr= E_POINTER;
	}
	else
	{
		hr= m_spTokenSvc->SpGetStatus( &enSpStatus,	bstrSpVersion, m_bstrSpPluginVersion );
		if( FAILED(hr) ) 
		{
			char buff[256];
			sprintf_s( buff, 256, "m_spTokenSvc->SpGetStatus() failed: %x\n", hr );
			NPLOG( buff ); 
		}

		if( FAILED(hr) ) return hr;

		CComBSTR bstrTmp;
		//bstrTmp.LoadStringW(IDS_SP_STATUS_DISABLED);
		bstrTmp = STR_STATUS_DISABLED;
		switch(enSpStatus)
		{
		case SP_STATUS_DISABLED:
			*bstrSpStatus= bstrTmp.Detach();
			break;
		case SP_STATUS_NOT_CONFIGURED:
			//bstrTmp.LoadStringW(IDS_SP_STATUS_NOT_CONFIGURED);
			bstrTmp = STR_STATUS_NOT_CONFIGURED;
			*bstrSpStatus= bstrTmp.Detach();
			break;
		case SP_STATUS_RUNNING:
			//bstrTmp.LoadStringW(IDS_SP_STATUS_ENABLED);
			bstrTmp = STR_STATUS_ENABLED;
			*bstrSpStatus= bstrTmp.Detach();
			break;
		case SP_STATUS_ERROR:
			*bstrSpStatus= bstrTmp.Detach();        
			hr= E_FAIL;
			break;
		default:
			*bstrSpStatus= bstrTmp.Detach();
			hr= E_FAIL;
			break;
		}
		if( bstrSpStatus ) 
		{
			char buff[256];
			sprintf_s( buff, 256, "SP Protocol version: %S, status: %S\n", *bstrSpVersion, *bstrSpStatus );
			NPLOG( buff );
		}
		else
		{
			hr = E_FAIL;
		}
	}

	return(hr);
}


HRESULT CTokenSvcProxy::ProcessSpRequest( BSTR bstrRequest, 
	UINT timeout, BSTR* bstrSpResponse)
{
	NPLOG( "Entering CTokenSvcProxy::ProcessSpRequest()\n" );

	if( !bstrSpResponse ) return E_INVALIDARG;

	HRESULT hr=S_OK;
	if(NULL == m_spTokenSvc)
	{
		NPLOG( "CTokenSvcProxy::ProcessSpRequest: NULL TokenSvc pointer\n" );
		hr= E_POINTER;
	}
	else
	{
		hr= m_spTokenSvc->SpProcessRequest( bstrRequest, timeout, bstrSpResponse );
		if( SUCCEEDED(hr) && !bstrSpResponse ) hr = E_FAIL;

		if( FAILED(hr) ) 
		{
			char buff[256];
			sprintf_s( buff, 256, "m_spTokenSvc->SpProcessRequest() failed: %x\n", hr );
			NPLOG( buff ); 
		}
	}
	
	return(hr);
}