/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// To use this file, you need to
// 1. Include PlatformTokenApp.idl and TokenCommon.idl in your project
// 2. Set output directory of MIDL to $(IntDir), and add $(IntDir) to C++ input directories
// 3. Set MIDL IID file name to $(InputName)_i.c and proxy file name to $(InputName)_p.c
// 4. Define TSP_LOGID in your stdafx.h

#pragma once
#include <atlbase.h>
#include <atlcom.h>
#include "PlatformTokenApp.h"

// Note: if methods in this class return return S_OK, it means the results are good.
// No need to check if the out parameters are valid or not!
class CTokenSvcProxy
{
public:
	CTokenSvcProxy(void);
	virtual ~CTokenSvcProxy(void);

	HRESULT Initialize(BSTR bstrSpPluginVersion);
	HRESULT UnInitialize(void);

	// Get current status of Sentry Peak and Sentry Peak Version.
	HRESULT GetSpStatusVersion(BSTR* bstrSpStatus, BSTR* bstrSpVersion);

    // Perform Sentry Peak Transaction.
	HRESULT ProcessSpRequest( BSTR bstrRequest, UINT timeout, BSTR* bstrSpResponse);

protected:
	CComPtr<ITokenSvc> m_spTokenSvc;
	CComBSTR m_bstrSpPluginVersion;
};
