;
; Warning: Comments _only_ allowed on a separate line!
;
; Contents:
;     Gimp Script-fu function definitions for creating menu and button images.
;

; create menu tabs (i.e. the headlines)
(define (gen-menu-tab text basename)
    (let* (
	    (font "Sans Bold")
	    (fontsize 12)
	    (inactive_text '(100 100 200))
	    (active_text '(255 255 255))
	)

	(set! i 0)
	(while (< i 2)
	    ; make one tab in each iteration

	    (set! i_str (number->string i 10))
	    (if (equal? i 1)
		; then
		(begin
		    (set! text_fg_color active_text)
		    (set! active_suffix "_on")
		)
		; else
		(begin
		    (set! text_fg_color inactive_text)
		    (set! active_suffix "_off")
		)
	    )

	    (set! tmpl-img-fname (string-append 
		    global-template-dir "/" "menu_tab_head" active_suffix ".gif"))
	    (set! image (car (gimp-file-load RUN-NONINTERACTIVE 
					     tmpl-img-fname tmpl-img-fname)))
	    (set! width (car (gimp-image-width image)))
	    (set! height (car (gimp-image-height image)))
	    (set! layer (car (gimp-layer-new image width height RGB-IMAGE
					      "mylayer" 100 NORMAL-MODE)))
	    (gimp-layer-add-alpha layer)
	    (gimp-drawable-fill layer TRANSPARENT-FILL)
	    (gimp-convert-rgb image)
	    (gimp-image-add-layer image layer 0)
	    (gimp-palette-set-foreground text_fg_color)
	    (gimp-text-fontname image layer 13 3 text -1 TRUE fontsize 1 font)
	    (gimp-image-merge-visible-layers image CLIP-TO-IMAGE) 

	    ; save image and free
	    (gimp-image-convert-indexed image 1 0 255 0 1 "")
	    (set! filename (string-append target-dir "/" "tab_" basename active_suffix ".gif"))
	    (gimp-file-save RUN-NONINTERACTIVE image layer filename filename)
	    (gimp-image-delete image)

	    (set! i (+ i 1))
	)
    )
)

(define (gen-menu-entry text basename)
    (let* (
	    (inactive_text '(111 111 111))
	    (active_text '(225 255 100))
	    (inactive_background '(200 200 200))
	    (active_background '(100 100 200))
	    (active_background_inactive_text '(240 240 255))
	    (font "Sans")
	    (fontsize 9)
	    (width 154)
	    (height 12)
	)
	(set! i 0)
	(while (< i 3)
	    (set! i_str (number->string i 10))

	    ; 3 cases:
	    ;     - "off": menu tab (i.e. background) inactive
	    ;     - "on":  menu tab active
	    ;     - "ylw": menu tab and entry active
	    (if (equal? i 0)
		(begin
		    ; bg and fg "off"
		    (set! bg_color inactive_background)
		    (set! fg_color inactive_text)
		    (set! suffix "_off.gif")
		)
	    (if (equal? i 1)
		(begin
		    ; bg "on" and fg "off"
		    (set! bg_color active_background)
		    (set! fg_color active_background_inactive_text)
		    (set! suffix "_on.gif")
		)
	    (if (equal? i 2)
		(begin
		    ; bg "on" and fg "on"
		    (set! bg_color active_background)
		    (set! fg_color active_text)
		    (set! suffix "_ylw.gif")
		)
	    )))

	    (set! image (car (gimp-image-new width height RGB)))
	    (set! layer  (car (gimp-layer-new image width height RGB-IMAGE "mylayer" 100 NORMAL-MODE)))
	    (gimp-image-add-layer image layer 0)
	    (gimp-palette-set-background bg_color)       
	    (gimp-palette-set-foreground fg_color)
	    (gimp-drawable-fill layer BG-IMAGE-FILL)

	    (gimp-text-fontname image layer 20 -1 text -1 TRUE fontsize 1 font)
	    (gimp-image-merge-visible-layers image CLIP-TO-IMAGE) 

	    ; make 4 pixel white box on the left
	    (gimp-rect-select image 0 0 4 height 2 0 0)
	    (gimp-edit-fill layer WHITE-FILL)
	    (gimp-selection-all image)

	    ; save image and free
	    (gimp-image-convert-indexed image 1 0 255 0 1 "")
	    (set! filename (string-append target-dir "/" "menu_" basename suffix))
	    (gimp-file-save RUN-NONINTERACTIVE image layer filename filename)
	    (gimp-image-delete image)

	    (set! i (+ i 1))
	)
    )
)

(define (gen-button text basename)
    (let* (
	    (font "Sans Bold")
	    (fontsize 14)
	    (extents (gimp-text-get-extents-fontname text fontsize 0 font))
	    (text-width (car extents))
	    (text-height (cadr extents))
	    (text-color '(40 37 37))
	    (fname (string-append global-template-dir "/" "web-button-plain.xcf"))
	    (image (car (gimp-file-load RUN-NONINTERACTIVE fname fname)))
	    (layer (car (gimp-image-get-active-layer image)))
	    (img-width (car (gimp-image-width image)))
	    (img-height (car (gimp-image-height image)))
	    (x-offset (trunc (/ (- img-width text-width) 2)))
	    (y-offset (trunc (/ (- img-height text-height) 2)))

	)
	; draw label
	(gimp-palette-set-foreground text-color)
	(set! text-layer (car (gimp-text-fontname 
		    image layer x-offset y-offset text 0 TRUE fontsize 0 font)))
	(gimp-floating-sel-anchor text-layer)

	; save image and free
	(gimp-image-convert-indexed image 1 0 255 0 1 "")
	(set! filename (string-append target-dir "/" "button_" basename ".en.gif"))
	(gimp-file-save RUN-NONINTERACTIVE image layer filename filename)
	(gimp-image-delete image)
    )
)

