/**
 * This is the global meta information describing our MO
 * Pls. don't forget to change (In the future this is going
 * to be the only place where to change things ;-)
 *
 */

#include <pp/metadata.h>

static pp_perm_desc_t perms[] = {
    { "acl",         "User/Group Permissions",     {"view", "change"} },
    { "cert",        "SSL Certificate Management", {"allow", 0} },
    { "events_ipmi", "Event Log via IPMI",         {"view", "change"} },
    { "ft",          "File Transfer",              {"allow", 0} },
    { "fw",          "Firmware Update",            {"allow", 0} },
    { "ipmi_s",      "IPMI Settings",              {"view", "change"} },
    { "isdn_s",      "ISDN Settings",              {"view", "change"} },
    { "km_s",        "Keyboard/Mouse Settings",    {"view", "change"} },
    { "kvm_s",       "KVM Settings",               {"view", "change"} },
    { "modem_s",     "Modem Settings",             {"view", "change"} },
    { "net_s",       "Network Settings",           {"view", "change"} },
    { "pc",          "Server Power Control",       {"allow", 0} },
    { "pc_s",        "Power Control Settings",     {"view", "change"} },
    { "rc",          "Remote Console Access",      {"allow", 0} },
    { "rc_s_enc",    "RC settings (Encoding)",     {"view", "change"} },
    { "rc_s_hk",     "RC settings (Hotkeys)",      {"view", "change"} },
    { "rc_s_mm",     "RC settings (Monitor Mode)", {"view", "change"} },
    { "reset",       "Board Reset",                {"allow", 0} },
    { "sec_s",       "Security Settings",          {"view", "change"} },
    { "serial_s",    "Serial Settings",            {"view", "change"} },
    { "snmp_s",      "SNMP Settings",              {"view", "change"} },
    { "status_ipmi", "Server Status via IPMI",     {"view", "change"} },
    { "um",          "User/Group Management",      {"view", "change"} },
    { "vfloppy",     "Virtual Floppy Upload",      {"allow", 0} },
    { 0, 0, {0, 0} }
};

static pp_setting_desc_t settings[] = {
    { "rc_encoding",              "Transmission Encoding",     0 },
    { "rc_compress_rate",         "Compression Rate",          0 },
    { "rc_monitor_mode_enabled",  "Monitor Mode",              0 },
    { "rc_use_active_x",          "Active X",                  0 },
    { "rc_use_sunplugin",         "Sun Plugin",                0 },
    { "rc_mouse_relative",        "Single Mouse Mode",         0 },
    { "rc_mousesync_key",         "Mouse Synchronization Key", 1 },
    { "rc_mousesync_keycode",     "",                          1 },
    { "rc_hotkey",                "Button Key",                0 },
    { "rc_hotkeycode",            "",                          0 },
    { 0, 0, 0 }
};

static pp_capability_desc_t caps[] = {
    { "rc",            "Show Remote Console",       "/title_app.asp", 
      "true" },
    { "rc_opts",       "Remote Console Settings",   "/rc_settings.asp",
      "true" },
    { "telnet",        "Telnet Console",            "/telnet.asp",
      "true" },
    { "state_ipmi",    "Status via IPMI",           "/status_ipmi.asp",
      "true" },
    { "evts_ipmi",     "Event Log via IPMI",        "/events_ipmi.asp",
      "true" },
    { "pwr_ctrl",      "Power Control",             "/powerctrl_lara.asp",
      "true" },
    { "km_opts",       "Keyboard/Mouse Settings",   "/km_settings.asp",
      "true" },
    { "kvm_opts",      "KVM Settings",              "/kvm.asp",
      "true" },
    { "vid_opts",      "Video Settings",            "/video_settings.asp",
      "true" },
    { "um_mgmt",       "User/Group Management",     "/um.asp",
      "true" },
    { "um_perms",      "User/Group Permissions",    "/acl.asp",
      "true" },
    { "net_opts",      "Network Settings",          "/network.asp",
      "true" },
    { "net_isdn",      "ISDN Settings",             "/isdn.asp",
      "true" },
    { "serial_opts",   "Serial Port Settings",      "/serial.asp",
      "true" },
    { "sec_opts",      "Security Settings",         "/security.asp",
      "true" },
    { "snmp_opts",     "SNMP Settings",             "/snmp.asp",
      "true" },
    { "ipmi_opts",     "IPMI Settings",             "/ipmi.asp",
      "true" },
    { "ldap_opts",     "LDAP Settings",             "/ldap.asp",
      "true" },
    { "board",         "Maintenance",               "/board.asp",
      "true" },
    { 0, 0, 0, 0 }
};

pp_meta_data_t pp_mo_meta_data = {
    perms, settings, caps
};

