/**
 * This is the global meta information describing our MO
 * Pls. don't forget to change (In the future this is going
 * to be the only place where to change things ;-)
 *
 * $Id: metadata.c,v 1.1 2005-08-09 09:29:41 rgue Exp $
 */

#warning TODO: fill out Meta Information for LARA eco !!!

#include <pp/metadata.h>

static pp_perm_desc_t perms[] = {
    { "acl",         "User/Group Permissions",     {"view", "change"} },
    { "cert",        "SSL Certificate Management", {"allow", 0} },
    { "fw",          "Firmware Update",            {"allow", 0} },    
    { "km_s",        "Keyboard/Mouse Settings",    {"view", "change"} },
    { "kvm_s",       "KVM Settings",               {"view", "change"} },
    { "modem_s",     "Modem Settings",             {"view", "change"} },
    { "net_s",       "Network Settings",           {"view", "change"} },
    { "pc",          "Server Power Control",       {"allow", 0} },
    { "pc_s",        "Power Control Settings",     {"view", "change"} },
    { "rc",          "Remote Console Access",      {"allow", 0} },
    { "rc_s_enc",    "RC settings (Encoding)",     {"view", "change"} },
    { "rc_s_hk",     "RC settings (Hotkeys)",      {"view", "change"} },
    { "rc_s_mm",     "RC settings (Monitor Mode)", {"view", "change"} },
    { "reset",       "Board Reset",                {"allow", 0} },
    { "sec_s",       "Security Settings",          {"view", "change"} },
    { "serial_s",    "Serial Settings",            {"view", "change"} },
    { "snmp_s",      "SNMP Settings",              {"view", "change"} },
    { "um",          "User/Group Management",      {"view", "change"} },
    { 0, 0, {0, 0} }
};

static pp_setting_desc_t settings[] = {
    { "rc_encoding",              "Transmission Encoding",     0 },
    { "rc_compress_rate",         "Compression Rate",          0 },
    { "rc_monitor_mode_enabled",  "Monitor Mode",              0 },
    { "rc_use_sunplugin",         "Sun Plugin",                0 },
    { "rc_mouse_relative",        "Single Mouse Mode",         0 },
    { "rc_mousesync_key",         "Mouse Synchronization Key", 1 },
    { "rc_mousesync_keycode",     "",                          1 },
    { "rc_hotkey",                "Button Key",                0 },
    { "rc_hotkeycode",            "",                          0 },
    { 0, 0, 0 }
};

static pp_capability_desc_t caps[] = {
    { "rc",            "Show Remote Console",       "/title_app.asp", 
      "acl::rc == +allow" },
    { "rc_opts",       "Remote Console Settings",   "/r1_rc_settings.asp",
      "acl::net_s == +view" },
    { "net_opts",      "Network Settings",          "/r1_network.asp",
      "acl::net_s == +view" },
    { "serial_opts",   "Serial Port Settings",      "/r1_serial.asp",
      "acl::serial_s == +view" },    
    { "board",         "Maintenance",               "/r1_board.asp",
      "acl::fw == +allow || acl::reset == +allow" },
    { 0, 0, 0, 0 }
};

pp_meta_data_t pp_mo_meta_data = {
    perms, settings, caps
};

