/**
 * file bmc_dev_oem_icp.h
 *
 * Description: BMC ICP-OEM Device
 *
 * (c) 2005 Peppercon AG, thomas@peppercon.de
 */

#ifndef __BMC_DEV_OEM_ICP_H__
#define __BMC_DEV_OEM_ICP_H__

/**
 * Initializes the BMC ICP-OEM device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_oem_icp_init(void);

/**
 * Finishes the BMC ICP-OEM device and unregisters it at the BMC core.
 */
void pp_bmc_dev_oem_icp_cleanup(void);

#endif /* !__BMC_DEV_OEM_ICP_H__ */
