/**
 * \file bmc_dev_oem_pp.h
 *
 * Description: BMC Peppercon OEM commands
 *
 * (c) 2005 Peppercon AG, Ingo van Lil <inva@peppercon.de>
 */

#ifndef __BMC_DEV_OEM_PP_H__
#define __BMC_DEV_OEM_PP_H__

/**
 * Initializes the BMC PP-OEM device and registers it at the BMC core.
 *
 * @return PP_SUC (0) if success
 *         PP_ERR (-1) if error
 */
int pp_bmc_dev_oem_pp_init(void);

/**
 * Finishes the BMC PP-OEM device and unregisters it at the BMC core.
 */
void pp_bmc_dev_oem_pp_cleanup(void);

#endif /* !__BMC_DEV_OEM_PP_H__ */

